
/*
Functions to hide the Gimp API.

API changed from Gimp 2 to 3.
*/

#include <libgimp/gimp.h>


gint          bpp(GimpDrawable *d)       { return gimp_drawable_get_bpp   (d); }
gint          width    (GimpDrawable *d) { return gimp_drawable_get_width (d); }
gint          height   (GimpDrawable *d) { return gimp_drawable_get_height(d); }

GimpImageType  imageType(GimpDrawable *d) { return gimp_drawable_type     (d); }
gboolean       is_rgb   (GimpDrawable *d) { return gimp_drawable_is_rgb   (d); }
gboolean       is_gray  (GimpDrawable *d) { return gimp_drawable_is_gray  (d); }
gboolean       is_indexed(GimpDrawable *d) { return gimp_drawable_is_indexed(d); }
gboolean       has_alpha(GimpDrawable *d)  { return gimp_drawable_has_alpha(d);  }

GeglBuffer *
get_buffer(GimpDrawable *d)        { return gimp_drawable_get_buffer(d);        }
GeglBuffer *
get_shadow_buffer(GimpDrawable *d) { return gimp_drawable_get_shadow_buffer(d); }

gboolean
merge_shadow(GimpDrawable *d)
{
  return gimp_drawable_merge_shadow(
    d,
    TRUE); // hardcoded
}

void
update(
  GimpDrawable *d,
  gint lx,
  gint ly,
  gint rx,
  gint ry)
{
  gimp_drawable_update(d, lx, ly, rx, ry);
}

// Offset of layer in image
void
offsets(
  GimpDrawable *d,
  gint         *x,
  gint         *y )
{
  gimp_drawable_get_offsets( d, x, y );
}

/*
Returns a drawable of the selection mask,
for the image of the given drawable.
The drawable is the same size as the canvas,
not necessarily the same size as the given drawable.
The drawable is-a Channel.

The result may be all zeroes (when user has not selected anything.)
The area that is not all zeroes need not intersect the given drawable
(when the user has selected an area outside the given drawable.)
*/
GimpDrawable *
get_selection(GimpDrawable * d)
{
  return (GimpDrawable*)gimp_image_get_selection(gimp_item_get_image((GimpItem*)d));
}

/*
See gimp_drawable_mask_bounds
*/
gboolean
selection_bounds(
  GimpDrawable *d,
  gint *lx,
  gint *ly,
  gint *rx,
  gint *ry)
{
  return gimp_drawable_mask_bounds(d, lx, ly, rx, ry);
}

// More generally, any mask.  Here a selection
gboolean
selection_intersect(
  GimpDrawable *d,
  gint        *drawable_relative_x,
  gint        *drawable_relative_y,
  gint        *intersect_width,
  gint        *intersect_height)
{
return gimp_drawable_mask_intersect(d,
  drawable_relative_x, drawable_relative_y,
  intersect_width, intersect_height);
}
