/* 
 * Oroborus Window Manager
 * X11 I18N Support Library
 *
 * Copyright (C) 2001 Ken Lynch
 * Copyright (C) 2002 Stefan Pfetzing
 * 
 * OroboROX Window Manager
 * 
 * Copyright (C) 2004 Guido Schimmels
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "config.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xmd.h>
#include <X11/Xatom.h>
#include <ft2build.h>
#include <X11/Xft/Xft.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>
#include "xerror.h"
#include "main.h"
#include "hints.h"
#include "client.h"
#include "frame.h"
#include "i18n.h"

#define DBUG_VERBOSE(x)			// DBUG(x)

MyFont title_font;
int use_fontset;
XftColor textcolor;

int getFont(Display * dpy, MyFont * font, char *name)
{


	DBUG_VERBOSE("entering getFont");
	DBUG_VERBOSE("font=");
	DBUG_VERBOSE(name);

	{
		font->fontset = NULL;

		font->xftfont = XftFontOpenName(dpy, screen, name);
		if (font->xftfont == NULL)
		{
			g_warning("font '%s' not found\n", name);
			return False;
		}
#ifdef DEBUG
		fprintf(stderr, "XFT: font '%s' found\n", name);
#endif
		//font->fontset = FcFontSetCreate();
		//font->fcconfig = FcConfigCreate();
		//FcFontSetAdd(font->fontset, font->xftfont->pattern);
	}

	return True;
}

static void freeFont(Display * dpy, MyFont * font)
{
	DBUG_VERBOSE("entering freeFont");

	/*if (use_fontset)
	   FcFontSetDestroy(font->fontset);
	   else */
	XftFontClose(dpy, font->xftfont);

}

void
drawString(Client * c, Display * dpy, Drawable d, MyFont * font,
		   XftColor * xftcol, int x, int y, char *str)
{
	DBUG_VERBOSE("entering drawString");

	if (!str)
		return;

	XftDrawChange(c->xftdraw, d);

	//fprintf(stderr, "entering drawString\n");

	//XftDrawStringUtf8(c->xftdraw, xftcol, font->xftfont, x, y, 
	//                    (const FcChar8*)str, g_utf8_strlen(str, -1));
	XftDrawStringUtf8(c->xftdraw, xftcol, font->xftfont, x, y, (const FcChar8 *) str, strlen(str));


}

static XGlyphInfo extents;

int getTextWidth(char *str, MyFont * font)
{

	DBUG_VERBOSE("entering getTextWidth");

	if (!str)
		return 0;

	//fprintf (stderr, "entering getTextWidth\n");

	int len = strlen(str);


	//fprintf (stderr, "getTextWidth(): %s len=%d\n", str, len);
	//fprintf (stderr, "getTextWidth(): %s len=%d\n", str, strlen(str));

	XftTextExtentsUtf8(dpy, font->xftfont, (const FcChar8 *) str, len, &extents);
	//XftTextExtentsUtf8(dpy, font->xftfont, (const FcChar8*)str, strlen(str), &extents);
	return extents.width;
}


static char *get_property_utf8_string(Client * c, Atom type_atom)
{
	XTextProperty tp;
	char *utf8_string = NULL;

	tp.nitems = 0;
	tp.value = NULL;

	if (XGetTextProperty(dpy, c->window, &tp, type_atom))
	{
		if (tp.value)
		{
			if ((tp.encoding == xa_utf8_string) && (tp.format == 8) && (tp.nitems > 0))
				utf8_string = g_strdup((char *) tp.value);
			XFree(tp.value);
		}
	}

	return utf8_string;
}

#ifdef USE_ICON_NAME
void get_net_wm_icon_name(Client * c)
{	
	gchar *name = get_property_utf8_string(c, intern_atoms[NET_WM_ICON_NAME]);
	if (name)
	{
		g_free(c->net_wm_icon_name);
		c->net_wm_icon_name = name;
		dbg("NET_WM_ICON_NAME: %s\n", c->net_wm_icon_name);
	}
}
#endif

void get_net_wm_name(Client * c)
{
	gchar *name = get_property_utf8_string(c, intern_atoms[NET_WM_NAME]);

	if (name)
	{
		g_free(c->net_wm_name);
		c->net_wm_name = name;
		dbg("NET_WM_NAME: %s\n", c->net_wm_name);
	}
}

static char *read_property_xa_string(const Client * c, const XTextProperty * text_prop)
{
	char *xa_string = NULL;

	//g_print("read_property_xa_string()\n");

	if (text_prop->value && (text_prop->nitems > 0) && (text_prop->format == 8))
	{
		if (text_prop->encoding == XA_STRING)
		{
			//fprintf (stderr, "read_property_xa_string:(): XA_STRING\n");
			xa_string =
				g_locale_to_utf8(text_prop->value, strlen(text_prop->value), NULL, NULL, NULL);
		}
		
		if (!xa_string)
		{
			int num;
			char **list;

			XmbTextPropertyToTextList(dpy, text_prop, &list, &num);
			if (num && (*list))
			{
				//fprintf (stderr, "read_property_xa_string:(): not XA_STRING\n");
				xa_string = g_locale_to_utf8(*list, strlen(*list), NULL, NULL, NULL);
				XFreeStringList(list);
			}
		}
		XFree(text_prop->value);
	}

	return xa_string;
}


#ifdef USE_ICON_NAME
void get_wm_icon_name(Client * c)
{
	DBUG_VERBOSE("entering get_wm_icon_name");

	XTextProperty text_prop;

	text_prop.value = NULL;
	text_prop.nitems = 0;
	if (XGetWMIconName(dpy, c->window, &text_prop))
	{
		gchar *name = read_property_xa_string(c, &text_prop);
		if (name)
		{
			g_free(c->wm_icon_name);
			c->wm_icon_name = name;
		}		
	}
}
#endif


void get_wm_name(Client * c)
{
	DBUG_VERBOSE("entering get_wm_name");
	 
	XTextProperty text_prop;

	text_prop.value = NULL;
	text_prop.nitems = 0;

	if (XGetWMName(dpy, c->window, &text_prop))
	{
		gchar *name = read_property_xa_string(c, &text_prop);
		if (name) 
		{
			g_free(c->wm_name);
			c->wm_name = name;
		}
	}
}

/* point to window title, return value <> 0 if title changed*/
gboolean get_window_title(Client *c)
{
	gchar *old_title = c->title_string;
	

	if (c->net_wm_name)
		c->title_string = g_strdup(c->net_wm_name);
	else if (c->wm_name)
		c->title_string = g_strdup(c->wm_name);
	else 
		c->title_string = g_strdup("");

	if (!old_title)
		return TRUE;

	gboolean retval = strcmp(old_title, c->title_string);
    
	g_free(old_title);
    
	return retval;
}

