/* 
 * Oroborus Window Manager
 * X11 I18N Support Library
 *
 * Copyright (C) 2001 Ken Lynch
 * Copyright (C) 2002 Stefan Pfetzing
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#ifndef __I18N_H
#define __I18N_H

#include <X11/Xlocale.h>


typedef struct {
	XftFont *xftfont;
	XftColor xft_detail[2];
	FcFontSet *fontset;
	FcConfig *fcconfig;
} MyFont;

extern MyFont title_font;
extern int use_fontset;
extern XftColor textcolor;
int getFont(Display *, MyFont *, char *);
int getTextWidth(char *, MyFont *);
#ifdef USE_ICON_NAME
void get_wm_icon_name(Client *);
void get_net_wm_icon_name(Client * c);
#endif
void get_wm_name(Client *);
void get_net_wm_name(Client *);
gboolean get_window_title(Client *c);

void drawString(Client *, Display *, Drawable, MyFont *, XftColor *, int, int, char *);

#endif /* __I18N_H */

/***This must remain at the end of the file.***********************************************
 * vi:set sw=2 cindent cinoptions={1s,>2s,^-1s,n-1s foldmethod=marker foldmarker=,: *
 ******************************************************************************************/
