# MD004 - Unordered list style should be consistent

Aliases: `ul-style`

## What this rule does

Ensures all unordered lists use the same marker (* or + or -) throughout your document.

## Why this matters

- **Visual consistency**: Mixed list markers look unprofessional and disorganized
- **Readability**: Consistent markers make it easier to scan lists
- **Maintenance**: One style is easier to remember and apply
- **Style guides**: Most organizations standardize on one list marker

## Examples

### ✅ Correct (using * throughout)

```markdown
* Item 1
* Item 2
  * Nested item 1
  * Nested item 2
* Item 3
```

### ✅ Correct (using - throughout)

```markdown
- Item 1
- Item 2
  - Nested item 1
  - Nested item 2
- Item 3
```

### ✅ Correct (using sublist style)

```markdown
* Item 1
* Item 2
  + Nested item 1
  + Nested item 2
    - Deep nested item 1
    - Deep nested item 2
      * Even deeper (cycles back to *)
* Item 3
```

### ❌ Incorrect

```markdown
* Item 1
+ Item 2  (different marker)
  - Nested item 1
  * Nested item 2
- Item 3  (yet another marker)
```

### 🔧 Fixed

```markdown
* Item 1
* Item 2
  * Nested item 1
  * Nested item 2
* Item 3
```

## Configuration

```toml
[MD004]
style = "consistent"  # Options: "consistent", "asterisk", "plus", "dash", "sublist"
after-marker = 1      # Number of spaces after marker (default: 1)
```

### Style options

- `"consistent"` (default): Use the most prevalent marker in your document (in case of a tie, dash `-` is preferred as it's the GitHub default)
- `"asterisk"`: Always use * markers
- `"plus"`: Always use + markers
- `"dash"`: Always use - markers
- `"sublist"`: Each nesting level uses a different marker (cycles through *, +, -)

## Automatic fixes

This rule automatically converts all list markers to match your configured style or the most prevalent marker in the document.

## Learn more

- [CommonMark lists](https://spec.commonmark.org/0.31.2/#lists) - Technical specification
- [Markdown Guide - Lists](https://www.markdownguide.org/basic-syntax/#lists) - List best practices

## Related rules

- [MD005](md005.md) - List indentation
- [MD007](md007.md) - Unordered list indentation  
- [MD030](md030.md) - List marker spacing
- [MD032](md032.md) - Lists should be surrounded by blank lines
