# MD062 - No whitespace in link destinations

Aliases: `link-destination-whitespace`, `no-space-in-link-destination`

## What this rule does

Removes unnecessary whitespace inside parentheses for link and image destinations.

## Why this matters

- **Copy-paste errors**: Extra spaces often appear from copying URLs with leading/trailing whitespace
- **Clean formatting**: Link destinations should be tightly wrapped
- **Consistent style**: Matches common markdown conventions
- **Prevents issues**: Some parsers may handle whitespace inconsistently

## Examples

<!-- rumdl-disable MD062 -->

### Correct

Link destinations directly touch the parentheses:

```markdown
[Visit our website](https://example.com)

![Company logo](logo.png)

[Link with title](https://example.com "Title text")
```

### Incorrect

Extra spaces inside parentheses around the URL:

```markdown
[Visit our website]( https://example.com)

[Visit our website](https://example.com )

[Visit our website]( https://example.com )

![Company logo]( logo.png )
```

### Fixed

Spaces removed from inside parentheses:

```markdown
[Visit our website](https://example.com)

[Visit our website](https://example.com)

[Visit our website](https://example.com)

![Company logo](logo.png)
```

<!-- rumdl-enable MD062 -->

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule will:

- Remove spaces after opening parenthesis `(`
- Remove spaces before closing parenthesis `)`
- Work on both regular links and images
- Preserve link titles (e.g., `"title text"`)
- Handle tabs and other whitespace characters

## Learn more

- [CommonMark specification for links](https://spec.commonmark.org/0.31.2/#links)
- [CommonMark specification for images](https://spec.commonmark.org/0.31.2/#images)

## Related rules

- [MD039 - No space in links](md039.md) - Remove spaces inside link text brackets
- [MD034 - No bare URLs](md034.md) - Ensure URLs are properly formatted as links
- [MD042 - No empty links](md042.md) - Ensure links have destinations
