# MD074 - MkDocs nav validation

Aliases: `mkdocs-nav`

## What this rule does

Validates that MkDocs navigation entries in `mkdocs.yml` point to existing files. This rule only runs when the markdown flavor is set to `mkdocs`.

## Why this matters

- **Prevents broken navigation**: Ensures all nav entries resolve to actual documentation files
- **Catches typos**: Common mistakes in file paths are caught before deployment
- **Maintains site structure**: Helps keep your MkDocs site organized and complete

## Examples

Given this `mkdocs.yml`:

```yaml
site_name: My Docs
docs_dir: docs
nav:
  - Home: index.md
  - Guide: guide.md
  - API:
    - Overview: api/overview.md
    - Reference: api/reference.md
```

### ✅ Correct

All referenced files exist in the `docs/` directory:

- `docs/index.md`
- `docs/guide.md`
- `docs/api/overview.md`
- `docs/api/reference.md`

Directory nav entries like `- Section: section/` are valid if `section/index.md` exists.

### ❌ Incorrect

```yaml
nav:
  - Home: index.md
  - Guide: missing-guide.md      # File doesn't exist
  - API:
    - Overview: /api/overview.md  # Absolute path (if configured to warn)
```

### 🔧 Fixed

This rule cannot automatically fix broken nav entries. You must manually:

- Fix typos in file paths
- Create missing documentation files
- Update nav structure after moving files

## Configuration

### `not-found`

How to handle nav entries pointing to non-existent files.

| Value            | Behavior          |
| ---------------- | ----------------- |
| `warn` (default) | Report a warning  |
| `ignore`         | Skip validation   |

### `omitted-files`

How to handle files in `docs_dir` that aren't referenced in nav.

| Value              | Behavior                |
| ------------------ | ----------------------- |
| `warn`             | Report files not in nav |
| `ignore` (default) | Skip this check         |

### `absolute-links`

How to handle absolute links (starting with `/`) in nav entries.

| Value              | Behavior         |
| ------------------ | ---------------- |
| `warn`             | Report a warning |
| `ignore` (default) | Skip validation  |

### Example configuration

```toml
# .rumdl.toml
[global]
flavor = "mkdocs"

[MD074]
not-found = "warn"
omitted-files = "warn"
absolute-links = "warn"
```

## Automatic fixes

This rule does not provide automatic fixes. Missing nav entries must be corrected manually.

## Learn more

- [MkDocs Navigation](https://www.mkdocs.org/user-guide/writing-your-docs/#configure-pages-and-navigation)
- [MkDocs Configuration](https://www.mkdocs.org/user-guide/configuration/)

## Related rules

- [MD057 - Check that file links work](md057.md)
- [MD051 - Fix broken link fragments](md051.md)
