# MD037 - Remove extra spaces in emphasis

Aliases: `no-space-in-emphasis`

## What this rule does

Removes unnecessary spaces between emphasis markers (*asterisks* or *underscores*) and the text they format.

## Why this matters

- **Consistent rendering**: Extra spaces can cause some tools to not recognize the formatting
- **Cleaner appearance**: Properly formatted emphasis looks more professional
- **Prevents confusion**: Clear boundaries between formatted and regular text
- **Better compatibility**: Works reliably across all Markdown viewers

## Examples

<!-- rumdl-disable MD037 -->

### ✅ Correct

Emphasis markers directly touch the text:

```markdown
This is *italic* text.

This is **bold** text.

This is ***bold italic*** text.

Using _underscores_ also works.
```

### ❌ Incorrect

Extra spaces inside emphasis markers:

```markdown
This is * italic with spaces * text.

This is ** bold with spaces ** text.

This is * space at start* text.

This is *space at end * text.
```

### 🔧 Fixed

Spaces removed from inside markers:

```markdown
This is *italic with spaces* text.

This is **bold with spaces** text.

This is *space at start* text.

This is *space at end* text.
```

<!-- rumdl-enable MD037 -->

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule will automatically remove spaces between:

- Opening emphasis markers and the first character
- Last character and closing emphasis markers
- Preserves all other spacing in your text

## Learn more

- [CommonMark specification for emphasis](https://spec.commonmark.org/0.31.2/#emphasis-and-strong-emphasis)

## Related rules

- [MD049 - Emphasis style](md049.md) - Choose between asterisks or underscores
- [MD050 - Strong style](md050.md) - Choose bold marker style
- [MD036 - No emphasis as heading](md036.md) - Use real headings instead of bold text
