# MD027 - No multiple spaces after quote marker

Aliases: `no-multiple-space-blockquote`

## What this rule does

Ensures quoted text has only one space after the > symbol, not multiple spaces.

## Why this matters

- **Consistency**: Extra spaces create uneven indentation in quotes
- **Readability**: Consistent spacing makes quoted content easier to follow
- **Standards**: One space after > is the Markdown convention

## Examples

### ✅ Correct

```markdown
> This is a properly formatted quote.
> Each line has one space after the > symbol.
> 
> Even with paragraph breaks.

> > Nested quotes also follow this rule.
> > Each level has one space.
```

### ❌ Incorrect

<!-- rumdl-disable MD027 -->

```markdown
>  This quote has two spaces after >
>   This line has three spaces
>    This line has four spaces

> >  Nested quote with extra spaces
```

<!-- rumdl-enable MD027 -->

### 🔧 Fixed

```markdown
> This quote has two spaces after >
> This line has three spaces
> This line has four spaces

> > Nested quote with extra spaces
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically removes extra spaces, leaving just one space after each > symbol.

## Learn more

- [CommonMark block quotes](https://spec.commonmark.org/0.31.2/#block-quotes) - Technical specification for quotes
- [Markdown Guide - Blockquotes](https://www.markdownguide.org/basic-syntax/#blockquotes-1) - Quote formatting guide

## Related rules

- [MD028](md028.md) - No blank lines inside quotes
- [MD009](md009.md) - No trailing spaces
- [MD032](md032.md) - Lists should be surrounded by blank lines
