# MD070 - Nested Code Fence Collision

Aliases: `nested-code-fence`

## Description

Detects when a fenced code block contains fence markers that would cause premature closure. This commonly occurs when documenting markdown examples that themselves contain code blocks.

## Why This Matters

When a code block's content contains fence markers (`` ``` `` or `~~~`) of the same type and equal or greater length, CommonMark parsers treat the inner fence as the closing fence, causing:

- Premature block closure
- Content appearing outside the intended block
- Rendering issues in documentation

## Examples

### Incorrect

The following markdown has a nested fence collision:

`````markdown
```markdown
1. First item

   ```python
   code_in_list()
   ```

1. Second item

```
`````

The inner `` ``` `` on line 4 closes the outer block prematurely.

### Correct

Use longer fences for the outer block:

`````markdown
````markdown
1. First item

   ```python
   code_in_list()
   ```

1. Second item

````
`````

## Automatic Fixes

This rule automatically:

1. Increases the outer fence length to be longer than any inner fence
2. Updates both the opening and closing fences

For example, if content contains triple backticks (`` ``` ``), the fix changes both fences to quadruple backticks (`` ```` ``).

## When This Rule Applies

This rule only triggers for:

- Fenced code blocks (`` ``` `` or `~~~`)
- Markdown-related blocks: empty language, `markdown`, or `md`
- When the content contains fence-like patterns that would close the outer block

Programming language blocks (Python, Rust, JavaScript, etc.) are not checked since backticks in those languages don't represent markdown fences.

### Different fence types don't collide

Tildes (`~~~`) and backticks (`` ``` ``) don't conflict:

````markdown
~~~markdown
```python
code()
```
~~~
````

This is valid because the inner backtick fence doesn't close the outer tilde fence.

## Related Rules

- [MD031](md031.md) - Fenced code blocks should be surrounded by blank lines
- [MD040](md040.md) - Fenced code blocks should have a language specified
- [MD046](md046.md) - Code block style (fenced vs indented)
- [MD048](md048.md) - Code fence style (backticks vs tildes)

## Learn More

- [CommonMark fenced code blocks](https://spec.commonmark.org/0.31.2/#fenced-code-blocks)
- [GitHub Flavored Markdown](https://github.github.com/gfm/#fenced-code-blocks)
