/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.apksig.SigningCertificateLineage;
import com.android.tools.build.bundletool.model.AutoValue_SigningConfiguration;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Optional;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class SigningConfiguration {
    public abstract SignerConfig getSignerConfig();

    public abstract Optional<Integer> getMinimumV3RotationApiVersion();

    public abstract Optional<SigningCertificateLineage> getSigningCertificateLineage();

    public abstract Optional<SignerConfig> getOldestSigner();

    public abstract Optional<Integer> getRotationMinSdkVersion();

    public abstract Builder toBuilder();

    public int getEffectiveMinimumV3RotationApiVersion() {
        return this.getMinimumV3RotationApiVersion().orElse(1);
    }

    public static Builder builder() {
        return new AutoValue_SigningConfiguration.Builder();
    }

    public static SigningConfiguration extractFromKeystore(Path keystorePath, String keyAlias, Optional<Password> optionalKeystorePassword, Optional<Password> optionalKeyPassword) {
        SignerConfig signerConfig = SignerConfig.extractFromKeystore(keystorePath, keyAlias, optionalKeystorePassword, optionalKeyPassword);
        return SigningConfiguration.builder().setSignerConfig(signerConfig).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSignerConfig(SignerConfig var1);

        public Builder setSignerConfig(PrivateKey privateKey, X509Certificate certificate) {
            return this.setSignerConfig(privateKey, ImmutableList.of(certificate));
        }

        public Builder setSignerConfig(PrivateKey privateKey, ImmutableList<X509Certificate> certificates) {
            return this.setSignerConfig(SignerConfig.builder().setPrivateKey(privateKey).setCertificates(certificates).build());
        }

        public abstract Builder setMinimumV3RotationApiVersion(Optional<Integer> var1);

        public abstract Builder setRotationMinSdkVersion(Optional<Integer> var1);

        public abstract Builder setSigningCertificateLineage(SigningCertificateLineage var1);

        public abstract Builder setOldestSigner(SignerConfig var1);

        abstract SigningConfiguration autoBuild();

        public SigningConfiguration build() {
            SigningConfiguration signingConfiguration = this.autoBuild();
            if (signingConfiguration.getOldestSigner().isPresent()) {
                Preconditions.checkState(signingConfiguration.getSigningCertificateLineage().isPresent(), "Oldest signer should not be provided without signing certificate lineage.");
            }
            return signingConfiguration;
        }
    }
}

