#! /bin/sh

# Convert .md files into .html for viewing with a web browser
#
# Usage: sh makehtml.sh
#
# It was written for sox_ng's wiki but can be used to convert any
# .md files in the current directory to HTML.
# It will just say "sox_ng wiki" at the top of each page.

# The sed scripts convert [Link](Link) to [Link](Link.html) 
# but not for http:// links (which contain a colon and slashes)
# nor for image files (which live in a subdir and contain a slash and a dot)
# nor for patch files (which contain a dot)

# multimarkdown https://fletcherpenney.net/multimarkdown
# can be obtained from https://github.com/fletcher/MultiMarkdown-6/releases
# and its output is naked HTML with no <head> or <body> tags.
# so we wrap that in a simple template.

echo '' | multimarkdown || {
    {
	echo "You need to install multimarkdown to run makehtml.sh"
	echo "Fedora: yum install multimarkdown"
	echo "Debian: apt-get install libtext-multimarkdown-perl"
	echo "or you can get it from"
	echo "https://fletcherpenney.net/multimarkdown" or
	echo "https://github.com/fletcher/MultiMarkdown-6/releases"
    } 1>&2
    exit 1
}

for a in *.md
do
    {
	title="$(basename "$a" .md)"
	echo "<html><head><title>$title - sox_ng wiki</title></head>"
	echo "<body><p align=center>sox_ng wiki - $title</p>"
	echo "<hr>"
	sed 's/  /    /g' "$a" | multimarkdown | \
	sed 's/href="\([-A-Za-z0-9]*\)"/href="\1.html"/g' | \
	sed 's/<table>/<table border=1 cellspacing=0>/'
	echo "<hr>Generated by <tt>makehtml.sh</tt> on $(date)</body>"
    } > "$(basename "$a" .md).html"
done

test -f Home.html && ln -sf Home.html index.html
