Example of illegal code:

```ada
package P is
   Max : Integer := 42;
   subtype Int is Natural range 0 .. Max; -- error: Max is not constant
end P;
```

This error is issued on direct reads of variables, or indirect reads of
variables through function calls, in specific expressions which should only
read constants in SPARK. Such a read violates legality rule 2 of [section 4.4 of
SPARK Reference Manual].

This is the case for type constraints, such as the bounds of subtype `Int`
above, which is not allowed to depend on the value of variable `Max`.

The fix is to introduce constants to capture the value of variables, that can
then be used in these specific expressions:

```ada
package P is
   Max : constant Integer := 42;
   subtype Int is Natural range 0 .. Max;
end P;
```

[section 4.4 of SPARK Reference Manual]:
https://docs.adacore.com/live/wave/spark2014/html/spark2014_rm/names-and-expressions.html#expressions
