package sqlite

import "strings"

// https://sqlite.org/lang_keywords.html
func (p *Parser) IsReservedKeyword(s string) bool {
	switch strings.ToLower(s) {
	case "abort":
	case "action":
	case "add":
	case "after":
	case "all":
	case "alter":
	case "always":
	case "analyze":
	case "and":
	case "as":
	case "asc":
	case "attach":
	case "autoincrement":
	case "before":
	case "begin":
	case "between":
	case "by":
	case "cascade":
	case "case":
	case "cast":
	case "check":
	case "collate":
	case "column":
	case "commit":
	case "conflict":
	case "constraint":
	case "create":
	case "cross":
	case "current":
	case "current_date":
	case "current_time":
	case "current_timestamp":
	case "database":
	case "default":
	case "deferrable":
	case "deferred":
	case "delete":
	case "desc":
	case "detach":
	case "distinct":
	case "do":
	case "drop":
	case "each":
	case "else":
	case "end":
	case "escape":
	case "except":
	case "exclude":
	case "exclusive":
	case "exists":
	case "explain":
	case "fail":
	case "filter":
	case "first":
	case "following":
	case "for":
	case "foreign":
	case "from":
	case "full":
	case "generated":
	case "glob":
	case "group":
	case "groups":
	case "having":
	case "if":
	case "ignore":
	case "immediate":
	case "in":
	case "index":
	case "indexed":
	case "initially":
	case "inner":
	case "insert":
	case "instead":
	case "intersect":
	case "into":
	case "is":
	case "isnull":
	case "join":
	case "key":
	case "last":
	case "left":
	case "like":
	case "limit":
	case "match":
	case "natural":
	case "no":
	case "not":
	case "nothing":
	case "notnull":
	case "null":
	case "nulls":
	case "of":
	case "offset":
	case "on":
	case "or":
	case "order":
	case "others":
	case "outer":
	case "over":
	case "partition":
	case "plan":
	case "pragma":
	case "preceding":
	case "primary":
	case "query":
	case "raise":
	case "range":
	case "recursive":
	case "references":
	case "regexp":
	case "reindex":
	case "release":
	case "rename":
	case "replace":
	case "restrict":
	case "right":
	case "rollback":
	case "row":
	case "rows":
	case "savepoint":
	case "select":
	case "set":
	case "table":
	case "temp":
	case "temporary":
	case "then":
	case "ties":
	case "to":
	case "transaction":
	case "trigger":
	case "unbounded":
	case "union":
	case "unique":
	case "update":
	case "using":
	case "vacuum":
	case "values":
	case "view":
	case "virtual":
	case "when":
	case "where":
	case "window":
	case "with":
	case "without":
	default:
		return false
	}
	return true
}
