// Copyright (C) 2022 Storj Labs, Inc.
// See LICENSE for copying information.

//go:build go1.18

package extensions

import (
	"testing"
)

func FuzzDecode(f *testing.F) {
	f.Add([]byte{})
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\x03\xff\x82\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\x05\xff\x82\x01\x02\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\r\xff\x82\x01\xf8\xff\xff\xff\xff\xff\xff\xff\xfe\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\b\xff\x82\x02\x03\x01\x02\x03\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\b\xff\x82\x03\x03\x05\x04\x03\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\x12\xff\x82\x01\xf8\xff\xff\xff\xff\xff\xff\xff\xfe\x01\x03\x05\x04\x03\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\x12\xff\x82\x01\xf8\xff\xff\xff\xff\xff\xff\xff\xfe\x02\x03\x05\x04\x03\x00"))
	f.Add([]byte("@\xff\x81\x03\x01\x01\nRevocation\x01\xff\x82\x00\x01\x03\x01\tTimestamp\x01\x04\x00\x01\aKeyHash\x01\n\x00\x01\tSignature\x01\n\x00\x00\x00\r\xff\x82\x02\x03\x01\x02\x03\x01\x03\x05\x04\x03\x00"))

	f.Fuzz(func(t *testing.T, data []byte) {
		var dec revocationDecoder
		_, _ = dec.decode(data)
	})
}
