// Code generated by protoc-gen-pico. DO NOT EDIT.
// source: test.proto
//
// versions:
//     protoc-gen-pico: (devel)
//     protoc:          v5.27.3

package picotest

import (
	picobuf "storj.io/picobuf"
	pic "storj.io/picobuf/internal/picotest/pic"
	picoconv "storj.io/picobuf/picoconv"
	picowire "storj.io/picobuf/picowire"
	time "time"
)

type Basic struct {
	Byte0        int32  `json:"byte0,omitempty"`
	Byte1        int32  `json:"byte1,omitempty"`
	Byte100      int32  `json:"byte100,omitempty"`
	Byte255      int32  `json:"byte255,omitempty"`
	StringEmpty  string `json:"string_empty,omitempty"`
	StringHello  string `json:"string_hello,omitempty"`
	BytesZero    []byte `json:"bytes_zero,omitempty"`
	BytesNumbers []byte `json:"bytes_numbers,omitempty"`
}

func (m *Basic) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Int32(1, &m.Byte0)
	c.Int32(2, &m.Byte1)
	c.Int32(3, &m.Byte100)
	c.Int32(4, &m.Byte255)
	c.String(5, &m.StringEmpty)
	c.String(6, &m.StringHello)
	c.Bytes(7, &m.BytesZero)
	c.Bytes(8, &m.BytesNumbers)
	return true
}

func (m *Basic) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Int32(1, &m.Byte0)
	c.Int32(2, &m.Byte1)
	c.Int32(3, &m.Byte100)
	c.Int32(4, &m.Byte255)
	c.String(5, &m.StringEmpty)
	c.String(6, &m.StringHello)
	c.Bytes(7, &m.BytesZero)
	c.Bytes(8, &m.BytesNumbers)
}

func (m *Basic) GetByte0() (v int32) {
	if m != nil {
		return m.Byte0
	}
	return 0
}

func (m *Basic) GetByte1() (v int32) {
	if m != nil {
		return m.Byte1
	}
	return 0
}

func (m *Basic) GetByte100() (v int32) {
	if m != nil {
		return m.Byte100
	}
	return 0
}

func (m *Basic) GetByte255() (v int32) {
	if m != nil {
		return m.Byte255
	}
	return 0
}

func (m *Basic) GetStringEmpty() (v string) {
	if m != nil {
		return m.StringEmpty
	}
	return ""
}

func (m *Basic) GetStringHello() (v string) {
	if m != nil {
		return m.StringHello
	}
	return ""
}

func (m *Basic) GetBytesZero() (v []byte) {
	if m != nil {
		return m.BytesZero
	}
	return nil
}

func (m *Basic) GetBytesNumbers() (v []byte) {
	if m != nil {
		return m.BytesNumbers
	}
	return nil
}

type Person struct {
	Name    string   `json:"name,omitempty"`
	Address *Address `json:"address,omitempty"`
}

func (m *Person) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.String(1, &m.Name)
	c.Message(2, m.Address.Encode)
	return true
}

func (m *Person) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.String(1, &m.Name)
	c.Message(2, func(c *picobuf.Decoder) {
		if m.Address == nil {
			m.Address = new(Address)
		}
		m.Address.Decode(c)
	})
}

func (m *Person) GetName() (v string) {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Person) GetAddress() (v *Address) {
	if m != nil {
		return m.Address
	}
	return nil
}

type Address struct {
	Street string `json:"street,omitempty"`
}

func (m *Address) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.String(1, &m.Street)
	return true
}

func (m *Address) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.String(1, &m.Street)
}

func (m *Address) GetStreet() (v string) {
	if m != nil {
		return m.Street
	}
	return ""
}

type AllTypes struct {
	Int32     int32      `json:"int32,omitempty"`
	Int64     int64      `json:"int64,omitempty"`
	Uint32    uint32     `json:"uint32,omitempty"`
	Uint64    uint64     `json:"uint64,omitempty"`
	Sint32    int32      `json:"sint32,omitempty"`
	Sint64    int64      `json:"sint64,omitempty"`
	Fixed32   uint32     `json:"fixed32,omitempty"`
	Fixed64   uint64     `json:"fixed64,omitempty"`
	Sfixed32  int32      `json:"sfixed32,omitempty"`
	Sfixed64  int64      `json:"sfixed64,omitempty"`
	Float     float32    `json:"float,omitempty"`
	Double    float64    `json:"double,omitempty"`
	Bool      bool       `json:"bool,omitempty"`
	String_   string     `json:"string,omitempty"`
	Bytes     []byte     `json:"bytes,omitempty"`
	Message   *Message   `json:"message,omitempty"`
	Int32S    []int32    `json:"int32s,omitempty"`
	Int64S    []int64    `json:"int64s,omitempty"`
	Uint32S   []uint32   `json:"uint32s,omitempty"`
	Uint64S   []uint64   `json:"uint64s,omitempty"`
	Sint32S   []int32    `json:"sint32s,omitempty"`
	Sint64S   []int64    `json:"sint64s,omitempty"`
	Fixed32S  []uint32   `json:"fixed32s,omitempty"`
	Fixed64S  []uint64   `json:"fixed64s,omitempty"`
	Sfixed32S []int32    `json:"sfixed32s,omitempty"`
	Sfixed64S []int64    `json:"sfixed64s,omitempty"`
	Floats    []float32  `json:"floats,omitempty"`
	Doubles   []float64  `json:"doubles,omitempty"`
	Bools     []bool     `json:"bools,omitempty"`
	Strings   []string   `json:"strings,omitempty"`
	Bytess    [][]byte   `json:"bytess,omitempty"`
	Messages  []*Message `json:"messages,omitempty"`
}

func (m *AllTypes) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Int32(1, &m.Int32)
	c.Int64(2, &m.Int64)
	c.Uint32(3, &m.Uint32)
	c.Uint64(4, &m.Uint64)
	c.Sint32(5, &m.Sint32)
	c.Sint64(6, &m.Sint64)
	c.Fixed32(7, &m.Fixed32)
	c.Fixed64(8, &m.Fixed64)
	c.Sfixed32(9, &m.Sfixed32)
	c.Sfixed64(10, &m.Sfixed64)
	c.Float(11, &m.Float)
	c.Double(12, &m.Double)
	c.Bool(13, &m.Bool)
	c.String(14, &m.String_)
	c.Bytes(15, &m.Bytes)
	c.Message(16, m.Message.Encode)
	c.RepeatedInt32(17, &m.Int32S)
	c.RepeatedInt64(18, &m.Int64S)
	c.RepeatedUint32(19, &m.Uint32S)
	c.RepeatedUint64(20, &m.Uint64S)
	c.RepeatedSint32(21, &m.Sint32S)
	c.RepeatedSint64(22, &m.Sint64S)
	c.RepeatedFixed32(23, &m.Fixed32S)
	c.RepeatedFixed64(24, &m.Fixed64S)
	c.RepeatedSfixed32(25, &m.Sfixed32S)
	c.RepeatedSfixed64(26, &m.Sfixed64S)
	c.RepeatedFloat(27, &m.Floats)
	c.RepeatedDouble(28, &m.Doubles)
	c.RepeatedBool(29, &m.Bools)
	c.RepeatedString(30, &m.Strings)
	c.RepeatedBytes(31, &m.Bytess)
	for _, x := range m.Messages {
		c.AlwaysMessage(32, x.Encode)
	}
	return true
}

func (m *AllTypes) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Int32(1, &m.Int32)
	c.Int64(2, &m.Int64)
	c.Uint32(3, &m.Uint32)
	c.Uint64(4, &m.Uint64)
	c.Sint32(5, &m.Sint32)
	c.Sint64(6, &m.Sint64)
	c.Fixed32(7, &m.Fixed32)
	c.Fixed64(8, &m.Fixed64)
	c.Sfixed32(9, &m.Sfixed32)
	c.Sfixed64(10, &m.Sfixed64)
	c.Float(11, &m.Float)
	c.Double(12, &m.Double)
	c.Bool(13, &m.Bool)
	c.String(14, &m.String_)
	c.Bytes(15, &m.Bytes)
	c.Message(16, func(c *picobuf.Decoder) {
		if m.Message == nil {
			m.Message = new(Message)
		}
		m.Message.Decode(c)
	})
	c.RepeatedInt32(17, &m.Int32S)
	c.RepeatedInt64(18, &m.Int64S)
	c.RepeatedUint32(19, &m.Uint32S)
	c.RepeatedUint64(20, &m.Uint64S)
	c.RepeatedSint32(21, &m.Sint32S)
	c.RepeatedSint64(22, &m.Sint64S)
	c.RepeatedFixed32(23, &m.Fixed32S)
	c.RepeatedFixed64(24, &m.Fixed64S)
	c.RepeatedSfixed32(25, &m.Sfixed32S)
	c.RepeatedSfixed64(26, &m.Sfixed64S)
	c.RepeatedFloat(27, &m.Floats)
	c.RepeatedDouble(28, &m.Doubles)
	c.RepeatedBool(29, &m.Bools)
	c.RepeatedString(30, &m.Strings)
	c.RepeatedBytes(31, &m.Bytess)
	c.RepeatedMessage(32, func(c *picobuf.Decoder) {
		x := new(Message)
		c.Loop(x.Decode)
		m.Messages = append(m.Messages, x)
	})
}

func (m *AllTypes) GetInt32() (v int32) {
	if m != nil {
		return m.Int32
	}
	return 0
}

func (m *AllTypes) GetInt64() (v int64) {
	if m != nil {
		return m.Int64
	}
	return 0
}

func (m *AllTypes) GetUint32() (v uint32) {
	if m != nil {
		return m.Uint32
	}
	return 0
}

func (m *AllTypes) GetUint64() (v uint64) {
	if m != nil {
		return m.Uint64
	}
	return 0
}

func (m *AllTypes) GetSint32() (v int32) {
	if m != nil {
		return m.Sint32
	}
	return 0
}

func (m *AllTypes) GetSint64() (v int64) {
	if m != nil {
		return m.Sint64
	}
	return 0
}

func (m *AllTypes) GetFixed32() (v uint32) {
	if m != nil {
		return m.Fixed32
	}
	return 0
}

func (m *AllTypes) GetFixed64() (v uint64) {
	if m != nil {
		return m.Fixed64
	}
	return 0
}

func (m *AllTypes) GetSfixed32() (v int32) {
	if m != nil {
		return m.Sfixed32
	}
	return 0
}

func (m *AllTypes) GetSfixed64() (v int64) {
	if m != nil {
		return m.Sfixed64
	}
	return 0
}

func (m *AllTypes) GetFloat() (v float32) {
	if m != nil {
		return m.Float
	}
	return 0
}

func (m *AllTypes) GetDouble() (v float64) {
	if m != nil {
		return m.Double
	}
	return 0
}

func (m *AllTypes) GetBool() (v bool) {
	if m != nil {
		return m.Bool
	}
	return false
}

func (m *AllTypes) GetString_() (v string) {
	if m != nil {
		return m.String_
	}
	return ""
}

func (m *AllTypes) GetBytes() (v []byte) {
	if m != nil {
		return m.Bytes
	}
	return nil
}

func (m *AllTypes) GetMessage() (v *Message) {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *AllTypes) GetInt32S() (v []int32) {
	if m != nil {
		return m.Int32S
	}
	return nil
}

func (m *AllTypes) GetInt64S() (v []int64) {
	if m != nil {
		return m.Int64S
	}
	return nil
}

func (m *AllTypes) GetUint32S() (v []uint32) {
	if m != nil {
		return m.Uint32S
	}
	return nil
}

func (m *AllTypes) GetUint64S() (v []uint64) {
	if m != nil {
		return m.Uint64S
	}
	return nil
}

func (m *AllTypes) GetSint32S() (v []int32) {
	if m != nil {
		return m.Sint32S
	}
	return nil
}

func (m *AllTypes) GetSint64S() (v []int64) {
	if m != nil {
		return m.Sint64S
	}
	return nil
}

func (m *AllTypes) GetFixed32S() (v []uint32) {
	if m != nil {
		return m.Fixed32S
	}
	return nil
}

func (m *AllTypes) GetFixed64S() (v []uint64) {
	if m != nil {
		return m.Fixed64S
	}
	return nil
}

func (m *AllTypes) GetSfixed32S() (v []int32) {
	if m != nil {
		return m.Sfixed32S
	}
	return nil
}

func (m *AllTypes) GetSfixed64S() (v []int64) {
	if m != nil {
		return m.Sfixed64S
	}
	return nil
}

func (m *AllTypes) GetFloats() (v []float32) {
	if m != nil {
		return m.Floats
	}
	return nil
}

func (m *AllTypes) GetDoubles() (v []float64) {
	if m != nil {
		return m.Doubles
	}
	return nil
}

func (m *AllTypes) GetBools() (v []bool) {
	if m != nil {
		return m.Bools
	}
	return nil
}

func (m *AllTypes) GetStrings() (v []string) {
	if m != nil {
		return m.Strings
	}
	return nil
}

func (m *AllTypes) GetBytess() (v [][]byte) {
	if m != nil {
		return m.Bytess
	}
	return nil
}

func (m *AllTypes) GetMessages() (v []*Message) {
	if m != nil {
		return m.Messages
	}
	return nil
}

type Message struct {
	Int32 int32 `json:"int32,omitempty"`
}

func (m *Message) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Int32(1, &m.Int32)
	return true
}

func (m *Message) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Int32(1, &m.Int32)
}

func (m *Message) GetInt32() (v int32) {
	if m != nil {
		return m.Int32
	}
	return 0
}

type Piece struct {
	Id  pic.ID `json:"id,omitempty"`
	Alt string `json:"alt,omitempty"`
}

func (m *Piece) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	m.Id.PicoEncode(c, 1)
	(*pic.RawString)(&m.Alt).PicoEncode(c, 2)
	return true
}

func (m *Piece) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	m.Id.PicoDecode(c, 1)
	(*pic.RawString)(&m.Alt).PicoDecode(c, 2)
}

func (m *Piece) GetId() (v pic.ID) {
	if m != nil {
		return m.Id
	}
	return // zero
}

func (m *Piece) GetAlt() (v string) {
	if m != nil {
		return m.Alt
	}
	return ""
}

type Map struct {
	Values map[int32]int32 `json:"values,omitempty"`
}

func (m *Map) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	(*picowire.MapInt32Int32)(&m.Values).PicoEncode(c, 1)
	return true
}

func (m *Map) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	(*picowire.MapInt32Int32)(&m.Values).PicoDecode(c, 1)
}

func (m *Map) GetValues() (v map[int32]int32) {
	if m != nil {
		return m.Values
	}
	return // zero
}

type VariationsScalar struct {
	Value        string   `json:"value,omitempty"`
	Opt          *string  `json:"opt,omitempty"`
	Rep          []string `json:"rep,omitempty"`
	PresentBasic string   `json:"present_basic,omitempty"`
	PresentOpt   string   `json:"present_opt,omitempty"`
	PresentRep   []string `json:"present_rep,omitempty"`
	OptBytes     *[]byte  `json:"opt_bytes,omitempty"`
}

func (m *VariationsScalar) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.String(1, &m.Value)
	if m.Opt != nil {
		c.String(2, m.Opt)
	}
	c.RepeatedString(3, &m.Rep)
	c.String(4, &m.PresentBasic)
	c.String(5, &m.PresentOpt)
	c.RepeatedString(6, &m.PresentRep)
	if m.OptBytes != nil {
		c.Bytes(7, m.OptBytes)
	}
	return true
}

func (m *VariationsScalar) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.String(1, &m.Value)
	if c.PendingField() == 2 {
		m.Opt = new(string)
		c.String(2, m.Opt)
	}
	c.RepeatedString(3, &m.Rep)
	c.String(4, &m.PresentBasic)
	c.String(5, &m.PresentOpt)
	c.RepeatedString(6, &m.PresentRep)
	if c.PendingField() == 7 {
		m.OptBytes = new([]byte)
		c.Bytes(7, m.OptBytes)
	}
}

func (m *VariationsScalar) GetValue() (v string) {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *VariationsScalar) GetOpt() (v *string) {
	if m != nil {
		return m.Opt
	}
	return nil
}

func (m *VariationsScalar) GetRep() (v []string) {
	if m != nil {
		return m.Rep
	}
	return nil
}

func (m *VariationsScalar) GetPresentBasic() (v string) {
	if m != nil {
		return m.PresentBasic
	}
	return ""
}

func (m *VariationsScalar) GetPresentOpt() (v string) {
	if m != nil {
		return m.PresentOpt
	}
	return ""
}

func (m *VariationsScalar) GetPresentRep() (v []string) {
	if m != nil {
		return m.PresentRep
	}
	return nil
}

func (m *VariationsScalar) GetOptBytes() (v *[]byte) {
	if m != nil {
		return m.OptBytes
	}
	return nil
}

type VariationsMessage struct {
	Value        *Message   `json:"value,omitempty"`
	Opt          *Message   `json:"opt,omitempty"`
	Rep          []*Message `json:"rep,omitempty"`
	PresentBasic Message    `json:"present_basic,omitempty"`
	PresentOpt   Message    `json:"present_opt,omitempty"`
	PresentRep   []Message  `json:"present_rep,omitempty"`
}

func (m *VariationsMessage) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Message(1, m.Value.Encode)
	c.Message(2, m.Opt.Encode)
	for _, x := range m.Rep {
		c.AlwaysMessage(3, x.Encode)
	}
	c.PresentMessage(4, m.PresentBasic.Encode)
	c.PresentMessage(5, m.PresentOpt.Encode)
	for i := range m.PresentRep {
		x := &m.PresentRep[i]
		c.AlwaysMessage(6, x.Encode)
	}
	return true
}

func (m *VariationsMessage) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Message(1, func(c *picobuf.Decoder) {
		if m.Value == nil {
			m.Value = new(Message)
		}
		m.Value.Decode(c)
	})
	c.Message(2, func(c *picobuf.Decoder) {
		if m.Opt == nil {
			m.Opt = new(Message)
		}
		m.Opt.Decode(c)
	})
	c.RepeatedMessage(3, func(c *picobuf.Decoder) {
		x := new(Message)
		c.Loop(x.Decode)
		m.Rep = append(m.Rep, x)
	})
	c.PresentMessage(4, m.PresentBasic.Decode)
	c.PresentMessage(5, m.PresentOpt.Decode)
	c.RepeatedMessage(6, func(c *picobuf.Decoder) {
		m.PresentRep = append(m.PresentRep, Message{})
		c.Loop(m.PresentRep[len(m.PresentRep)-1].Decode)
	})
}

func (m *VariationsMessage) GetValue() (v *Message) {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *VariationsMessage) GetOpt() (v *Message) {
	if m != nil {
		return m.Opt
	}
	return nil
}

func (m *VariationsMessage) GetRep() (v []*Message) {
	if m != nil {
		return m.Rep
	}
	return nil
}

func (m *VariationsMessage) GetPresentBasic() (v Message) {
	if m != nil {
		return m.PresentBasic
	}
	return // zero
}

func (m *VariationsMessage) GetPresentOpt() (v Message) {
	if m != nil {
		return m.PresentOpt
	}
	return // zero
}

func (m *VariationsMessage) GetPresentRep() (v []Message) {
	if m != nil {
		return m.PresentRep
	}
	return nil
}

type CustomBytes struct {
	Value        pic.ID   `json:"value,omitempty"`
	Opt          *pic.ID  `json:"opt,omitempty"`
	Rep          []pic.ID `json:"rep,omitempty"`
	PresentBasic pic.ID   `json:"present_basic,omitempty"`
	PresentOpt   pic.ID   `json:"present_opt,omitempty"`
	PresentRep   []pic.ID `json:"present_rep,omitempty"`
}

func (m *CustomBytes) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	m.Value.PicoEncode(c, 1)
	m.Opt.PicoEncode(c, 2)
	for i := range m.Rep {
		x := &m.Rep[i]
		x.PicoEncode(c, 3)
	}
	m.PresentBasic.PicoEncode(c, 4)
	m.PresentOpt.PicoEncode(c, 5)
	for i := range m.PresentRep {
		x := &m.PresentRep[i]
		x.PicoEncode(c, 6)
	}
	return true
}

func (m *CustomBytes) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	m.Value.PicoDecode(c, 1)
	if c.PendingField() == 2 {
		if m.Opt == nil {
			m.Opt = new(pic.ID)
		}
		m.Opt.PicoDecode(c, 2)
	}
	for c.PendingField() == 3 {
		m.Rep = append(m.Rep, pic.ID{})
		m.Rep[len(m.Rep)-1].PicoDecode(c, 3)
	}
	m.PresentBasic.PicoDecode(c, 4)
	m.PresentOpt.PicoDecode(c, 5)
	for c.PendingField() == 6 {
		m.PresentRep = append(m.PresentRep, pic.ID{})
		m.PresentRep[len(m.PresentRep)-1].PicoDecode(c, 6)
	}
}

func (m *CustomBytes) GetValue() (v pic.ID) {
	if m != nil {
		return m.Value
	}
	return // zero
}

func (m *CustomBytes) GetOpt() (v *pic.ID) {
	if m != nil {
		return m.Opt
	}
	return nil
}

func (m *CustomBytes) GetRep() (v []pic.ID) {
	if m != nil {
		return m.Rep
	}
	return nil
}

func (m *CustomBytes) GetPresentBasic() (v pic.ID) {
	if m != nil {
		return m.PresentBasic
	}
	return // zero
}

func (m *CustomBytes) GetPresentOpt() (v pic.ID) {
	if m != nil {
		return m.PresentOpt
	}
	return // zero
}

func (m *CustomBytes) GetPresentRep() (v []pic.ID) {
	if m != nil {
		return m.PresentRep
	}
	return nil
}

type Timestamp struct {
	Seconds int64 `json:"seconds,omitempty"`
	Nanos   int32 `json:"nanos,omitempty"`
}

func (m *Timestamp) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Int64(1, &m.Seconds)
	c.Int32(2, &m.Nanos)
	return true
}

func (m *Timestamp) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Int64(1, &m.Seconds)
	c.Int32(2, &m.Nanos)
}

func (m *Timestamp) GetSeconds() (v int64) {
	if m != nil {
		return m.Seconds
	}
	return 0
}

func (m *Timestamp) GetNanos() (v int32) {
	if m != nil {
		return m.Nanos
	}
	return 0
}

type CustomMessageTypes struct {
	Normal                        *Timestamp       `json:"normal,omitempty"`
	CustomType                    *pic.Timestamp   `json:"custom_type,omitempty"`
	PresentCustomType             pic.Timestamp    `json:"present_custom_type,omitempty"`
	CustomTypeCast                *time.Time       `json:"custom_type_cast,omitempty"`
	PresentCustomTypeCast         time.Time        `json:"present_custom_type_cast,omitempty"`
	RepeatedCustomType            []*pic.Timestamp `json:"repeated_custom_type,omitempty"`
	RepeatedPresentCustomType     []pic.Timestamp  `json:"repeated_present_custom_type,omitempty"`
	RepeatedCustomTypeCast        []*time.Time     `json:"repeated_custom_type_cast,omitempty"`
	RepeatedPresentCustomTypeCast []time.Time      `json:"repeated_present_custom_type_cast,omitempty"`
}

func (m *CustomMessageTypes) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Message(1, m.Normal.Encode)
	m.CustomType.PicoEncode(c, 2)
	m.PresentCustomType.PicoEncode(c, 3)
	(*picoconv.Timestamp)(m.CustomTypeCast).PicoEncode(c, 4)
	(*picoconv.Timestamp)(&m.PresentCustomTypeCast).PicoEncode(c, 5)
	for _, x := range m.RepeatedCustomType {
		x.PicoEncode(c, 6)
	}
	for i := range m.RepeatedPresentCustomType {
		x := &m.RepeatedPresentCustomType[i]
		x.PicoEncode(c, 7)
	}
	for _, x := range m.RepeatedCustomTypeCast {
		(*picoconv.Timestamp)(x).PicoEncode(c, 8)
	}
	for i := range m.RepeatedPresentCustomTypeCast {
		x := &m.RepeatedPresentCustomTypeCast[i]
		(*picoconv.Timestamp)(x).PicoEncode(c, 9)
	}
	return true
}

func (m *CustomMessageTypes) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Message(1, func(c *picobuf.Decoder) {
		if m.Normal == nil {
			m.Normal = new(Timestamp)
		}
		m.Normal.Decode(c)
	})
	if c.PendingField() == 2 {
		if m.CustomType == nil {
			m.CustomType = new(pic.Timestamp)
		}
		m.CustomType.PicoDecode(c, 2)
	}
	m.PresentCustomType.PicoDecode(c, 3)
	if c.PendingField() == 4 {
		if m.CustomTypeCast == nil {
			m.CustomTypeCast = new(time.Time)
		}
		(*picoconv.Timestamp)(m.CustomTypeCast).PicoDecode(c, 4)
	}
	(*picoconv.Timestamp)(&m.PresentCustomTypeCast).PicoDecode(c, 5)
	for c.PendingField() == 6 {
		x := new(pic.Timestamp)
		x.PicoDecode(c, 6)
		m.RepeatedCustomType = append(m.RepeatedCustomType, x)
	}
	for c.PendingField() == 7 {
		m.RepeatedPresentCustomType = append(m.RepeatedPresentCustomType, pic.Timestamp{})
		m.RepeatedPresentCustomType[len(m.RepeatedPresentCustomType)-1].PicoDecode(c, 7)
	}
	for c.PendingField() == 8 {
		x := new(time.Time)
		(*picoconv.Timestamp)(x).PicoDecode(c, 8)
		m.RepeatedCustomTypeCast = append(m.RepeatedCustomTypeCast, x)
	}
	for c.PendingField() == 9 {
		m.RepeatedPresentCustomTypeCast = append(m.RepeatedPresentCustomTypeCast, time.Time{})
		x := &m.RepeatedPresentCustomTypeCast[len(m.RepeatedPresentCustomTypeCast)-1]
		(*picoconv.Timestamp)(x).PicoDecode(c, 9)
	}
}

func (m *CustomMessageTypes) GetNormal() (v *Timestamp) {
	if m != nil {
		return m.Normal
	}
	return nil
}

func (m *CustomMessageTypes) GetCustomType() (v *pic.Timestamp) {
	if m != nil {
		return m.CustomType
	}
	return nil
}

func (m *CustomMessageTypes) GetPresentCustomType() (v pic.Timestamp) {
	if m != nil {
		return m.PresentCustomType
	}
	return // zero
}

func (m *CustomMessageTypes) GetCustomTypeCast() (v *time.Time) {
	if m != nil {
		return m.CustomTypeCast
	}
	return nil
}

func (m *CustomMessageTypes) GetPresentCustomTypeCast() (v time.Time) {
	if m != nil {
		return m.PresentCustomTypeCast
	}
	return // zero
}

func (m *CustomMessageTypes) GetRepeatedCustomType() (v []*pic.Timestamp) {
	if m != nil {
		return m.RepeatedCustomType
	}
	return nil
}

func (m *CustomMessageTypes) GetRepeatedPresentCustomType() (v []pic.Timestamp) {
	if m != nil {
		return m.RepeatedPresentCustomType
	}
	return nil
}

func (m *CustomMessageTypes) GetRepeatedCustomTypeCast() (v []*time.Time) {
	if m != nil {
		return m.RepeatedCustomTypeCast
	}
	return nil
}

func (m *CustomMessageTypes) GetRepeatedPresentCustomTypeCast() (v []time.Time) {
	if m != nil {
		return m.RepeatedPresentCustomTypeCast
	}
	return nil
}

type UnknownMessage struct {
	Second           int64 `json:"second,omitempty"`
	Fourth           int64 `json:"fourth,omitempty"`
	XXX_unrecognized []byte
}

func (m *UnknownMessage) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Int64(2, &m.Second)
	c.Int64(4, &m.Fourth)
	c.UnrecognizedFields(m.XXX_unrecognized)
	return true
}

func (m *UnknownMessage) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Int64(2, &m.Second)
	c.Int64(4, &m.Fourth)
	c.UnrecognizedFields(20, &m.XXX_unrecognized)
}

func (m *UnknownMessage) GetSecond() (v int64) {
	if m != nil {
		return m.Second
	}
	return 0
}

func (m *UnknownMessage) GetFourth() (v int64) {
	if m != nil {
		return m.Fourth
	}
	return 0
}

type KnownMessage struct {
	First            int64 `json:"first,omitempty"`
	Second           int64 `json:"second,omitempty"`
	Third            int64 `json:"third,omitempty"`
	Fourth           int64 `json:"fourth,omitempty"`
	XXX_unrecognized []byte
}

func (m *KnownMessage) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.Int64(1, &m.First)
	c.Int64(2, &m.Second)
	c.Int64(3, &m.Third)
	c.Int64(4, &m.Fourth)
	c.UnrecognizedFields(m.XXX_unrecognized)
	return true
}

func (m *KnownMessage) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.Int64(1, &m.First)
	c.Int64(2, &m.Second)
	c.Int64(3, &m.Third)
	c.Int64(4, &m.Fourth)
	c.UnrecognizedFields(30, &m.XXX_unrecognized)
}

func (m *KnownMessage) GetFirst() (v int64) {
	if m != nil {
		return m.First
	}
	return 0
}

func (m *KnownMessage) GetSecond() (v int64) {
	if m != nil {
		return m.Second
	}
	return 0
}

func (m *KnownMessage) GetThird() (v int64) {
	if m != nil {
		return m.Third
	}
	return 0
}

func (m *KnownMessage) GetFourth() (v int64) {
	if m != nil {
		return m.Fourth
	}
	return 0
}

type Tag struct {
	Key string `json:"key,omitempty"`
	// Types that are assignable to Value:
	//
	//	*Tag_String_
	//	*Tag_Int64
	//	*Tag_Double
	//	*Tag_Bytes
	//	*Tag_Bool
	//	*Tag_DurationNs
	//	*Tag_Timestamp
	Value isTag_Value
}

func (m *Tag) Encode(c *picobuf.Encoder) bool {
	if m == nil {
		return false
	}
	c.String(1, &m.Key)
	if m, ok := m.Value.(*Tag_String_); ok {
		c.AlwaysBytes(2, &m.String_)
	}
	if m, ok := m.Value.(*Tag_Int64); ok {
		c.AlwaysInt64(3, &m.Int64)
	}
	if m, ok := m.Value.(*Tag_Double); ok {
		c.AlwaysDouble(4, &m.Double)
	}
	if m, ok := m.Value.(*Tag_Bytes); ok {
		c.AlwaysBytes(5, &m.Bytes)
	}
	if m, ok := m.Value.(*Tag_Bool); ok {
		c.AlwaysBool(6, &m.Bool)
	}
	if m, ok := m.Value.(*Tag_DurationNs); ok {
		c.AlwaysInt64(7, &m.DurationNs)
	}
	if m, ok := m.Value.(*Tag_Timestamp); ok {
		c.Message(8, m.Timestamp.Encode)
	}
	return true
}

func (m *Tag) Decode(c *picobuf.Decoder) {
	if m == nil {
		return
	}
	c.String(1, &m.Key)
	if c.PendingField() == 2 {
		var x *Tag_String_
		if z, ok := m.Value.(*Tag_String_); ok {
			x = z
		} else {
			x = new(Tag_String_)
			m.Value = x
		}
		m := x
		c.Bytes(2, &m.String_)
	}
	if c.PendingField() == 3 {
		var x *Tag_Int64
		if z, ok := m.Value.(*Tag_Int64); ok {
			x = z
		} else {
			x = new(Tag_Int64)
			m.Value = x
		}
		m := x
		c.Int64(3, &m.Int64)
	}
	if c.PendingField() == 4 {
		var x *Tag_Double
		if z, ok := m.Value.(*Tag_Double); ok {
			x = z
		} else {
			x = new(Tag_Double)
			m.Value = x
		}
		m := x
		c.Double(4, &m.Double)
	}
	if c.PendingField() == 5 {
		var x *Tag_Bytes
		if z, ok := m.Value.(*Tag_Bytes); ok {
			x = z
		} else {
			x = new(Tag_Bytes)
			m.Value = x
		}
		m := x
		c.Bytes(5, &m.Bytes)
	}
	if c.PendingField() == 6 {
		var x *Tag_Bool
		if z, ok := m.Value.(*Tag_Bool); ok {
			x = z
		} else {
			x = new(Tag_Bool)
			m.Value = x
		}
		m := x
		c.Bool(6, &m.Bool)
	}
	if c.PendingField() == 7 {
		var x *Tag_DurationNs
		if z, ok := m.Value.(*Tag_DurationNs); ok {
			x = z
		} else {
			x = new(Tag_DurationNs)
			m.Value = x
		}
		m := x
		c.Int64(7, &m.DurationNs)
	}
	if c.PendingField() == 8 {
		var x *Tag_Timestamp
		if z, ok := m.Value.(*Tag_Timestamp); ok {
			x = z
		} else {
			x = new(Tag_Timestamp)
			m.Value = x
		}
		m := x
		c.Message(8, func(c *picobuf.Decoder) {
			if m.Timestamp == nil {
				m.Timestamp = new(Timestamp)
			}
			m.Timestamp.Decode(c)
		})
	}
}

func (m *Tag) GetKey() (v string) {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Tag) GetValue() (v isTag_Value) {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Tag) GetString_() (v []byte) {
	if x, ok := m.GetValue().(*Tag_String_); ok {
		return x.String_
	}
	return nil
}

func (m *Tag) GetInt64() (v int64) {
	if x, ok := m.GetValue().(*Tag_Int64); ok {
		return x.Int64
	}
	return 0
}

func (m *Tag) GetDouble() (v float64) {
	if x, ok := m.GetValue().(*Tag_Double); ok {
		return x.Double
	}
	return 0
}

func (m *Tag) GetBytes() (v []byte) {
	if x, ok := m.GetValue().(*Tag_Bytes); ok {
		return x.Bytes
	}
	return nil
}

func (m *Tag) GetBool() (v bool) {
	if x, ok := m.GetValue().(*Tag_Bool); ok {
		return x.Bool
	}
	return false
}

func (m *Tag) GetDurationNs() (v int64) {
	if x, ok := m.GetValue().(*Tag_DurationNs); ok {
		return x.DurationNs
	}
	return 0
}

func (m *Tag) GetTimestamp() (v *Timestamp) {
	if x, ok := m.GetValue().(*Tag_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

type isTag_Value interface{ isTag_Value() }

type Tag_String_ struct {
	String_ []byte
}

type Tag_Int64 struct {
	Int64 int64
}

type Tag_Double struct {
	Double float64
}

type Tag_Bytes struct {
	Bytes []byte
}

type Tag_Bool struct {
	Bool bool
}

type Tag_DurationNs struct {
	DurationNs int64
}

type Tag_Timestamp struct {
	Timestamp *Timestamp
}

func (*Tag_String_) isTag_Value()    {}
func (*Tag_Int64) isTag_Value()      {}
func (*Tag_Double) isTag_Value()     {}
func (*Tag_Bytes) isTag_Value()      {}
func (*Tag_Bool) isTag_Value()       {}
func (*Tag_DurationNs) isTag_Value() {}
func (*Tag_Timestamp) isTag_Value()  {}
