// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chatbot

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateChimeWebhookConfiguration = "CreateChimeWebhookConfiguration"

// CreateChimeWebhookConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateChimeWebhookConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChimeWebhookConfiguration for more information on using the CreateChimeWebhookConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChimeWebhookConfigurationRequest method.
//	req, resp := client.CreateChimeWebhookConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration
func (c *Chatbot) CreateChimeWebhookConfigurationRequest(input *CreateChimeWebhookConfigurationInput) (req *request.Request, output *CreateChimeWebhookConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateChimeWebhookConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/create-chime-webhook-configuration",
	}

	if input == nil {
		input = &CreateChimeWebhookConfigurationInput{}
	}

	output = &CreateChimeWebhookConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChimeWebhookConfiguration API operation for AWS Chatbot.
//
// # Creates Chime Webhook Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation CreateChimeWebhookConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - LimitExceededException
//     You have exceeded a service limit for AWS Chatbot.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - CreateChimeWebhookConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ConflictException
//     There was an issue processing your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration
func (c *Chatbot) CreateChimeWebhookConfiguration(input *CreateChimeWebhookConfigurationInput) (*CreateChimeWebhookConfigurationOutput, error) {
	req, out := c.CreateChimeWebhookConfigurationRequest(input)
	return out, req.Send()
}

// CreateChimeWebhookConfigurationWithContext is the same as CreateChimeWebhookConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChimeWebhookConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) CreateChimeWebhookConfigurationWithContext(ctx aws.Context, input *CreateChimeWebhookConfigurationInput, opts ...request.Option) (*CreateChimeWebhookConfigurationOutput, error) {
	req, out := c.CreateChimeWebhookConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMicrosoftTeamsChannelConfiguration = "CreateMicrosoftTeamsChannelConfiguration"

// CreateMicrosoftTeamsChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateMicrosoftTeamsChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMicrosoftTeamsChannelConfiguration for more information on using the CreateMicrosoftTeamsChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMicrosoftTeamsChannelConfigurationRequest method.
//	req, resp := client.CreateMicrosoftTeamsChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration
func (c *Chatbot) CreateMicrosoftTeamsChannelConfigurationRequest(input *CreateMicrosoftTeamsChannelConfigurationInput) (req *request.Request, output *CreateMicrosoftTeamsChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateMicrosoftTeamsChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/create-ms-teams-channel-configuration",
	}

	if input == nil {
		input = &CreateMicrosoftTeamsChannelConfigurationInput{}
	}

	output = &CreateMicrosoftTeamsChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMicrosoftTeamsChannelConfiguration API operation for AWS Chatbot.
//
// # Creates MS Teams Channel Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation CreateMicrosoftTeamsChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - LimitExceededException
//     You have exceeded a service limit for AWS Chatbot.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - CreateTeamsChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ConflictException
//     There was an issue processing your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration
func (c *Chatbot) CreateMicrosoftTeamsChannelConfiguration(input *CreateMicrosoftTeamsChannelConfigurationInput) (*CreateMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.CreateMicrosoftTeamsChannelConfigurationRequest(input)
	return out, req.Send()
}

// CreateMicrosoftTeamsChannelConfigurationWithContext is the same as CreateMicrosoftTeamsChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMicrosoftTeamsChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) CreateMicrosoftTeamsChannelConfigurationWithContext(ctx aws.Context, input *CreateMicrosoftTeamsChannelConfigurationInput, opts ...request.Option) (*CreateMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.CreateMicrosoftTeamsChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSlackChannelConfiguration = "CreateSlackChannelConfiguration"

// CreateSlackChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlackChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlackChannelConfiguration for more information on using the CreateSlackChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSlackChannelConfigurationRequest method.
//	req, resp := client.CreateSlackChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration
func (c *Chatbot) CreateSlackChannelConfigurationRequest(input *CreateSlackChannelConfigurationInput) (req *request.Request, output *CreateSlackChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSlackChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/create-slack-channel-configuration",
	}

	if input == nil {
		input = &CreateSlackChannelConfigurationInput{}
	}

	output = &CreateSlackChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSlackChannelConfiguration API operation for AWS Chatbot.
//
// # Creates Slack Channel Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation CreateSlackChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - LimitExceededException
//     You have exceeded a service limit for AWS Chatbot.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - CreateSlackChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ConflictException
//     There was an issue processing your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration
func (c *Chatbot) CreateSlackChannelConfiguration(input *CreateSlackChannelConfigurationInput) (*CreateSlackChannelConfigurationOutput, error) {
	req, out := c.CreateSlackChannelConfigurationRequest(input)
	return out, req.Send()
}

// CreateSlackChannelConfigurationWithContext is the same as CreateSlackChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlackChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) CreateSlackChannelConfigurationWithContext(ctx aws.Context, input *CreateSlackChannelConfigurationInput, opts ...request.Option) (*CreateSlackChannelConfigurationOutput, error) {
	req, out := c.CreateSlackChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChimeWebhookConfiguration = "DeleteChimeWebhookConfiguration"

// DeleteChimeWebhookConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChimeWebhookConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChimeWebhookConfiguration for more information on using the DeleteChimeWebhookConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChimeWebhookConfigurationRequest method.
//	req, resp := client.DeleteChimeWebhookConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration
func (c *Chatbot) DeleteChimeWebhookConfigurationRequest(input *DeleteChimeWebhookConfigurationInput) (req *request.Request, output *DeleteChimeWebhookConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteChimeWebhookConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-chime-webhook-configuration",
	}

	if input == nil {
		input = &DeleteChimeWebhookConfigurationInput{}
	}

	output = &DeleteChimeWebhookConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChimeWebhookConfiguration API operation for AWS Chatbot.
//
// # Deletes a Chime Webhook Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteChimeWebhookConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - DeleteChimeWebhookConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration
func (c *Chatbot) DeleteChimeWebhookConfiguration(input *DeleteChimeWebhookConfigurationInput) (*DeleteChimeWebhookConfigurationOutput, error) {
	req, out := c.DeleteChimeWebhookConfigurationRequest(input)
	return out, req.Send()
}

// DeleteChimeWebhookConfigurationWithContext is the same as DeleteChimeWebhookConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChimeWebhookConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteChimeWebhookConfigurationWithContext(ctx aws.Context, input *DeleteChimeWebhookConfigurationInput, opts ...request.Option) (*DeleteChimeWebhookConfigurationOutput, error) {
	req, out := c.DeleteChimeWebhookConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMicrosoftTeamsChannelConfiguration = "DeleteMicrosoftTeamsChannelConfiguration"

// DeleteMicrosoftTeamsChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMicrosoftTeamsChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMicrosoftTeamsChannelConfiguration for more information on using the DeleteMicrosoftTeamsChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMicrosoftTeamsChannelConfigurationRequest method.
//	req, resp := client.DeleteMicrosoftTeamsChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration
func (c *Chatbot) DeleteMicrosoftTeamsChannelConfigurationRequest(input *DeleteMicrosoftTeamsChannelConfigurationInput) (req *request.Request, output *DeleteMicrosoftTeamsChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteMicrosoftTeamsChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-ms-teams-channel-configuration",
	}

	if input == nil {
		input = &DeleteMicrosoftTeamsChannelConfigurationInput{}
	}

	output = &DeleteMicrosoftTeamsChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMicrosoftTeamsChannelConfiguration API operation for AWS Chatbot.
//
// # Deletes MS Teams Channel Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteMicrosoftTeamsChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - DeleteTeamsChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration
func (c *Chatbot) DeleteMicrosoftTeamsChannelConfiguration(input *DeleteMicrosoftTeamsChannelConfigurationInput) (*DeleteMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.DeleteMicrosoftTeamsChannelConfigurationRequest(input)
	return out, req.Send()
}

// DeleteMicrosoftTeamsChannelConfigurationWithContext is the same as DeleteMicrosoftTeamsChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMicrosoftTeamsChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteMicrosoftTeamsChannelConfigurationWithContext(ctx aws.Context, input *DeleteMicrosoftTeamsChannelConfigurationInput, opts ...request.Option) (*DeleteMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.DeleteMicrosoftTeamsChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMicrosoftTeamsConfiguredTeam = "DeleteMicrosoftTeamsConfiguredTeam"

// DeleteMicrosoftTeamsConfiguredTeamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMicrosoftTeamsConfiguredTeam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMicrosoftTeamsConfiguredTeam for more information on using the DeleteMicrosoftTeamsConfiguredTeam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMicrosoftTeamsConfiguredTeamRequest method.
//	req, resp := client.DeleteMicrosoftTeamsConfiguredTeamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam
func (c *Chatbot) DeleteMicrosoftTeamsConfiguredTeamRequest(input *DeleteMicrosoftTeamsConfiguredTeamInput) (req *request.Request, output *DeleteMicrosoftTeamsConfiguredTeamOutput) {
	op := &request.Operation{
		Name:       opDeleteMicrosoftTeamsConfiguredTeam,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-ms-teams-configured-teams",
	}

	if input == nil {
		input = &DeleteMicrosoftTeamsConfiguredTeamInput{}
	}

	output = &DeleteMicrosoftTeamsConfiguredTeamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMicrosoftTeamsConfiguredTeam API operation for AWS Chatbot.
//
// Deletes the Microsoft Teams team authorization allowing for channels to be
// configured in that Microsoft Teams team. Note that the Microsoft Teams team
// must have no channels configured to remove it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteMicrosoftTeamsConfiguredTeam for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - DeleteTeamsConfiguredTeamException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam
func (c *Chatbot) DeleteMicrosoftTeamsConfiguredTeam(input *DeleteMicrosoftTeamsConfiguredTeamInput) (*DeleteMicrosoftTeamsConfiguredTeamOutput, error) {
	req, out := c.DeleteMicrosoftTeamsConfiguredTeamRequest(input)
	return out, req.Send()
}

// DeleteMicrosoftTeamsConfiguredTeamWithContext is the same as DeleteMicrosoftTeamsConfiguredTeam with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMicrosoftTeamsConfiguredTeam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteMicrosoftTeamsConfiguredTeamWithContext(ctx aws.Context, input *DeleteMicrosoftTeamsConfiguredTeamInput, opts ...request.Option) (*DeleteMicrosoftTeamsConfiguredTeamOutput, error) {
	req, out := c.DeleteMicrosoftTeamsConfiguredTeamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMicrosoftTeamsUserIdentity = "DeleteMicrosoftTeamsUserIdentity"

// DeleteMicrosoftTeamsUserIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMicrosoftTeamsUserIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMicrosoftTeamsUserIdentity for more information on using the DeleteMicrosoftTeamsUserIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMicrosoftTeamsUserIdentityRequest method.
//	req, resp := client.DeleteMicrosoftTeamsUserIdentityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity
func (c *Chatbot) DeleteMicrosoftTeamsUserIdentityRequest(input *DeleteMicrosoftTeamsUserIdentityInput) (req *request.Request, output *DeleteMicrosoftTeamsUserIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteMicrosoftTeamsUserIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-ms-teams-user-identity",
	}

	if input == nil {
		input = &DeleteMicrosoftTeamsUserIdentityInput{}
	}

	output = &DeleteMicrosoftTeamsUserIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMicrosoftTeamsUserIdentity API operation for AWS Chatbot.
//
// # Deletes a Teams user identity
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteMicrosoftTeamsUserIdentity for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - DeleteMicrosoftTeamsUserIdentityException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity
func (c *Chatbot) DeleteMicrosoftTeamsUserIdentity(input *DeleteMicrosoftTeamsUserIdentityInput) (*DeleteMicrosoftTeamsUserIdentityOutput, error) {
	req, out := c.DeleteMicrosoftTeamsUserIdentityRequest(input)
	return out, req.Send()
}

// DeleteMicrosoftTeamsUserIdentityWithContext is the same as DeleteMicrosoftTeamsUserIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMicrosoftTeamsUserIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteMicrosoftTeamsUserIdentityWithContext(ctx aws.Context, input *DeleteMicrosoftTeamsUserIdentityInput, opts ...request.Option) (*DeleteMicrosoftTeamsUserIdentityOutput, error) {
	req, out := c.DeleteMicrosoftTeamsUserIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlackChannelConfiguration = "DeleteSlackChannelConfiguration"

// DeleteSlackChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlackChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlackChannelConfiguration for more information on using the DeleteSlackChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlackChannelConfigurationRequest method.
//	req, resp := client.DeleteSlackChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration
func (c *Chatbot) DeleteSlackChannelConfigurationRequest(input *DeleteSlackChannelConfigurationInput) (req *request.Request, output *DeleteSlackChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSlackChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-slack-channel-configuration",
	}

	if input == nil {
		input = &DeleteSlackChannelConfigurationInput{}
	}

	output = &DeleteSlackChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlackChannelConfiguration API operation for AWS Chatbot.
//
// # Deletes Slack Channel Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteSlackChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - DeleteSlackChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration
func (c *Chatbot) DeleteSlackChannelConfiguration(input *DeleteSlackChannelConfigurationInput) (*DeleteSlackChannelConfigurationOutput, error) {
	req, out := c.DeleteSlackChannelConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSlackChannelConfigurationWithContext is the same as DeleteSlackChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlackChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteSlackChannelConfigurationWithContext(ctx aws.Context, input *DeleteSlackChannelConfigurationInput, opts ...request.Option) (*DeleteSlackChannelConfigurationOutput, error) {
	req, out := c.DeleteSlackChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlackUserIdentity = "DeleteSlackUserIdentity"

// DeleteSlackUserIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlackUserIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlackUserIdentity for more information on using the DeleteSlackUserIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlackUserIdentityRequest method.
//	req, resp := client.DeleteSlackUserIdentityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity
func (c *Chatbot) DeleteSlackUserIdentityRequest(input *DeleteSlackUserIdentityInput) (req *request.Request, output *DeleteSlackUserIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteSlackUserIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-slack-user-identity",
	}

	if input == nil {
		input = &DeleteSlackUserIdentityInput{}
	}

	output = &DeleteSlackUserIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlackUserIdentity API operation for AWS Chatbot.
//
// # Deletes a Slack user identity
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteSlackUserIdentity for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - DeleteSlackUserIdentityException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity
func (c *Chatbot) DeleteSlackUserIdentity(input *DeleteSlackUserIdentityInput) (*DeleteSlackUserIdentityOutput, error) {
	req, out := c.DeleteSlackUserIdentityRequest(input)
	return out, req.Send()
}

// DeleteSlackUserIdentityWithContext is the same as DeleteSlackUserIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlackUserIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteSlackUserIdentityWithContext(ctx aws.Context, input *DeleteSlackUserIdentityInput, opts ...request.Option) (*DeleteSlackUserIdentityOutput, error) {
	req, out := c.DeleteSlackUserIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlackWorkspaceAuthorization = "DeleteSlackWorkspaceAuthorization"

// DeleteSlackWorkspaceAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlackWorkspaceAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlackWorkspaceAuthorization for more information on using the DeleteSlackWorkspaceAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlackWorkspaceAuthorizationRequest method.
//	req, resp := client.DeleteSlackWorkspaceAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization
func (c *Chatbot) DeleteSlackWorkspaceAuthorizationRequest(input *DeleteSlackWorkspaceAuthorizationInput) (req *request.Request, output *DeleteSlackWorkspaceAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteSlackWorkspaceAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-slack-workspace-authorization",
	}

	if input == nil {
		input = &DeleteSlackWorkspaceAuthorizationInput{}
	}

	output = &DeleteSlackWorkspaceAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlackWorkspaceAuthorization API operation for AWS Chatbot.
//
// Deletes the Slack workspace authorization that allows channels to be configured
// in that workspace. This requires all configured channels in the workspace
// to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DeleteSlackWorkspaceAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - DeleteSlackWorkspaceAuthorizationFault
//     There was an issue deleting your Slack workspace.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization
func (c *Chatbot) DeleteSlackWorkspaceAuthorization(input *DeleteSlackWorkspaceAuthorizationInput) (*DeleteSlackWorkspaceAuthorizationOutput, error) {
	req, out := c.DeleteSlackWorkspaceAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteSlackWorkspaceAuthorizationWithContext is the same as DeleteSlackWorkspaceAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlackWorkspaceAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DeleteSlackWorkspaceAuthorizationWithContext(ctx aws.Context, input *DeleteSlackWorkspaceAuthorizationInput, opts ...request.Option) (*DeleteSlackWorkspaceAuthorizationOutput, error) {
	req, out := c.DeleteSlackWorkspaceAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChimeWebhookConfigurations = "DescribeChimeWebhookConfigurations"

// DescribeChimeWebhookConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChimeWebhookConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChimeWebhookConfigurations for more information on using the DescribeChimeWebhookConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChimeWebhookConfigurationsRequest method.
//	req, resp := client.DescribeChimeWebhookConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations
func (c *Chatbot) DescribeChimeWebhookConfigurationsRequest(input *DescribeChimeWebhookConfigurationsInput) (req *request.Request, output *DescribeChimeWebhookConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeChimeWebhookConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-chime-webhook-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeChimeWebhookConfigurationsInput{}
	}

	output = &DescribeChimeWebhookConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChimeWebhookConfigurations API operation for AWS Chatbot.
//
// # Lists Chime Webhook Configurations optionally filtered by ChatConfigurationArn
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DescribeChimeWebhookConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - DescribeChimeWebhookConfigurationsException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations
func (c *Chatbot) DescribeChimeWebhookConfigurations(input *DescribeChimeWebhookConfigurationsInput) (*DescribeChimeWebhookConfigurationsOutput, error) {
	req, out := c.DescribeChimeWebhookConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeChimeWebhookConfigurationsWithContext is the same as DescribeChimeWebhookConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChimeWebhookConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeChimeWebhookConfigurationsWithContext(ctx aws.Context, input *DescribeChimeWebhookConfigurationsInput, opts ...request.Option) (*DescribeChimeWebhookConfigurationsOutput, error) {
	req, out := c.DescribeChimeWebhookConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeChimeWebhookConfigurationsPages iterates over the pages of a DescribeChimeWebhookConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeChimeWebhookConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeChimeWebhookConfigurations operation.
//	pageNum := 0
//	err := client.DescribeChimeWebhookConfigurationsPages(params,
//	    func(page *chatbot.DescribeChimeWebhookConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) DescribeChimeWebhookConfigurationsPages(input *DescribeChimeWebhookConfigurationsInput, fn func(*DescribeChimeWebhookConfigurationsOutput, bool) bool) error {
	return c.DescribeChimeWebhookConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeChimeWebhookConfigurationsPagesWithContext same as DescribeChimeWebhookConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeChimeWebhookConfigurationsPagesWithContext(ctx aws.Context, input *DescribeChimeWebhookConfigurationsInput, fn func(*DescribeChimeWebhookConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeChimeWebhookConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeChimeWebhookConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeChimeWebhookConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSlackChannelConfigurations = "DescribeSlackChannelConfigurations"

// DescribeSlackChannelConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlackChannelConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlackChannelConfigurations for more information on using the DescribeSlackChannelConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlackChannelConfigurationsRequest method.
//	req, resp := client.DescribeSlackChannelConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations
func (c *Chatbot) DescribeSlackChannelConfigurationsRequest(input *DescribeSlackChannelConfigurationsInput) (req *request.Request, output *DescribeSlackChannelConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeSlackChannelConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-slack-channel-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSlackChannelConfigurationsInput{}
	}

	output = &DescribeSlackChannelConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlackChannelConfigurations API operation for AWS Chatbot.
//
// # Lists Slack Channel Configurations optionally filtered by ChatConfigurationArn
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DescribeSlackChannelConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - DescribeSlackChannelConfigurationsException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations
func (c *Chatbot) DescribeSlackChannelConfigurations(input *DescribeSlackChannelConfigurationsInput) (*DescribeSlackChannelConfigurationsOutput, error) {
	req, out := c.DescribeSlackChannelConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeSlackChannelConfigurationsWithContext is the same as DescribeSlackChannelConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlackChannelConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeSlackChannelConfigurationsWithContext(ctx aws.Context, input *DescribeSlackChannelConfigurationsInput, opts ...request.Option) (*DescribeSlackChannelConfigurationsOutput, error) {
	req, out := c.DescribeSlackChannelConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSlackChannelConfigurationsPages iterates over the pages of a DescribeSlackChannelConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSlackChannelConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSlackChannelConfigurations operation.
//	pageNum := 0
//	err := client.DescribeSlackChannelConfigurationsPages(params,
//	    func(page *chatbot.DescribeSlackChannelConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) DescribeSlackChannelConfigurationsPages(input *DescribeSlackChannelConfigurationsInput, fn func(*DescribeSlackChannelConfigurationsOutput, bool) bool) error {
	return c.DescribeSlackChannelConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSlackChannelConfigurationsPagesWithContext same as DescribeSlackChannelConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeSlackChannelConfigurationsPagesWithContext(ctx aws.Context, input *DescribeSlackChannelConfigurationsInput, fn func(*DescribeSlackChannelConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSlackChannelConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSlackChannelConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSlackChannelConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSlackUserIdentities = "DescribeSlackUserIdentities"

// DescribeSlackUserIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlackUserIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlackUserIdentities for more information on using the DescribeSlackUserIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlackUserIdentitiesRequest method.
//	req, resp := client.DescribeSlackUserIdentitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities
func (c *Chatbot) DescribeSlackUserIdentitiesRequest(input *DescribeSlackUserIdentitiesInput) (req *request.Request, output *DescribeSlackUserIdentitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeSlackUserIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-slack-user-identities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSlackUserIdentitiesInput{}
	}

	output = &DescribeSlackUserIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlackUserIdentities API operation for AWS Chatbot.
//
// Lists all Slack user identities with a mapped role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DescribeSlackUserIdentities for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - DescribeSlackUserIdentitiesException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities
func (c *Chatbot) DescribeSlackUserIdentities(input *DescribeSlackUserIdentitiesInput) (*DescribeSlackUserIdentitiesOutput, error) {
	req, out := c.DescribeSlackUserIdentitiesRequest(input)
	return out, req.Send()
}

// DescribeSlackUserIdentitiesWithContext is the same as DescribeSlackUserIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlackUserIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeSlackUserIdentitiesWithContext(ctx aws.Context, input *DescribeSlackUserIdentitiesInput, opts ...request.Option) (*DescribeSlackUserIdentitiesOutput, error) {
	req, out := c.DescribeSlackUserIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSlackUserIdentitiesPages iterates over the pages of a DescribeSlackUserIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSlackUserIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSlackUserIdentities operation.
//	pageNum := 0
//	err := client.DescribeSlackUserIdentitiesPages(params,
//	    func(page *chatbot.DescribeSlackUserIdentitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) DescribeSlackUserIdentitiesPages(input *DescribeSlackUserIdentitiesInput, fn func(*DescribeSlackUserIdentitiesOutput, bool) bool) error {
	return c.DescribeSlackUserIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSlackUserIdentitiesPagesWithContext same as DescribeSlackUserIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeSlackUserIdentitiesPagesWithContext(ctx aws.Context, input *DescribeSlackUserIdentitiesInput, fn func(*DescribeSlackUserIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSlackUserIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSlackUserIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSlackUserIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSlackWorkspaces = "DescribeSlackWorkspaces"

// DescribeSlackWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlackWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlackWorkspaces for more information on using the DescribeSlackWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlackWorkspacesRequest method.
//	req, resp := client.DescribeSlackWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces
func (c *Chatbot) DescribeSlackWorkspacesRequest(input *DescribeSlackWorkspacesInput) (req *request.Request, output *DescribeSlackWorkspacesOutput) {
	op := &request.Operation{
		Name:       opDescribeSlackWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-slack-workspaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSlackWorkspacesInput{}
	}

	output = &DescribeSlackWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlackWorkspaces API operation for AWS Chatbot.
//
// # Lists all authorized Slack Workspaces for AWS Account
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation DescribeSlackWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - DescribeSlackWorkspacesException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces
func (c *Chatbot) DescribeSlackWorkspaces(input *DescribeSlackWorkspacesInput) (*DescribeSlackWorkspacesOutput, error) {
	req, out := c.DescribeSlackWorkspacesRequest(input)
	return out, req.Send()
}

// DescribeSlackWorkspacesWithContext is the same as DescribeSlackWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlackWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeSlackWorkspacesWithContext(ctx aws.Context, input *DescribeSlackWorkspacesInput, opts ...request.Option) (*DescribeSlackWorkspacesOutput, error) {
	req, out := c.DescribeSlackWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSlackWorkspacesPages iterates over the pages of a DescribeSlackWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSlackWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSlackWorkspaces operation.
//	pageNum := 0
//	err := client.DescribeSlackWorkspacesPages(params,
//	    func(page *chatbot.DescribeSlackWorkspacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) DescribeSlackWorkspacesPages(input *DescribeSlackWorkspacesInput, fn func(*DescribeSlackWorkspacesOutput, bool) bool) error {
	return c.DescribeSlackWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSlackWorkspacesPagesWithContext same as DescribeSlackWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) DescribeSlackWorkspacesPagesWithContext(ctx aws.Context, input *DescribeSlackWorkspacesInput, fn func(*DescribeSlackWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSlackWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSlackWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSlackWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAccountPreferences = "GetAccountPreferences"

// GetAccountPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountPreferences for more information on using the GetAccountPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountPreferencesRequest method.
//	req, resp := client.GetAccountPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences
func (c *Chatbot) GetAccountPreferencesRequest(input *GetAccountPreferencesInput) (req *request.Request, output *GetAccountPreferencesOutput) {
	op := &request.Operation{
		Name:       opGetAccountPreferences,
		HTTPMethod: "POST",
		HTTPPath:   "/get-account-preferences",
	}

	if input == nil {
		input = &GetAccountPreferencesInput{}
	}

	output = &GetAccountPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountPreferences API operation for AWS Chatbot.
//
// # Get Chatbot account level preferences
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation GetAccountPreferences for usage and error information.
//
// Returned Error Types:
//
//   - GetAccountPreferencesException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences
func (c *Chatbot) GetAccountPreferences(input *GetAccountPreferencesInput) (*GetAccountPreferencesOutput, error) {
	req, out := c.GetAccountPreferencesRequest(input)
	return out, req.Send()
}

// GetAccountPreferencesWithContext is the same as GetAccountPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) GetAccountPreferencesWithContext(ctx aws.Context, input *GetAccountPreferencesInput, opts ...request.Option) (*GetAccountPreferencesOutput, error) {
	req, out := c.GetAccountPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMicrosoftTeamsChannelConfiguration = "GetMicrosoftTeamsChannelConfiguration"

// GetMicrosoftTeamsChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetMicrosoftTeamsChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMicrosoftTeamsChannelConfiguration for more information on using the GetMicrosoftTeamsChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMicrosoftTeamsChannelConfigurationRequest method.
//	req, resp := client.GetMicrosoftTeamsChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration
func (c *Chatbot) GetMicrosoftTeamsChannelConfigurationRequest(input *GetMicrosoftTeamsChannelConfigurationInput) (req *request.Request, output *GetMicrosoftTeamsChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetMicrosoftTeamsChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/get-ms-teams-channel-configuration",
	}

	if input == nil {
		input = &GetMicrosoftTeamsChannelConfigurationInput{}
	}

	output = &GetMicrosoftTeamsChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMicrosoftTeamsChannelConfiguration API operation for AWS Chatbot.
//
// # Get a single MS Teams Channel Configurations
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation GetMicrosoftTeamsChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - GetTeamsChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration
func (c *Chatbot) GetMicrosoftTeamsChannelConfiguration(input *GetMicrosoftTeamsChannelConfigurationInput) (*GetMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.GetMicrosoftTeamsChannelConfigurationRequest(input)
	return out, req.Send()
}

// GetMicrosoftTeamsChannelConfigurationWithContext is the same as GetMicrosoftTeamsChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetMicrosoftTeamsChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) GetMicrosoftTeamsChannelConfigurationWithContext(ctx aws.Context, input *GetMicrosoftTeamsChannelConfigurationInput, opts ...request.Option) (*GetMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.GetMicrosoftTeamsChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMicrosoftTeamsChannelConfigurations = "ListMicrosoftTeamsChannelConfigurations"

// ListMicrosoftTeamsChannelConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListMicrosoftTeamsChannelConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMicrosoftTeamsChannelConfigurations for more information on using the ListMicrosoftTeamsChannelConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMicrosoftTeamsChannelConfigurationsRequest method.
//	req, resp := client.ListMicrosoftTeamsChannelConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations
func (c *Chatbot) ListMicrosoftTeamsChannelConfigurationsRequest(input *ListMicrosoftTeamsChannelConfigurationsInput) (req *request.Request, output *ListMicrosoftTeamsChannelConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListMicrosoftTeamsChannelConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/list-ms-teams-channel-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMicrosoftTeamsChannelConfigurationsInput{}
	}

	output = &ListMicrosoftTeamsChannelConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMicrosoftTeamsChannelConfigurations API operation for AWS Chatbot.
//
// # Lists MS Teams Channel Configurations optionally filtered by TeamId
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation ListMicrosoftTeamsChannelConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ListTeamsChannelConfigurationsException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations
func (c *Chatbot) ListMicrosoftTeamsChannelConfigurations(input *ListMicrosoftTeamsChannelConfigurationsInput) (*ListMicrosoftTeamsChannelConfigurationsOutput, error) {
	req, out := c.ListMicrosoftTeamsChannelConfigurationsRequest(input)
	return out, req.Send()
}

// ListMicrosoftTeamsChannelConfigurationsWithContext is the same as ListMicrosoftTeamsChannelConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListMicrosoftTeamsChannelConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) ListMicrosoftTeamsChannelConfigurationsWithContext(ctx aws.Context, input *ListMicrosoftTeamsChannelConfigurationsInput, opts ...request.Option) (*ListMicrosoftTeamsChannelConfigurationsOutput, error) {
	req, out := c.ListMicrosoftTeamsChannelConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMicrosoftTeamsChannelConfigurationsPages iterates over the pages of a ListMicrosoftTeamsChannelConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMicrosoftTeamsChannelConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMicrosoftTeamsChannelConfigurations operation.
//	pageNum := 0
//	err := client.ListMicrosoftTeamsChannelConfigurationsPages(params,
//	    func(page *chatbot.ListMicrosoftTeamsChannelConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) ListMicrosoftTeamsChannelConfigurationsPages(input *ListMicrosoftTeamsChannelConfigurationsInput, fn func(*ListMicrosoftTeamsChannelConfigurationsOutput, bool) bool) error {
	return c.ListMicrosoftTeamsChannelConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMicrosoftTeamsChannelConfigurationsPagesWithContext same as ListMicrosoftTeamsChannelConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) ListMicrosoftTeamsChannelConfigurationsPagesWithContext(ctx aws.Context, input *ListMicrosoftTeamsChannelConfigurationsInput, fn func(*ListMicrosoftTeamsChannelConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMicrosoftTeamsChannelConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMicrosoftTeamsChannelConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMicrosoftTeamsChannelConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMicrosoftTeamsConfiguredTeams = "ListMicrosoftTeamsConfiguredTeams"

// ListMicrosoftTeamsConfiguredTeamsRequest generates a "aws/request.Request" representing the
// client's request for the ListMicrosoftTeamsConfiguredTeams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMicrosoftTeamsConfiguredTeams for more information on using the ListMicrosoftTeamsConfiguredTeams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMicrosoftTeamsConfiguredTeamsRequest method.
//	req, resp := client.ListMicrosoftTeamsConfiguredTeamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams
func (c *Chatbot) ListMicrosoftTeamsConfiguredTeamsRequest(input *ListMicrosoftTeamsConfiguredTeamsInput) (req *request.Request, output *ListMicrosoftTeamsConfiguredTeamsOutput) {
	op := &request.Operation{
		Name:       opListMicrosoftTeamsConfiguredTeams,
		HTTPMethod: "POST",
		HTTPPath:   "/list-ms-teams-configured-teams",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMicrosoftTeamsConfiguredTeamsInput{}
	}

	output = &ListMicrosoftTeamsConfiguredTeamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMicrosoftTeamsConfiguredTeams API operation for AWS Chatbot.
//
// # Lists all authorized MS teams for AWS Account
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation ListMicrosoftTeamsConfiguredTeams for usage and error information.
//
// Returned Error Types:
//
//   - ListMicrosoftTeamsConfiguredTeamsException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams
func (c *Chatbot) ListMicrosoftTeamsConfiguredTeams(input *ListMicrosoftTeamsConfiguredTeamsInput) (*ListMicrosoftTeamsConfiguredTeamsOutput, error) {
	req, out := c.ListMicrosoftTeamsConfiguredTeamsRequest(input)
	return out, req.Send()
}

// ListMicrosoftTeamsConfiguredTeamsWithContext is the same as ListMicrosoftTeamsConfiguredTeams with the addition of
// the ability to pass a context and additional request options.
//
// See ListMicrosoftTeamsConfiguredTeams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) ListMicrosoftTeamsConfiguredTeamsWithContext(ctx aws.Context, input *ListMicrosoftTeamsConfiguredTeamsInput, opts ...request.Option) (*ListMicrosoftTeamsConfiguredTeamsOutput, error) {
	req, out := c.ListMicrosoftTeamsConfiguredTeamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMicrosoftTeamsConfiguredTeamsPages iterates over the pages of a ListMicrosoftTeamsConfiguredTeams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMicrosoftTeamsConfiguredTeams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMicrosoftTeamsConfiguredTeams operation.
//	pageNum := 0
//	err := client.ListMicrosoftTeamsConfiguredTeamsPages(params,
//	    func(page *chatbot.ListMicrosoftTeamsConfiguredTeamsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) ListMicrosoftTeamsConfiguredTeamsPages(input *ListMicrosoftTeamsConfiguredTeamsInput, fn func(*ListMicrosoftTeamsConfiguredTeamsOutput, bool) bool) error {
	return c.ListMicrosoftTeamsConfiguredTeamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMicrosoftTeamsConfiguredTeamsPagesWithContext same as ListMicrosoftTeamsConfiguredTeamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) ListMicrosoftTeamsConfiguredTeamsPagesWithContext(ctx aws.Context, input *ListMicrosoftTeamsConfiguredTeamsInput, fn func(*ListMicrosoftTeamsConfiguredTeamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMicrosoftTeamsConfiguredTeamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMicrosoftTeamsConfiguredTeamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMicrosoftTeamsConfiguredTeamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMicrosoftTeamsUserIdentities = "ListMicrosoftTeamsUserIdentities"

// ListMicrosoftTeamsUserIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListMicrosoftTeamsUserIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMicrosoftTeamsUserIdentities for more information on using the ListMicrosoftTeamsUserIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMicrosoftTeamsUserIdentitiesRequest method.
//	req, resp := client.ListMicrosoftTeamsUserIdentitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities
func (c *Chatbot) ListMicrosoftTeamsUserIdentitiesRequest(input *ListMicrosoftTeamsUserIdentitiesInput) (req *request.Request, output *ListMicrosoftTeamsUserIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListMicrosoftTeamsUserIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/list-ms-teams-user-identities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMicrosoftTeamsUserIdentitiesInput{}
	}

	output = &ListMicrosoftTeamsUserIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMicrosoftTeamsUserIdentities API operation for AWS Chatbot.
//
// Lists all Microsoft Teams user identities with a mapped role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation ListMicrosoftTeamsUserIdentities for usage and error information.
//
// Returned Error Types:
//
//   - ListMicrosoftTeamsUserIdentitiesException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities
func (c *Chatbot) ListMicrosoftTeamsUserIdentities(input *ListMicrosoftTeamsUserIdentitiesInput) (*ListMicrosoftTeamsUserIdentitiesOutput, error) {
	req, out := c.ListMicrosoftTeamsUserIdentitiesRequest(input)
	return out, req.Send()
}

// ListMicrosoftTeamsUserIdentitiesWithContext is the same as ListMicrosoftTeamsUserIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListMicrosoftTeamsUserIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) ListMicrosoftTeamsUserIdentitiesWithContext(ctx aws.Context, input *ListMicrosoftTeamsUserIdentitiesInput, opts ...request.Option) (*ListMicrosoftTeamsUserIdentitiesOutput, error) {
	req, out := c.ListMicrosoftTeamsUserIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMicrosoftTeamsUserIdentitiesPages iterates over the pages of a ListMicrosoftTeamsUserIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMicrosoftTeamsUserIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMicrosoftTeamsUserIdentities operation.
//	pageNum := 0
//	err := client.ListMicrosoftTeamsUserIdentitiesPages(params,
//	    func(page *chatbot.ListMicrosoftTeamsUserIdentitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chatbot) ListMicrosoftTeamsUserIdentitiesPages(input *ListMicrosoftTeamsUserIdentitiesInput, fn func(*ListMicrosoftTeamsUserIdentitiesOutput, bool) bool) error {
	return c.ListMicrosoftTeamsUserIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMicrosoftTeamsUserIdentitiesPagesWithContext same as ListMicrosoftTeamsUserIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) ListMicrosoftTeamsUserIdentitiesPagesWithContext(ctx aws.Context, input *ListMicrosoftTeamsUserIdentitiesInput, fn func(*ListMicrosoftTeamsUserIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMicrosoftTeamsUserIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMicrosoftTeamsUserIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMicrosoftTeamsUserIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateAccountPreferences = "UpdateAccountPreferences"

// UpdateAccountPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountPreferences for more information on using the UpdateAccountPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountPreferencesRequest method.
//	req, resp := client.UpdateAccountPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences
func (c *Chatbot) UpdateAccountPreferencesRequest(input *UpdateAccountPreferencesInput) (req *request.Request, output *UpdateAccountPreferencesOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountPreferences,
		HTTPMethod: "POST",
		HTTPPath:   "/update-account-preferences",
	}

	if input == nil {
		input = &UpdateAccountPreferencesInput{}
	}

	output = &UpdateAccountPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountPreferences API operation for AWS Chatbot.
//
// # Update Chatbot account level preferences
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation UpdateAccountPreferences for usage and error information.
//
// Returned Error Types:
//
//   - UpdateAccountPreferencesException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences
func (c *Chatbot) UpdateAccountPreferences(input *UpdateAccountPreferencesInput) (*UpdateAccountPreferencesOutput, error) {
	req, out := c.UpdateAccountPreferencesRequest(input)
	return out, req.Send()
}

// UpdateAccountPreferencesWithContext is the same as UpdateAccountPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) UpdateAccountPreferencesWithContext(ctx aws.Context, input *UpdateAccountPreferencesInput, opts ...request.Option) (*UpdateAccountPreferencesOutput, error) {
	req, out := c.UpdateAccountPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChimeWebhookConfiguration = "UpdateChimeWebhookConfiguration"

// UpdateChimeWebhookConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChimeWebhookConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChimeWebhookConfiguration for more information on using the UpdateChimeWebhookConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChimeWebhookConfigurationRequest method.
//	req, resp := client.UpdateChimeWebhookConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration
func (c *Chatbot) UpdateChimeWebhookConfigurationRequest(input *UpdateChimeWebhookConfigurationInput) (req *request.Request, output *UpdateChimeWebhookConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateChimeWebhookConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/update-chime-webhook-configuration",
	}

	if input == nil {
		input = &UpdateChimeWebhookConfigurationInput{}
	}

	output = &UpdateChimeWebhookConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChimeWebhookConfiguration API operation for AWS Chatbot.
//
// # Updates a Chime Webhook Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation UpdateChimeWebhookConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - UpdateChimeWebhookConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration
func (c *Chatbot) UpdateChimeWebhookConfiguration(input *UpdateChimeWebhookConfigurationInput) (*UpdateChimeWebhookConfigurationOutput, error) {
	req, out := c.UpdateChimeWebhookConfigurationRequest(input)
	return out, req.Send()
}

// UpdateChimeWebhookConfigurationWithContext is the same as UpdateChimeWebhookConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChimeWebhookConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) UpdateChimeWebhookConfigurationWithContext(ctx aws.Context, input *UpdateChimeWebhookConfigurationInput, opts ...request.Option) (*UpdateChimeWebhookConfigurationOutput, error) {
	req, out := c.UpdateChimeWebhookConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMicrosoftTeamsChannelConfiguration = "UpdateMicrosoftTeamsChannelConfiguration"

// UpdateMicrosoftTeamsChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMicrosoftTeamsChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMicrosoftTeamsChannelConfiguration for more information on using the UpdateMicrosoftTeamsChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMicrosoftTeamsChannelConfigurationRequest method.
//	req, resp := client.UpdateMicrosoftTeamsChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration
func (c *Chatbot) UpdateMicrosoftTeamsChannelConfigurationRequest(input *UpdateMicrosoftTeamsChannelConfigurationInput) (req *request.Request, output *UpdateMicrosoftTeamsChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateMicrosoftTeamsChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/update-ms-teams-channel-configuration",
	}

	if input == nil {
		input = &UpdateMicrosoftTeamsChannelConfigurationInput{}
	}

	output = &UpdateMicrosoftTeamsChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMicrosoftTeamsChannelConfiguration API operation for AWS Chatbot.
//
// # Updates MS Teams Channel Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation UpdateMicrosoftTeamsChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - UpdateTeamsChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration
func (c *Chatbot) UpdateMicrosoftTeamsChannelConfiguration(input *UpdateMicrosoftTeamsChannelConfigurationInput) (*UpdateMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.UpdateMicrosoftTeamsChannelConfigurationRequest(input)
	return out, req.Send()
}

// UpdateMicrosoftTeamsChannelConfigurationWithContext is the same as UpdateMicrosoftTeamsChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMicrosoftTeamsChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) UpdateMicrosoftTeamsChannelConfigurationWithContext(ctx aws.Context, input *UpdateMicrosoftTeamsChannelConfigurationInput, opts ...request.Option) (*UpdateMicrosoftTeamsChannelConfigurationOutput, error) {
	req, out := c.UpdateMicrosoftTeamsChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSlackChannelConfiguration = "UpdateSlackChannelConfiguration"

// UpdateSlackChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSlackChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSlackChannelConfiguration for more information on using the UpdateSlackChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSlackChannelConfigurationRequest method.
//	req, resp := client.UpdateSlackChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration
func (c *Chatbot) UpdateSlackChannelConfigurationRequest(input *UpdateSlackChannelConfigurationInput) (req *request.Request, output *UpdateSlackChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSlackChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/update-slack-channel-configuration",
	}

	if input == nil {
		input = &UpdateSlackChannelConfigurationInput{}
	}

	output = &UpdateSlackChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSlackChannelConfiguration API operation for AWS Chatbot.
//
// # Updates Slack Channel Configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Chatbot's
// API operation UpdateSlackChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     We were not able to find the resource for your request.
//
//   - InvalidParameterException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - InvalidRequestException
//     Your request input doesn't meet the constraints that AWS Chatbot requires.
//
//   - UpdateSlackChannelConfigurationException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration
func (c *Chatbot) UpdateSlackChannelConfiguration(input *UpdateSlackChannelConfigurationInput) (*UpdateSlackChannelConfigurationOutput, error) {
	req, out := c.UpdateSlackChannelConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSlackChannelConfigurationWithContext is the same as UpdateSlackChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSlackChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chatbot) UpdateSlackChannelConfigurationWithContext(ctx aws.Context, input *UpdateSlackChannelConfigurationInput, opts ...request.Option) (*UpdateSlackChannelConfigurationOutput, error) {
	req, out := c.UpdateSlackChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Preferences which apply for AWS Chatbot usage in the calling AWS account.
type AccountPreferences struct {
	_ struct{} `type:"structure"`

	// Turns on training data collection. This helps improve the AWS Chatbot experience
	// by allowing AWS Chatbot to store and use your customer information, such
	// as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot generated
	// responses, and interaction data. This data helps us to continuously improve
	// and develop Artificial Intelligence (AI) technologies. Your data is not shared
	// with any third parties and is protected using sophisticated controls to prevent
	// unauthorized access and misuse. AWS Chatbot does not store or use interactions
	// in chat channels with Amazon Q for training AWS Chatbot’s AI technologies.
	TrainingDataCollectionEnabled *bool `type:"boolean"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountPreferences) GoString() string {
	return s.String()
}

// SetTrainingDataCollectionEnabled sets the TrainingDataCollectionEnabled field's value.
func (s *AccountPreferences) SetTrainingDataCollectionEnabled(v bool) *AccountPreferences {
	s.TrainingDataCollectionEnabled = &v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *AccountPreferences) SetUserAuthorizationRequired(v bool) *AccountPreferences {
	s.UserAuthorizationRequired = &v
	return s
}

// An AWS Chatbot configuration for Amazon Chime.
type ChimeWebhookConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the ChimeWebhookConfiguration.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// Specifies the logging level for this configuration. This property affects
	// the log entries pushed to Amazon CloudWatch Logs.Logging levels include ERROR,
	// INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// SnsTopicArns is a required field
	SnsTopicArns []*string `type:"list" required:"true"`

	// Description of the webhook. Recommend using the convention `RoomName/WebhookName`.
	// See Chime setup tutorial for more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
	//
	// WebhookDescription is a required field
	WebhookDescription *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeWebhookConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeWebhookConfiguration) GoString() string {
	return s.String()
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *ChimeWebhookConfiguration) SetChatConfigurationArn(v string) *ChimeWebhookConfiguration {
	s.ChatConfigurationArn = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *ChimeWebhookConfiguration) SetConfigurationName(v string) *ChimeWebhookConfiguration {
	s.ConfigurationName = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ChimeWebhookConfiguration) SetIamRoleArn(v string) *ChimeWebhookConfiguration {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *ChimeWebhookConfiguration) SetLoggingLevel(v string) *ChimeWebhookConfiguration {
	s.LoggingLevel = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *ChimeWebhookConfiguration) SetSnsTopicArns(v []*string) *ChimeWebhookConfiguration {
	s.SnsTopicArns = v
	return s
}

// SetWebhookDescription sets the WebhookDescription field's value.
func (s *ChimeWebhookConfiguration) SetWebhookDescription(v string) *ChimeWebhookConfiguration {
	s.WebhookDescription = &v
	return s
}

// A Microsoft Teams team that has been authorized with AWS Chatbot.
type ConfiguredTeam struct {
	_ struct{} `type:"structure"`

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team
	// ID, you must perform the initial authorization flow with Microsoft Teams
	// in the AWS Chatbot console. Then you can copy and paste the team ID from
	// the console. For more details, see steps 1-4 in Get started with Microsoft
	// Teams in the AWS Chatbot Administrator Guide.
	//
	// TeamId is a required field
	TeamId *string `min:"36" type:"string" required:"true"`

	// The name of the Microsoft Teams Team.
	TeamName *string `min:"36" type:"string"`

	// The ID of the Microsoft Teams tenant.
	//
	// TenantId is a required field
	TenantId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTeam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTeam) GoString() string {
	return s.String()
}

// SetTeamId sets the TeamId field's value.
func (s *ConfiguredTeam) SetTeamId(v string) *ConfiguredTeam {
	s.TeamId = &v
	return s
}

// SetTeamName sets the TeamName field's value.
func (s *ConfiguredTeam) SetTeamName(v string) *ConfiguredTeam {
	s.TeamName = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *ConfiguredTeam) SetTenantId(v string) *ConfiguredTeam {
	s.TenantId = &v
	return s
}

// There was an issue processing your request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can’t process your request right now because of a server issue. Try
// again later.
type CreateChimeWebhookConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChimeWebhookConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChimeWebhookConfigurationException) GoString() string {
	return s.String()
}

func newErrorCreateChimeWebhookConfigurationException(v protocol.ResponseMetadata) error {
	return &CreateChimeWebhookConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateChimeWebhookConfigurationException) Code() string {
	return "CreateChimeWebhookConfigurationException"
}

// Message returns the exception's message.
func (s *CreateChimeWebhookConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateChimeWebhookConfigurationException) OrigErr() error {
	return nil
}

func (s *CreateChimeWebhookConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateChimeWebhookConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateChimeWebhookConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChimeWebhookConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration.
	//
	// ConfigurationName is a required field
	ConfigurationName *string `min:"1" type:"string" required:"true"`

	// This is a user-defined role that AWS Chatbot will assume. This is not the
	// service-linked role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// SnsTopicArns is a required field
	SnsTopicArns []*string `type:"list" required:"true"`

	// Description of the webhook. Recommend using the convention `RoomName/WebhookName`.
	// See Chime setup tutorial for more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
	//
	// WebhookDescription is a required field
	WebhookDescription *string `min:"1" type:"string" required:"true"`

	// URL for the Chime webhook.
	//
	// WebhookUrl is a required field
	WebhookUrl *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChimeWebhookConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChimeWebhookConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChimeWebhookConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChimeWebhookConfigurationInput"}
	if s.ConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationName"))
	}
	if s.ConfigurationName != nil && len(*s.ConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationName", 1))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 12))
	}
	if s.LoggingLevel != nil && len(*s.LoggingLevel) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingLevel", 4))
	}
	if s.SnsTopicArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArns"))
	}
	if s.WebhookDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("WebhookDescription"))
	}
	if s.WebhookDescription != nil && len(*s.WebhookDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebhookDescription", 1))
	}
	if s.WebhookUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("WebhookUrl"))
	}
	if s.WebhookUrl != nil && len(*s.WebhookUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebhookUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *CreateChimeWebhookConfigurationInput) SetConfigurationName(v string) *CreateChimeWebhookConfigurationInput {
	s.ConfigurationName = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateChimeWebhookConfigurationInput) SetIamRoleArn(v string) *CreateChimeWebhookConfigurationInput {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *CreateChimeWebhookConfigurationInput) SetLoggingLevel(v string) *CreateChimeWebhookConfigurationInput {
	s.LoggingLevel = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *CreateChimeWebhookConfigurationInput) SetSnsTopicArns(v []*string) *CreateChimeWebhookConfigurationInput {
	s.SnsTopicArns = v
	return s
}

// SetWebhookDescription sets the WebhookDescription field's value.
func (s *CreateChimeWebhookConfigurationInput) SetWebhookDescription(v string) *CreateChimeWebhookConfigurationInput {
	s.WebhookDescription = &v
	return s
}

// SetWebhookUrl sets the WebhookUrl field's value.
func (s *CreateChimeWebhookConfigurationInput) SetWebhookUrl(v string) *CreateChimeWebhookConfigurationInput {
	s.WebhookUrl = &v
	return s
}

type CreateChimeWebhookConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Chime webhook configuration.
	WebhookConfiguration *ChimeWebhookConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChimeWebhookConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChimeWebhookConfigurationOutput) GoString() string {
	return s.String()
}

// SetWebhookConfiguration sets the WebhookConfiguration field's value.
func (s *CreateChimeWebhookConfigurationOutput) SetWebhookConfiguration(v *ChimeWebhookConfiguration) *CreateChimeWebhookConfigurationOutput {
	s.WebhookConfiguration = v
	return s
}

type CreateMicrosoftTeamsChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Microsoft Teams channel.
	//
	// ChannelId is a required field
	ChannelId *string `min:"1" type:"string" required:"true"`

	// The name of the Microsoft Teams channel.
	ChannelName *string `min:"1" type:"string"`

	// The name of the configuration.
	//
	// ConfigurationName is a required field
	ConfigurationName *string `min:"1" type:"string" required:"true"`

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not
	// set.
	GuardrailPolicyArns []*string `type:"list"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	SnsTopicArns []*string `type:"list"`

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team
	// ID, you must perform the initial authorization flow with Microsoft Teams
	// in the AWS Chatbot console. Then you can copy and paste the team ID from
	// the console. For more details, see steps 1-4 in Get started with Microsoft
	// Teams in the AWS Chatbot Administrator Guide.
	//
	// TeamId is a required field
	TeamId *string `min:"36" type:"string" required:"true"`

	// The name of the Microsoft Teams Team.
	TeamName *string `min:"1" type:"string"`

	// The ID of the Microsoft Teams tenant.
	//
	// TenantId is a required field
	TenantId *string `min:"36" type:"string" required:"true"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMicrosoftTeamsChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMicrosoftTeamsChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMicrosoftTeamsChannelConfigurationInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationName"))
	}
	if s.ConfigurationName != nil && len(*s.ConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationName", 1))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 12))
	}
	if s.LoggingLevel != nil && len(*s.LoggingLevel) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingLevel", 4))
	}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 36))
	}
	if s.TeamName != nil && len(*s.TeamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TeamName", 1))
	}
	if s.TenantId == nil {
		invalidParams.Add(request.NewErrParamRequired("TenantId"))
	}
	if s.TenantId != nil && len(*s.TenantId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TenantId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetChannelId(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetChannelName(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.ChannelName = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetConfigurationName(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.ConfigurationName = &v
	return s
}

// SetGuardrailPolicyArns sets the GuardrailPolicyArns field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetGuardrailPolicyArns(v []*string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.GuardrailPolicyArns = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetIamRoleArn(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetLoggingLevel(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.LoggingLevel = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetSnsTopicArns(v []*string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.SnsTopicArns = v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetTeamId(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.TeamId = &v
	return s
}

// SetTeamName sets the TeamName field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetTeamName(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.TeamName = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetTenantId(v string) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.TenantId = &v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationInput) SetUserAuthorizationRequired(v bool) *CreateMicrosoftTeamsChannelConfigurationInput {
	s.UserAuthorizationRequired = &v
	return s
}

type CreateMicrosoftTeamsChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for a Microsoft Teams channel configured with AWS Chatbot.
	ChannelConfiguration *TeamsChannelConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMicrosoftTeamsChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMicrosoftTeamsChannelConfigurationOutput) GoString() string {
	return s.String()
}

// SetChannelConfiguration sets the ChannelConfiguration field's value.
func (s *CreateMicrosoftTeamsChannelConfigurationOutput) SetChannelConfiguration(v *TeamsChannelConfiguration) *CreateMicrosoftTeamsChannelConfigurationOutput {
	s.ChannelConfiguration = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type CreateSlackChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorCreateSlackChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &CreateSlackChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateSlackChannelConfigurationException) Code() string {
	return "CreateSlackChannelConfigurationException"
}

// Message returns the exception's message.
func (s *CreateSlackChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateSlackChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *CreateSlackChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateSlackChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateSlackChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateSlackChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration.
	//
	// ConfigurationName is a required field
	ConfigurationName *string `min:"1" type:"string" required:"true"`

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not
	// set.
	GuardrailPolicyArns []*string `type:"list"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ID of the Slack channel. To get the ID, open Slack, right click on the
	// channel name in the left pane, then choose Copy Link. The channel ID is the
	// 9-character string at the end of the URL. For example, ABCBBLZZZ.
	//
	// SlackChannelId is a required field
	SlackChannelId *string `min:"1" type:"string" required:"true"`

	// The name of the Slack Channel.
	SlackChannelName *string `min:"1" type:"string"`

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// SlackTeamId is a required field
	SlackTeamId *string `min:"1" type:"string" required:"true"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	SnsTopicArns []*string `type:"list"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlackChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlackChannelConfigurationInput"}
	if s.ConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationName"))
	}
	if s.ConfigurationName != nil && len(*s.ConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationName", 1))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 12))
	}
	if s.LoggingLevel != nil && len(*s.LoggingLevel) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingLevel", 4))
	}
	if s.SlackChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlackChannelId"))
	}
	if s.SlackChannelId != nil && len(*s.SlackChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackChannelId", 1))
	}
	if s.SlackChannelName != nil && len(*s.SlackChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackChannelName", 1))
	}
	if s.SlackTeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlackTeamId"))
	}
	if s.SlackTeamId != nil && len(*s.SlackTeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackTeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *CreateSlackChannelConfigurationInput) SetConfigurationName(v string) *CreateSlackChannelConfigurationInput {
	s.ConfigurationName = &v
	return s
}

// SetGuardrailPolicyArns sets the GuardrailPolicyArns field's value.
func (s *CreateSlackChannelConfigurationInput) SetGuardrailPolicyArns(v []*string) *CreateSlackChannelConfigurationInput {
	s.GuardrailPolicyArns = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateSlackChannelConfigurationInput) SetIamRoleArn(v string) *CreateSlackChannelConfigurationInput {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *CreateSlackChannelConfigurationInput) SetLoggingLevel(v string) *CreateSlackChannelConfigurationInput {
	s.LoggingLevel = &v
	return s
}

// SetSlackChannelId sets the SlackChannelId field's value.
func (s *CreateSlackChannelConfigurationInput) SetSlackChannelId(v string) *CreateSlackChannelConfigurationInput {
	s.SlackChannelId = &v
	return s
}

// SetSlackChannelName sets the SlackChannelName field's value.
func (s *CreateSlackChannelConfigurationInput) SetSlackChannelName(v string) *CreateSlackChannelConfigurationInput {
	s.SlackChannelName = &v
	return s
}

// SetSlackTeamId sets the SlackTeamId field's value.
func (s *CreateSlackChannelConfigurationInput) SetSlackTeamId(v string) *CreateSlackChannelConfigurationInput {
	s.SlackTeamId = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *CreateSlackChannelConfigurationInput) SetSnsTopicArns(v []*string) *CreateSlackChannelConfigurationInput {
	s.SnsTopicArns = v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *CreateSlackChannelConfigurationInput) SetUserAuthorizationRequired(v bool) *CreateSlackChannelConfigurationInput {
	s.UserAuthorizationRequired = &v
	return s
}

type CreateSlackChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for a Slack channel configured with AWS Chatbot.
	ChannelConfiguration *SlackChannelConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationOutput) GoString() string {
	return s.String()
}

// SetChannelConfiguration sets the ChannelConfiguration field's value.
func (s *CreateSlackChannelConfigurationOutput) SetChannelConfiguration(v *SlackChannelConfiguration) *CreateSlackChannelConfigurationOutput {
	s.ChannelConfiguration = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type CreateTeamsChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTeamsChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTeamsChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorCreateTeamsChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &CreateTeamsChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateTeamsChannelConfigurationException) Code() string {
	return "CreateTeamsChannelConfigurationException"
}

// Message returns the exception's message.
func (s *CreateTeamsChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateTeamsChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *CreateTeamsChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateTeamsChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateTeamsChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DeleteChimeWebhookConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChimeWebhookConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChimeWebhookConfigurationException) GoString() string {
	return s.String()
}

func newErrorDeleteChimeWebhookConfigurationException(v protocol.ResponseMetadata) error {
	return &DeleteChimeWebhookConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteChimeWebhookConfigurationException) Code() string {
	return "DeleteChimeWebhookConfigurationException"
}

// Message returns the exception's message.
func (s *DeleteChimeWebhookConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteChimeWebhookConfigurationException) OrigErr() error {
	return nil
}

func (s *DeleteChimeWebhookConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteChimeWebhookConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteChimeWebhookConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteChimeWebhookConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the ChimeWebhookConfiguration to delete.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChimeWebhookConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChimeWebhookConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChimeWebhookConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChimeWebhookConfigurationInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DeleteChimeWebhookConfigurationInput) SetChatConfigurationArn(v string) *DeleteChimeWebhookConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

type DeleteChimeWebhookConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChimeWebhookConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChimeWebhookConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteMicrosoftTeamsChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the MicrosoftTeamsChannelConfiguration to delete.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMicrosoftTeamsChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMicrosoftTeamsChannelConfigurationInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DeleteMicrosoftTeamsChannelConfigurationInput) SetChatConfigurationArn(v string) *DeleteMicrosoftTeamsChannelConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

type DeleteMicrosoftTeamsChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsChannelConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteMicrosoftTeamsConfiguredTeamInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team
	// ID, you must perform the initial authorization flow with Microsoft Teams
	// in the AWS Chatbot console. Then you can copy and paste the team ID from
	// the console. For more details, see steps 1-4 in Get started with Microsoft
	// Teams in the AWS Chatbot Administrator Guide.
	//
	// TeamId is a required field
	TeamId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsConfiguredTeamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsConfiguredTeamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMicrosoftTeamsConfiguredTeamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMicrosoftTeamsConfiguredTeamInput"}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTeamId sets the TeamId field's value.
func (s *DeleteMicrosoftTeamsConfiguredTeamInput) SetTeamId(v string) *DeleteMicrosoftTeamsConfiguredTeamInput {
	s.TeamId = &v
	return s
}

type DeleteMicrosoftTeamsConfiguredTeamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsConfiguredTeamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsConfiguredTeamOutput) GoString() string {
	return s.String()
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DeleteMicrosoftTeamsUserIdentityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsUserIdentityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsUserIdentityException) GoString() string {
	return s.String()
}

func newErrorDeleteMicrosoftTeamsUserIdentityException(v protocol.ResponseMetadata) error {
	return &DeleteMicrosoftTeamsUserIdentityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteMicrosoftTeamsUserIdentityException) Code() string {
	return "DeleteMicrosoftTeamsUserIdentityException"
}

// Message returns the exception's message.
func (s *DeleteMicrosoftTeamsUserIdentityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteMicrosoftTeamsUserIdentityException) OrigErr() error {
	return nil
}

func (s *DeleteMicrosoftTeamsUserIdentityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteMicrosoftTeamsUserIdentityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteMicrosoftTeamsUserIdentityException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteMicrosoftTeamsUserIdentityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the MicrosoftTeamsChannelConfiguration associated with the user
	// identity to delete.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// Id from Microsoft Teams for user.
	//
	// UserId is a required field
	UserId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsUserIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsUserIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMicrosoftTeamsUserIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMicrosoftTeamsUserIdentityInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DeleteMicrosoftTeamsUserIdentityInput) SetChatConfigurationArn(v string) *DeleteMicrosoftTeamsUserIdentityInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteMicrosoftTeamsUserIdentityInput) SetUserId(v string) *DeleteMicrosoftTeamsUserIdentityInput {
	s.UserId = &v
	return s
}

type DeleteMicrosoftTeamsUserIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsUserIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMicrosoftTeamsUserIdentityOutput) GoString() string {
	return s.String()
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DeleteSlackChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorDeleteSlackChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &DeleteSlackChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteSlackChannelConfigurationException) Code() string {
	return "DeleteSlackChannelConfigurationException"
}

// Message returns the exception's message.
func (s *DeleteSlackChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteSlackChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *DeleteSlackChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteSlackChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteSlackChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteSlackChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SlackChannelConfiguration to delete.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlackChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlackChannelConfigurationInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DeleteSlackChannelConfigurationInput) SetChatConfigurationArn(v string) *DeleteSlackChannelConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

type DeleteSlackChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationOutput) GoString() string {
	return s.String()
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DeleteSlackUserIdentityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackUserIdentityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackUserIdentityException) GoString() string {
	return s.String()
}

func newErrorDeleteSlackUserIdentityException(v protocol.ResponseMetadata) error {
	return &DeleteSlackUserIdentityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteSlackUserIdentityException) Code() string {
	return "DeleteSlackUserIdentityException"
}

// Message returns the exception's message.
func (s *DeleteSlackUserIdentityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteSlackUserIdentityException) OrigErr() error {
	return nil
}

func (s *DeleteSlackUserIdentityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteSlackUserIdentityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteSlackUserIdentityException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteSlackUserIdentityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SlackChannelConfiguration associated with the user identity
	// to delete.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// SlackTeamId is a required field
	SlackTeamId *string `min:"1" type:"string" required:"true"`

	// The ID of the user in Slack.
	//
	// SlackUserId is a required field
	SlackUserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackUserIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackUserIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlackUserIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlackUserIdentityInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.SlackTeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlackTeamId"))
	}
	if s.SlackTeamId != nil && len(*s.SlackTeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackTeamId", 1))
	}
	if s.SlackUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlackUserId"))
	}
	if s.SlackUserId != nil && len(*s.SlackUserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackUserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DeleteSlackUserIdentityInput) SetChatConfigurationArn(v string) *DeleteSlackUserIdentityInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetSlackTeamId sets the SlackTeamId field's value.
func (s *DeleteSlackUserIdentityInput) SetSlackTeamId(v string) *DeleteSlackUserIdentityInput {
	s.SlackTeamId = &v
	return s
}

// SetSlackUserId sets the SlackUserId field's value.
func (s *DeleteSlackUserIdentityInput) SetSlackUserId(v string) *DeleteSlackUserIdentityInput {
	s.SlackUserId = &v
	return s
}

type DeleteSlackUserIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackUserIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackUserIdentityOutput) GoString() string {
	return s.String()
}

// There was an issue deleting your Slack workspace.
type DeleteSlackWorkspaceAuthorizationFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceAuthorizationFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceAuthorizationFault) GoString() string {
	return s.String()
}

func newErrorDeleteSlackWorkspaceAuthorizationFault(v protocol.ResponseMetadata) error {
	return &DeleteSlackWorkspaceAuthorizationFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteSlackWorkspaceAuthorizationFault) Code() string {
	return "DeleteSlackWorkspaceAuthorizationFault"
}

// Message returns the exception's message.
func (s *DeleteSlackWorkspaceAuthorizationFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteSlackWorkspaceAuthorizationFault) OrigErr() error {
	return nil
}

func (s *DeleteSlackWorkspaceAuthorizationFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteSlackWorkspaceAuthorizationFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteSlackWorkspaceAuthorizationFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteSlackWorkspaceAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// SlackTeamId is a required field
	SlackTeamId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlackWorkspaceAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlackWorkspaceAuthorizationInput"}
	if s.SlackTeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlackTeamId"))
	}
	if s.SlackTeamId != nil && len(*s.SlackTeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackTeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSlackTeamId sets the SlackTeamId field's value.
func (s *DeleteSlackWorkspaceAuthorizationInput) SetSlackTeamId(v string) *DeleteSlackWorkspaceAuthorizationInput {
	s.SlackTeamId = &v
	return s
}

type DeleteSlackWorkspaceAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceAuthorizationOutput) GoString() string {
	return s.String()
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DeleteTeamsChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTeamsChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTeamsChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorDeleteTeamsChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &DeleteTeamsChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteTeamsChannelConfigurationException) Code() string {
	return "DeleteTeamsChannelConfigurationException"
}

// Message returns the exception's message.
func (s *DeleteTeamsChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteTeamsChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *DeleteTeamsChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteTeamsChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteTeamsChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DeleteTeamsConfiguredTeamException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTeamsConfiguredTeamException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTeamsConfiguredTeamException) GoString() string {
	return s.String()
}

func newErrorDeleteTeamsConfiguredTeamException(v protocol.ResponseMetadata) error {
	return &DeleteTeamsConfiguredTeamException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteTeamsConfiguredTeamException) Code() string {
	return "DeleteTeamsConfiguredTeamException"
}

// Message returns the exception's message.
func (s *DeleteTeamsConfiguredTeamException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteTeamsConfiguredTeamException) OrigErr() error {
	return nil
}

func (s *DeleteTeamsConfiguredTeamException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteTeamsConfiguredTeamException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteTeamsConfiguredTeamException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DescribeChimeWebhookConfigurationsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChimeWebhookConfigurationsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChimeWebhookConfigurationsException) GoString() string {
	return s.String()
}

func newErrorDescribeChimeWebhookConfigurationsException(v protocol.ResponseMetadata) error {
	return &DescribeChimeWebhookConfigurationsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DescribeChimeWebhookConfigurationsException) Code() string {
	return "DescribeChimeWebhookConfigurationsException"
}

// Message returns the exception's message.
func (s *DescribeChimeWebhookConfigurationsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DescribeChimeWebhookConfigurationsException) OrigErr() error {
	return nil
}

func (s *DescribeChimeWebhookConfigurationsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DescribeChimeWebhookConfigurationsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DescribeChimeWebhookConfigurationsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeChimeWebhookConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// An optional ARN of a ChimeWebhookConfiguration to describe.
	ChatConfigurationArn *string `min:"19" type:"string"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChimeWebhookConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChimeWebhookConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChimeWebhookConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChimeWebhookConfigurationsInput"}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DescribeChimeWebhookConfigurationsInput) SetChatConfigurationArn(v string) *DescribeChimeWebhookConfigurationsInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeChimeWebhookConfigurationsInput) SetMaxResults(v int64) *DescribeChimeWebhookConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChimeWebhookConfigurationsInput) SetNextToken(v string) *DescribeChimeWebhookConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeChimeWebhookConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// A list of Chime webhooks associated with the account.
	WebhookConfigurations []*ChimeWebhookConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChimeWebhookConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChimeWebhookConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChimeWebhookConfigurationsOutput) SetNextToken(v string) *DescribeChimeWebhookConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetWebhookConfigurations sets the WebhookConfigurations field's value.
func (s *DescribeChimeWebhookConfigurationsOutput) SetWebhookConfigurations(v []*ChimeWebhookConfiguration) *DescribeChimeWebhookConfigurationsOutput {
	s.WebhookConfigurations = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DescribeSlackChannelConfigurationsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackChannelConfigurationsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackChannelConfigurationsException) GoString() string {
	return s.String()
}

func newErrorDescribeSlackChannelConfigurationsException(v protocol.ResponseMetadata) error {
	return &DescribeSlackChannelConfigurationsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DescribeSlackChannelConfigurationsException) Code() string {
	return "DescribeSlackChannelConfigurationsException"
}

// Message returns the exception's message.
func (s *DescribeSlackChannelConfigurationsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DescribeSlackChannelConfigurationsException) OrigErr() error {
	return nil
}

func (s *DescribeSlackChannelConfigurationsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DescribeSlackChannelConfigurationsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DescribeSlackChannelConfigurationsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeSlackChannelConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// An optional ARN of a SlackChannelConfiguration to describe.
	ChatConfigurationArn *string `min:"19" type:"string"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackChannelConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackChannelConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlackChannelConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlackChannelConfigurationsInput"}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DescribeSlackChannelConfigurationsInput) SetChatConfigurationArn(v string) *DescribeSlackChannelConfigurationsInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSlackChannelConfigurationsInput) SetMaxResults(v int64) *DescribeSlackChannelConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSlackChannelConfigurationsInput) SetNextToken(v string) *DescribeSlackChannelConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeSlackChannelConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// A list of Slack channel configurations.
	SlackChannelConfigurations []*SlackChannelConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackChannelConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackChannelConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSlackChannelConfigurationsOutput) SetNextToken(v string) *DescribeSlackChannelConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetSlackChannelConfigurations sets the SlackChannelConfigurations field's value.
func (s *DescribeSlackChannelConfigurationsOutput) SetSlackChannelConfigurations(v []*SlackChannelConfiguration) *DescribeSlackChannelConfigurationsOutput {
	s.SlackChannelConfigurations = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DescribeSlackUserIdentitiesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackUserIdentitiesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackUserIdentitiesException) GoString() string {
	return s.String()
}

func newErrorDescribeSlackUserIdentitiesException(v protocol.ResponseMetadata) error {
	return &DescribeSlackUserIdentitiesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DescribeSlackUserIdentitiesException) Code() string {
	return "DescribeSlackUserIdentitiesException"
}

// Message returns the exception's message.
func (s *DescribeSlackUserIdentitiesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DescribeSlackUserIdentitiesException) OrigErr() error {
	return nil
}

func (s *DescribeSlackUserIdentitiesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DescribeSlackUserIdentitiesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DescribeSlackUserIdentitiesException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeSlackUserIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SlackChannelConfiguration associated with the user identities
	// to describe.
	ChatConfigurationArn *string `min:"19" type:"string"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackUserIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackUserIdentitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlackUserIdentitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlackUserIdentitiesInput"}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *DescribeSlackUserIdentitiesInput) SetChatConfigurationArn(v string) *DescribeSlackUserIdentitiesInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSlackUserIdentitiesInput) SetMaxResults(v int64) *DescribeSlackUserIdentitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSlackUserIdentitiesInput) SetNextToken(v string) *DescribeSlackUserIdentitiesInput {
	s.NextToken = &v
	return s
}

type DescribeSlackUserIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// A list of Slack User Identities.
	SlackUserIdentities []*SlackUserIdentity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackUserIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackUserIdentitiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSlackUserIdentitiesOutput) SetNextToken(v string) *DescribeSlackUserIdentitiesOutput {
	s.NextToken = &v
	return s
}

// SetSlackUserIdentities sets the SlackUserIdentities field's value.
func (s *DescribeSlackUserIdentitiesOutput) SetSlackUserIdentities(v []*SlackUserIdentity) *DescribeSlackUserIdentitiesOutput {
	s.SlackUserIdentities = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type DescribeSlackWorkspacesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackWorkspacesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackWorkspacesException) GoString() string {
	return s.String()
}

func newErrorDescribeSlackWorkspacesException(v protocol.ResponseMetadata) error {
	return &DescribeSlackWorkspacesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DescribeSlackWorkspacesException) Code() string {
	return "DescribeSlackWorkspacesException"
}

// Message returns the exception's message.
func (s *DescribeSlackWorkspacesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DescribeSlackWorkspacesException) OrigErr() error {
	return nil
}

func (s *DescribeSlackWorkspacesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DescribeSlackWorkspacesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DescribeSlackWorkspacesException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeSlackWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlackWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlackWorkspacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSlackWorkspacesInput) SetMaxResults(v int64) *DescribeSlackWorkspacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSlackWorkspacesInput) SetNextToken(v string) *DescribeSlackWorkspacesInput {
	s.NextToken = &v
	return s
}

type DescribeSlackWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// A list of Slack Workspaces registered with AWS Chatbot.
	SlackWorkspaces []*SlackWorkspace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlackWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSlackWorkspacesOutput) SetNextToken(v string) *DescribeSlackWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetSlackWorkspaces sets the SlackWorkspaces field's value.
func (s *DescribeSlackWorkspacesOutput) SetSlackWorkspaces(v []*SlackWorkspace) *DescribeSlackWorkspacesOutput {
	s.SlackWorkspaces = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type GetAccountPreferencesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountPreferencesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountPreferencesException) GoString() string {
	return s.String()
}

func newErrorGetAccountPreferencesException(v protocol.ResponseMetadata) error {
	return &GetAccountPreferencesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GetAccountPreferencesException) Code() string {
	return "GetAccountPreferencesException"
}

// Message returns the exception's message.
func (s *GetAccountPreferencesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GetAccountPreferencesException) OrigErr() error {
	return nil
}

func (s *GetAccountPreferencesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GetAccountPreferencesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GetAccountPreferencesException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAccountPreferencesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountPreferencesInput) GoString() string {
	return s.String()
}

type GetAccountPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// Preferences which apply for AWS Chatbot usage in the calling AWS account.
	AccountPreferences *AccountPreferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountPreferencesOutput) GoString() string {
	return s.String()
}

// SetAccountPreferences sets the AccountPreferences field's value.
func (s *GetAccountPreferencesOutput) SetAccountPreferences(v *AccountPreferences) *GetAccountPreferencesOutput {
	s.AccountPreferences = v
	return s
}

type GetMicrosoftTeamsChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the MicrosoftTeamsChannelConfiguration to retrieve.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMicrosoftTeamsChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMicrosoftTeamsChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMicrosoftTeamsChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMicrosoftTeamsChannelConfigurationInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *GetMicrosoftTeamsChannelConfigurationInput) SetChatConfigurationArn(v string) *GetMicrosoftTeamsChannelConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

type GetMicrosoftTeamsChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for a Microsoft Teams channel configured with AWS Chatbot.
	ChannelConfiguration *TeamsChannelConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMicrosoftTeamsChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMicrosoftTeamsChannelConfigurationOutput) GoString() string {
	return s.String()
}

// SetChannelConfiguration sets the ChannelConfiguration field's value.
func (s *GetMicrosoftTeamsChannelConfigurationOutput) SetChannelConfiguration(v *TeamsChannelConfiguration) *GetMicrosoftTeamsChannelConfigurationOutput {
	s.ChannelConfiguration = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type GetTeamsChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTeamsChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTeamsChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorGetTeamsChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &GetTeamsChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GetTeamsChannelConfigurationException) Code() string {
	return "GetTeamsChannelConfigurationException"
}

// Message returns the exception's message.
func (s *GetTeamsChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GetTeamsChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *GetTeamsChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GetTeamsChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GetTeamsChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request input doesn't meet the constraints that AWS Chatbot requires.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request input doesn't meet the constraints that AWS Chatbot requires.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded a service limit for AWS Chatbot.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListMicrosoftTeamsChannelConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team
	// ID, you must perform the initial authorization flow with Microsoft Teams
	// in the AWS Chatbot console. Then you can copy and paste the team ID from
	// the console. For more details, see steps 1-4 in Get started with Microsoft
	// Teams in the AWS Chatbot Administrator Guide.
	TeamId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsChannelConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsChannelConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMicrosoftTeamsChannelConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMicrosoftTeamsChannelConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TeamId != nil && len(*s.TeamId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMicrosoftTeamsChannelConfigurationsInput) SetMaxResults(v int64) *ListMicrosoftTeamsChannelConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMicrosoftTeamsChannelConfigurationsInput) SetNextToken(v string) *ListMicrosoftTeamsChannelConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *ListMicrosoftTeamsChannelConfigurationsInput) SetTeamId(v string) *ListMicrosoftTeamsChannelConfigurationsInput {
	s.TeamId = &v
	return s
}

type ListMicrosoftTeamsChannelConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// A list of AWS Chatbot channel configurations for Microsoft Teams.
	TeamChannelConfigurations []*TeamsChannelConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsChannelConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsChannelConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMicrosoftTeamsChannelConfigurationsOutput) SetNextToken(v string) *ListMicrosoftTeamsChannelConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetTeamChannelConfigurations sets the TeamChannelConfigurations field's value.
func (s *ListMicrosoftTeamsChannelConfigurationsOutput) SetTeamChannelConfigurations(v []*TeamsChannelConfiguration) *ListMicrosoftTeamsChannelConfigurationsOutput {
	s.TeamChannelConfigurations = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type ListMicrosoftTeamsConfiguredTeamsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsConfiguredTeamsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsConfiguredTeamsException) GoString() string {
	return s.String()
}

func newErrorListMicrosoftTeamsConfiguredTeamsException(v protocol.ResponseMetadata) error {
	return &ListMicrosoftTeamsConfiguredTeamsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ListMicrosoftTeamsConfiguredTeamsException) Code() string {
	return "ListMicrosoftTeamsConfiguredTeamsException"
}

// Message returns the exception's message.
func (s *ListMicrosoftTeamsConfiguredTeamsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ListMicrosoftTeamsConfiguredTeamsException) OrigErr() error {
	return nil
}

func (s *ListMicrosoftTeamsConfiguredTeamsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ListMicrosoftTeamsConfiguredTeamsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ListMicrosoftTeamsConfiguredTeamsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListMicrosoftTeamsConfiguredTeamsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsConfiguredTeamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsConfiguredTeamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMicrosoftTeamsConfiguredTeamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMicrosoftTeamsConfiguredTeamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMicrosoftTeamsConfiguredTeamsInput) SetMaxResults(v int64) *ListMicrosoftTeamsConfiguredTeamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMicrosoftTeamsConfiguredTeamsInput) SetNextToken(v string) *ListMicrosoftTeamsConfiguredTeamsInput {
	s.NextToken = &v
	return s
}

type ListMicrosoftTeamsConfiguredTeamsOutput struct {
	_ struct{} `type:"structure"`

	// A list of teams in Microsoft Teams that have been configured with AWS Chatbot.
	ConfiguredTeams []*ConfiguredTeam `type:"list"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsConfiguredTeamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsConfiguredTeamsOutput) GoString() string {
	return s.String()
}

// SetConfiguredTeams sets the ConfiguredTeams field's value.
func (s *ListMicrosoftTeamsConfiguredTeamsOutput) SetConfiguredTeams(v []*ConfiguredTeam) *ListMicrosoftTeamsConfiguredTeamsOutput {
	s.ConfiguredTeams = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMicrosoftTeamsConfiguredTeamsOutput) SetNextToken(v string) *ListMicrosoftTeamsConfiguredTeamsOutput {
	s.NextToken = &v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type ListMicrosoftTeamsUserIdentitiesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsUserIdentitiesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsUserIdentitiesException) GoString() string {
	return s.String()
}

func newErrorListMicrosoftTeamsUserIdentitiesException(v protocol.ResponseMetadata) error {
	return &ListMicrosoftTeamsUserIdentitiesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ListMicrosoftTeamsUserIdentitiesException) Code() string {
	return "ListMicrosoftTeamsUserIdentitiesException"
}

// Message returns the exception's message.
func (s *ListMicrosoftTeamsUserIdentitiesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ListMicrosoftTeamsUserIdentitiesException) OrigErr() error {
	return nil
}

func (s *ListMicrosoftTeamsUserIdentitiesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ListMicrosoftTeamsUserIdentitiesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ListMicrosoftTeamsUserIdentitiesException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListMicrosoftTeamsUserIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the MicrosoftTeamsChannelConfiguration associated with the user
	// identities to list.
	ChatConfigurationArn *string `min:"19" type:"string"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsUserIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsUserIdentitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMicrosoftTeamsUserIdentitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMicrosoftTeamsUserIdentitiesInput"}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *ListMicrosoftTeamsUserIdentitiesInput) SetChatConfigurationArn(v string) *ListMicrosoftTeamsUserIdentitiesInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMicrosoftTeamsUserIdentitiesInput) SetMaxResults(v int64) *ListMicrosoftTeamsUserIdentitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMicrosoftTeamsUserIdentitiesInput) SetNextToken(v string) *ListMicrosoftTeamsUserIdentitiesInput {
	s.NextToken = &v
	return s
}

type ListMicrosoftTeamsUserIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// User level permissions associated to a channel configuration.
	TeamsUserIdentities []*TeamsUserIdentity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsUserIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMicrosoftTeamsUserIdentitiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMicrosoftTeamsUserIdentitiesOutput) SetNextToken(v string) *ListMicrosoftTeamsUserIdentitiesOutput {
	s.NextToken = &v
	return s
}

// SetTeamsUserIdentities sets the TeamsUserIdentities field's value.
func (s *ListMicrosoftTeamsUserIdentitiesOutput) SetTeamsUserIdentities(v []*TeamsUserIdentity) *ListMicrosoftTeamsUserIdentitiesOutput {
	s.TeamsUserIdentities = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type ListTeamsChannelConfigurationsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTeamsChannelConfigurationsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTeamsChannelConfigurationsException) GoString() string {
	return s.String()
}

func newErrorListTeamsChannelConfigurationsException(v protocol.ResponseMetadata) error {
	return &ListTeamsChannelConfigurationsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ListTeamsChannelConfigurationsException) Code() string {
	return "ListTeamsChannelConfigurationsException"
}

// Message returns the exception's message.
func (s *ListTeamsChannelConfigurationsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ListTeamsChannelConfigurationsException) OrigErr() error {
	return nil
}

func (s *ListTeamsChannelConfigurationsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ListTeamsChannelConfigurationsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ListTeamsChannelConfigurationsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We were not able to find the resource for your request.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An AWS Chatbot configuration for Slack.
type SlackChannelConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the SlackChannelConfiguration.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not
	// set.
	GuardrailPolicyArns []*string `type:"list"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ID of the Slack channel. To get the ID, open Slack, right click on the
	// channel name in the left pane, then choose Copy Link. The channel ID is the
	// 9-character string at the end of the URL. For example, ABCBBLZZZ.
	//
	// SlackChannelId is a required field
	SlackChannelId *string `min:"1" type:"string" required:"true"`

	// The name of the Slack Channel.
	//
	// SlackChannelName is a required field
	SlackChannelName *string `min:"1" type:"string" required:"true"`

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// SlackTeamId is a required field
	SlackTeamId *string `min:"1" type:"string" required:"true"`

	// Name of the Slack Workspace.
	//
	// SlackTeamName is a required field
	SlackTeamName *string `min:"1" type:"string" required:"true"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// SnsTopicArns is a required field
	SnsTopicArns []*string `type:"list" required:"true"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackChannelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackChannelConfiguration) GoString() string {
	return s.String()
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *SlackChannelConfiguration) SetChatConfigurationArn(v string) *SlackChannelConfiguration {
	s.ChatConfigurationArn = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *SlackChannelConfiguration) SetConfigurationName(v string) *SlackChannelConfiguration {
	s.ConfigurationName = &v
	return s
}

// SetGuardrailPolicyArns sets the GuardrailPolicyArns field's value.
func (s *SlackChannelConfiguration) SetGuardrailPolicyArns(v []*string) *SlackChannelConfiguration {
	s.GuardrailPolicyArns = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *SlackChannelConfiguration) SetIamRoleArn(v string) *SlackChannelConfiguration {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *SlackChannelConfiguration) SetLoggingLevel(v string) *SlackChannelConfiguration {
	s.LoggingLevel = &v
	return s
}

// SetSlackChannelId sets the SlackChannelId field's value.
func (s *SlackChannelConfiguration) SetSlackChannelId(v string) *SlackChannelConfiguration {
	s.SlackChannelId = &v
	return s
}

// SetSlackChannelName sets the SlackChannelName field's value.
func (s *SlackChannelConfiguration) SetSlackChannelName(v string) *SlackChannelConfiguration {
	s.SlackChannelName = &v
	return s
}

// SetSlackTeamId sets the SlackTeamId field's value.
func (s *SlackChannelConfiguration) SetSlackTeamId(v string) *SlackChannelConfiguration {
	s.SlackTeamId = &v
	return s
}

// SetSlackTeamName sets the SlackTeamName field's value.
func (s *SlackChannelConfiguration) SetSlackTeamName(v string) *SlackChannelConfiguration {
	s.SlackTeamName = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *SlackChannelConfiguration) SetSnsTopicArns(v []*string) *SlackChannelConfiguration {
	s.SnsTopicArns = v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *SlackChannelConfiguration) SetUserAuthorizationRequired(v bool) *SlackChannelConfiguration {
	s.UserAuthorizationRequired = &v
	return s
}

// Identifes a User level permission for a channel configuration.
type SlackUserIdentity struct {
	_ struct{} `type:"structure"`

	// The AWS user identity ARN used to associate a Slack User Identity with an
	// IAM Role.
	AwsUserIdentity *string `min:"15" type:"string"`

	// The ARN of the SlackChannelConfiguration associated with the user identity.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// SlackTeamId is a required field
	SlackTeamId *string `min:"1" type:"string" required:"true"`

	// The ID of the user in Slack.
	//
	// SlackUserId is a required field
	SlackUserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackUserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackUserIdentity) GoString() string {
	return s.String()
}

// SetAwsUserIdentity sets the AwsUserIdentity field's value.
func (s *SlackUserIdentity) SetAwsUserIdentity(v string) *SlackUserIdentity {
	s.AwsUserIdentity = &v
	return s
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *SlackUserIdentity) SetChatConfigurationArn(v string) *SlackUserIdentity {
	s.ChatConfigurationArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *SlackUserIdentity) SetIamRoleArn(v string) *SlackUserIdentity {
	s.IamRoleArn = &v
	return s
}

// SetSlackTeamId sets the SlackTeamId field's value.
func (s *SlackUserIdentity) SetSlackTeamId(v string) *SlackUserIdentity {
	s.SlackTeamId = &v
	return s
}

// SetSlackUserId sets the SlackUserId field's value.
func (s *SlackUserIdentity) SetSlackUserId(v string) *SlackUserIdentity {
	s.SlackUserId = &v
	return s
}

// A Slack Workspace.
type SlackWorkspace struct {
	_ struct{} `type:"structure"`

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// SlackTeamId is a required field
	SlackTeamId *string `min:"1" type:"string" required:"true"`

	// Name of the Slack Workspace.
	//
	// SlackTeamName is a required field
	SlackTeamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackWorkspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackWorkspace) GoString() string {
	return s.String()
}

// SetSlackTeamId sets the SlackTeamId field's value.
func (s *SlackWorkspace) SetSlackTeamId(v string) *SlackWorkspace {
	s.SlackTeamId = &v
	return s
}

// SetSlackTeamName sets the SlackTeamName field's value.
func (s *SlackWorkspace) SetSlackTeamName(v string) *SlackWorkspace {
	s.SlackTeamName = &v
	return s
}

// An AWS Chatbot configuration for Microsoft Teams.
type TeamsChannelConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the Microsoft Teams channel.
	//
	// ChannelId is a required field
	ChannelId *string `min:"1" type:"string" required:"true"`

	// The name of the Microsoft Teams channel.
	ChannelName *string `min:"1" type:"string"`

	// The ARN of the MicrosoftTeamsChannelConfiguration.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not
	// set.
	GuardrailPolicyArns []*string `type:"list"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	//
	// SnsTopicArns is a required field
	SnsTopicArns []*string `type:"list" required:"true"`

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team
	// ID, you must perform the initial authorization flow with Microsoft Teams
	// in the AWS Chatbot console. Then you can copy and paste the team ID from
	// the console. For more details, see steps 1-4 in Get started with Microsoft
	// Teams in the AWS Chatbot Administrator Guide.
	//
	// TeamId is a required field
	TeamId *string `min:"36" type:"string" required:"true"`

	// The name of the Microsoft Teams Team.
	TeamName *string `type:"string"`

	// The ID of the Microsoft Teams tenant.
	//
	// TenantId is a required field
	TenantId *string `min:"36" type:"string" required:"true"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TeamsChannelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TeamsChannelConfiguration) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *TeamsChannelConfiguration) SetChannelId(v string) *TeamsChannelConfiguration {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *TeamsChannelConfiguration) SetChannelName(v string) *TeamsChannelConfiguration {
	s.ChannelName = &v
	return s
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *TeamsChannelConfiguration) SetChatConfigurationArn(v string) *TeamsChannelConfiguration {
	s.ChatConfigurationArn = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *TeamsChannelConfiguration) SetConfigurationName(v string) *TeamsChannelConfiguration {
	s.ConfigurationName = &v
	return s
}

// SetGuardrailPolicyArns sets the GuardrailPolicyArns field's value.
func (s *TeamsChannelConfiguration) SetGuardrailPolicyArns(v []*string) *TeamsChannelConfiguration {
	s.GuardrailPolicyArns = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *TeamsChannelConfiguration) SetIamRoleArn(v string) *TeamsChannelConfiguration {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *TeamsChannelConfiguration) SetLoggingLevel(v string) *TeamsChannelConfiguration {
	s.LoggingLevel = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *TeamsChannelConfiguration) SetSnsTopicArns(v []*string) *TeamsChannelConfiguration {
	s.SnsTopicArns = v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *TeamsChannelConfiguration) SetTeamId(v string) *TeamsChannelConfiguration {
	s.TeamId = &v
	return s
}

// SetTeamName sets the TeamName field's value.
func (s *TeamsChannelConfiguration) SetTeamName(v string) *TeamsChannelConfiguration {
	s.TeamName = &v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *TeamsChannelConfiguration) SetTenantId(v string) *TeamsChannelConfiguration {
	s.TenantId = &v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *TeamsChannelConfiguration) SetUserAuthorizationRequired(v bool) *TeamsChannelConfiguration {
	s.UserAuthorizationRequired = &v
	return s
}

// Identifes a user level permission for a channel configuration.
type TeamsUserIdentity struct {
	_ struct{} `type:"structure"`

	// The AWS user identity ARN used to associate a Microsoft Teams User Identity
	// with an IAM Role.
	AwsUserIdentity *string `min:"15" type:"string"`

	// The ARN of the MicrosoftTeamsChannelConfiguration associated with the user
	// identity.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"12" type:"string" required:"true"`

	// The ID of the Microsoft Team authorized with AWS Chatbot. To get the team
	// ID, you must perform the initial authorization flow with Microsoft Teams
	// in the AWS Chatbot console. Then you can copy and paste the team ID from
	// the console. For more details, see steps 1-4 in Get started with Microsoft
	// Teams in the AWS Chatbot Administrator Guide.
	//
	// TeamId is a required field
	TeamId *string `min:"36" type:"string" required:"true"`

	// The ID of the Microsoft Teams channel.
	TeamsChannelId *string `min:"1" type:"string"`

	// The ID of the Microsoft Teams tenant.
	TeamsTenantId *string `min:"36" type:"string"`

	// Id from Microsoft Teams for user.
	UserId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TeamsUserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TeamsUserIdentity) GoString() string {
	return s.String()
}

// SetAwsUserIdentity sets the AwsUserIdentity field's value.
func (s *TeamsUserIdentity) SetAwsUserIdentity(v string) *TeamsUserIdentity {
	s.AwsUserIdentity = &v
	return s
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *TeamsUserIdentity) SetChatConfigurationArn(v string) *TeamsUserIdentity {
	s.ChatConfigurationArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *TeamsUserIdentity) SetIamRoleArn(v string) *TeamsUserIdentity {
	s.IamRoleArn = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *TeamsUserIdentity) SetTeamId(v string) *TeamsUserIdentity {
	s.TeamId = &v
	return s
}

// SetTeamsChannelId sets the TeamsChannelId field's value.
func (s *TeamsUserIdentity) SetTeamsChannelId(v string) *TeamsUserIdentity {
	s.TeamsChannelId = &v
	return s
}

// SetTeamsTenantId sets the TeamsTenantId field's value.
func (s *TeamsUserIdentity) SetTeamsTenantId(v string) *TeamsUserIdentity {
	s.TeamsTenantId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *TeamsUserIdentity) SetUserId(v string) *TeamsUserIdentity {
	s.UserId = &v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type UpdateAccountPreferencesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountPreferencesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountPreferencesException) GoString() string {
	return s.String()
}

func newErrorUpdateAccountPreferencesException(v protocol.ResponseMetadata) error {
	return &UpdateAccountPreferencesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpdateAccountPreferencesException) Code() string {
	return "UpdateAccountPreferencesException"
}

// Message returns the exception's message.
func (s *UpdateAccountPreferencesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpdateAccountPreferencesException) OrigErr() error {
	return nil
}

func (s *UpdateAccountPreferencesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpdateAccountPreferencesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpdateAccountPreferencesException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateAccountPreferencesInput struct {
	_ struct{} `type:"structure"`

	// Turns on training data collection. This helps improve the AWS Chatbot experience
	// by allowing AWS Chatbot to store and use your customer information, such
	// as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot generated
	// responses, and interaction data. This data helps us to continuously improve
	// and develop Artificial Intelligence (AI) technologies. Your data is not shared
	// with any third parties and is protected using sophisticated controls to prevent
	// unauthorized access and misuse. AWS Chatbot does not store or use interactions
	// in chat channels with Amazon Q for training AWS Chatbot’s AI technologies.
	TrainingDataCollectionEnabled *bool `type:"boolean"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountPreferencesInput) GoString() string {
	return s.String()
}

// SetTrainingDataCollectionEnabled sets the TrainingDataCollectionEnabled field's value.
func (s *UpdateAccountPreferencesInput) SetTrainingDataCollectionEnabled(v bool) *UpdateAccountPreferencesInput {
	s.TrainingDataCollectionEnabled = &v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *UpdateAccountPreferencesInput) SetUserAuthorizationRequired(v bool) *UpdateAccountPreferencesInput {
	s.UserAuthorizationRequired = &v
	return s
}

type UpdateAccountPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// Preferences which apply for AWS Chatbot usage in the calling AWS account.
	AccountPreferences *AccountPreferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountPreferencesOutput) GoString() string {
	return s.String()
}

// SetAccountPreferences sets the AccountPreferences field's value.
func (s *UpdateAccountPreferencesOutput) SetAccountPreferences(v *AccountPreferences) *UpdateAccountPreferencesOutput {
	s.AccountPreferences = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type UpdateChimeWebhookConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChimeWebhookConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChimeWebhookConfigurationException) GoString() string {
	return s.String()
}

func newErrorUpdateChimeWebhookConfigurationException(v protocol.ResponseMetadata) error {
	return &UpdateChimeWebhookConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpdateChimeWebhookConfigurationException) Code() string {
	return "UpdateChimeWebhookConfigurationException"
}

// Message returns the exception's message.
func (s *UpdateChimeWebhookConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpdateChimeWebhookConfigurationException) OrigErr() error {
	return nil
}

func (s *UpdateChimeWebhookConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpdateChimeWebhookConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpdateChimeWebhookConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateChimeWebhookConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the ChimeWebhookConfiguration to update.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	IamRoleArn *string `min:"12" type:"string"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	SnsTopicArns []*string `type:"list"`

	// Description of the webhook. Recommend using the convention `RoomName/WebhookName`.
	// See Chime setup tutorial for more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
	WebhookDescription *string `min:"1" type:"string"`

	// URL for the Chime webhook.
	WebhookUrl *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChimeWebhookConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChimeWebhookConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChimeWebhookConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChimeWebhookConfigurationInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 12))
	}
	if s.LoggingLevel != nil && len(*s.LoggingLevel) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingLevel", 4))
	}
	if s.WebhookDescription != nil && len(*s.WebhookDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebhookDescription", 1))
	}
	if s.WebhookUrl != nil && len(*s.WebhookUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebhookUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *UpdateChimeWebhookConfigurationInput) SetChatConfigurationArn(v string) *UpdateChimeWebhookConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *UpdateChimeWebhookConfigurationInput) SetIamRoleArn(v string) *UpdateChimeWebhookConfigurationInput {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *UpdateChimeWebhookConfigurationInput) SetLoggingLevel(v string) *UpdateChimeWebhookConfigurationInput {
	s.LoggingLevel = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *UpdateChimeWebhookConfigurationInput) SetSnsTopicArns(v []*string) *UpdateChimeWebhookConfigurationInput {
	s.SnsTopicArns = v
	return s
}

// SetWebhookDescription sets the WebhookDescription field's value.
func (s *UpdateChimeWebhookConfigurationInput) SetWebhookDescription(v string) *UpdateChimeWebhookConfigurationInput {
	s.WebhookDescription = &v
	return s
}

// SetWebhookUrl sets the WebhookUrl field's value.
func (s *UpdateChimeWebhookConfigurationInput) SetWebhookUrl(v string) *UpdateChimeWebhookConfigurationInput {
	s.WebhookUrl = &v
	return s
}

type UpdateChimeWebhookConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Chime webhook configuration.
	WebhookConfiguration *ChimeWebhookConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChimeWebhookConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChimeWebhookConfigurationOutput) GoString() string {
	return s.String()
}

// SetWebhookConfiguration sets the WebhookConfiguration field's value.
func (s *UpdateChimeWebhookConfigurationOutput) SetWebhookConfiguration(v *ChimeWebhookConfiguration) *UpdateChimeWebhookConfigurationOutput {
	s.WebhookConfiguration = v
	return s
}

type UpdateMicrosoftTeamsChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Microsoft Teams channel.
	//
	// ChannelId is a required field
	ChannelId *string `min:"1" type:"string" required:"true"`

	// The name of the Microsoft Teams channel.
	ChannelName *string `min:"1" type:"string"`

	// The ARN of the MicrosoftTeamsChannelConfiguration to update.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not
	// set.
	GuardrailPolicyArns []*string `type:"list"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	IamRoleArn *string `min:"12" type:"string"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	SnsTopicArns []*string `type:"list"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMicrosoftTeamsChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMicrosoftTeamsChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMicrosoftTeamsChannelConfigurationInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 12))
	}
	if s.LoggingLevel != nil && len(*s.LoggingLevel) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingLevel", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetChannelId(v string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetChannelName(v string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.ChannelName = &v
	return s
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetChatConfigurationArn(v string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetGuardrailPolicyArns sets the GuardrailPolicyArns field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetGuardrailPolicyArns(v []*string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.GuardrailPolicyArns = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetIamRoleArn(v string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetLoggingLevel(v string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.LoggingLevel = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetSnsTopicArns(v []*string) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.SnsTopicArns = v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationInput) SetUserAuthorizationRequired(v bool) *UpdateMicrosoftTeamsChannelConfigurationInput {
	s.UserAuthorizationRequired = &v
	return s
}

type UpdateMicrosoftTeamsChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for a Microsoft Teams channel configured with AWS Chatbot.
	ChannelConfiguration *TeamsChannelConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMicrosoftTeamsChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMicrosoftTeamsChannelConfigurationOutput) GoString() string {
	return s.String()
}

// SetChannelConfiguration sets the ChannelConfiguration field's value.
func (s *UpdateMicrosoftTeamsChannelConfigurationOutput) SetChannelConfiguration(v *TeamsChannelConfiguration) *UpdateMicrosoftTeamsChannelConfigurationOutput {
	s.ChannelConfiguration = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type UpdateSlackChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorUpdateSlackChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &UpdateSlackChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpdateSlackChannelConfigurationException) Code() string {
	return "UpdateSlackChannelConfigurationException"
}

// Message returns the exception's message.
func (s *UpdateSlackChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpdateSlackChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *UpdateSlackChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpdateSlackChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpdateSlackChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateSlackChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SlackChannelConfiguration to update.
	//
	// ChatConfigurationArn is a required field
	ChatConfigurationArn *string `min:"19" type:"string" required:"true"`

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not
	// set.
	GuardrailPolicyArns []*string `type:"list"`

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This
	// is a user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	IamRoleArn *string `min:"12" type:"string"`

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string `min:"4" type:"string"`

	// The ID of the Slack channel. To get the ID, open Slack, right click on the
	// channel name in the left pane, then choose Copy Link. The channel ID is the
	// 9-character string at the end of the URL. For example, ABCBBLZZZ.
	//
	// SlackChannelId is a required field
	SlackChannelId *string `min:"1" type:"string" required:"true"`

	// The name of the Slack Channel.
	SlackChannelName *string `min:"1" type:"string"`

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	SnsTopicArns []*string `type:"list"`

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSlackChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSlackChannelConfigurationInput"}
	if s.ChatConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChatConfigurationArn"))
	}
	if s.ChatConfigurationArn != nil && len(*s.ChatConfigurationArn) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ChatConfigurationArn", 19))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 12))
	}
	if s.LoggingLevel != nil && len(*s.LoggingLevel) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingLevel", 4))
	}
	if s.SlackChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlackChannelId"))
	}
	if s.SlackChannelId != nil && len(*s.SlackChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackChannelId", 1))
	}
	if s.SlackChannelName != nil && len(*s.SlackChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlackChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatConfigurationArn sets the ChatConfigurationArn field's value.
func (s *UpdateSlackChannelConfigurationInput) SetChatConfigurationArn(v string) *UpdateSlackChannelConfigurationInput {
	s.ChatConfigurationArn = &v
	return s
}

// SetGuardrailPolicyArns sets the GuardrailPolicyArns field's value.
func (s *UpdateSlackChannelConfigurationInput) SetGuardrailPolicyArns(v []*string) *UpdateSlackChannelConfigurationInput {
	s.GuardrailPolicyArns = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *UpdateSlackChannelConfigurationInput) SetIamRoleArn(v string) *UpdateSlackChannelConfigurationInput {
	s.IamRoleArn = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *UpdateSlackChannelConfigurationInput) SetLoggingLevel(v string) *UpdateSlackChannelConfigurationInput {
	s.LoggingLevel = &v
	return s
}

// SetSlackChannelId sets the SlackChannelId field's value.
func (s *UpdateSlackChannelConfigurationInput) SetSlackChannelId(v string) *UpdateSlackChannelConfigurationInput {
	s.SlackChannelId = &v
	return s
}

// SetSlackChannelName sets the SlackChannelName field's value.
func (s *UpdateSlackChannelConfigurationInput) SetSlackChannelName(v string) *UpdateSlackChannelConfigurationInput {
	s.SlackChannelName = &v
	return s
}

// SetSnsTopicArns sets the SnsTopicArns field's value.
func (s *UpdateSlackChannelConfigurationInput) SetSnsTopicArns(v []*string) *UpdateSlackChannelConfigurationInput {
	s.SnsTopicArns = v
	return s
}

// SetUserAuthorizationRequired sets the UserAuthorizationRequired field's value.
func (s *UpdateSlackChannelConfigurationInput) SetUserAuthorizationRequired(v bool) *UpdateSlackChannelConfigurationInput {
	s.UserAuthorizationRequired = &v
	return s
}

type UpdateSlackChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for a Slack channel configured with AWS Chatbot.
	ChannelConfiguration *SlackChannelConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationOutput) GoString() string {
	return s.String()
}

// SetChannelConfiguration sets the ChannelConfiguration field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetChannelConfiguration(v *SlackChannelConfiguration) *UpdateSlackChannelConfigurationOutput {
	s.ChannelConfiguration = v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type UpdateTeamsChannelConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTeamsChannelConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTeamsChannelConfigurationException) GoString() string {
	return s.String()
}

func newErrorUpdateTeamsChannelConfigurationException(v protocol.ResponseMetadata) error {
	return &UpdateTeamsChannelConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpdateTeamsChannelConfigurationException) Code() string {
	return "UpdateTeamsChannelConfigurationException"
}

// Message returns the exception's message.
func (s *UpdateTeamsChannelConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpdateTeamsChannelConfigurationException) OrigErr() error {
	return nil
}

func (s *UpdateTeamsChannelConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpdateTeamsChannelConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpdateTeamsChannelConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}
