#include "compat.h"
#include "cmd.h"
struct cmd cmds[] = {
	{ "q",  cmd_kill_telescope, NULL },
	{ "w",  cmd_write_buffer, NULL },
	{ "tabn",  cmd_tab_next, NULL },
	{ "tabnew",  cmd_tab_new, NULL },
	{ "tabp",  cmd_tab_previous, NULL },
	{ "wq",  cmd_kill_telescope, NULL },
	{ "open",  cmd_load_url, NULL },
	{ "backward-char", cmd_backward_char, 		"Move point one character backward." },
	{ "backward-paragraph", cmd_backward_paragraph, 	"Move point on paragraph backward." },
	{ "beginning-of-buffer", cmd_beginning_of_buffer, 	"Move point to the beginning of the buffer." },
	{ "bookmark-page", cmd_bookmark_page, 		"Save a page in the bookmark file." },
	{ "cache-info", cmd_cache_info, 		"Show cache stats." },
	{ "clear-minibuf", cmd_clear_minibuf, 		"Clear the echo area." },
	{ "client-certificate-info", cmd_client_certificate_info, "Show the active client certificate." },
	{ "dec-fill-column", cmd_dec_fill_column, 	"Decrement fill-column by two." },
	{ "end-of-buffer", cmd_end_of_buffer, 		"Move the point to the end of the buffer." },
	{ "execute-extended-command", cmd_execute_extended_command,  "Execute an internal command." },
	{ "forward-char", cmd_forward_char, 		"Move point one character forward." },
	{ "forward-paragraph", cmd_forward_paragraph, 	"Move point one paragraph forward." },
	{ "home", cmd_home, 			"Go to the home directory." },
	{ "inc-fill-column", cmd_inc_fill_column, 	"Increment fill-column by two" },
	{ "insert-current-candidate", cmd_insert_current_candidate,  "Copy the current selection text as minibuffer input." },
	{ "kill-telescope", cmd_kill_telescope, 		"Quit Telescope." },
	{ "link-select", cmd_link_select, 		"Select and visit a link using the minibuffer." },
	{ "list-bookmarks", cmd_list_bookmarks, 		"Load the bookmarks page." },
	{ "load-current-url", cmd_load_current_url, 	"Edit the current URL." },
	{ "load-url", cmd_load_url, 		"Prompt for an URL." },
	{ "mini-abort", cmd_mini_abort, 		"Abort the current minibuffer action." },
	{ "mini-complete-and-exit", cmd_mini_complete_and_exit, 	"Complete the current minibuffer action." },
	{ "mini-delete-backward-char", cmd_mini_delete_backward_char,  "Delete the character before the point." },
	{ "mini-delete-char", cmd_mini_delete_char, 	"Delete the character after the point." },
	{ "mini-edit-external", cmd_mini_edit_external, 	"Use an external editor to compose the text." },
	{ "mini-goto-beginning", cmd_mini_goto_beginning, 	"Select the first completion." },
	{ "mini-goto-end", cmd_mini_goto_end, 		"Select the last completion." },
	{ "mini-kill-line", cmd_mini_kill_line, 		"Delete from point until the end of the line." },
	{ "mini-kill-whole-line", cmd_mini_kill_whole_line, 	"Delete the whole line." },
	{ "mini-next-history-element", cmd_mini_next_history_element,  "Load the next history element." },
	{ "mini-previous-history-element", cmd_mini_previous_history_element,  "Load the previous history element." },
	{ "mini-scroll-down", cmd_mini_scroll_down, 	"Scroll completions up by one visual page" },
	{ "mini-scroll-up", cmd_mini_scroll_up, 		"Scroll completions up by one visual page" },
	{ "move-beginning-of-line", cmd_move_beginning_of_line, 	"Move point at the beginning of the current visual line." },
	{ "move-end-of-line", cmd_move_end_of_line, 	"Move point at the end of the current visual line." },
	{ "next-button", cmd_next_button, 		"Move point to the next link." },
	{ "next-completion", cmd_next_completion, 	"Select the next completion." },
	{ "next-heading", cmd_next_heading, 		"Move point to the next heading." },
	{ "next-line", cmd_next_line, 		"Move point to the next visual line." },
	{ "next-page", cmd_next_page, 		"Go forward in the page history." },
	{ "olivetti-mode", cmd_olivetti_mode, 		"Toggle olivetti-mode." },
	{ "other-window", cmd_other_window, 		"Select the other window." },
	{ "previous-button", cmd_previous_button, 	"Move point to the previous link." },
	{ "previous-completion", cmd_previous_completion, 	"Select the previous completion." },
	{ "previous-heading", cmd_previous_heading, 	"Move point to the previous heading." },
	{ "previous-line", cmd_previous_line, 		"Move point to the previous visual line." },
	{ "previous-page", cmd_previous_page, 		"Go backward in the page history." },
	{ "push-button", cmd_push_button, 		"Follow link at point or toggle pre-visibility." },
	{ "push-button-new-tab", cmd_push_button_new_tab, 	"Follow link at point in a new tab." },
	{ "redraw", cmd_redraw, 			"Redraw the screen." },
	{ "reload-page", cmd_reload_page, 		"Reload the current page." },
	{ "reply-last-input", cmd_reply_last_input, 	"Reply last input request." },
	{ "root", cmd_root, 			"Go to the root directory." },
	{ "scroll-down", cmd_scroll_down, 		"Scroll down by one visual page" },
	{ "scroll-line-down", cmd_scroll_line_down, 	"Scroll down by one line" },
	{ "scroll-line-up", cmd_scroll_line_up, 		"Scroll up by one line." },
	{ "scroll-up", cmd_scroll_up, 		"Scroll up by one visual page" },
	{ "search", cmd_search, 			"Search using the preferred search engine" },
	{ "suspend-telescope", cmd_suspend_telescope, 	"Suspend the current Telescope session." },
	{ "swiper", cmd_swiper, 			"Jump to a line using the minibuffer." },
	{ "tab-close", cmd_tab_close, 		"Close the current tab." },
	{ "tab-close-other", cmd_tab_close_other, 	"Close all tabs but the current one." },
	{ "tab-move", cmd_tab_move, 		"Move the current tab to the right." },
	{ "tab-move-to", cmd_tab_move_to, 		"Move the current tab to the left." },
	{ "tab-new", cmd_tab_new, 		"Open a new tab." },
	{ "tab-next", cmd_tab_next, 		"Focus next tab." },
	{ "tab-previous", cmd_tab_previous, 		"Focus previous tab." },
	{ "tab-select", cmd_tab_select, 		"Switch to a tab using the minibuffer." },
	{ "tab-undo-close", cmd_tab_undo_close, 		"Reopen last closed tab." },
	{ "toc", cmd_toc, 			"Jump to a heading using the minibuffer." },
	{ "toggle-downloads", cmd_toggle_downloads, 	"Toggle the downloads side window." },
	{ "toggle-help", cmd_toggle_help, 		"Toggle side window with help." },
	{ "toggle-pre-wrap", cmd_toggle_pre_wrap, 	"Toggle the wrapping of preformatted blocks." },
	{ "toggle-styling", cmd_toggle_styling, 		"Toggle the page styling." },
	{ "unload-certificate", cmd_unload_certificate, 	"Forget the certificate on this page." },
	{ "up", cmd_up, 			"Go up one level." },
	{ "use-certificate", cmd_use_certificate, 	"Use a certificate for the current page." },
	{ "write-buffer", cmd_write_buffer, 		"Save the current page to the disk." },
	{ NULL, NULL, NULL },
};
