/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

const { PermissionTestUtils } = ChromeUtils.importESModule(
  "resource://testing-common/PermissionTestUtils.sys.mjs"
);

add_task(async function test() {
  // eslint-disable-next-line @microsoft/sdl/no-insecure-url
  let uriString = "http://example.com/";
  let cookieBehavior = "network.cookie.cookieBehavior";

  await SpecialPowers.pushPrefEnv({ set: [[cookieBehavior, 2]] });
  PermissionTestUtils.add(uriString, "cookie", Services.perms.ALLOW_ACTION);

  await BrowserTestUtils.withNewTab(
    { gBrowser, url: uriString },
    async function (browser) {
      await SpecialPowers.spawn(browser, [], function () {
        is(
          content.navigator.cookieEnabled,
          true,
          "navigator.cookieEnabled should be true"
        );
      });
    }
  );

  PermissionTestUtils.add(uriString, "cookie", Services.perms.UNKNOWN_ACTION);
});
