// Code generated by go generate; DO NOT EDIT.
package asana

import "errors"

type Permission int

const (
    Invalid Permission = iota
    AllocationsRead Permission = iota
    AllocationsWrite Permission = iota
    AttachmentsRead Permission = iota
    AttachmentsWrite Permission = iota
    AutditLogsRead Permission = iota
    AutditLogsWrite Permission = iota
    CustomFieldsRead Permission = iota
    CustomFieldsWrite Permission = iota
    CustomFieldSettingsRead Permission = iota
    CustomFieldSettingsWrite Permission = iota
    BatchApiRead Permission = iota
    BatchApiWrite Permission = iota
    EventsRead Permission = iota
    EventsWrite Permission = iota
    GoalsRead Permission = iota
    GoalsWrite Permission = iota
    JobsRead Permission = iota
    JobsWrite Permission = iota
    PortfoliosRead Permission = iota
    PortfoliosWrite Permission = iota
    ProjectsRead Permission = iota
    ProjectsWrite Permission = iota
    ProjectMembershipsRead Permission = iota
    ProjectMembershipsWrite Permission = iota
    SectionsRead Permission = iota
    SectionsWrite Permission = iota
    TagsRead Permission = iota
    TagsWrite Permission = iota
    TasksRead Permission = iota
    TasksWrite Permission = iota
    TeamsRead Permission = iota
    TeamsWrite Permission = iota
    UsersRead Permission = iota
    UsersWrite Permission = iota
    UserTaskListsRead Permission = iota
    UserTaskListsWrite Permission = iota
    MembershipsRead Permission = iota
    MembershipsWrite Permission = iota
    RulesRead Permission = iota
    RulesWrite Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        AllocationsRead: "allocations:read",
        AllocationsWrite: "allocations:write",
        AttachmentsRead: "attachments:read",
        AttachmentsWrite: "attachments:write",
        AutditLogsRead: "autdit_logs:read",
        AutditLogsWrite: "autdit_logs:write",
        CustomFieldsRead: "custom_fields:read",
        CustomFieldsWrite: "custom_fields:write",
        CustomFieldSettingsRead: "custom_field_settings:read",
        CustomFieldSettingsWrite: "custom_field_settings:write",
        BatchApiRead: "batch_api:read",
        BatchApiWrite: "batch_api:write",
        EventsRead: "events:read",
        EventsWrite: "events:write",
        GoalsRead: "goals:read",
        GoalsWrite: "goals:write",
        JobsRead: "jobs:read",
        JobsWrite: "jobs:write",
        PortfoliosRead: "portfolios:read",
        PortfoliosWrite: "portfolios:write",
        ProjectsRead: "projects:read",
        ProjectsWrite: "projects:write",
        ProjectMembershipsRead: "project_memberships:read",
        ProjectMembershipsWrite: "project_memberships:write",
        SectionsRead: "sections:read",
        SectionsWrite: "sections:write",
        TagsRead: "tags:read",
        TagsWrite: "tags:write",
        TasksRead: "tasks:read",
        TasksWrite: "tasks:write",
        TeamsRead: "teams:read",
        TeamsWrite: "teams:write",
        UsersRead: "users:read",
        UsersWrite: "users:write",
        UserTaskListsRead: "user_task_lists:read",
        UserTaskListsWrite: "user_task_lists:write",
        MembershipsRead: "memberships:read",
        MembershipsWrite: "memberships:write",
        RulesRead: "rules:read",
        RulesWrite: "rules:write",
    }

    StringToPermission = map[string]Permission{
        "allocations:read": AllocationsRead,
        "allocations:write": AllocationsWrite,
        "attachments:read": AttachmentsRead,
        "attachments:write": AttachmentsWrite,
        "autdit_logs:read": AutditLogsRead,
        "autdit_logs:write": AutditLogsWrite,
        "custom_fields:read": CustomFieldsRead,
        "custom_fields:write": CustomFieldsWrite,
        "custom_field_settings:read": CustomFieldSettingsRead,
        "custom_field_settings:write": CustomFieldSettingsWrite,
        "batch_api:read": BatchApiRead,
        "batch_api:write": BatchApiWrite,
        "events:read": EventsRead,
        "events:write": EventsWrite,
        "goals:read": GoalsRead,
        "goals:write": GoalsWrite,
        "jobs:read": JobsRead,
        "jobs:write": JobsWrite,
        "portfolios:read": PortfoliosRead,
        "portfolios:write": PortfoliosWrite,
        "projects:read": ProjectsRead,
        "projects:write": ProjectsWrite,
        "project_memberships:read": ProjectMembershipsRead,
        "project_memberships:write": ProjectMembershipsWrite,
        "sections:read": SectionsRead,
        "sections:write": SectionsWrite,
        "tags:read": TagsRead,
        "tags:write": TagsWrite,
        "tasks:read": TasksRead,
        "tasks:write": TasksWrite,
        "teams:read": TeamsRead,
        "teams:write": TeamsWrite,
        "users:read": UsersRead,
        "users:write": UsersWrite,
        "user_task_lists:read": UserTaskListsRead,
        "user_task_lists:write": UserTaskListsWrite,
        "memberships:read": MembershipsRead,
        "memberships:write": MembershipsWrite,
        "rules:read": RulesRead,
        "rules:write": RulesWrite,
    }

    PermissionIDs = map[Permission]int{
        AllocationsRead: 1,
        AllocationsWrite: 2,
        AttachmentsRead: 3,
        AttachmentsWrite: 4,
        AutditLogsRead: 5,
        AutditLogsWrite: 6,
        CustomFieldsRead: 7,
        CustomFieldsWrite: 8,
        CustomFieldSettingsRead: 9,
        CustomFieldSettingsWrite: 10,
        BatchApiRead: 11,
        BatchApiWrite: 12,
        EventsRead: 13,
        EventsWrite: 14,
        GoalsRead: 15,
        GoalsWrite: 16,
        JobsRead: 17,
        JobsWrite: 18,
        PortfoliosRead: 19,
        PortfoliosWrite: 20,
        ProjectsRead: 21,
        ProjectsWrite: 22,
        ProjectMembershipsRead: 23,
        ProjectMembershipsWrite: 24,
        SectionsRead: 25,
        SectionsWrite: 26,
        TagsRead: 27,
        TagsWrite: 28,
        TasksRead: 29,
        TasksWrite: 30,
        TeamsRead: 31,
        TeamsWrite: 32,
        UsersRead: 33,
        UsersWrite: 34,
        UserTaskListsRead: 35,
        UserTaskListsWrite: 36,
        MembershipsRead: 37,
        MembershipsWrite: 38,
        RulesRead: 39,
        RulesWrite: 40,
    }

    IdToPermission = map[int]Permission{
        1: AllocationsRead,
        2: AllocationsWrite,
        3: AttachmentsRead,
        4: AttachmentsWrite,
        5: AutditLogsRead,
        6: AutditLogsWrite,
        7: CustomFieldsRead,
        8: CustomFieldsWrite,
        9: CustomFieldSettingsRead,
        10: CustomFieldSettingsWrite,
        11: BatchApiRead,
        12: BatchApiWrite,
        13: EventsRead,
        14: EventsWrite,
        15: GoalsRead,
        16: GoalsWrite,
        17: JobsRead,
        18: JobsWrite,
        19: PortfoliosRead,
        20: PortfoliosWrite,
        21: ProjectsRead,
        22: ProjectsWrite,
        23: ProjectMembershipsRead,
        24: ProjectMembershipsWrite,
        25: SectionsRead,
        26: SectionsWrite,
        27: TagsRead,
        28: TagsWrite,
        29: TasksRead,
        30: TasksWrite,
        31: TeamsRead,
        32: TeamsWrite,
        33: UsersRead,
        34: UsersWrite,
        35: UserTaskListsRead,
        36: UserTaskListsWrite,
        37: MembershipsRead,
        38: MembershipsWrite,
        39: RulesRead,
        40: RulesWrite,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
