/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2011 Freescale Semiconductor, Inc. All Rights Reserved.
 */

#ifndef __ARCH_ARM_MACH_MX6_CCM_REGS_H__
#define __ARCH_ARM_MACH_MX6_CCM_REGS_H__

#define CCM_CCOSR		0x020c4060
#define CCM_CCGR0		0x020C4068
#define CCM_CCGR1		0x020C406c
#define CCM_CCGR2		0x020C4070
#define CCM_CCGR3		0x020C4074
#define CCM_CCGR4		0x020C4078
#define CCM_CCGR5		0x020C407c
#define CCM_CCGR6		0x020C4080

#define PMU_MISC2		0x020C8170

#ifndef __ASSEMBLY__
struct mxc_ccm_reg {
	u32 ccr;	/* 0x0000 */
	u32 ccdr;
	u32 csr;
	u32 ccsr;
	u32 cacrr;	/* 0x0010*/
	u32 cbcdr;
	u32 cbcmr;
	u32 cscmr1;
	u32 cscmr2;	/* 0x0020 */
	u32 cscdr1;
	u32 cs1cdr;
	u32 cs2cdr;
	u32 cdcdr;	/* 0x0030 */
	u32 chsccdr;
	u32 cscdr2;
	u32 cscdr3;
	u32 cscdr4;	/* 0x0040 */
	u32 resv0;
	u32 cdhipr;
	u32 cdcr;
	u32 ctor;	/* 0x0050 */
	u32 clpcr;
	u32 cisr;
	u32 cimr;
	u32 ccosr;	/* 0x0060 */
	u32 cgpr;
	u32 CCGR0;
	u32 CCGR1;
	u32 CCGR2;	/* 0x0070 */
	u32 CCGR3;
	u32 CCGR4;
	u32 CCGR5;
	u32 CCGR6;	/* 0x0080 */
	u32 CCGR7;
	u32 cmeor;
	u32 resv[0xfdd];
	u32 analog_pll_sys;			/* 0x4000 */
	u32 analog_pll_sys_set;
	u32 analog_pll_sys_clr;
	u32 analog_pll_sys_tog;
	u32 analog_usb1_pll_480_ctrl;		/* 0x4010 */
	u32 analog_usb1_pll_480_ctrl_set;
	u32 analog_usb1_pll_480_ctrl_clr;
	u32 analog_usb1_pll_480_ctrl_tog;
	u32 analog_reserved0[4];
	u32 analog_pll_528;			/* 0x4030 */
	u32 analog_pll_528_set;
	u32 analog_pll_528_clr;
	u32 analog_pll_528_tog;
	u32 analog_pll_528_ss;			/* 0x4040 */
	u32 analog_reserved1[3];
	u32 analog_pll_528_num;			/* 0x4050 */
	u32 analog_reserved2[3];
	u32 analog_pll_528_denom;		/* 0x4060 */
	u32 analog_reserved3[3];
	u32 analog_pll_audio;			/* 0x4070 */
	u32 analog_pll_audio_set;
	u32 analog_pll_audio_clr;
	u32 analog_pll_audio_tog;
	u32 analog_pll_audio_num;		/* 0x4080*/
	u32 analog_reserved4[3];
	u32 analog_pll_audio_denom;		/* 0x4090 */
	u32 analog_reserved5[3];
	u32 analog_pll_video;			/* 0x40a0 */
	u32 analog_pll_video_set;
	u32 analog_pll_video_clr;
	u32 analog_pll_video_tog;
	u32 analog_pll_video_num;		/* 0x40b0 */
	u32 analog_reserved6[3];
	u32 analog_pll_video_denom;		/* 0x40c0 */
	u32 analog_reserved7[7];
	u32 analog_pll_enet;			/* 0x40e0 */
	u32 analog_pll_enet_set;
	u32 analog_pll_enet_clr;
	u32 analog_pll_enet_tog;
	u32 analog_pfd_480;			/* 0x40f0 */
	u32 analog_pfd_480_set;
	u32 analog_pfd_480_clr;
	u32 analog_pfd_480_tog;
	u32 analog_pfd_528;			/* 0x4100 */
	u32 analog_pfd_528_set;
	u32 analog_pfd_528_clr;
	u32 analog_pfd_528_tog;
	/* PMU Memory Map/Register Definition */
	u32 pmu_reg_1p1;
	u32 pmu_reg_1p1_set;
	u32 pmu_reg_1p1_clr;
	u32 pmu_reg_1p1_tog;
	u32 pmu_reg_3p0;
	u32 pmu_reg_3p0_set;
	u32 pmu_reg_3p0_clr;
	u32 pmu_reg_3p0_tog;
	u32 pmu_reg_2p5;
	u32 pmu_reg_2p5_set;
	u32 pmu_reg_2p5_clr;
	u32 pmu_reg_2p5_tog;
	u32 pmu_reg_core;
	u32 pmu_reg_core_set;
	u32 pmu_reg_core_clr;
	u32 pmu_reg_core_tog;
	u32 pmu_misc0;
	u32 pmu_misc0_set;
	u32 pmu_misc0_clr;
	u32 pmu_misc0_tog;
	u32 pmu_misc1;
	u32 pmu_misc1_set;
	u32 pmu_misc1_clr;
	u32 pmu_misc1_tog;
	u32 pmu_misc2;
	u32 pmu_misc2_set;
	u32 pmu_misc2_clr;
	u32 pmu_misc2_tog;
	/* TEMPMON Memory Map/Register Definition */
	u32 tempsense0;
	u32 tempsense0_set;
	u32 tempsense0_clr;
	u32 tempsense0_tog;
	u32 tempsense1;
	u32 tempsense1_set;
	u32 tempsense1_clr;
	u32 tempsense1_tog;
	/* USB Analog Memory Map/Register Definition */
	u32 usb1_vbus_detect;
	u32 usb1_vbus_detect_set;
	u32 usb1_vbus_detect_clr;
	u32 usb1_vbus_detect_tog;
	u32 usb1_chrg_detect;
	u32 usb1_chrg_detect_set;
	u32 usb1_chrg_detect_clr;
	u32 usb1_chrg_detect_tog;
	u32 usb1_vbus_det_stat;
	u32 usb1_vbus_det_stat_set;
	u32 usb1_vbus_det_stat_clr;
	u32 usb1_vbus_det_stat_tog;
	u32 usb1_chrg_det_stat;
	u32 usb1_chrg_det_stat_set;
	u32 usb1_chrg_det_stat_clr;
	u32 usb1_chrg_det_stat_tog;
	u32 usb1_loopback;
	u32 usb1_loopback_set;
	u32 usb1_loopback_clr;
	u32 usb1_loopback_tog;
	u32 usb1_misc;
	u32 usb1_misc_set;
	u32 usb1_misc_clr;
	u32 usb1_misc_tog;
	u32 usb2_vbus_detect;
	u32 usb2_vbus_detect_set;
	u32 usb2_vbus_detect_clr;
	u32 usb2_vbus_detect_tog;
	u32 usb2_chrg_detect;
	u32 usb2_chrg_detect_set;
	u32 usb2_chrg_detect_clr;
	u32 usb2_chrg_detect_tog;
	u32 usb2_vbus_det_stat;
	u32 usb2_vbus_det_stat_set;
	u32 usb2_vbus_det_stat_clr;
	u32 usb2_vbus_det_stat_tog;
	u32 usb2_chrg_det_stat;
	u32 usb2_chrg_det_stat_set;
	u32 usb2_chrg_det_stat_clr;
	u32 usb2_chrg_det_stat_tog;
	u32 usb2_loopback;
	u32 usb2_loopback_set;
	u32 usb2_loopback_clr;
	u32 usb2_loopback_tog;
	u32 usb2_misc;
	u32 usb2_misc_set;
	u32 usb2_misc_clr;
	u32 usb2_misc_tog;
	u32 digprog;
	u32 reserved1[7];
	/* For i.MX 6SoloLite */
	u32 digprog_sololite;
};
#endif

/* Define the bits in register CCR */
#define MXC_CCM_CCR_RBC_EN				(1 << 27)
#define MXC_CCM_CCR_REG_BYPASS_CNT_MASK			(0x3F << 21)
#define MXC_CCM_CCR_REG_BYPASS_CNT_OFFSET		21
/* CCR_WB does not exist on i.MX6SX/UL */
#define MXC_CCM_CCR_WB_COUNT_MASK			0x7
#define MXC_CCM_CCR_WB_COUNT_OFFSET			(1 << 16)
#define MXC_CCM_CCR_COSC_EN				(1 << 12)
#ifdef CONFIG_MX6SX
#define MXC_CCM_CCR_OSCNT_MASK				0x7F
#else
#define MXC_CCM_CCR_OSCNT_MASK				0xFF
#endif
#define MXC_CCM_CCR_OSCNT_OFFSET			0

/* Define the bits in register CCDR */
#define MXC_CCM_CCDR_MMDC_CH1_HS_MASK			(1 << 16)
#define MXC_CCM_CCDR_MMDC_CH0_HS_MASK			(1 << 17)
/* Exists on i.MX6QP */
#define MXC_CCM_CCDR_MMDC_CH1_AXI_ROOT_CG		(1 << 18)

/* Define the bits in register CSR */
#define MXC_CCM_CSR_COSC_READY				(1 << 5)
#define MXC_CCM_CSR_REF_EN_B				(1 << 0)

/* Define the bits in register CCSR */
#define MXC_CCM_CCSR_PDF_540M_AUTO_DIS			(1 << 15)
#define MXC_CCM_CCSR_PDF_720M_AUTO_DIS			(1 << 14)
#define MXC_CCM_CCSR_PDF_454M_AUTO_DIS			(1 << 13)
#define MXC_CCM_CCSR_PDF_508M_AUTO_DIS			(1 << 12)
#define MXC_CCM_CCSR_PDF_594M_AUTO_DIS			(1 << 11)
#define MXC_CCM_CCSR_PDF_352M_AUTO_DIS			(1 << 10)
#define MXC_CCM_CCSR_PDF_400M_AUTO_DIS			(1 << 9)
#define MXC_CCM_CCSR_STEP_SEL				(1 << 8)
#define MXC_CCM_CCSR_PLL1_SW_CLK_SEL			(1 << 2)
#define MXC_CCM_CCSR_PLL2_SW_CLK_SEL			(1 << 1)
#define MXC_CCM_CCSR_PLL3_SW_CLK_SEL			(1 << 0)

/* Define the bits in register CACRR */
#define MXC_CCM_CACRR_ARM_PODF_OFFSET			0
#define MXC_CCM_CACRR_ARM_PODF_MASK			0x7

/* Define the bits in register CBCDR */
#define MXC_CCM_CBCDR_PERIPH_CLK2_PODF_MASK		(0x7 << 27)
#define MXC_CCM_CBCDR_PERIPH_CLK2_PODF_OFFSET		27
#define MXC_CCM_CBCDR_PERIPH2_CLK_SEL			(1 << 26)
#define MXC_CCM_CBCDR_PERIPH_CLK_SEL			(1 << 25)
/* MMDC_CH0 not exists on i.MX6SX */
#define MXC_CCM_CBCDR_MMDC_CH0_PODF_MASK		(0x7 << 19)
#define MXC_CCM_CBCDR_MMDC_CH0_PODF_OFFSET		19
#define MXC_CCM_CBCDR_AXI_PODF_MASK			(0x7 << 16)
#define MXC_CCM_CBCDR_AXI_PODF_OFFSET			16
#define MXC_CCM_CBCDR_AHB_PODF_MASK			(0x7 << 10)
#define MXC_CCM_CBCDR_AHB_PODF_OFFSET			10
#define MXC_CCM_CBCDR_IPG_PODF_MASK			(0x3 << 8)
#define MXC_CCM_CBCDR_IPG_PODF_OFFSET			8
#define MXC_CCM_CBCDR_AXI_ALT_SEL			(1 << 7)
#define MXC_CCM_CBCDR_AXI_SEL				(1 << 6)
#define MXC_CCM_CBCDR_MMDC_CH1_PODF_MASK		(0x7 << 3)
#define MXC_CCM_CBCDR_MMDC_CH1_PODF_OFFSET		3
#define MXC_CCM_CBCDR_PERIPH2_CLK2_PODF_MASK		(0x7 << 0)
#define MXC_CCM_CBCDR_PERIPH2_CLK2_PODF_OFFSET		0

/* Define the bits in register CBCMR */
#define MXC_CCM_CBCMR_GPU3D_SHADER_PODF_MASK		(0x7 << 29)
#define MXC_CCM_CBCMR_GPU3D_SHADER_PODF_OFFSET		29
#define MXC_CCM_CBCMR_GPU3D_CORE_PODF_MASK		(0x7 << 26)
#define MXC_CCM_CBCMR_GPU3D_CORE_PODF_OFFSET		26
/* LCDIF on i.MX6SX/UL */
#define MXC_CCM_CBCMR_LCDIF1_PODF_MASK                  (0x7 << 23)
#define MXC_CCM_CBCMR_LCDIF1_PODF_OFFSET                23
#define MXC_CCM_CBCMR_GPU2D_CORE_PODF_MASK		(0x7 << 23)
#define MXC_CCM_CBCMR_GPU2D_CORE_PODF_OFFSET		23
#define MXC_CCM_CBCMR_PRE_PERIPH2_CLK_SEL_MASK		(0x3 << 21)
#define MXC_CCM_CBCMR_PRE_PERIPH2_CLK_SEL_OFFSET	21
#define MXC_CCM_CBCMR_PERIPH2_CLK2_SEL			(1 << 20)
#define MXC_CCM_CBCMR_PRE_PERIPH_CLK_SEL_MASK		(0x3 << 18)
#define MXC_CCM_CBCMR_PRE_PERIPH_CLK_SEL_OFFSET		18
#ifndef CONFIG_MX6SX
#define MXC_CCM_CBCMR_GPU2D_CLK_SEL_MASK		(0x3 << 16)
#define MXC_CCM_CBCMR_GPU2D_CLK_SEL_OFFSET		16
#define MXC_CCM_CBCMR_VPU_AXI_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CBCMR_VPU_AXI_CLK_SEL_OFFSET		14
#endif
#define MXC_CCM_CBCMR_PERIPH_CLK2_SEL_MASK		(0x3 << 12)
#define MXC_CCM_CBCMR_PERIPH_CLK2_SEL_OFFSET		12
#ifndef CONFIG_MX6SX
#define MXC_CCM_CBCMR_VDOAXI_CLK_SEL			(1 << 11)
#endif
#define MXC_CCM_CBCMR_PCIE_AXI_CLK_SEL			(1 << 10)
#define MXC_CCM_CBCMR_GPU3D_SHADER_CLK_SEL_MASK		(0x3 << 8)
#define MXC_CCM_CBCMR_GPU3D_SHADER_CLK_SEL_OFFSET	8
#define MXC_CCM_CBCMR_GPU3D_CORE_CLK_SEL_MASK		(0x3 << 4)
#define MXC_CCM_CBCMR_GPU3D_CORE_CLK_SEL_OFFSET		4
/* Exists on i.MX6QP */
#define MXC_CCM_CBCMR_PRE_CLK_SEL			(1 << 1)

/* Define the bits in register CSCMR1 */
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_MASK		(0x3 << 29)
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_OFFSET		29
/* QSPI1 exist on i.MX6SX/UL */
#define MXC_CCM_CSCMR1_QSPI1_PODF_MASK			(0x7 << 26)
#define MXC_CCM_CSCMR1_QSPI1_PODF_OFFSET		26
#define MXC_CCM_CSCMR1_ACLK_EMI_MASK			(0x3 << 27)
#define MXC_CCM_CSCMR1_ACLK_EMI_OFFSET			27
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_PODF_MASK		(0x7 << 23)
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_PODF_OFFSET	23
/* LCFIF2_PODF on i.MX6SX */
#define MXC_CCM_CSCMR1_LCDIF2_PODF_MASK			(0x7 << 20)
#define MXC_CCM_CSCMR1_LCDIF2_PODF_OFFSET               20
/* LCDIF_PIX_PODF on i.MX6SL */
#define MXC_CCM_CSCMR1_LCDIF_PIX_PODF_MASK		(0x7 << 20)
#define MXC_CCM_CSCMR1_LCDIF_PIX_PODF_OFFSET		20
/* ACLK_EMI on i.MX6DQ/SDL/DQP */
#define MXC_CCM_CSCMR1_ACLK_EMI_PODF_MASK		(0x7 << 20)
#define MXC_CCM_CSCMR1_ACLK_EMI_PODF_OFFSET		20
/* CSCMR1_GPMI/BCH exist on i.MX6UL */
#define MXC_CCM_CSCMR1_GPMI_CLK_SEL			(1 << 19)
#define MXC_CCM_CSCMR1_BCH_CLK_SEL			(1 << 18)
#define MXC_CCM_CSCMR1_USDHC4_CLK_SEL			(1 << 19)
#define MXC_CCM_CSCMR1_USDHC3_CLK_SEL			(1 << 18)
#define MXC_CCM_CSCMR1_USDHC2_CLK_SEL			(1 << 17)
#define MXC_CCM_CSCMR1_USDHC1_CLK_SEL			(1 << 16)
#define MXC_CCM_CSCMR1_SSI3_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CSCMR1_SSI3_CLK_SEL_OFFSET		14
#define MXC_CCM_CSCMR1_SSI2_CLK_SEL_MASK		(0x3 << 12)
#define MXC_CCM_CSCMR1_SSI2_CLK_SEL_OFFSET		12
#define MXC_CCM_CSCMR1_SSI1_CLK_SEL_MASK		(0x3 << 10)
#define MXC_CCM_CSCMR1_SSI1_CLK_SEL_OFFSET		10
/* QSPI1 exist on i.MX6SX/UL */
#define MXC_CCM_CSCMR1_QSPI1_CLK_SEL_MASK		(0x7 << 7)
#define MXC_CCM_CSCMR1_QSPI1_CLK_SEL_OFFSET		7
/* CSCMR1_PER_CLK exists on i.MX6SX/SL/QP */
#define MXC_CCM_CSCMR1_PER_CLK_SEL_MASK (1 << 6)
#define MXC_CCM_CSCMR1_PER_CLK_SEL_OFFSET		6

#define MXC_CCM_CSCMR1_PERCLK_PODF_MASK			0x3F

/* Define the bits in register CSCMR2 */
#ifdef CONFIG_MX6SX
#define MXC_CCM_CSCMR2_VID_CLK_SEL_MASK			(0x7 << 21)
#define MXC_CCM_CSCMR2_VID_CLK_SEL_OFFSET		21
#endif
#define MXC_CCM_CSCMR2_ESAI_PRE_SEL_MASK		(0x3 << 19)
#define MXC_CCM_CSCMR2_ESAI_PRE_SEL_OFFSET		19
#define MXC_CCM_CSCMR2_LDB_DI1_IPU_DIV			(1 << 11)
#define MXC_CCM_CSCMR2_LDB_DI0_IPU_DIV			(1 << 10)
/* CSCMR1_CAN_CLK exists on i.MX6SX/QP */
#define MXC_CCM_CSCMR2_CAN_CLK_SEL_MASK			(0x3 << 8)
#define MXC_CCM_CSCMR2_CAN_CLK_SEL_OFFSET		8

#define MXC_CCM_CSCMR2_CAN_CLK_PODF_MASK		(0x3F << 2)
#define MXC_CCM_CSCMR2_CAN_CLK_PODF_OFFSET		2

/* Define the bits in register CSCDR1 */
#ifndef CONFIG_MX6SX
#define MXC_CCM_CSCDR1_VPU_AXI_PODF_MASK		(0x7 << 25)
#define MXC_CCM_CSCDR1_VPU_AXI_PODF_OFFSET		25
#endif
/* CSCDR1_GPMI/BCH exist on i.MX6UL */
#define MXC_CCM_CSCDR1_GPMI_PODF_MASK			(0x7 << 22)
#define MXC_CCM_CSCDR1_GPMI_PODF_OFFSET			22
#define MXC_CCM_CSCDR1_BCH_PODF_MASK			(0x7 << 19)
#define MXC_CCM_CSCDR1_BCH_PODF_OFFSET			19

#define MXC_CCM_CSCDR1_USDHC4_PODF_MASK			(0x7 << 22)
#define MXC_CCM_CSCDR1_USDHC4_PODF_OFFSET		22
#define MXC_CCM_CSCDR1_USDHC3_PODF_MASK			(0x7 << 19)
#define MXC_CCM_CSCDR1_USDHC3_PODF_OFFSET		19
#define MXC_CCM_CSCDR1_USDHC2_PODF_MASK			(0x7 << 16)
#define MXC_CCM_CSCDR1_USDHC2_PODF_OFFSET		16
#define MXC_CCM_CSCDR1_USDHC1_PODF_MASK			(0x7 << 11)
#define MXC_CCM_CSCDR1_USDHC1_PODF_OFFSET		11
#ifndef CONFIG_MX6SX
#define MXC_CCM_CSCDR1_USBOH3_CLK_PRED_OFFSET		8
#define MXC_CCM_CSCDR1_USBOH3_CLK_PRED_MASK		(0x7 << 8)
#define MXC_CCM_CSCDR1_USBOH3_CLK_PODF_OFFSET		6
#define MXC_CCM_CSCDR1_USBOH3_CLK_PODF_MASK		(0x3 << 6)
#endif
#define MXC_CCM_CSCDR1_UART_CLK_PODF_MASK		0x3F
#define MXC_CCM_CSCDR1_UART_CLK_PODF_OFFSET		0
/* UART_CLK_SEL exists on i.MX6SL/SX/QP */
#define MXC_CCM_CSCDR1_UART_CLK_SEL			(1 << 6)

/* Define the bits in register CS1CDR */
/* MX6UL, !MX6ULL */
#define MXC_CCM_CS1CDR_SAI3_CLK_PRED_MASK		(0x7 << 22)
#define MXC_CCM_CS1CDR_SAI3_CLK_PRED_OFFSET		22
#define MXC_CCM_CS1CDR_SAI3_CLK_PODF_MASK		(0x3F << 16)
#define MXC_CCM_CS1CDR_SAI3_CLK_PODF_OFFSET		16
#define MXC_CCM_CS1CDR_SAI1_CLK_PRED_MASK		(0x7 << 6)
#define MXC_CCM_CS1CDR_SAI1_CLK_PRED_OFFSET		6
#define MXC_CCM_CS1CDR_SAI1_CLK_PODF_MASK		0x3F
#define MXC_CCM_CS1CDR_SAI1_CLK_PODF_OFFSET		0

#define MXC_CCM_CS1CDR_ESAI_CLK_PODF_MASK		(0x3F << 25)
#define MXC_CCM_CS1CDR_ESAI_CLK_PODF_OFFSET		25
#define MXC_CCM_CS1CDR_SSI3_CLK_PRED_MASK		(0x7 << 22)
#define MXC_CCM_CS1CDR_SSI3_CLK_PRED_OFFSET		22
#define MXC_CCM_CS1CDR_SSI3_CLK_PODF_MASK		(0x3F << 16)
#define MXC_CCM_CS1CDR_SSI3_CLK_PODF_OFFSET		16
#define MXC_CCM_CS1CDR_ESAI_CLK_PRED_MASK		(0x3 << 9)
#define MXC_CCM_CS1CDR_ESAI_CLK_PRED_OFFSET		9
#define MXC_CCM_CS1CDR_SSI1_CLK_PRED_MASK		(0x7 << 6)
#define MXC_CCM_CS1CDR_SSI1_CLK_PRED_OFFSET		6
#define MXC_CCM_CS1CDR_SSI1_CLK_PODF_MASK		0x3F
#define MXC_CCM_CS1CDR_SSI1_CLK_PODF_OFFSET		0

/* Define the bits in register CS2CDR */
/* QSPI2 on i.MX6SX */
#define MXC_CCM_CS2CDR_QSPI2_CLK_PODF_MASK             (0x3F << 21)
#define MXC_CCM_CS2CDR_QSPI2_CLK_PODF_OFFSET           21
#define MXC_CCM_CS2CDR_QSPI2_CLK_PODF(v)                       (((v) & 0x3f) << 21)
#define MXC_CCM_CS2CDR_QSPI2_CLK_PRED_MASK             (0x7 << 18)
#define MXC_CCM_CS2CDR_QSPI2_CLK_PRED_OFFSET           18
#define MXC_CCM_CS2CDR_QSPI2_CLK_PRED(v)                       (((v) & 0x7) << 18)
#define MXC_CCM_CS2CDR_QSPI2_CLK_SEL_MASK              (0x7 << 15)
#define MXC_CCM_CS2CDR_QSPI2_CLK_SEL_OFFSET            15
#define MXC_CCM_CS2CDR_QSPI2_CLK_SEL(v)                        (((v) & 0x7) << 15)

#define MXC_CCM_CS2CDR_ENFC_CLK_PODF_MASK		(0x3F << 21)
#define MXC_CCM_CS2CDR_ENFC_CLK_PODF_OFFSET		21
#define MXC_CCM_CS2CDR_ENFC_CLK_PODF(v)			(((v) & 0x3f) << 21)
#define MXC_CCM_CS2CDR_ENFC_CLK_PRED_MASK		(0x7 << 18)
#define MXC_CCM_CS2CDR_ENFC_CLK_PRED_OFFSET		18
#define MXC_CCM_CS2CDR_ENFC_CLK_PRED(v)			(((v) & 0x7) << 18)

#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_MASK_DQP		(0x7 << 15)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_OFFSET_DQP		15
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_DQP(v)		(((v) & 0x7) << 15)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_MASK_DQ		(0x3 << 16)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_OFFSET_DQ		16
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_DQ(v)		(((v) & 0x3) << 16)

#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_MASK		\
	((is_mx6dqp() || is_cpu_type(MXC_CPU_MX6UL)) ?	\
	 MXC_CCM_CS2CDR_ENFC_CLK_SEL_MASK_DQP :		\
	 MXC_CCM_CS2CDR_ENFC_CLK_SEL_MASK_DQ)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_OFFSET		\
	((is_mx6dqp() || is_cpu_type(MXC_CPU_MX6UL)) ?	\
	 MXC_CCM_CS2CDR_ENFC_CLK_SEL_OFFSET_DQP :	\
	 MXC_CCM_CS2CDR_ENFC_CLK_SEL_OFFSET_DQ)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL(v)			\
	((is_mx6dqp() || is_cpu_type(MXC_CPU_MX6UL)) ?	\
	 MXC_CCM_CS2CDR_ENFC_CLK_SEL_DQP(v) :		\
	 MXC_CCM_CS2CDR_ENFC_CLK_SEL_DQ(v))

#define MXC_CCM_CS2CDR_LDB_DI1_CLK_SEL_MASK		(0x7 << 12)
#define MXC_CCM_CS2CDR_LDB_DI1_CLK_SEL_OFFSET		12
#define MXC_CCM_CS2CDR_LDB_DI0_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CS2CDR_LDB_DI0_CLK_SEL_OFFSET		9
#define MXC_CCM_CS2CDR_SSI2_CLK_PRED_MASK		(0x7 << 6)
#define MXC_CCM_CS2CDR_SSI2_CLK_PRED_OFFSET		6
#define MXC_CCM_CS2CDR_SSI2_CLK_PODF_MASK		0x3F
#define MXC_CCM_CS2CDR_SSI2_CLK_PODF_OFFSET		0

/* Define the bits in register CDCDR */
#ifndef CONFIG_MX6SX
#define MXC_CCM_CDCDR_HSI_TX_PODF_MASK			(0x7 << 29)
#define MXC_CCM_CDCDR_HSI_TX_PODF_OFFSET		29
#define MXC_CCM_CDCDR_HSI_TX_CLK_SEL			(1 << 28)
#endif
#define MXC_CCM_CDCDR_SPDIF0_CLK_PRED_MASK		(0x7 << 25)
#define MXC_CCM_CDCDR_SPDIF0_CLK_PRED_OFFSET		25
#define MXC_CCM_CDCDR_SPDIF0_CLK_PODF_MASK		(0x7 << 22)
#define MXC_CCM_CDCDR_SPDIF0_CLK_PODF_OFFSET		22
#define MXC_CCM_CDCDR_SPDIF0_CLK_SEL_MASK		(0x3 << 20)
#define MXC_CCM_CDCDR_SPDIF0_CLK_SEL_OFFSET		20
#define MXC_CCM_CDCDR_SPDIF1_CLK_PRED_MASK		(0x7 << 12)
#define MXC_CCM_CDCDR_SPDIF1_CLK_PRED_OFFSET		12
#define MXC_CCM_CDCDR_SPDIF1_CLK_PODF_MASK		(0x7 << 9)
#define MXC_CCM_CDCDR_SPDIF1_CLK_PODF_OFFSET		9
#define MXC_CCM_CDCDR_SPDIF1_CLK_SEL_MASK		(0x3 << 7)
#define MXC_CCM_CDCDR_SPDIF1_CLK_SEL_OFFSET		7

/* Define the bits in register CHSCCDR */
/* i.MX6SX */
#define MXC_CCM_CHSCCDR_ENET_PRE_CLK_SEL_MASK		(0x7 << 15)
#define MXC_CCM_CHSCCDR_ENET_PRE_CLK_SEL_OFFSET		15
#define MXC_CCM_CHSCCDR_ENET_PODF_MASK			(0x7 << 12)
#define MXC_CCM_CHSCCDR_ENET_PODF_OFFSET		12
#define MXC_CCM_CHSCCDR_ENET_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CHSCCDR_ENET_CLK_SEL_OFFSET		9
#define MXC_CCM_CHSCCDR_M4_PRE_CLK_SEL_MASK		(0x7 << 6)
#define MXC_CCM_CHSCCDR_M4_PRE_CLK_SEL_OFFSET		6
#define MXC_CCM_CHSCCDR_M4_PODF_MASK			(0x7 << 3)
#define MXC_CCM_CHSCCDR_M4_PODF_OFFSET			3
#define MXC_CCM_CHSCCDR_M4_CLK_SEL_MASK			(0x7)
#define MXC_CCM_CHSCCDR_M4_CLK_SEL_OFFSET		0

#define MXC_CCM_CHSCCDR_IPU1_DI1_PRE_CLK_SEL_MASK	(0x7 << 15)
#define MXC_CCM_CHSCCDR_IPU1_DI1_PRE_CLK_SEL_OFFSET	15
#define MXC_CCM_CHSCCDR_IPU1_DI1_PODF_MASK		(0x7 << 12)
#define MXC_CCM_CHSCCDR_IPU1_DI1_PODF_OFFSET		12
#define MXC_CCM_CHSCCDR_IPU1_DI1_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CHSCCDR_IPU1_DI1_CLK_SEL_OFFSET		9
#define MXC_CCM_CHSCCDR_IPU1_DI0_PRE_CLK_SEL_MASK	(0x7 << 6)
#define MXC_CCM_CHSCCDR_IPU1_DI0_PRE_CLK_SEL_OFFSET	6
#define MXC_CCM_CHSCCDR_IPU1_DI0_PODF_MASK		(0x7 << 3)
#define MXC_CCM_CHSCCDR_IPU1_DI0_PODF_OFFSET		3
#define MXC_CCM_CHSCCDR_IPU1_DI0_CLK_SEL_MASK		(0x7)
#define MXC_CCM_CHSCCDR_IPU1_DI0_CLK_SEL_OFFSET		0

/* i.MX6ULL */
#define MXC_CCM_CHSCCDR_EPDC_PRE_CLK_SEL_MASK		(0x7 << 15)
#define MXC_CCM_CHSCCDR_EPDC_PRE_CLK_SEL_OFFSET		15
#define MXC_CCM_CHSCCDR_EPDC_PODF_MASK			(0x7 << 12)
#define MXC_CCM_CHSCCDR_EPDC_PODF_OFFSET		12
#define MXC_CCM_CHSCCDR_EPDC_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CHSCCDR_EPDC_CLK_SEL_OFFSET		9

#define CHSCCDR_CLK_SEL_LDB_DI0				3
#define CHSCCDR_PODF_DIVIDE_BY_3			2
#define CHSCCDR_IPU_PRE_CLK_540M_PFD			5

/* Define the bits in register CSCDR2 */
#define MXC_CCM_CSCDR2_ECSPI_CLK_PODF_MASK		(0x3F << 19)
#define MXC_CCM_CSCDR2_ECSPI_CLK_PODF_OFFSET		19
/* ECSPI_CLK_SEL exists on i.MX6SX/SL/QP */
#define MXC_CCM_CSCDR2_ECSPI_CLK_SEL_MASK		(0x1 << 18)
/* LCDIF1 on i.MX6SX/UL */
#define MXC_CCM_CSCDR2_LCDIF1_PRED_SEL_MASK             (0x7 << 15)
#define MXC_CCM_CSCDR2_LCDIF1_PRED_SEL_OFFSET           15
#define MXC_CCM_CSCDR2_LCDIF1_PRE_DIV_MASK              (0x7 << 12)
#define MXC_CCM_CSCDR2_LCDIF1_PRE_DIV_OFFSET            12
#define MXC_CCM_CSCDR2_LCDIF1_CLK_SEL_MASK              (0x7 << 9)
#define MXC_CCM_CSCDR2_LCDIF1_CLK_SEL_OFFSET            9
/* LCDIF2 on i.MX6SX */
#define MXC_CCM_CSCDR2_LCDIF2_PRED_SEL_MASK             (0x7 << 6)
#define MXC_CCM_CSCDR2_LCDIF2_PRED_SEL_OFFSET           6
#define MXC_CCM_CSCDR2_LCDIF2_PRE_DIV_MASK              (0x7 << 3)
#define MXC_CCM_CSCDR2_LCDIF2_PRE_DIV_OFFSET            3
#define MXC_CCM_CSCDR2_LCDIF2_CLK_SEL_MASK              (0x7 << 0)
#define MXC_CCM_CSCDR2_LCDIF2_CLK_SEL_OFFSET             0

/*LCD on i.MX6SL */
#define MXC_CCM_CSCDR2_LCDIF_PIX_CLK_SEL_MASK		(0x7 << 6)
#define MXC_CCM_CSCDR2_LCDIF_PIX_CLK_SEL_OFFSET		6
#define MXC_CCM_CSCDR2_LCDIF_PIX_PRE_DIV_MASK		(0x7 << 3)
#define MXC_CCM_CSCDR2_LCDIF_PIX_PRE_DIV_OFFSET		3

/* All IPU2_DI1 are LCDIF1 on MX6SX */
#define MXC_CCM_CHSCCDR_IPU2_DI1_PRE_CLK_SEL_MASK	(0x7 << 15)
#define MXC_CCM_CHSCCDR_IPU2_DI1_PRE_CLK_SEL_OFFSET	15
#define MXC_CCM_CHSCCDR_IPU2_DI1_PODF_MASK		(0x7 << 12)
#define MXC_CCM_CHSCCDR_IPU2_DI1_PODF_OFFSET		12
#define MXC_CCM_CHSCCDR_IPU2_DI1_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CHSCCDR_IPU2_DI1_CLK_SEL_OFFSET		9
/* All IPU2_DI0 are LCDIF2 on MX6SX */
#define MXC_CCM_CHSCCDR_IPU2_DI0_PRE_CLK_SEL_MASK	(0x7 << 6)
#define MXC_CCM_CHSCCDR_IPU2_DI0_PRE_CLK_SEL_OFFSET	6
#define MXC_CCM_CHSCCDR_IPU2_DI0_PODF_MASK		(0x7 << 3)
#define MXC_CCM_CHSCCDR_IPU2_DI0_PODF_OFFSET		3
#define MXC_CCM_CHSCCDR_IPU2_DI0_CLK_SEL_MASK		0x7
#define MXC_CCM_CHSCCDR_IPU2_DI0_CLK_SEL_OFFSET		0

/* Define the bits in register CSCDR3 */
#define MXC_CCM_CSCDR3_IPU2_HSP_PODF_MASK		(0x7 << 16)
#define MXC_CCM_CSCDR3_IPU2_HSP_PODF_OFFSET		16
#define MXC_CCM_CSCDR3_IPU2_HSP_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CSCDR3_IPU2_HSP_CLK_SEL_OFFSET		14
#define MXC_CCM_CSCDR3_IPU1_HSP_PODF_MASK		(0x7 << 11)
#define MXC_CCM_CSCDR3_IPU1_HSP_PODF_OFFSET		11
#define MXC_CCM_CSCDR3_IPU1_HSP_CLK_SEL_MASK		(0x3 << 9)
#define MXC_CCM_CSCDR3_IPU1_HSP_CLK_SEL_OFFSET		9

/* For i.MX6SL */
#define MXC_CCM_CSCDR3_LCDIF_AXI_PODF_MASK		(0x7 << 16)
#define MXC_CCM_CSCDR3_LCDIF_AXI_PODF_OFFSET		16
#define MXC_CCM_CSCDR3_LCDIF_AXI_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CSCDR3_LCDIF_AXI_CLK_SEL_OFFSET		14

/* Define the bits in register CDHIPR */
#define MXC_CCM_CDHIPR_ARM_PODF_BUSY			(1 << 16)
#define MXC_CCM_CDHIPR_PERIPH_CLK_SEL_BUSY		(1 << 5)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CDHIPR_MMDC_CH0_PODF_BUSY		(1 << 4)
#endif
#define MXC_CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY		(1 << 3)
#define MXC_CCM_CDHIPR_MMDC_CH1_PODF_BUSY		(1 << 2)
#define MXC_CCM_CDHIPR_AHB_PODF_BUSY			(1 << 1)
#define MXC_CCM_CDHIPR_AXI_PODF_BUSY			1

/* Define the bits in register CLPCR */
#define MXC_CCM_CLPCR_MASK_L2CC_IDLE			(1 << 27)
#define MXC_CCM_CLPCR_MASK_SCU_IDLE			(1 << 26)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CLPCR_MASK_CORE3_WFI			(1 << 25)
#define MXC_CCM_CLPCR_MASK_CORE2_WFI			(1 << 24)
#define MXC_CCM_CLPCR_MASK_CORE1_WFI			(1 << 23)
#endif
#define MXC_CCM_CLPCR_MASK_CORE0_WFI			(1 << 22)
#define MXC_CCM_CLPCR_BYP_MMDC_CH1_LPM_HS		(1 << 21)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CLPCR_BYP_MMDC_CH0_LPM_HS		(1 << 19)
#define MXC_CCM_CLPCR_WB_CORE_AT_LPM			(1 << 17)
#endif
#define MXC_CCM_CLPCR_WB_PER_AT_LPM			(1 << 16)
#define MXC_CCM_CLPCR_COSC_PWRDOWN			(1 << 11)
#define MXC_CCM_CLPCR_STBY_COUNT_MASK			(0x3 << 9)
#define MXC_CCM_CLPCR_STBY_COUNT_OFFSET			9
#define MXC_CCM_CLPCR_VSTBY				(1 << 8)
#define MXC_CCM_CLPCR_DIS_REF_OSC			(1 << 7)
#define MXC_CCM_CLPCR_SBYOS				(1 << 6)
#define MXC_CCM_CLPCR_ARM_CLK_DIS_ON_LPM		(1 << 5)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CLPCR_LPSR_CLK_SEL_MASK			(0x3 << 3)
#define MXC_CCM_CLPCR_LPSR_CLK_SEL_OFFSET		3
#define MXC_CCM_CLPCR_BYPASS_PMIC_VFUNC_READY		(1 << 2)
#endif
#define MXC_CCM_CLPCR_LPM_MASK				0x3
#define MXC_CCM_CLPCR_LPM_OFFSET			0

/* Define the bits in register CISR */
#define MXC_CCM_CISR_ARM_PODF_LOADED			(1 << 26)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CISR_MMDC_CH0_PODF_LOADED		(1 << 23)
#endif
#define MXC_CCM_CISR_PERIPH_CLK_SEL_LOADED		(1 << 22)
#define MXC_CCM_CISR_MMDC_CH1_PODF_LOADED		(1 << 21)
#define MXC_CCM_CISR_AHB_PODF_LOADED			(1 << 20)
#define MXC_CCM_CISR_PERIPH2_CLK_SEL_LOADED		(1 << 19)
#define MXC_CCM_CISR_AXI_PODF_LOADED			(1 << 17)
#define MXC_CCM_CISR_COSC_READY				(1 << 6)
#define MXC_CCM_CISR_LRF_PLL				1

/* Define the bits in register CIMR */
#define MXC_CCM_CIMR_MASK_ARM_PODF_LOADED		(1 << 26)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CIMR_MASK_MMDC_CH0_PODF_LOADED		(1 << 23)
#endif
#define MXC_CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED		(1 << 22)
#define MXC_CCM_CIMR_MASK_MMDC_CH1_PODF_LOADED		(1 << 21)
#define MXC_CCM_CIMR_MASK_AHB_PODF_LOADED		(1 << 20)
#define MXC_CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED	(1 << 19)
#define MXC_CCM_CIMR_MASK_AXI_PODF_LOADED		(1 << 17)
#define MXC_CCM_CIMR_MASK_COSC_READY			(1 << 6)
#define MXC_CCM_CIMR_MASK_LRF_PLL			1

/* Define the bits in register CCOSR */
#define MXC_CCM_CCOSR_CKO2_EN_OFFSET			(1 << 24)
#define MXC_CCM_CCOSR_CKO2_DIV_MASK			(0x7 << 21)
#define MXC_CCM_CCOSR_CKO2_DIV_OFFSET			21
#define MXC_CCM_CCOSR_CKO2_SEL_OFFSET			16
#define MXC_CCM_CCOSR_CKO2_SEL_MASK			(0x1F << 16)
#define MXC_CCM_CCOSR_CLK_OUT_SEL			(0x1 << 8)
#define MXC_CCM_CCOSR_CKOL_EN				(0x1 << 7)
#define MXC_CCM_CCOSR_CKOL_DIV_MASK			(0x7 << 4)
#define MXC_CCM_CCOSR_CKOL_DIV_OFFSET			4
#define MXC_CCM_CCOSR_CKOL_SEL_MASK			0xF
#define MXC_CCM_CCOSR_CKOL_SEL_OFFSET			0

/* Define the bits in registers CGPR */
#define MXC_CCM_CGPR_FAST_PLL_EN			(1 << 16)
#define MXC_CCM_CGPR_EFUSE_PROG_SUPPLY_GATE		(1 << 4)
#define MXC_CCM_CGPR_MMDC_EXT_CLK_DIS			(1 << 2)
#define MXC_CCM_CGPR_PMIC_DELAY_SCALER			1

/* Define the bits in registers CCGRx */
#define MXC_CCM_CCGR_CG_MASK				3

/* i.MX 6ULL */
#define MXC_CCM_CCGR0_DCP_CLK_OFFSET		10
#define MXC_CCM_CCGR0_DCP_CLK_MASK		(3 << MXC_CCM_CCGR0_DCP_CLK_OFFSET)
#define MXC_CCM_CCGR0_ENET_CLK_ENABLE_OFFSET	12
#define MXC_CCM_CCGR0_ENET_CLK_ENABLE_MASK	(3 << MXC_CCM_CCGR0_ENET_CLK_ENABLE_OFFSET)

#define MXC_CCM_CCGR0_AIPS_TZ1_OFFSET			0
#define MXC_CCM_CCGR0_AIPS_TZ1_MASK			(3 << MXC_CCM_CCGR0_AIPS_TZ1_OFFSET)
#define MXC_CCM_CCGR0_AIPS_TZ2_OFFSET			2
#define MXC_CCM_CCGR0_AIPS_TZ2_MASK			(3 << MXC_CCM_CCGR0_AIPS_TZ2_OFFSET)
#define MXC_CCM_CCGR0_APBHDMA_OFFSET			4
#define MXC_CCM_CCGR0_APBHDMA_MASK			(3 << MXC_CCM_CCGR0_APBHDMA_OFFSET)
#define MXC_CCM_CCGR0_ASRC_OFFSET			6
#define MXC_CCM_CCGR0_ASRC_MASK				(3 << MXC_CCM_CCGR0_ASRC_OFFSET)
#define MXC_CCM_CCGR0_CAAM_SECURE_MEM_OFFSET		8
#define MXC_CCM_CCGR0_CAAM_SECURE_MEM_MASK		(3 << MXC_CCM_CCGR0_CAAM_SECURE_MEM_OFFSET)
#define MXC_CCM_CCGR0_CAAM_WRAPPER_ACLK_OFFSET		10
#define MXC_CCM_CCGR0_CAAM_WRAPPER_ACLK_MASK		(3 << MXC_CCM_CCGR0_CAAM_WRAPPER_ACLK_OFFSET)
#define MXC_CCM_CCGR0_CAAM_WRAPPER_IPG_OFFSET		12
#define MXC_CCM_CCGR0_CAAM_WRAPPER_IPG_MASK		(3 << MXC_CCM_CCGR0_CAAM_WRAPPER_IPG_OFFSET)
#define MXC_CCM_CCGR0_CAN1_OFFSET			14
#define MXC_CCM_CCGR0_CAN1_MASK				(3 << MXC_CCM_CCGR0_CAN1_OFFSET)
#define MXC_CCM_CCGR0_CAN1_SERIAL_OFFSET		16
#define MXC_CCM_CCGR0_CAN1_SERIAL_MASK			(3 << MXC_CCM_CCGR0_CAN1_SERIAL_OFFSET)
#define MXC_CCM_CCGR0_CAN2_OFFSET			18
#define MXC_CCM_CCGR0_CAN2_MASK				(3 << MXC_CCM_CCGR0_CAN2_OFFSET)
#define MXC_CCM_CCGR0_CAN2_SERIAL_OFFSET		20
#define MXC_CCM_CCGR0_CAN2_SERIAL_MASK			(3 << MXC_CCM_CCGR0_CAN2_SERIAL_OFFSET)
#define MXC_CCM_CCGR0_CHEETAH_DBG_CLK_OFFSET		22
#define MXC_CCM_CCGR0_CHEETAH_DBG_CLK_MASK		(3 << MXC_CCM_CCGR0_CHEETAH_DBG_CLK_OFFSET)
#define MXC_CCM_CCGR0_DCIC1_OFFSET			24
#define MXC_CCM_CCGR0_DCIC1_MASK			(3 << MXC_CCM_CCGR0_DCIC1_OFFSET)
#define MXC_CCM_CCGR0_DCIC2_OFFSET			26
#define MXC_CCM_CCGR0_DCIC2_MASK			(3 << MXC_CCM_CCGR0_DCIC2_OFFSET)
#ifdef CONFIG_MX6SX
#define MXC_CCM_CCGR0_AIPS_TZ3_OFFSET			30
#define MXC_CCM_CCGR0_AIPS_TZ3_MASK			(3 << MXC_CCM_CCGR0_AIPS_TZ3_OFFSET)
#else
#define MXC_CCM_CCGR0_DTCP_OFFSET			28
#define MXC_CCM_CCGR0_DTCP_MASK				(3 << MXC_CCM_CCGR0_DTCP_OFFSET)
#endif

#define MXC_CCM_CCGR1_ECSPI1S_OFFSET			0
#define MXC_CCM_CCGR1_ECSPI1S_MASK			(3 << MXC_CCM_CCGR1_ECSPI1S_OFFSET)
#define MXC_CCM_CCGR1_ECSPI2S_OFFSET			2
#define MXC_CCM_CCGR1_ECSPI2S_MASK			(3 << MXC_CCM_CCGR1_ECSPI2S_OFFSET)
#define MXC_CCM_CCGR1_ECSPI3S_OFFSET			4
#define MXC_CCM_CCGR1_ECSPI3S_MASK			(3 << MXC_CCM_CCGR1_ECSPI3S_OFFSET)
#define MXC_CCM_CCGR1_ECSPI4S_OFFSET			6
#define MXC_CCM_CCGR1_ECSPI4S_MASK			(3 << MXC_CCM_CCGR1_ECSPI4S_OFFSET)
#define MXC_CCM_CCGR1_ECSPI5S_OFFSET			8
#define MXC_CCM_CCGR1_ECSPI5S_MASK			(3 << MXC_CCM_CCGR1_ECSPI5S_OFFSET)
/* CCGR1_ENET does not exist on i.MX6SX/UL */
#define MXC_CCM_CCGR1_ENET_OFFSET			10
#define MXC_CCM_CCGR1_ENET_MASK				(3 << MXC_CCM_CCGR1_ENET_OFFSET)
#define MXC_CCM_CCGR1_EPIT1S_OFFSET			12
#define MXC_CCM_CCGR1_EPIT1S_MASK			(3 << MXC_CCM_CCGR1_EPIT1S_OFFSET)
#define MXC_CCM_CCGR1_EPIT2S_OFFSET			14
#define MXC_CCM_CCGR1_EPIT2S_MASK			(3 << MXC_CCM_CCGR1_EPIT2S_OFFSET)
#define MXC_CCM_CCGR1_ESAIS_OFFSET			16
#define MXC_CCM_CCGR1_ESAIS_MASK			(3 << MXC_CCM_CCGR1_ESAIS_OFFSET)
#ifdef CONFIG_MX6SX
#define MXC_CCM_CCGR1_WAKEUP_OFFSET			18
#define MXC_CCM_CCGR1_WAKEUP_MASK			(3 << MXC_CCM_CCGR1_WAKEUP_OFFSET)
#endif
#define MXC_CCM_CCGR1_GPT_BUS_OFFSET			20
#define MXC_CCM_CCGR1_GPT_BUS_MASK			(3 << MXC_CCM_CCGR1_GPT_BUS_OFFSET)
#define MXC_CCM_CCGR1_GPT_SERIAL_OFFSET			22
#define MXC_CCM_CCGR1_GPT_SERIAL_MASK			(3 << MXC_CCM_CCGR1_GPT_SERIAL_OFFSET)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CCGR1_GPU2D_OFFSET			24
#define MXC_CCM_CCGR1_GPU2D_MASK			(3 << MXC_CCM_CCGR1_GPU2D_OFFSET)
#endif
#define MXC_CCM_CCGR1_GPU3D_OFFSET			26
#define MXC_CCM_CCGR1_GPU3D_MASK			(3 << MXC_CCM_CCGR1_GPU3D_OFFSET)
#ifdef CONFIG_MX6SX
#define MXC_CCM_CCGR1_OCRAM_S_OFFSET			28
#define MXC_CCM_CCGR1_OCRAM_S_MASK			(3 << MXC_CCM_CCGR1_OCRAM_S_OFFSET)
#define MXC_CCM_CCGR1_CANFD_OFFSET			30
#define MXC_CCM_CCGR1_CANFD_MASK			(3 << MXC_CCM_CCGR1_CANFD_OFFSET)
#endif

#define MXC_CCM_CCGR2_HDMI_TX_IAHBCLK_OFFSET		0
#define MXC_CCM_CCGR2_HDMI_TX_IAHBCLK_MASK		(3 << MXC_CCM_CCGR2_HDMI_TX_IAHBCLK_OFFSET)
/* i.MX6SX/UL */
#define MXC_CCM_CCGR2_CSI_OFFSET			2
#define MXC_CCM_CCGR2_CSI_MASK				(3 << MXC_CCM_CCGR2_CSI_OFFSET)

#ifndef CONFIG_MX6SX
#define MXC_CCM_CCGR2_HDMI_TX_ISFRCLK_OFFSET		4
#define MXC_CCM_CCGR2_HDMI_TX_ISFRCLK_MASK		(3 << MXC_CCM_CCGR2_HDMI_TX_ISFRCLK_OFFSET)
#endif
#define MXC_CCM_CCGR2_I2C1_SERIAL_OFFSET		6
#define MXC_CCM_CCGR2_I2C1_SERIAL_MASK			(3 << MXC_CCM_CCGR2_I2C1_SERIAL_OFFSET)
#define MXC_CCM_CCGR2_I2C2_SERIAL_OFFSET		8
#define MXC_CCM_CCGR2_I2C2_SERIAL_MASK			(3 << MXC_CCM_CCGR2_I2C2_SERIAL_OFFSET)
#define MXC_CCM_CCGR2_I2C3_SERIAL_OFFSET		10
#define MXC_CCM_CCGR2_I2C3_SERIAL_MASK			(3 << MXC_CCM_CCGR2_I2C3_SERIAL_OFFSET)
#define MXC_CCM_CCGR1_I2C4_SERIAL_OFFSET		8
#define MXC_CCM_CCGR1_I2C4_SERIAL_MASK			(3 << MXC_CCM_CCGR1_I2C4_SERIAL_OFFSET)
#define MXC_CCM_CCGR2_OCOTP_CTRL_OFFSET			12
#define MXC_CCM_CCGR2_OCOTP_CTRL_MASK			(3 << MXC_CCM_CCGR2_OCOTP_CTRL_OFFSET)
#define MXC_CCM_CCGR2_IOMUX_IPT_CLK_IO_OFFSET		14
#define MXC_CCM_CCGR2_IOMUX_IPT_CLK_IO_MASK		(3 << MXC_CCM_CCGR2_IOMUX_IPT_CLK_IO_OFFSET)
#define MXC_CCM_CCGR2_IPMUX1_OFFSET			16
#define MXC_CCM_CCGR2_IPMUX1_MASK			(3 << MXC_CCM_CCGR2_IPMUX1_OFFSET)
#define MXC_CCM_CCGR2_IPMUX2_OFFSET			18
#define MXC_CCM_CCGR2_IPMUX2_MASK			(3 << MXC_CCM_CCGR2_IPMUX2_OFFSET)
#define MXC_CCM_CCGR2_IPMUX3_OFFSET			20
#define MXC_CCM_CCGR2_IPMUX3_MASK			(3 << MXC_CCM_CCGR2_IPMUX3_OFFSET)
#define MXC_CCM_CCGR2_IPSYNC_IP2APB_TZASC1_IPGS_OFFSET	22
#define MXC_CCM_CCGR2_IPSYNC_IP2APB_TZASC1_IPGS_MASK	(3 << MXC_CCM_CCGR2_IPSYNC_IP2APB_TZASC1_IPGS_OFFSET)
/* i.MX6SX/UL LCD and PXP */
#define MXC_CCM_CCGR2_LCD_OFFSET			28
#define MXC_CCM_CCGR2_LCD_MASK				(3 << MXC_CCM_CCGR2_LCD_OFFSET)
#define MXC_CCM_CCGR2_PXP_OFFSET			30
#define MXC_CCM_CCGR2_PXP_MASK				(3 << MXC_CCM_CCGR2_PXP_OFFSET)

#define MXC_CCM_CCGR2_IPSYNC_IP2APB_TZASC2_IPG_OFFSET	24
#define MXC_CCM_CCGR2_IPSYNC_IP2APB_TZASC2_IPG_MASK	(3 << MXC_CCM_CCGR2_IPSYNC_IP2APB_TZASC2_IPG_OFFSET)
#define MXC_CCM_CCGR2_IPSYNC_VDOA_IPG_MASTER_CLK_OFFSET	26
#define MXC_CCM_CCGR2_IPSYNC_VDOA_IPG_MASTER_CLK_MASK	(3 << MXC_CCM_CCGR2_IPSYNC_VDOA_IPG_MASTER_CLK_OFFSET)

/* i.MX6ULL */
#define MXC_CCM_CCGR2_ESAI_CLK_OFFSET		0
#define MXC_CCM_CCGR2_ESAI_CLK_MASK		(3 << MXC_CCM_CCGR2_ESAI_CLK_OFFSET)
#define MXC_CCM_CCGR2_IOMUXC_SNVS_CLK_OFFSET	4
#define MXC_CCM_CCGR2_IOMUXC_SNVS_CLK_MASK	(3 << MXC_CCM_CCGR2_IOMUXC_SNVS_CLK_OFFSET)

/* Exist on i.MX6SX */
#define MXC_CCM_CCGR3_M4_OFFSET					2
#define MXC_CCM_CCGR3_M4_MASK					(3 << MXC_CCM_CCGR3_M4_OFFSET)
/* i.MX6ULL */
#define MXC_CCM_CCGR3_EPDC_CLK_ENABLE_OFFSET			4
#define MXC_CCM_CCGR3_EPDC_CLK_ENABLE_MASK			(3 << MXC_CCM_CCGR3_EPDC_CLK_ENABLE_OFFSET)
#define MXC_CCM_CCGR3_ENET_OFFSET				4
#define MXC_CCM_CCGR3_ENET_MASK					(3 << MXC_CCM_CCGR3_ENET_OFFSET)
#define MXC_CCM_CCGR3_QSPI_OFFSET				14
#define MXC_CCM_CCGR3_QSPI_MASK					(3 << MXC_CCM_CCGR3_QSPI_OFFSET)

/* i.MX6SL */
#define MXC_CCM_CCGR3_LCDIF_AXI_OFFSET				6
#define MXC_CCM_CCGR3_LCDIF_AXI_MASK				(3 << MXC_CCM_CCGR3_LCDIF_AXI_OFFSET)
#define MXC_CCM_CCGR3_LCDIF_PIX_OFFSET				8
#define MXC_CCM_CCGR3_LCDIF_PIX_MASK				(3 << MXC_CCM_CCGR3_LCDIF_PIX_OFFSET)

#define MXC_CCM_CCGR3_IPU1_IPU_OFFSET				0
#define MXC_CCM_CCGR3_IPU1_IPU_MASK				(3 << MXC_CCM_CCGR3_IPU1_IPU_OFFSET)
#define MXC_CCM_CCGR3_IPU1_IPU_DI0_OFFSET			2
#define MXC_CCM_CCGR3_IPU1_IPU_DI0_MASK				(3 << MXC_CCM_CCGR3_IPU1_IPU_DI0_OFFSET)
#define MXC_CCM_CCGR3_IPU1_IPU_DI1_OFFSET			4
#define MXC_CCM_CCGR3_IPU1_IPU_DI1_MASK				(3 << MXC_CCM_CCGR3_IPU1_IPU_DI1_OFFSET)

#define MXC_CCM_CCGR3_IPU2_IPU_OFFSET				6
#define MXC_CCM_CCGR3_IPU2_IPU_MASK				(3 << MXC_CCM_CCGR3_IPU2_IPU_OFFSET)
#define MXC_CCM_CCGR3_IPU2_IPU_DI0_OFFSET			8
#define MXC_CCM_CCGR3_IPU2_IPU_DI0_MASK				(3 << MXC_CCM_CCGR3_IPU2_IPU_DI0_OFFSET)
#define MXC_CCM_CCGR3_IPU2_IPU_DI1_OFFSET			10
#define MXC_CCM_CCGR3_IPU2_IPU_DI1_MASK				(3 << MXC_CCM_CCGR3_IPU2_IPU_DI1_OFFSET)
#define MXC_CCM_CCGR3_LDB_DI0_OFFSET				12
#define MXC_CCM_CCGR3_LDB_DI0_MASK				(3 << MXC_CCM_CCGR3_LDB_DI0_OFFSET)

/* QSPI1 exists on i.MX6SX/UL */
#define MXC_CCM_CCGR3_QSPI1_OFFSET				14
#define MXC_CCM_CCGR3_QSPI1_MASK				(3 << MXC_CCM_CCGR3_QSPI1_OFFSET)

#define MXC_CCM_CCGR3_LDB_DI1_OFFSET				14
#define MXC_CCM_CCGR3_LDB_DI1_MASK				(3 << MXC_CCM_CCGR3_LDB_DI1_OFFSET)
#define MXC_CCM_CCGR3_MIPI_CORE_CFG_OFFSET			16
#define MXC_CCM_CCGR3_MIPI_CORE_CFG_MASK			(3 << MXC_CCM_CCGR3_MIPI_CORE_CFG_OFFSET)

/* A7_CLKDIV/WDOG1 on i.MX6UL */
#define MXC_CCM_CCGR3_WDOG1_CLK_ENABLE_OFFSET			16
#define MXC_CCM_CCGR3_WDOG1_CLK_ENABLE_MASK			(3 << MXC_CCM_CCGR3_WDOG1_CLK_ENABLE_OFFSET)
#define MXC_CCM_CCGR3_A7_CLKDIV_PATCH_OFFSET			18
#define MXC_CCM_CCGR3_A7_CLKDIV_PATCH_MASK			(3 << MXC_CCM_CCGR3_A7_CLKDIV_PATCH_OFFSET)

#define MXC_CCM_CCGR3_MLB_OFFSET				18
#define MXC_CCM_CCGR3_MLB_MASK					(3 << MXC_CCM_CCGR3_MLB_OFFSET)
#define MXC_CCM_CCGR3_MMDC_CORE_ACLK_FAST_CORE_P0_OFFSET	20
#define MXC_CCM_CCGR3_MMDC_CORE_ACLK_FAST_CORE_P0_MASK		(3 << MXC_CCM_CCGR3_MMDC_CORE_ACLK_FAST_CORE_P0_OFFSET)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CCGR3_MMDC_CORE_ACLK_FAST_CORE_P1_OFFSET	22
#define MXC_CCM_CCGR3_MMDC_CORE_ACLK_FAST_CORE_P1_MASK		(3 << MXC_CCM_CCGR3_MMDC_CORE_ACLK_FAST_CORE_P1_OFFSET)
#endif
#define MXC_CCM_CCGR3_MMDC_CORE_IPG_CLK_P0_OFFSET		24
#define MXC_CCM_CCGR3_MMDC_CORE_IPG_CLK_P0_MASK			(3 << MXC_CCM_CCGR3_MMDC_CORE_IPG_CLK_P0_OFFSET)
#define MXC_CCM_CCGR3_MMDC_CORE_IPG_CLK_P1_OFFSET		26
#define MXC_CCM_CCGR3_MMDC_CORE_IPG_CLK_P1_MASK			(3 << MXC_CCM_CCGR3_MMDC_CORE_IPG_CLK_P1_OFFSET)

#define MXC_CCM_CCGR3_DISP_AXI_OFFSET                           6
#define MXC_CCM_CCGR3_DISP_AXI_MASK                             (3 << MXC_CCM_CCGR3_DISP_AXI_OFFSET)
#define MXC_CCM_CCGR3_LCDIF2_PIX_OFFSET                         8
#define MXC_CCM_CCGR3_LCDIF2_PIX_MASK                           (3 << MXC_CCM_CCGR3_LCDIF2_PIX_OFFSET)
#define MXC_CCM_CCGR3_LCDIF1_PIX_OFFSET                         10
#define MXC_CCM_CCGR3_LCDIF1_PIX_MASK                           (3 << MXC_CCM_CCGR3_LCDIF1_PIX_OFFSET)
/* AXI on i.MX6UL */
#define MXC_CCM_CCGR3_AXI_CLK_OFFSET				28
#define MXC_CCM_CCGR3_AXI_CLK_MASK				(3 << MXC_CCM_CCGR3_AXI_CLK_OFFSET)
#define MXC_CCM_CCGR3_OCRAM_OFFSET				28
#define MXC_CCM_CCGR3_OCRAM_MASK				(3 << MXC_CCM_CCGR3_OCRAM_OFFSET)

/* GPIO4 on i.MX6UL/ULL */
#define MXC_CCM_CCGR3_GPIO4_CLK_OFFSET				30
#define MXC_CCM_CCGR3_GPIO4_CLK_MASK				(3 << MXC_CCM_CCGR3_GPIO4_CLK_OFFSET)

#ifndef CONFIG_MX6SX
#define MXC_CCM_CCGR3_OPENVGAXICLK_OFFSET			30
#define MXC_CCM_CCGR3_OPENVGAXICLK_MASK				(3 << MXC_CCM_CCGR3_OPENVGAXICLK_OFFSET)
#endif

/* i.MX6ULL */
#define MXC_CCM_CCGR3_IOMUXC_SNVS_GPR_CLK_OFFSET		30
#define MXC_CCM_CCGR3_IOMUXC_SNVS_GPR_CLK_MASK			(3 << MXC_CCM_CCGR3_IOMUXC_SNVS_GPR_CLK_OFFSET)

#define MXC_CCM_CCGR4_PCIE_OFFSET				0
#define MXC_CCM_CCGR4_PCIE_MASK					(3 << MXC_CCM_CCGR4_PCIE_OFFSET)
/* QSPI2 on i.MX6SX */
#define MXC_CCM_CCGR4_QSPI2_ENFC_OFFSET				10
#define MXC_CCM_CCGR4_QSPI2_ENFC_MASK				(3 << MXC_CCM_CCGR4_QSPI2_ENFC_OFFSET)
#define MXC_CCM_CCGR4_PL301_MX6QFAST1_S133_OFFSET		8
#define MXC_CCM_CCGR4_PL301_MX6QFAST1_S133_MASK			(3 << MXC_CCM_CCGR4_PL301_MX6QFAST1_S133_OFFSET)
#define MXC_CCM_CCGR4_PL301_MX6QPER1_BCH_OFFSET			12
#define MXC_CCM_CCGR4_PL301_MX6QPER1_BCH_MASK			(3 << MXC_CCM_CCGR4_PL301_MX6QPER1_BCH_OFFSET)
#define MXC_CCM_CCGR4_PL301_MX6QPER2_MAINCLK_ENABLE_OFFSET	14
#define MXC_CCM_CCGR4_PL301_MX6QPER2_MAINCLK_ENABLE_MASK	(3 << MXC_CCM_CCGR4_PL301_MX6QPER2_MAINCLK_ENABLE_OFFSET)
#define MXC_CCM_CCGR4_PWM1_OFFSET				16
#define MXC_CCM_CCGR4_PWM1_MASK					(3 << MXC_CCM_CCGR4_PWM1_OFFSET)
#define MXC_CCM_CCGR4_PWM2_OFFSET				18
#define MXC_CCM_CCGR4_PWM2_MASK					(3 << MXC_CCM_CCGR4_PWM2_OFFSET)
#define MXC_CCM_CCGR4_PWM3_OFFSET				20
#define MXC_CCM_CCGR4_PWM3_MASK					(3 << MXC_CCM_CCGR4_PWM3_OFFSET)
#define MXC_CCM_CCGR4_PWM4_OFFSET				22
#define MXC_CCM_CCGR4_PWM4_MASK					(3 << MXC_CCM_CCGR4_PWM4_OFFSET)
#define MXC_CCM_CCGR4_RAWNAND_U_BCH_INPUT_APB_OFFSET		24
#define MXC_CCM_CCGR4_RAWNAND_U_BCH_INPUT_APB_MASK		(3 << MXC_CCM_CCGR4_RAWNAND_U_BCH_INPUT_APB_OFFSET)
#define MXC_CCM_CCGR4_RAWNAND_U_GPMI_BCH_INPUT_BCH_OFFSET	26
#define MXC_CCM_CCGR4_RAWNAND_U_GPMI_BCH_INPUT_BCH_MASK		(3 << MXC_CCM_CCGR4_RAWNAND_U_GPMI_BCH_INPUT_BCH_OFFSET)
#define MXC_CCM_CCGR4_RAWNAND_U_GPMI_BCH_INPUT_GPMI_IO_OFFSET	28
#define MXC_CCM_CCGR4_RAWNAND_U_GPMI_BCH_INPUT_GPMI_IO_MASK	(3 << MXC_CCM_CCGR4_RAWNAND_U_GPMI_BCH_INPUT_GPMI_IO_OFFSET)
#define MXC_CCM_CCGR4_RAWNAND_U_GPMI_INPUT_APB_OFFSET		30
#define MXC_CCM_CCGR4_RAWNAND_U_GPMI_INPUT_APB_MASK		(3 << MXC_CCM_CCGR4_RAWNAND_U_GPMI_INPUT_APB_OFFSET)

#define MXC_CCM_CCGR5_ROM_OFFSET			0
#define MXC_CCM_CCGR5_ROM_MASK				(3 << MXC_CCM_CCGR5_ROM_OFFSET)
#ifndef CONFIG_MX6SX
#define MXC_CCM_CCGR5_SATA_OFFSET			4
#define MXC_CCM_CCGR5_SATA_MASK				(3 << MXC_CCM_CCGR5_SATA_OFFSET)
#endif
#define MXC_CCM_CCGR5_SDMA_OFFSET			6
#define MXC_CCM_CCGR5_SDMA_MASK				(3 << MXC_CCM_CCGR5_SDMA_OFFSET)
#define MXC_CCM_CCGR5_SPBA_OFFSET			12
#define MXC_CCM_CCGR5_SPBA_MASK				(3 << MXC_CCM_CCGR5_SPBA_OFFSET)
#define MXC_CCM_CCGR5_SPDIF_OFFSET			14
#define MXC_CCM_CCGR5_SPDIF_MASK			(3 << MXC_CCM_CCGR5_SPDIF_OFFSET)
#define MXC_CCM_CCGR5_SSI1_OFFSET			18
#define MXC_CCM_CCGR5_SSI1_MASK				(3 << MXC_CCM_CCGR5_SSI1_OFFSET)
#define MXC_CCM_CCGR5_SSI2_OFFSET			20
#define MXC_CCM_CCGR5_SSI2_MASK				(3 << MXC_CCM_CCGR5_SSI2_OFFSET)
#define MXC_CCM_CCGR5_SSI3_OFFSET			22
#define MXC_CCM_CCGR5_SSI3_MASK				(3 << MXC_CCM_CCGR5_SSI3_OFFSET)
#define MXC_CCM_CCGR5_UART_OFFSET			24
#define MXC_CCM_CCGR5_UART_MASK				(3 << MXC_CCM_CCGR5_UART_OFFSET)
#define MXC_CCM_CCGR5_UART_SERIAL_OFFSET		26
#define MXC_CCM_CCGR5_UART_SERIAL_MASK			(3 << MXC_CCM_CCGR5_UART_SERIAL_OFFSET)
#ifdef CONFIG_MX6SX
#define MXC_CCM_CCGR5_SAI1_OFFSET			20
#define MXC_CCM_CCGR5_SAI1_MASK				(3 << MXC_CCM_CCGR5_SAI1_OFFSET)
#define MXC_CCM_CCGR5_SAI2_OFFSET			30
#define MXC_CCM_CCGR5_SAI2_MASK				(3 << MXC_CCM_CCGR5_SAI2_OFFSET)
#endif

/* PRG_CLK0 exists on i.MX6QP */
#define MXC_CCM_CCGR6_PRG_CLK0_MASK		(3 << 24)

#define MXC_CCM_CCGR6_USBOH3_OFFSET		0
#define MXC_CCM_CCGR6_USBOH3_MASK		(3 << MXC_CCM_CCGR6_USBOH3_OFFSET)
#define MXC_CCM_CCGR6_USDHC1_OFFSET		2
#define MXC_CCM_CCGR6_USDHC1_MASK		(3 << MXC_CCM_CCGR6_USDHC1_OFFSET)
#define MXC_CCM_CCGR6_USDHC2_OFFSET		4
#define MXC_CCM_CCGR6_USDHC2_MASK		(3 << MXC_CCM_CCGR6_USDHC2_OFFSET)
#define MXC_CCM_CCGR6_SIM1_CLK_OFFSET		6
#define MXC_CCM_CCGR6_SIM1_CLK_MASK		(3 << MXC_CCM_CCGR6_SIM1_CLK_OFFSET)
#define MXC_CCM_CCGR6_SIM2_CLK_OFFSET		8
#define MXC_CCM_CCGR6_SIM2_CLK_MASK		(3 << MXC_CCM_CCGR6_SIM2_CLK_OFFSET)
/* i.MX6ULL */
#define MXC_CCM_CCGR6_IPMUX4_CLK_OFFSET		8
#define MXC_CCM_CCGR6_IPMUX4_CLK_MASK		(3 << MXC_CCM_CCGR6_IPMUX4_CLK_OFFSET)
/* GPMI/BCH on i.MX6UL */
#define MXC_CCM_CCGR6_BCH_OFFSET		6
#define MXC_CCM_CCGR6_BCH_MASK			(3 << MXC_CCM_CCGR6_BCH_OFFSET)
#define MXC_CCM_CCGR6_GPMI_OFFSET		8
#define MXC_CCM_CCGR6_GPMI_MASK		(3 << MXC_CCM_CCGR6_GPMI_OFFSET)

#define MXC_CCM_CCGR6_USDHC3_OFFSET		6
#define MXC_CCM_CCGR6_USDHC3_MASK		(3 << MXC_CCM_CCGR6_USDHC3_OFFSET)
#define MXC_CCM_CCGR6_USDHC4_OFFSET		8
#define MXC_CCM_CCGR6_USDHC4_MASK		(3 << MXC_CCM_CCGR6_USDHC4_OFFSET)
#define MXC_CCM_CCGR6_EMI_SLOW_OFFSET		10
#define MXC_CCM_CCGR6_EMI_SLOW_MASK		(3 << MXC_CCM_CCGR6_EMI_SLOW_OFFSET)
/* i.MX6ULL */
#define MXC_CCM_CCGR6_AIPS_TZ3_CLK_OFFSET	18
#define MXC_CCM_CCGR6_AIPS_TZ3_CLK_MASK		(3 << MXC_CCM_CCGR6_AIPS_TZ3_CLK_OFFSET)
/* The following *CCGR6* exist only i.MX6SX */
#define MXC_CCM_CCGR6_PWM8_OFFSET		16
#define MXC_CCM_CCGR6_PWM8_MASK			(3 << MXC_CCM_CCGR6_PWM8_OFFSET)
#define MXC_CCM_CCGR6_VADC_OFFSET		20
#define MXC_CCM_CCGR6_VADC_MASK			(3 << MXC_CCM_CCGR6_VADC_OFFSET)
#define MXC_CCM_CCGR6_GIS_OFFSET		22
#define MXC_CCM_CCGR6_GIS_MASK			(3 << MXC_CCM_CCGR6_GIS_OFFSET)
#define MXC_CCM_CCGR6_I2C4_OFFSET		24
#define MXC_CCM_CCGR6_I2C4_MASK			(3 << MXC_CCM_CCGR6_I2C4_OFFSET)
#define MXC_CCM_CCGR6_PWM5_OFFSET		26
#define MXC_CCM_CCGR6_PWM5_MASK			(3 << MXC_CCM_CCGR6_PWM5_OFFSET)
#define MXC_CCM_CCGR6_PWM6_OFFSET		28
#define MXC_CCM_CCGR6_PWM6_MASK			(3 << MXC_CCM_CCGR6_PWM6_OFFSET)
#define MXC_CCM_CCGR6_PWM7_OFFSET		30
#define MXC_CCM_CCGR6_PWM7_MASK			(3 << MXC_CCM_CCGR6_PWM7_OFFSET)
/* The two does not exist on i.MX6SX */
#define MXC_CCM_CCGR6_VDOAXICLK_OFFSET		12
#define MXC_CCM_CCGR6_VDOAXICLK_MASK		(3 << MXC_CCM_CCGR6_VDOAXICLK_OFFSET)

#define BM_ANADIG_PLL_SYS_LOCK 0x80000000
#define BP_ANADIG_PLL_SYS_RSVD0      20
#define BM_ANADIG_PLL_SYS_RSVD0 0x7FF00000
#define BF_ANADIG_PLL_SYS_RSVD0(v)  \
	(((v) << 20) & BM_ANADIG_PLL_SYS_RSVD0)
#define BM_ANADIG_PLL_SYS_PLL_SEL 0x00080000
#define BM_ANADIG_PLL_SYS_LVDS_24MHZ_SEL 0x00040000
#define BM_ANADIG_PLL_SYS_LVDS_SEL 0x00020000
#define BM_ANADIG_PLL_SYS_BYPASS 0x00010000
#define BP_ANADIG_PLL_SYS_BYPASS_CLK_SRC      14
#define BM_ANADIG_PLL_SYS_BYPASS_CLK_SRC 0x0000C000
#define BF_ANADIG_PLL_SYS_BYPASS_CLK_SRC(v)  \
	(((v) << 14) & BM_ANADIG_PLL_SYS_BYPASS_CLK_SRC)
#define BV_ANADIG_PLL_SYS_BYPASS_CLK_SRC__OSC_24M  0x0
#define BV_ANADIG_PLL_SYS_BYPASS_CLK_SRC__ANACLK_1 0x1
#define BV_ANADIG_PLL_SYS_BYPASS_CLK_SRC__ANACLK_2 0x2
#define BV_ANADIG_PLL_SYS_BYPASS_CLK_SRC__XOR      0x3
#define BM_ANADIG_PLL_SYS_ENABLE 0x00002000
#define BM_ANADIG_PLL_SYS_POWERDOWN 0x00001000
#define BM_ANADIG_PLL_SYS_HOLD_RING_OFF 0x00000800
#define BM_ANADIG_PLL_SYS_DOUBLE_CP 0x00000400
#define BM_ANADIG_PLL_SYS_HALF_CP 0x00000200
#define BM_ANADIG_PLL_SYS_DOUBLE_LF 0x00000100
#define BM_ANADIG_PLL_SYS_HALF_LF 0x00000080
#define BP_ANADIG_PLL_SYS_DIV_SELECT      0
#define BM_ANADIG_PLL_SYS_DIV_SELECT 0x0000007F
#define BF_ANADIG_PLL_SYS_DIV_SELECT(v)  \
	(((v) << 0) & BM_ANADIG_PLL_SYS_DIV_SELECT)

#define BM_ANADIG_USB1_PLL_480_CTRL_LOCK 0x80000000
#define BP_ANADIG_USB1_PLL_480_CTRL_RSVD1      17
#define BM_ANADIG_USB1_PLL_480_CTRL_RSVD1 0x7FFE0000
#define BF_ANADIG_USB1_PLL_480_CTRL_RSVD1(v)  \
	(((v) << 17) & BM_ANADIG_USB1_PLL_480_CTRL_RSVD1)
#define BM_ANADIG_USB1_PLL_480_CTRL_BYPASS 0x00010000
#define BP_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC      14
#define BM_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC 0x0000C000
#define BF_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC(v)  \
	(((v) << 14) & BM_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC)
#define BV_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC__OSC_24M  0x0
#define BV_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC__ANACLK_1 0x1
#define BV_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC__ANACLK_2 0x2
#define BV_ANADIG_USB1_PLL_480_CTRL_BYPASS_CLK_SRC__XOR      0x3
#define BM_ANADIG_USB1_PLL_480_CTRL_ENABLE 0x00002000
#define BM_ANADIG_USB1_PLL_480_CTRL_POWER 0x00001000
#define BM_ANADIG_USB1_PLL_480_CTRL_HOLD_RING_OFF 0x00000800
#define BM_ANADIG_USB1_PLL_480_CTRL_DOUBLE_CP 0x00000400
#define BM_ANADIG_USB1_PLL_480_CTRL_HALF_CP 0x00000200
#define BM_ANADIG_USB1_PLL_480_CTRL_DOUBLE_LF 0x00000100
#define BM_ANADIG_USB1_PLL_480_CTRL_HALF_LF 0x00000080
#define BM_ANADIG_USB1_PLL_480_CTRL_EN_USB_CLKS 0x00000040
#define BM_ANADIG_USB1_PLL_480_CTRL_RSVD0 0x00000020
#define BP_ANADIG_USB1_PLL_480_CTRL_CONTROL0      2
#define BM_ANADIG_USB1_PLL_480_CTRL_CONTROL0 0x0000001C
#define BF_ANADIG_USB1_PLL_480_CTRL_CONTROL0(v)  \
	(((v) << 2) & BM_ANADIG_USB1_PLL_480_CTRL_CONTROL0)
#define BP_ANADIG_USB1_PLL_480_CTRL_DIV_SELECT      0
#define BM_ANADIG_USB1_PLL_480_CTRL_DIV_SELECT 0x00000003
#define BF_ANADIG_USB1_PLL_480_CTRL_DIV_SELECT(v)  \
	(((v) << 0) & BM_ANADIG_USB1_PLL_480_CTRL_DIV_SELECT)

#define BM_ANADIG_PLL_528_LOCK 0x80000000
#define BP_ANADIG_PLL_528_RSVD1      19
#define BM_ANADIG_PLL_528_RSVD1 0x7FF80000
#define BF_ANADIG_PLL_528_RSVD1(v)  \
	(((v) << 19) & BM_ANADIG_PLL_528_RSVD1)
#define BM_ANADIG_PLL_528_PFD_OFFSET_EN 0x00040000
#define BM_ANADIG_PLL_528_DITHER_ENABLE 0x00020000
#define BM_ANADIG_PLL_528_BYPASS 0x00010000
#define BP_ANADIG_PLL_528_BYPASS_CLK_SRC      14
#define BM_ANADIG_PLL_528_BYPASS_CLK_SRC 0x0000C000
#define BF_ANADIG_PLL_528_BYPASS_CLK_SRC(v)  \
	(((v) << 14) & BM_ANADIG_PLL_528_BYPASS_CLK_SRC)
#define BV_ANADIG_PLL_528_BYPASS_CLK_SRC__OSC_24M  0x0
#define BV_ANADIG_PLL_528_BYPASS_CLK_SRC__ANACLK_1 0x1
#define BV_ANADIG_PLL_528_BYPASS_CLK_SRC__ANACLK_2 0x2
#define BV_ANADIG_PLL_528_BYPASS_CLK_SRC__XOR      0x3
#define BM_ANADIG_PLL_528_ENABLE 0x00002000
#define BM_ANADIG_PLL_528_POWERDOWN 0x00001000
#define BM_ANADIG_PLL_528_HOLD_RING_OFF 0x00000800
#define BM_ANADIG_PLL_528_DOUBLE_CP 0x00000400
#define BM_ANADIG_PLL_528_HALF_CP 0x00000200
#define BM_ANADIG_PLL_528_DOUBLE_LF 0x00000100
#define BM_ANADIG_PLL_528_HALF_LF 0x00000080
#define BP_ANADIG_PLL_528_RSVD0      1
#define BM_ANADIG_PLL_528_RSVD0 0x0000007E
#define BF_ANADIG_PLL_528_RSVD0(v)  \
	(((v) << 1) & BM_ANADIG_PLL_528_RSVD0)
#define BM_ANADIG_PLL_528_DIV_SELECT 0x00000001

#define BP_ANADIG_PLL_528_SS_STOP      16
#define BM_ANADIG_PLL_528_SS_STOP 0xFFFF0000
#define BF_ANADIG_PLL_528_SS_STOP(v) \
	(((v) << 16) & BM_ANADIG_PLL_528_SS_STOP)
#define BM_ANADIG_PLL_528_SS_ENABLE 0x00008000
#define BP_ANADIG_PLL_528_SS_STEP      0
#define BM_ANADIG_PLL_528_SS_STEP 0x00007FFF
#define BF_ANADIG_PLL_528_SS_STEP(v)  \
	(((v) << 0) & BM_ANADIG_PLL_528_SS_STEP)

#define BP_ANADIG_PLL_528_NUM_RSVD0      30
#define BM_ANADIG_PLL_528_NUM_RSVD0 0xC0000000
#define BF_ANADIG_PLL_528_NUM_RSVD0(v) \
	(((v) << 30) & BM_ANADIG_PLL_528_NUM_RSVD0)
#define BP_ANADIG_PLL_528_NUM_A      0
#define BM_ANADIG_PLL_528_NUM_A 0x3FFFFFFF
#define BF_ANADIG_PLL_528_NUM_A(v)  \
	(((v) << 0) & BM_ANADIG_PLL_528_NUM_A)

#define BP_ANADIG_PLL_528_DENOM_RSVD0      30
#define BM_ANADIG_PLL_528_DENOM_RSVD0 0xC0000000
#define BF_ANADIG_PLL_528_DENOM_RSVD0(v) \
	(((v) << 30) & BM_ANADIG_PLL_528_DENOM_RSVD0)
#define BP_ANADIG_PLL_528_DENOM_B      0
#define BM_ANADIG_PLL_528_DENOM_B 0x3FFFFFFF
#define BF_ANADIG_PLL_528_DENOM_B(v)  \
	(((v) << 0) & BM_ANADIG_PLL_528_DENOM_B)

#define BM_ANADIG_PLL_AUDIO_LOCK 0x80000000
#define BP_ANADIG_PLL_AUDIO_RSVD0      22
#define BM_ANADIG_PLL_AUDIO_RSVD0 0x7FC00000
#define BF_ANADIG_PLL_AUDIO_RSVD0(v)  \
	(((v) << 22) & BM_ANADIG_PLL_AUDIO_RSVD0)
#define BM_ANADIG_PLL_AUDIO_SSC_EN 0x00200000
#define BP_ANADIG_PLL_AUDIO_TEST_DIV_SELECT      19
#define BM_ANADIG_PLL_AUDIO_TEST_DIV_SELECT 0x00180000
#define BF_ANADIG_PLL_AUDIO_TEST_DIV_SELECT(v)  \
	(((v) << 19) & BM_ANADIG_PLL_AUDIO_TEST_DIV_SELECT)
#define BM_ANADIG_PLL_AUDIO_PFD_OFFSET_EN 0x00040000
#define BM_ANADIG_PLL_AUDIO_DITHER_ENABLE 0x00020000
#define BM_ANADIG_PLL_AUDIO_BYPASS 0x00010000
#define BP_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC      14
#define BM_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC 0x0000C000
#define BF_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC(v)  \
	(((v) << 14) & BM_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC)
#define BV_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC__OSC_24M  0x0
#define BV_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC__ANACLK_1 0x1
#define BV_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC__ANACLK_2 0x2
#define BV_ANADIG_PLL_AUDIO_BYPASS_CLK_SRC__XOR      0x3
#define BM_ANADIG_PLL_AUDIO_ENABLE 0x00002000
#define BM_ANADIG_PLL_AUDIO_POWERDOWN 0x00001000
#define BM_ANADIG_PLL_AUDIO_HOLD_RING_OFF 0x00000800
#define BM_ANADIG_PLL_AUDIO_DOUBLE_CP 0x00000400
#define BM_ANADIG_PLL_AUDIO_HALF_CP 0x00000200
#define BM_ANADIG_PLL_AUDIO_DOUBLE_LF 0x00000100
#define BM_ANADIG_PLL_AUDIO_HALF_LF 0x00000080
#define BP_ANADIG_PLL_AUDIO_DIV_SELECT      0
#define BM_ANADIG_PLL_AUDIO_DIV_SELECT 0x0000007F
#define BF_ANADIG_PLL_AUDIO_DIV_SELECT(v)  \
	(((v) << 0) & BM_ANADIG_PLL_AUDIO_DIV_SELECT)

#define BP_ANADIG_PLL_AUDIO_NUM_RSVD0      30
#define BM_ANADIG_PLL_AUDIO_NUM_RSVD0 0xC0000000
#define BF_ANADIG_PLL_AUDIO_NUM_RSVD0(v) \
	(((v) << 30) & BM_ANADIG_PLL_AUDIO_NUM_RSVD0)
#define BP_ANADIG_PLL_AUDIO_NUM_A      0
#define BM_ANADIG_PLL_AUDIO_NUM_A 0x3FFFFFFF
#define BF_ANADIG_PLL_AUDIO_NUM_A(v)  \
	(((v) << 0) & BM_ANADIG_PLL_AUDIO_NUM_A)

#define BP_ANADIG_PLL_AUDIO_DENOM_RSVD0      30
#define BM_ANADIG_PLL_AUDIO_DENOM_RSVD0 0xC0000000
#define BF_ANADIG_PLL_AUDIO_DENOM_RSVD0(v) \
	(((v) << 30) & BM_ANADIG_PLL_AUDIO_DENOM_RSVD0)
#define BP_ANADIG_PLL_AUDIO_DENOM_B      0
#define BM_ANADIG_PLL_AUDIO_DENOM_B 0x3FFFFFFF
#define BF_ANADIG_PLL_AUDIO_DENOM_B(v)  \
	(((v) << 0) & BM_ANADIG_PLL_AUDIO_DENOM_B)

#define BM_ANADIG_PLL_VIDEO_LOCK 0x80000000
#define BP_ANADIG_PLL_VIDEO_RSVD0      22
#define BM_ANADIG_PLL_VIDEO_RSVD0 0x7FC00000
#define BF_ANADIG_PLL_VIDEO_RSVD0(v)  \
	(((v) << 22) & BM_ANADIG_PLL_VIDEO_RSVD0)
#define BM_ANADIG_PLL_VIDEO_SSC_EN 0x00200000
#define BP_ANADIG_PLL_VIDEO_POST_DIV_SELECT      19
#define BM_ANADIG_PLL_VIDEO_POST_DIV_SELECT 0x00180000
#define BF_ANADIG_PLL_VIDEO_POST_DIV_SELECT(v)  \
	(((v) << 19) & BM_ANADIG_PLL_VIDEO_POST_DIV_SELECT)
#define BM_ANADIG_PLL_VIDEO_PFD_OFFSET_EN 0x00040000
#define BM_ANADIG_PLL_VIDEO_DITHER_ENABLE 0x00020000
#define BM_ANADIG_PLL_VIDEO_BYPASS 0x00010000
#define BP_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC      14
#define BM_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC 0x0000C000
#define BF_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC(v)  \
	(((v) << 14) & BM_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC)
#define BV_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC__OSC_24M  0x0
#define BV_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC__ANACLK_1 0x1
#define BV_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC__ANACLK_2 0x2
#define BV_ANADIG_PLL_VIDEO_BYPASS_CLK_SRC__XOR      0x3
#define BM_ANADIG_PLL_VIDEO_ENABLE 0x00002000
#define BM_ANADIG_PLL_VIDEO_POWERDOWN 0x00001000
#define BM_ANADIG_PLL_VIDEO_HOLD_RING_OFF 0x00000800
#define BM_ANADIG_PLL_VIDEO_DOUBLE_CP 0x00000400
#define BM_ANADIG_PLL_VIDEO_HALF_CP 0x00000200
#define BM_ANADIG_PLL_VIDEO_DOUBLE_LF 0x00000100
#define BM_ANADIG_PLL_VIDEO_HALF_LF 0x00000080
#define BP_ANADIG_PLL_VIDEO_DIV_SELECT      0
#define BM_ANADIG_PLL_VIDEO_DIV_SELECT 0x0000007F
#define BF_ANADIG_PLL_VIDEO_DIV_SELECT(v)  \
	(((v) << 0) & BM_ANADIG_PLL_VIDEO_DIV_SELECT)

#define BP_ANADIG_PLL_VIDEO_NUM_RSVD0      30
#define BM_ANADIG_PLL_VIDEO_NUM_RSVD0 0xC0000000
#define BF_ANADIG_PLL_VIDEO_NUM_RSVD0(v) \
	(((v) << 30) & BM_ANADIG_PLL_VIDEO_NUM_RSVD0)
#define BP_ANADIG_PLL_VIDEO_NUM_A      0
#define BM_ANADIG_PLL_VIDEO_NUM_A 0x3FFFFFFF
#define BF_ANADIG_PLL_VIDEO_NUM_A(v)  \
	(((v) << 0) & BM_ANADIG_PLL_VIDEO_NUM_A)

#define BP_ANADIG_PLL_VIDEO_DENOM_RSVD0      30
#define BM_ANADIG_PLL_VIDEO_DENOM_RSVD0 0xC0000000
#define BF_ANADIG_PLL_VIDEO_DENOM_RSVD0(v) \
	(((v) << 30) & BM_ANADIG_PLL_VIDEO_DENOM_RSVD0)
#define BP_ANADIG_PLL_VIDEO_DENOM_B      0
#define BM_ANADIG_PLL_VIDEO_DENOM_B 0x3FFFFFFF
#define BF_ANADIG_PLL_VIDEO_DENOM_B(v)  \
	(((v) << 0) & BM_ANADIG_PLL_VIDEO_DENOM_B)

#define BM_ANADIG_PLL_ENET_LOCK 0x80000000
#define BP_ANADIG_PLL_ENET_RSVD1      21
#define BM_ANADIG_PLL_ENET_RSVD1 0x7FE00000
#define BF_ANADIG_PLL_ENET_RSVD1(v)  \
	(((v) << 21) & BM_ANADIG_PLL_ENET_RSVD1)
#define BM_ANADIG_PLL_ENET_REF_25M_ENABLE 0x00200000
#define BM_ANADIG_PLL_ENET_ENABLE_SATA 0x00100000
#define BM_ANADIG_PLL_ENET_ENABLE_PCIE 0x00080000
#define BM_ANADIG_PLL_ENET_PFD_OFFSET_EN 0x00040000
#define BM_ANADIG_PLL_ENET_DITHER_ENABLE 0x00020000
#define BM_ANADIG_PLL_ENET_BYPASS 0x00010000
#define BP_ANADIG_PLL_ENET_BYPASS_CLK_SRC      14
#define BM_ANADIG_PLL_ENET_BYPASS_CLK_SRC 0x0000C000
#define BF_ANADIG_PLL_ENET_BYPASS_CLK_SRC(v)  \
	(((v) << 14) & BM_ANADIG_PLL_ENET_BYPASS_CLK_SRC)
#define BV_ANADIG_PLL_ENET_BYPASS_CLK_SRC__OSC_24M  0x0
#define BV_ANADIG_PLL_ENET_BYPASS_CLK_SRC__ANACLK_1 0x1
#define BV_ANADIG_PLL_ENET_BYPASS_CLK_SRC__ANACLK_2 0x2
#define BV_ANADIG_PLL_ENET_BYPASS_CLK_SRC__XOR      0x3
#define BM_ANADIG_PLL_ENET_ENABLE 0x00002000
#define BM_ANADIG_PLL_ENET_POWERDOWN 0x00001000
#define BM_ANADIG_PLL_ENET_HOLD_RING_OFF 0x00000800
#define BM_ANADIG_PLL_ENET_DOUBLE_CP 0x00000400
#define BM_ANADIG_PLL_ENET_HALF_CP 0x00000200
#define BM_ANADIG_PLL_ENET_DOUBLE_LF 0x00000100
#define BM_ANADIG_PLL_ENET_HALF_LF 0x00000080
#define BP_ANADIG_PLL_ENET_RSVD0      2
#define BM_ANADIG_PLL_ENET_RSVD0 0x0000007C
#define BF_ANADIG_PLL_ENET_RSVD0(v)  \
	(((v) << 2) & BM_ANADIG_PLL_ENET_RSVD0)
#define BP_ANADIG_PLL_ENET_DIV_SELECT      0
#define BM_ANADIG_PLL_ENET_DIV_SELECT 0x00000003
#define BF_ANADIG_PLL_ENET_DIV_SELECT(v)  \
	(((v) << 0) & BM_ANADIG_PLL_ENET_DIV_SELECT)

/* ENET2 for i.MX6SX/UL */
#define BM_ANADIG_PLL_ENET2_ENABLE 0x00100000
#define BM_ANADIG_PLL_ENET2_DIV_SELECT 0x0000000C
#define BF_ANADIG_PLL_ENET2_DIV_SELECT(v)  \
	(((v) << 2) & BM_ANADIG_PLL_ENET2_DIV_SELECT)

#define BM_ANADIG_PFD_480_PFD3_CLKGATE 0x80000000
#define BM_ANADIG_PFD_480_PFD3_STABLE 0x40000000
#define BP_ANADIG_PFD_480_PFD3_FRAC      24
#define BM_ANADIG_PFD_480_PFD3_FRAC 0x3F000000
#define BF_ANADIG_PFD_480_PFD3_FRAC(v)  \
	(((v) << 24) & BM_ANADIG_PFD_480_PFD3_FRAC)
#define BM_ANADIG_PFD_480_PFD2_CLKGATE 0x00800000
#define BM_ANADIG_PFD_480_PFD2_STABLE 0x00400000
#define BP_ANADIG_PFD_480_PFD2_FRAC      16
#define BM_ANADIG_PFD_480_PFD2_FRAC 0x003F0000
#define BF_ANADIG_PFD_480_PFD2_FRAC(v)  \
	(((v) << 16) & BM_ANADIG_PFD_480_PFD2_FRAC)
#define BM_ANADIG_PFD_480_PFD1_CLKGATE 0x00008000
#define BM_ANADIG_PFD_480_PFD1_STABLE 0x00004000
#define BP_ANADIG_PFD_480_PFD1_FRAC      8
#define BM_ANADIG_PFD_480_PFD1_FRAC 0x00003F00
#define BF_ANADIG_PFD_480_PFD1_FRAC(v)  \
	(((v) << 8) & BM_ANADIG_PFD_480_PFD1_FRAC)
#define BM_ANADIG_PFD_480_PFD0_CLKGATE 0x00000080
#define BM_ANADIG_PFD_480_PFD0_STABLE 0x00000040
#define BP_ANADIG_PFD_480_PFD0_FRAC      0
#define BM_ANADIG_PFD_480_PFD0_FRAC 0x0000003F
#define BF_ANADIG_PFD_480_PFD0_FRAC(v)  \
	(((v) << 0) & BM_ANADIG_PFD_480_PFD0_FRAC)

#define BM_ANADIG_PFD_528_PFD3_CLKGATE 0x80000000
#define BM_ANADIG_PFD_528_PFD3_STABLE 0x40000000
#define BP_ANADIG_PFD_528_PFD3_FRAC      24
#define BM_ANADIG_PFD_528_PFD3_FRAC 0x3F000000
#define BF_ANADIG_PFD_528_PFD3_FRAC(v)  \
	(((v) << 24) & BM_ANADIG_PFD_528_PFD3_FRAC)
#define BM_ANADIG_PFD_528_PFD2_CLKGATE 0x00800000
#define BM_ANADIG_PFD_528_PFD2_STABLE 0x00400000
#define BP_ANADIG_PFD_528_PFD2_FRAC      16
#define BM_ANADIG_PFD_528_PFD2_FRAC 0x003F0000
#define BF_ANADIG_PFD_528_PFD2_FRAC(v)  \
	(((v) << 16) & BM_ANADIG_PFD_528_PFD2_FRAC)
#define BM_ANADIG_PFD_528_PFD1_CLKGATE 0x00008000
#define BM_ANADIG_PFD_528_PFD1_STABLE 0x00004000
#define BP_ANADIG_PFD_528_PFD1_FRAC      8
#define BM_ANADIG_PFD_528_PFD1_FRAC 0x00003F00
#define BF_ANADIG_PFD_528_PFD1_FRAC(v)  \
	(((v) << 8) & BM_ANADIG_PFD_528_PFD1_FRAC)
#define BM_ANADIG_PFD_528_PFD0_CLKGATE 0x00000080
#define BM_ANADIG_PFD_528_PFD0_STABLE 0x00000040
#define BP_ANADIG_PFD_528_PFD0_FRAC      0
#define BM_ANADIG_PFD_528_PFD0_FRAC 0x0000003F
#define BF_ANADIG_PFD_528_PFD0_FRAC(v)  \
	(((v) << 0) & BM_ANADIG_PFD_528_PFD0_FRAC)

#define BM_ANADIG_ANA_MISC0_REFTOP_SELBIASOFF 0x00000008
#define BM_ANADIG_ANA_MISC0_REFTOP_VBGADJ_SHIFT 4

#define BM_PMU_MISC2_AUDIO_DIV_MSB (1 << 23)
#define BP_PMU_MISC2_AUDIO_DIV_MSB 23

#define BM_PMU_MISC2_AUDIO_DIV_LSB (1 << 15)
#define BP_PMU_MISC2_AUDIO_DIV_LSB 15

#define PMU_MISC2_AUDIO_DIV(v) \
	(((v & BM_PMU_MISC2_AUDIO_DIV_MSB) >> \
	(BP_PMU_MISC2_AUDIO_DIV_MSB - 1)) | \
	((v & BM_PMU_MISC2_AUDIO_DIV_LSB) >> \
	 BP_PMU_MISC2_AUDIO_DIV_LSB))

#endif /*__ARCH_ARM_MACH_MX6_CCM_REGS_H__ */
