use crate::counter::update_new_counts;
use crate::nntp_client::NntpClient;
use crate::ui::AppState;
use ratatui::{
    backend::CrosstermBackend,
    layout::Rect,
    style::{Color, Style},
    widgets::{Block, Borders, Paragraph},
    Terminal,
};
use rusqlite::Connection;
use std::sync::Arc;
use tokio::sync::Mutex;

/// Draws a meow popup, refreshes all badges, and updates the status line.
pub async fn manual_refresh(
    terminal: &mut Terminal<CrosstermBackend<std::io::Stdout>>,
    state: &mut AppState,
    client: Arc<Mutex<NntpClient>>,
    db: Arc<Mutex<Connection>>,
) {
    // 1) Show popup
    let msg = "🔄 Fetching new articles…".to_string();
    state.status = Some(msg.clone());
    if let Ok(area) = terminal.size() {
        let popup = Rect {
            x: (area.width.saturating_sub(40)) / 2,
            y: (area.height.saturating_sub(3)) / 2,
            width: 40,
            height: 3,
        };
        let _ = terminal.draw(|f| {
            let p = Paragraph::new(msg.clone())
                .style(Style::default().fg(Color::White).bg(Color::Blue))
                .block(Block::default().borders(Borders::ALL).title("Refreshing"));
            f.render_widget(p, popup);
        });
    }

    // 2) Perform the full badges refresh
    update_new_counts(&client, &db, &state.subscriptions, &mut state.new_counts).await;

    // 3) Show success in footer
    state.status = Some("✅ Badges updated".to_string());

    // Force redraw so footer shows up
    let _ = terminal.draw(|_| {});
}
