/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <pthread.h>
#include <assert.h>
#include <vsync/atomic.h>
#define N  5
#define IT 10
vatomicptr_t g_shared;
void *g_ptrs[N];
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_cmpxchg
 *****************************************************************************/
static inline void *
mt_atomic_cmpxchg_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    void *cur   = 0;
    void *old   = 0;
    for (vsize_t i = 0; i < IT; i++) {
        do {
            cur = vatomicptr_read(&g_shared);
            old = vatomicptr_cmpxchg(&g_shared, cur, &g_ptrs[tid]);
        } while (cur != old);
    }
    return NULL;
}
static inline void
mt_atomic_cmpxchg(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_cmpxchg_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_xchg
 *****************************************************************************/
static inline void *
mt_atomic_xchg_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    for (vsize_t i = 0; i < IT; i++) {
        (void)vatomicptr_xchg(&g_shared, &g_ptrs[tid]);
    }
    return NULL;
}
static inline void
mt_atomic_xchg(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_xchg_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_cmpxchg_acq
 *****************************************************************************/
static inline void *
mt_atomic_cmpxchg_acq_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    void *cur   = 0;
    void *old   = 0;
    for (vsize_t i = 0; i < IT; i++) {
        do {
            cur = vatomicptr_read(&g_shared);
            old = vatomicptr_cmpxchg_acq(&g_shared, cur, &g_ptrs[tid]);
        } while (cur != old);
    }
    return NULL;
}
static inline void
mt_atomic_cmpxchg_acq(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_cmpxchg_acq_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_xchg_acq
 *****************************************************************************/
static inline void *
mt_atomic_xchg_acq_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    for (vsize_t i = 0; i < IT; i++) {
        (void)vatomicptr_xchg_acq(&g_shared, &g_ptrs[tid]);
    }
    return NULL;
}
static inline void
mt_atomic_xchg_acq(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_xchg_acq_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_cmpxchg_rel
 *****************************************************************************/
static inline void *
mt_atomic_cmpxchg_rel_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    void *cur   = 0;
    void *old   = 0;
    for (vsize_t i = 0; i < IT; i++) {
        do {
            cur = vatomicptr_read(&g_shared);
            old = vatomicptr_cmpxchg_rel(&g_shared, cur, &g_ptrs[tid]);
        } while (cur != old);
    }
    return NULL;
}
static inline void
mt_atomic_cmpxchg_rel(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_cmpxchg_rel_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_xchg_rel
 *****************************************************************************/
static inline void *
mt_atomic_xchg_rel_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    for (vsize_t i = 0; i < IT; i++) {
        (void)vatomicptr_xchg_rel(&g_shared, &g_ptrs[tid]);
    }
    return NULL;
}
static inline void
mt_atomic_xchg_rel(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_xchg_rel_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_cmpxchg_rlx
 *****************************************************************************/
static inline void *
mt_atomic_cmpxchg_rlx_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    void *cur   = 0;
    void *old   = 0;
    for (vsize_t i = 0; i < IT; i++) {
        do {
            cur = vatomicptr_read(&g_shared);
            old = vatomicptr_cmpxchg_rlx(&g_shared, cur, &g_ptrs[tid]);
        } while (cur != old);
    }
    return NULL;
}
static inline void
mt_atomic_cmpxchg_rlx(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_cmpxchg_rlx_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * MultiThreadedTest: vatomicptr_xchg_rlx
 *****************************************************************************/
static inline void *
mt_atomic_xchg_rlx_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    for (vsize_t i = 0; i < IT; i++) {
        (void)vatomicptr_xchg_rlx(&g_shared, &g_ptrs[tid]);
    }
    return NULL;
}
static inline void
mt_atomic_xchg_rlx(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[N];
    for (vsize_t i = 0; i < N; i++)
        pthread_create(&t[i], 0, mt_atomic_xchg_rlx_run, (void *)i);
    for (vsize_t i = 0; i < N; i++)
        pthread_join(t[i], 0);
    void *val = vatomicptr_read(&g_shared);
    for (vsize_t i = 0; i < N; i++) {
        if (val == &g_ptrs[i]) {
            return;
        }
    }
    assert(0 && "resulting value is not expected");
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    mt_atomic_cmpxchg();
    mt_atomic_xchg();
    mt_atomic_cmpxchg_rel();
    mt_atomic_xchg_rel();
    mt_atomic_cmpxchg_acq();
    mt_atomic_xchg_acq();
    mt_atomic_cmpxchg_rlx();
    mt_atomic_xchg_rlx();
    return 0;
}
