/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <assert.h>
#include <vsync/atomic.h>
#define BYTE_WIDTH 8U
/*****************************************************************************
 * UnitTest: vatomic32_read
 *****************************************************************************/
static inline void
ut_atomic_u32_read(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_read_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_read_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read_acq(&obj);
    assert(val == (vuint32_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_read_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_read_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read_rlx(&obj);
    assert(val == (vuint32_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_init
 *****************************************************************************/
static inline void
ut_atomic_u32_init(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vatomic32_init(&obj, VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_write
 *****************************************************************************/
static inline void
ut_atomic_u32_write(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vatomic32_write(&obj, VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_write_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_write_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vatomic32_write_rel(&obj, VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_write_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_write_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vatomic32_write_rlx(&obj, VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_xchg
 *****************************************************************************/
static inline void
ut_atomic_u32_xchg(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vuint32_t old = vatomic32_xchg(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_xchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_xchg_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vuint32_t old = vatomic32_xchg_acq(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_xchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_xchg_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vuint32_t old = vatomic32_xchg_rel(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_xchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_xchg_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t val   = vatomic32_read(&obj);
    assert(val == (vuint32_t)1);
    vuint32_t old = vatomic32_xchg_rlx(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_cmpxchg
 *****************************************************************************/
static inline void
ut_atomic_u32_cmpxchg(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    /* test failure */
    vuint32_t old = vatomic32_cmpxchg(&obj, VUINT32_MAX, (vuint32_t)1);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic32_cmpxchg(&obj, (vuint32_t)1, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_cmpxchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_cmpxchg_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    /* test failure */
    vuint32_t old = vatomic32_cmpxchg_acq(&obj, VUINT32_MAX, (vuint32_t)1);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic32_cmpxchg_acq(&obj, (vuint32_t)1, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_cmpxchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_cmpxchg_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    /* test failure */
    vuint32_t old = vatomic32_cmpxchg_rel(&obj, VUINT32_MAX, (vuint32_t)1);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic32_cmpxchg_rel(&obj, (vuint32_t)1, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_cmpxchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_cmpxchg_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    /* test failure */
    vuint32_t old = vatomic32_cmpxchg_rlx(&obj, VUINT32_MAX, (vuint32_t)1);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic32_cmpxchg_rlx(&obj, (vuint32_t)1, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val, old);
}
/* ****************************************************************************
 * UnitTest: vatomic32_add
 * ****************************************************************************/
static inline void
ut_atomic_u32_add(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_add(&obj, v);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_add_rel
 * ****************************************************************************/
static inline void
ut_atomic_u32_add_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_add_rel(&obj, v);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_add_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u32_add_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_add_rlx(&obj, v);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_add
 *****************************************************************************/
static inline void
ut_atomic_u32_get_add(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_add(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_add_get
 *****************************************************************************/
static inline void
ut_atomic_u32_add_get(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_add_get(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_add_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_add_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_add_acq(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_add_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_add_get_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_add_get_acq(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_add_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_add_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_add_rel(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_add_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_add_get_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_add_get_rel(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_add_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_add_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_add_rlx(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_add_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_add_get_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_add_get_rlx(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic32_inc
 * ****************************************************************************/
static inline void
ut_atomic_u32_inc(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_inc(&obj);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_inc_rel
 * ****************************************************************************/
static inline void
ut_atomic_u32_inc_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_inc_rel(&obj);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_inc_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u32_inc_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_inc_rlx(&obj);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_inc
 *****************************************************************************/
static inline void
ut_atomic_u32_get_inc(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_inc(&obj);
        assert(old == ref);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_inc_get
 *****************************************************************************/
static inline void
ut_atomic_u32_inc_get(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref++;
        cur = vatomic32_inc_get(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_inc_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_inc_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_inc_acq(&obj);
        assert(old == ref);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_inc_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_inc_get_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref++;
        cur = vatomic32_inc_get_acq(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_inc_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_inc_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_inc_rel(&obj);
        assert(old == ref);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_inc_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_inc_get_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref++;
        cur = vatomic32_inc_get_rel(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_inc_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_inc_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_inc_rlx(&obj);
        assert(old == ref);
        ref++;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_inc_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_inc_get_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref++;
        cur = vatomic32_inc_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_sub
 * ****************************************************************************/
static inline void
ut_atomic_u32_sub(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_sub(&obj, v);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_sub_rel
 * ****************************************************************************/
static inline void
ut_atomic_u32_sub_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_sub_rel(&obj, v);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_sub_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u32_sub_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_sub_rlx(&obj, v);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_sub
 *****************************************************************************/
static inline void
ut_atomic_u32_get_sub(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_sub(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_sub_get
 *****************************************************************************/
static inline void
ut_atomic_u32_sub_get(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_sub_get(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_sub_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_sub_acq(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_sub_acq(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_sub_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_sub_get_acq(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_sub_get_acq(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_sub_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_sub_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_sub_rel(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_sub_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_sub_get_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_sub_get_rel(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_sub_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_sub_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t old   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_sub_rlx(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_sub_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_sub_get_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;
    vuint32_t cur   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        cur = vatomic32_sub_get_rlx(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic32_dec
 * ****************************************************************************/
static inline void
ut_atomic_u32_dec(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_dec(&obj);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_dec_rel
 * ****************************************************************************/
static inline void
ut_atomic_u32_dec_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_dec_rel(&obj);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic32_dec_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u32_dec_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        vatomic32_dec_rlx(&obj);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_dec
 *****************************************************************************/
static inline void
ut_atomic_u32_get_dec(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t old   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_dec(&obj);
        assert(old == ref);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_dec_get
 *****************************************************************************/
static inline void
ut_atomic_u32_dec_get(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref--;
        cur = vatomic32_dec_get(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_dec_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_dec_acq(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t old   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_dec_acq(&obj);
        assert(old == ref);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_dec_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_dec_get_acq(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref--;
        cur = vatomic32_dec_get_acq(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_dec_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_dec_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t old   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_dec_rel(&obj);
        assert(old == ref);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_dec_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_dec_get_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref--;
        cur = vatomic32_dec_get_rel(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_dec_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_dec_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t old   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        old = vatomic32_get_dec_rlx(&obj);
        assert(old == ref);
        ref--;
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_dec_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_dec_get_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t max   = (vuint32_t)1 + (vuint32_t)10;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t val   = 0;

    for (vuint32_t v = (vuint32_t)1; v <= max; v++) {
        ref--;
        cur = vatomic32_dec_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic32_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_max
 *****************************************************************************/
static inline void
ut_atomic_u32_max(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vatomic32_max(&obj, VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    vatomic32_max(&obj, (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_max_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vatomic32_max_rel(&obj, VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    vatomic32_max_rel(&obj, (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_max_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vatomic32_max_rlx(&obj, VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    vatomic32_max_rlx(&obj, (vuint32_t)1);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_max
 *****************************************************************************/
static inline void
ut_atomic_u32_get_max(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t old = vatomic32_get_max(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    old = vatomic32_get_max(&obj, (vuint32_t)1);
    assert(old == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_max_get
 *****************************************************************************/
static inline void
ut_atomic_u32_max_get(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t cur = vatomic32_max_get(&obj, VUINT32_MAX);
    assert(cur == VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    cur = vatomic32_max_get(&obj, (vuint32_t)1);
    assert(cur == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_max_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_max_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t old = vatomic32_get_max_acq(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    old = vatomic32_get_max_acq(&obj, (vuint32_t)1);
    assert(old == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_max_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_max_get_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t cur = vatomic32_max_get_acq(&obj, VUINT32_MAX);
    assert(cur == VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    cur = vatomic32_max_get_acq(&obj, (vuint32_t)1);
    assert(cur == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_max_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t old = vatomic32_get_max_rel(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    old = vatomic32_get_max_rel(&obj, (vuint32_t)1);
    assert(old == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_max_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_max_get_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t cur = vatomic32_max_get_rel(&obj, VUINT32_MAX);
    assert(cur == VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    cur = vatomic32_max_get_rel(&obj, (vuint32_t)1);
    assert(cur == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_max_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t old = vatomic32_get_max_rlx(&obj, VUINT32_MAX);
    assert(old == (vuint32_t)1);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    old = vatomic32_get_max_rlx(&obj, (vuint32_t)1);
    assert(old == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_max_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_max_get_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};

    /* test write */
    vuint32_t cur = vatomic32_max_get_rlx(&obj, VUINT32_MAX);
    assert(cur == VUINT32_MAX);
    vuint32_t val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    /* test no write */
    cur = vatomic32_max_get_rlx(&obj, (vuint32_t)1);
    assert(cur == VUINT32_MAX);
    val = vatomic32_read(&obj);
    assert(val == VUINT32_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic32_and
 *****************************************************************************/
static inline void
ut_atomic_u32_and(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic32_and(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_and_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic32_and_rel(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_and_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic32_and_rlx(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_and
 *****************************************************************************/
static inline void
ut_atomic_u32_get_and(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic32_get_and(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_and_get
 *****************************************************************************/
static inline void
ut_atomic_u32_and_get(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic32_and_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_and_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_and_acq(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic32_get_and_acq(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_and_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_and_get_acq(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic32_and_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_and_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic32_get_and_rel(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_and_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_and_get_rel(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic32_and_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_and_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic32_get_and_rlx(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_and_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_and_get_rlx(void)
{
    vatomic32_t obj = {VUINT32_MAX};
    vuint32_t mask  = VUINT32_MAX;
    vuint32_t ref   = VUINT32_MAX;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic32_and_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or
 *****************************************************************************/
static inline void
ut_atomic_u32_or(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic32_or(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_or_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic32_or_rel(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_or_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic32_or_rlx(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_or
 *****************************************************************************/
static inline void
ut_atomic_u32_get_or(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic32_get_or(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get
 *****************************************************************************/
static inline void
ut_atomic_u32_or_get(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic32_or_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_or_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_or_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic32_get_or_acq(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_or_get_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic32_or_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_or_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic32_get_or_rel(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_or_get_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic32_or_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_or_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic32_get_or_rlx(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_or_get_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic32_or_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_xor
 *****************************************************************************/
static inline void
ut_atomic_u32_xor(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic32_xor(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_xor_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic32_xor_rel(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_xor_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic32_xor_rlx(&obj, mask);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_xor
 *****************************************************************************/
static inline void
ut_atomic_u32_get_xor(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic32_get_xor(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get
 *****************************************************************************/
static inline void
ut_atomic_u32_xor_get(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic32_xor_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_xor_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_get_xor_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic32_get_xor_acq(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u32_xor_get_acq(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic32_xor_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_get_xor_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic32_get_xor_rel(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u32_xor_get_rel(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic32_xor_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_get_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_get_xor_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0x33;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;
    vuint32_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic32_get_xor_rlx(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic32_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u32_xor_get_rlx(void)
{
    vatomic32_t obj = {(vuint32_t)1};
    vuint32_t mask  = 0xFF;
    vuint32_t ref   = (vuint32_t)1;
    vuint32_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint32_t); i++) {
        mask = (vuint32_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic32_xor_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic32_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    ut_atomic_u32_read();
    ut_atomic_u32_read_acq();
    ut_atomic_u32_read_rlx();

    ut_atomic_u32_init();

    ut_atomic_u32_write();
    ut_atomic_u32_write_rel();
    ut_atomic_u32_write_rlx();

    ut_atomic_u32_xchg();
    ut_atomic_u32_xchg_acq();
    ut_atomic_u32_xchg_rel();
    ut_atomic_u32_xchg_rlx();

    ut_atomic_u32_cmpxchg();
    ut_atomic_u32_cmpxchg_acq();
    ut_atomic_u32_cmpxchg_rel();
    ut_atomic_u32_cmpxchg_rlx();

    ut_atomic_u32_add();
    ut_atomic_u32_add_rel();
    ut_atomic_u32_add_rlx();
    ut_atomic_u32_get_add();
    ut_atomic_u32_add_get();
    ut_atomic_u32_get_add_acq();
    ut_atomic_u32_add_get_acq();
    ut_atomic_u32_get_add_rel();
    ut_atomic_u32_add_get_rel();
    ut_atomic_u32_get_add_rlx();
    ut_atomic_u32_add_get_rlx();

    ut_atomic_u32_inc();
    ut_atomic_u32_inc_rel();
    ut_atomic_u32_inc_rlx();
    ut_atomic_u32_get_inc();
    ut_atomic_u32_inc_get();
    ut_atomic_u32_get_inc_acq();
    ut_atomic_u32_inc_get_acq();
    ut_atomic_u32_get_inc_rel();
    ut_atomic_u32_inc_get_rel();
    ut_atomic_u32_get_inc_rlx();
    ut_atomic_u32_inc_get_rlx();

    ut_atomic_u32_sub();
    ut_atomic_u32_sub_rel();
    ut_atomic_u32_sub_rlx();
    ut_atomic_u32_get_sub();
    ut_atomic_u32_sub_get();
    ut_atomic_u32_get_sub_acq();
    ut_atomic_u32_sub_get_acq();
    ut_atomic_u32_get_sub_rel();
    ut_atomic_u32_sub_get_rel();
    ut_atomic_u32_get_sub_rlx();
    ut_atomic_u32_sub_get_rlx();

    ut_atomic_u32_dec();
    ut_atomic_u32_dec_rel();
    ut_atomic_u32_dec_rlx();
    ut_atomic_u32_get_dec();
    ut_atomic_u32_dec_get();
    ut_atomic_u32_get_dec_acq();
    ut_atomic_u32_dec_get_acq();
    ut_atomic_u32_get_dec_rel();
    ut_atomic_u32_dec_get_rel();
    ut_atomic_u32_get_dec_rlx();
    ut_atomic_u32_dec_get_rlx();

    ut_atomic_u32_max();
    ut_atomic_u32_max_rel();
    ut_atomic_u32_max_rlx();
    ut_atomic_u32_get_max();
    ut_atomic_u32_max_get();
    ut_atomic_u32_get_max_acq();
    ut_atomic_u32_max_get_acq();
    ut_atomic_u32_get_max_rel();
    ut_atomic_u32_max_get_rel();
    ut_atomic_u32_get_max_rlx();
    ut_atomic_u32_max_get_rlx();

    ut_atomic_u32_and();
    ut_atomic_u32_and_rel();
    ut_atomic_u32_and_rlx();
    ut_atomic_u32_get_and();
    ut_atomic_u32_and_get();
    ut_atomic_u32_get_and_acq();
    ut_atomic_u32_and_get_acq();
    ut_atomic_u32_get_and_rel();
    ut_atomic_u32_and_get_rel();
    ut_atomic_u32_get_and_rlx();
    ut_atomic_u32_and_get_rlx();

    ut_atomic_u32_or();
    ut_atomic_u32_or_rel();
    ut_atomic_u32_or_rlx();
    ut_atomic_u32_get_or();
    ut_atomic_u32_or_get();
    ut_atomic_u32_get_or_acq();
    ut_atomic_u32_or_get_acq();
    ut_atomic_u32_get_or_rel();
    ut_atomic_u32_or_get_rel();
    ut_atomic_u32_get_or_rlx();
    ut_atomic_u32_or_get_rlx();

    ut_atomic_u32_xor();
    ut_atomic_u32_xor_rel();
    ut_atomic_u32_xor_rlx();
    ut_atomic_u32_get_xor();
    ut_atomic_u32_xor_get();
    ut_atomic_u32_get_xor_acq();
    ut_atomic_u32_xor_get_acq();
    ut_atomic_u32_get_xor_rel();
    ut_atomic_u32_xor_get_rel();
    ut_atomic_u32_get_xor_rlx();
    ut_atomic_u32_xor_get_rlx();
    return 0;
}
