/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <pthread.h>
#include <assert.h>
#include <vsync/atomic.h>
/* keep number of threads even */
#define MAX_THREADS 10
#ifndef IS_EVEN
    #define IS_EVEN(_v_) (((_v_)&1U) == 0U)
#endif
vatomicptr_t g_shared;
/*****************************************************************************
 * Multi-thread Test: vatomicptr_await_eq
 *****************************************************************************/
static inline void *
mt_atomic_ptr_await_eq_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    (void)vatomicptr_await_eq(
        &g_shared, (void *)(vuintptr_t)(VUINTPTR_MAX + (vuintptr_t)tid));
    vatomicptr_write(&g_shared,
                     (void *)(vuintptr_t)(VUINTPTR_MAX + (vuintptr_t)tid + 1U));
    return NULL;
}
static inline void
mt_atomic_ptr_await_eq(void)
{
    vatomicptr_init(&g_shared, (void *)(vuintptr_t)VUINTPTR_MAX);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_ptr_await_eq_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    void *cur = vatomicptr_read(&g_shared);
    assert(cur == (void *)(vuintptr_t)(VUINTPTR_MAX + MAX_THREADS));
    V_UNUSED(cur);
}
/*****************************************************************************
 * Multi-thread Test: vatomicptr_await_eq_set
 *****************************************************************************/
static inline void *
mt_atomic_ptr_await_eq_set_run(void *args)
{
    vsize_t tid     = (vsize_t)(vuintptr_t)args;
    void *await_val = (void *)(vuintptr_t)(VUINTPTR_MAX + (vuintptr_t)tid);
    void *new_val = (void *)(vuintptr_t)((VUINTPTR_MAX + (vuintptr_t)tid + 1));
    (void)vatomicptr_await_eq_set(&g_shared, await_val, new_val);
    return NULL;
}
static inline void
mt_atomic_ptr_await_eq_set(void)
{
    vatomicptr_init(&g_shared, (void *)(vuintptr_t)VUINTPTR_MAX);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_ptr_await_eq_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    void *cur = vatomicptr_read(&g_shared);
    assert(cur == (void *)(vuintptr_t)(VUINTPTR_MAX + MAX_THREADS));
    V_UNUSED(cur);
}
/*****************************************************************************
 * Multi-thread Test: vatomicptr_await_neq
 *****************************************************************************/
static inline void *
mt_atomic_ptr_await_neq_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (tid == 0) {
        vatomicptr_write(&g_shared, (void *)(vuintptr_t)(VUINTPTR_MAX));
    } else {
        (void)vatomicptr_await_neq(&g_shared, NULL);
    }
    return NULL;
}
static inline void
mt_atomic_ptr_await_neq(void)
{
    vatomicptr_init(&g_shared, NULL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_ptr_await_neq_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    void *cur      = vatomicptr_read(&g_shared);
    void *expected = (void *)(vuintptr_t)(VUINTPTR_MAX);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomicptr_await_neq_set
 *****************************************************************************/
static inline void *
mt_atomic_ptr_await_neq_set_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        (void)vatomicptr_await_neq_set(&g_shared,
                                       (void *)(vuintptr_t)VUINTPTR_MAX,
                                       (void *)(vuintptr_t)VUINTPTR_MAX);
    } else {
        (void)vatomicptr_await_neq_set(&g_shared,
                                       (void *)(vuintptr_t)~VUINTPTR_MAX,
                                       (void *)(vuintptr_t)~VUINTPTR_MAX);
    }
    return NULL;
}
static inline void
mt_atomic_ptr_await_neq_set(void)
{
    vatomicptr_init(&g_shared, (void *)(vuintptr_t)VUINTPTR_MAX);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_ptr_await_neq_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    void *cur      = vatomicptr_read(&g_shared);
    void *expected = (void *)(vuintptr_t)VUINTPTR_MAX;
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    mt_atomic_ptr_await_eq();
    mt_atomic_ptr_await_neq();
    mt_atomic_ptr_await_eq_set();
    mt_atomic_ptr_await_neq_set();

    return 0;
}
