import { defineConfig } from "eslint/config";
import parser from "jsonc-eslint-parser";
import path from "node:path";
import { fileURLToPath } from "node:url";
import js from "@eslint/js";
import { FlatCompat } from "@eslint/eslintrc";

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
const compat = new FlatCompat({
    baseDirectory: __dirname,
    recommendedConfig: js.configs.recommended,
    allConfig: js.configs.all
});

export default defineConfig([{
    extends: compat.extends("eslint:recommended"),

    languageOptions: {
        globals: {
            version: "readonly",
            selectedPlayer: "readonly",
            gameTime: "readonly",
            modList: "readonly",
            difficulty: "readonly",
            mapName: "readonly",
            tilesetType: "readonly",
            baseType: "readonly",
            alliancesType: "readonly",
            powerType: "readonly",
            maxPlayers: "readonly",
            scavengers: "readonly",
            mapWidth: "readonly",
            mapHeight: "readonly",
            scavengerPlayer: "readonly",
            isMultiplayer: "readonly",
            challenge: "readonly",
            idleTime: "readonly",
            me: "readonly",
            scriptName: "readonly",
            scriptPath: "readonly",
            groupSizes: "readonly",
            playerData: "readonly",
            derrickPositions: "readonly",
            startPositions: "readonly",
            Stats: "readonly",
            MapTiles: "readonly",
            Upgrades: "writable",
            TER_WATER: "readonly",
            TER_CLIFFFACE: "readonly",
            WEATHER_RAIN: "readonly",
            WEATHER_SNOW: "readonly",
            WEATHER_CLEAR: "readonly",
            DORDER_STOP: "readonly",
            DORDER_MOVE: "readonly",
            DORDER_ATTACK: "readonly",
            DORDER_BUILD: "readonly",
            DORDER_HELPBUILD: "readonly",
            DORDER_LINEBUILD: "readonly",
            DORDER_DEMOLISH: "readonly",
            DORDER_REPAIR: "readonly",
            DORDER_OBSERVE: "readonly",
            DORDER_FIRESUPPORT: "readonly",
            DORDER_RTB: "readonly",
            DORDER_RTR: "readonly",
            DORDER_EMBARK: "readonly",
            DORDER_DISEMBARK: "readonly",
            DORDER_COMMANDERSUPPORT: "readonly",
            DORDER_RECYCLE: "readonly",
            DORDER_SCOUT: "readonly",
            DORDER_PATROL: "readonly",
            DORDER_REARM: "readonly",
            DORDER_RECOVER: "readonly",
            DORDER_HOLD: "readonly",
            BUILD: "readonly",
            MANUFACTURE: "readonly",
            RESEARCH: "readonly",
            INTELMAP: "readonly",
            DESIGN: "readonly",
            CANCEL: "readonly",
            COMMAND: "readonly",
            CAMP_CLEAN: "readonly",
            CAMP_BASE: "readonly",
            CAMP_WALLS: "readonly",
            NO_ALLIANCES: "readonly",
            ALLIANCES: "readonly",
            ALLIANCES_TEAMS: "readonly",
            ALLIANCES_UNSHARED: "readonly",
            NO_SCAVENGERS: "readonly",
            SCAVENGERS: "readonly",
            ULTIMATE_SCAVENGERS: "readonly",
            BEING_BUILT: "readonly",
            BUILT: "readonly",
            DROID_WEAPON: "readonly",
            DROID_SENSOR: "readonly",
            DROID_ECM: "readonly",
            DROID_CONSTRUCT: "readonly",
            DROID_PERSON: "readonly",
            DROID_CYBORG: "readonly",
            DROID_TRANSPORTER: "readonly",
            DROID_COMMAND: "readonly",
            DROID_REPAIR: "readonly",
            DROID_SUPERTRANSPORTER: "readonly",
            DROID_ANY: "readonly",
            ARTIFACT: "readonly",
            OIL_RESOURCE: "readonly",
            BUILDING: "readonly",
            OIL_DRUM: "readonly",
            HQ: "readonly",
            FACTORY: "readonly",
            POWER_GEN: "readonly",
            RESOURCE_EXTRACTOR: "readonly",
            DEFENSE: "readonly",
            WALL: "readonly",
            RESEARCH_LAB: "readonly",
            REPAIR_FACILITY: "readonly",
            COMMAND_CONTROL: "readonly",
            CYBORG_FACTORY: "readonly",
            VTOL_FACTORY: "readonly",
            REARM_PAD: "readonly",
            SAT_UPLINK: "readonly",
            GATE: "readonly",
            LASSAT: "readonly",
            SUPEREASY: "readonly",
            EASY: "readonly",
            MEDIUM: "readonly",
            HARD: "readonly",
            INSANE: "readonly",
            ALL_PLAYERS: "readonly",
            ALLIES: "readonly",
            ENEMIES: "readonly",
            DROID: "readonly",
            STRUCTURE: "readonly",
            FEATURE: "readonly",
            POSITION: "readonly",
            AREA: "readonly",
            PLAYER_DATA: "readonly",
            RESEARCH_DATA: "readonly",
            GROUP: "readonly",
            RADIUS: "readonly",
            LZ_COMPROMISED_TIME: "readonly",
            OBJECT_FLAG_UNSELECTABLE: "readonly",
            RES_MSG: "readonly",
            CAMP_MSG: "readonly",
            MISS_MSG: "readonly",
            PROX_MSG: "readonly",
            LDS_EXPAND_LIMBO: "readonly",
        },

        ecmaVersion: 6,
        sourceType: "script",

        parserOptions: {
            ecmaFeatures: {
                jsx: false,
                globalReturn: false,
            },
        },
    },

    rules: {
        "no-undef": "off",
        "no-fallthrough": "off",
        "no-mixed-spaces-and-tabs": "off",
        "no-console": "error",
        indent: "off",
        semi: "off",
        "no-tabs": "off",
        "no-redeclare": "warn",
        curly: "off",
        "dot-location": "off",
        "getter-return": "error",
        yoda: "off",
        "require-atomic-updates": "error",
        "no-with": "error",
        "no-prototype-builtins": "off",
        "no-misleading-character-class": "error",
        "no-unused-vars": "off",
        "no-cond-assign": ["error", "always"],
        "no-loss-of-precision": "error",
        "no-promise-executor-return": "error",
        "no-unreachable-loop": "error",
        "no-useless-backreference": "error",
        "accessor-pairs": "error",
        "array-callback-return": "error",
        "default-case-last": "error",
        "default-param-last": "error",
        "no-alert": "error",
        "no-eval": "error",
        "no-extra-bind": "error",
        "no-implied-eval": "error",
        "no-invalid-this": "error",
        "no-iterator": "error",
        "no-new": "error",
        "no-new-func": "error",
        "no-octal-escape": "error",
        "no-proto": "error",
        "no-self-compare": "error",
        "no-sequences": "warn",
        "no-throw-literal": "error",
        "no-useless-call": "error",
        "no-void": "error",
    },
}, {
    files: ["**/*.json"],
    extends: compat.extends("plugin:jsonc/recommended-with-json"),

    languageOptions: {
        parser: parser,
        ecmaVersion: 5,
        sourceType: "script",

        parserOptions: {
            jsonSyntax: "JSON",
        },
    },
}, {
    files: ["**/*.jsonc"],
    extends: compat.extends("plugin:jsonc/recommended-with-jsonc"),

    languageOptions: {
        parser: parser,
        ecmaVersion: 5,
        sourceType: "script",

        parserOptions: {
            jsonSyntax: "JSONC",
        },
    },
}, {
    files: ["**/*.json5"],
    extends: compat.extends("plugin:jsonc/recommended-with-json5"),

    languageOptions: {
        parser: parser,
        ecmaVersion: 5,
        sourceType: "script",

        parserOptions: {
            jsonSyntax: "JSON5",
        },
    },
}]);