/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Iterator;
import java.util.Map;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetObject
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.m_args.remove(0), "object ID");
        ObjectReference oRef = this.m_debugger.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        Map<Field, Value> fieldValues = oRef.getValues(oRef.referenceType().visibleFields());
        Iterator<Value> iter = fieldValues.values().iterator();
        while (iter.hasNext()) {
            Value value = iter.next();
            if (!(value instanceof ObjectReference)) continue;
            this.m_debugger.getStore().put((ObjectReference)value);
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, Rep.getObjectRep(oRef, true), true);
    }

    public Object clone() {
        return new GetObject();
    }
}

