/* window-monitor.c generated by valac 0.56.17, the Vala compiler
 * generated from window-monitor.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2024-2025  Arthur Demchenkov <spinal.by@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define XNP_WINDOW_MONITOR_CREATED G_FILE_MONITOR_EVENT_CREATED
#define XNP_WINDOW_MONITOR_CHANGES_DONE_HINT G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define XNP_WINDOW_MONITOR_TYPE_FILE_EVENT (xnp_window_monitor_file_event_get_type ())
typedef struct _XnpWindowMonitorFileEvent XnpWindowMonitorFileEvent;
enum  {
	XNP_WINDOW_MONITOR_0_PROPERTY,
	XNP_WINDOW_MONITOR_NUM_PROPERTIES
};
static GParamSpec* xnp_window_monitor_properties[XNP_WINDOW_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	XNP_WINDOW_MONITOR_NOTE_UPDATED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_DELETED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_CREATED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_RENAMED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL,
	XNP_WINDOW_MONITOR_NUM_SIGNALS
};
static guint xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NUM_SIGNALS] = {0};

struct _XnpWindowMonitorFileEvent {
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event;
};

struct _XnpWindowMonitorPrivate {
	GFileMonitor* monitor;
	guint src_external;
	guint src_internal;
	gboolean skip;
	XnpWindowMonitorFileEvent* events;
	gint events_length1;
	gint _events_size_;
	XnpWindowMonitorFileEvent dummy;
};

static gint XnpWindowMonitor_private_offset;
static gpointer xnp_window_monitor_parent_class = NULL;

static GType xnp_window_monitor_file_event_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static XnpWindowMonitorFileEvent* xnp_window_monitor_file_event_dup (const XnpWindowMonitorFileEvent* self);
static void xnp_window_monitor_file_event_free (XnpWindowMonitorFileEvent* self);
static void xnp_window_monitor_file_event_copy (const XnpWindowMonitorFileEvent* self,
                                         XnpWindowMonitorFileEvent* dest);
static void xnp_window_monitor_file_event_destroy (XnpWindowMonitorFileEvent* self);
static void _vala_XnpWindowMonitorFileEvent_array_free (XnpWindowMonitorFileEvent * array,
                                                 gssize array_length);
static void xnp_window_monitor_file_event_init (XnpWindowMonitorFileEvent *self,
                                         GFile* file,
                                         GFile* other_file,
                                         GFileMonitorEvent event);
static void xnp_window_monitor_monitor_change_cb (XnpWindowMonitor* self,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event);
static void _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self);
static void _vala_array_add1 (XnpWindowMonitorFileEvent* * array,
                       gint* length,
                       gint* size,
                       const XnpWindowMonitorFileEvent* value);
static gboolean __lambda5_ (XnpWindowMonitor* self);
static void xnp_window_monitor_optimize_events (XnpWindowMonitor* self);
static void xnp_window_monitor_process_events (XnpWindowMonitor* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean __lambda6_ (XnpWindowMonitor* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void xnp_window_monitor_optimize_event_created (XnpWindowMonitor* self,
                                                gint n);
static void xnp_window_monitor_optimize_event_deleted (XnpWindowMonitor* self,
                                                gint n);
static void xnp_window_monitor_optimize_event_renamed (XnpWindowMonitor* self,
                                                gint n);
static gboolean _xnp_window_monitor_file_event_equal (const XnpWindowMonitorFileEvent * s1,
                                               const XnpWindowMonitorFileEvent * s2);
static void _vala_array_add2 (XnpWindowMonitorFileEvent* * array,
                       gint* length,
                       gint* size,
                       const XnpWindowMonitorFileEvent* value);
static XnpWindowMonitorFileEvent* _vala_array_dup1 (XnpWindowMonitorFileEvent* self,
                                             gssize length);
static void _vala_array_add3 (XnpWindowMonitorFileEvent* * array,
                       gint* length,
                       gint* size,
                       const XnpWindowMonitorFileEvent* value);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void xnp_window_monitor_finalize (GObject * obj);
static GType xnp_window_monitor_get_type_once (void);

static inline gpointer
xnp_window_monitor_get_instance_private (XnpWindowMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, XnpWindowMonitor_private_offset);
}

static void
_vala_XnpWindowMonitorFileEvent_array_free (XnpWindowMonitorFileEvent * array,
                                            gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			xnp_window_monitor_file_event_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_xnp_window_monitor_monitor_change_cb_g_file_monitor_changed (GFileMonitor* _sender,
                                                              GFile* file,
                                                              GFile* other_file,
                                                              GFileMonitorEvent event_type,
                                                              gpointer self)
{
	xnp_window_monitor_monitor_change_cb ((XnpWindowMonitor*) self, file, other_file, event_type);
}

XnpWindowMonitor*
xnp_window_monitor_construct (GType object_type,
                              GFile* path)
{
	XnpWindowMonitor * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (XnpWindowMonitor*) g_object_new (object_type, NULL);
	{
		GFileMonitor* _tmp0_ = NULL;
		GFileMonitor* _tmp1_;
		GFileMonitor* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		_tmp1_ = g_file_monitor_directory (path, G_FILE_MONITOR_WATCH_MOVES, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp2_;
		_tmp3_ = self->priv->monitor;
		g_file_monitor_set_rate_limit (_tmp3_, 1000);
		_tmp4_ = self->priv->monitor;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_message ("window-monitor.vala:59: Unable to create a directory monitor: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

XnpWindowMonitor*
xnp_window_monitor_new (GFile* path)
{
	return xnp_window_monitor_construct (XNP_TYPE_WINDOW_MONITOR, path);
}

static void
_vala_array_add1 (XnpWindowMonitorFileEvent* * array,
                  gint* length,
                  gint* size,
                  const XnpWindowMonitorFileEvent* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XnpWindowMonitorFileEvent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static gboolean
__lambda5_ (XnpWindowMonitor* self)
{
	XnpWindowMonitorFileEvent* _tmp0_;
	gboolean result;
	xnp_window_monitor_optimize_events (self);
	xnp_window_monitor_process_events (self);
	self->priv->src_external = (guint) 0;
	_tmp0_ = g_new0 (XnpWindowMonitorFileEvent, 0);
	self->priv->events = (_vala_XnpWindowMonitorFileEvent_array_free (self->priv->events, self->priv->events_length1), NULL);
	self->priv->events = _tmp0_;
	self->priv->events_length1 = 0;
	self->priv->_events_size_ = self->priv->events_length1;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((XnpWindowMonitor*) self);
	return result;
}

static void
xnp_window_monitor_monitor_change_cb (XnpWindowMonitor* self,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event)
{
	XnpWindowMonitorFileEvent _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (self->priv->skip) {
		return;
	}
	xnp_window_monitor_file_event_init (&_tmp0_, file, other_file, event);
	_vala_array_add1 (&self->priv->events, &self->priv->events_length1, &self->priv->_events_size_, &_tmp0_);
	if (self->priv->src_external != ((guint) 0)) {
		g_source_remove (self->priv->src_external);
	}
	self->priv->src_external = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
}

static void
xnp_window_monitor_process_events (XnpWindowMonitor* self)
{
	XnpWindowMonitorFileEvent* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->events;
	_tmp0__length1 = self->priv->events_length1;
	{
		XnpWindowMonitorFileEvent* ev_collection = NULL;
		gint ev_collection_length1 = 0;
		gint _ev_collection_size_ = 0;
		gint ev_it = 0;
		ev_collection = _tmp0_;
		ev_collection_length1 = _tmp0__length1;
		for (ev_it = 0; ev_it < ev_collection_length1; ev_it = ev_it + 1) {
			XnpWindowMonitorFileEvent _tmp1_;
			XnpWindowMonitorFileEvent _tmp2_ = {0};
			XnpWindowMonitorFileEvent ev = {0};
			_tmp1_ = ev_collection[ev_it];
			xnp_window_monitor_file_event_copy (&_tmp1_, &_tmp2_);
			ev = _tmp2_;
			{
				gchar* note_name = NULL;
				XnpWindowMonitorFileEvent _tmp3_;
				GFile* _tmp4_;
				gchar* _tmp5_;
				XnpWindowMonitorFileEvent _tmp6_;
				_tmp3_ = ev;
				_tmp4_ = _tmp3_.file;
				_tmp5_ = g_file_get_basename (_tmp4_);
				note_name = _tmp5_;
				_tmp6_ = ev;
				switch (_tmp6_.event) {
					case XNP_WINDOW_MONITOR_CHANGES_DONE_HINT:
					{
						const gchar* _tmp7_;
						_tmp7_ = note_name;
						g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_UPDATED_SIGNAL], 0, _tmp7_);
						break;
					}
					case G_FILE_MONITOR_EVENT_DELETED:
					case G_FILE_MONITOR_EVENT_MOVED_OUT:
					{
						const gchar* _tmp8_;
						_tmp8_ = note_name;
						g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_DELETED_SIGNAL], 0, _tmp8_);
						break;
					}
					case XNP_WINDOW_MONITOR_CREATED:
					case G_FILE_MONITOR_EVENT_MOVED_IN:
					{
						const gchar* _tmp9_;
						_tmp9_ = note_name;
						g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_CREATED_SIGNAL], 0, _tmp9_);
						break;
					}
					case G_FILE_MONITOR_EVENT_RENAMED:
					{
						const gchar* _tmp10_;
						XnpWindowMonitorFileEvent _tmp11_;
						GFile* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp10_ = note_name;
						_tmp11_ = ev;
						_tmp12_ = _tmp11_.other_file;
						_tmp13_ = g_file_get_basename (_tmp12_);
						_tmp14_ = _tmp13_;
						g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_RENAMED_SIGNAL], 0, _tmp10_, _tmp14_);
						_g_free0 (_tmp14_);
						break;
					}
					default:
					{
						break;
					}
				}
				_g_free0 (note_name);
				xnp_window_monitor_file_event_destroy (&ev);
			}
		}
	}
}

static gboolean
__lambda6_ (XnpWindowMonitor* self)
{
	gboolean result;
	self->priv->skip = FALSE;
	self->priv->src_internal = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((XnpWindowMonitor*) self);
	return result;
}

void
xnp_window_monitor_internal_change (XnpWindowMonitor* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->src_internal != ((guint) 0)) {
		g_source_remove (self->priv->src_internal);
	}
	self->priv->skip = TRUE;
	self->priv->src_internal = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
_xnp_window_monitor_file_event_equal (const XnpWindowMonitorFileEvent * s1,
                                      const XnpWindowMonitorFileEvent * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->file != s2->file) {
		return FALSE;
	}
	if (s1->other_file != s2->other_file) {
		return FALSE;
	}
	if (s1->event != s2->event) {
		return FALSE;
	}
	return TRUE;
}

static void
_vala_array_add2 (XnpWindowMonitorFileEvent* * array,
                  gint* length,
                  gint* size,
                  const XnpWindowMonitorFileEvent* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XnpWindowMonitorFileEvent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static XnpWindowMonitorFileEvent*
_vala_array_dup1 (XnpWindowMonitorFileEvent* self,
                  gssize length)
{
	if (length > 0) {
		XnpWindowMonitorFileEvent* result;
		gssize i;
		result = g_new0 (XnpWindowMonitorFileEvent, length);
		for (i = 0; i < length; i++) {
			XnpWindowMonitorFileEvent _tmp0_;
			XnpWindowMonitorFileEvent _tmp1_ = {0};
			_tmp0_ = self[i];
			xnp_window_monitor_file_event_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static void
xnp_window_monitor_optimize_events (XnpWindowMonitor* self)
{
	XnpWindowMonitorFileEvent* new_events = NULL;
	XnpWindowMonitorFileEvent* _tmp9_;
	gint new_events_length1;
	gint _new_events_size_;
	XnpWindowMonitorFileEvent* _tmp10_;
	gint _tmp10__length1;
	XnpWindowMonitorFileEvent* _tmp18_;
	gint _tmp18__length1;
	XnpWindowMonitorFileEvent* _tmp19_;
	gint _tmp19__length1;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				XnpWindowMonitorFileEvent* _tmp2_;
				gint _tmp2__length1;
				XnpWindowMonitorFileEvent* _tmp3_;
				gint _tmp3__length1;
				XnpWindowMonitorFileEvent _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->events;
				_tmp2__length1 = self->priv->events_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->events;
				_tmp3__length1 = self->priv->events_length1;
				_tmp4_ = _tmp3_[i];
				switch (_tmp4_.event) {
					case XNP_WINDOW_MONITOR_CREATED:
					case G_FILE_MONITOR_EVENT_MOVED_IN:
					case XNP_WINDOW_MONITOR_CHANGES_DONE_HINT:
					{
						xnp_window_monitor_optimize_event_created (self, i);
						break;
					}
					case G_FILE_MONITOR_EVENT_DELETED:
					case G_FILE_MONITOR_EVENT_MOVED_OUT:
					{
						xnp_window_monitor_optimize_event_deleted (self, i);
						break;
					}
					case G_FILE_MONITOR_EVENT_RENAMED:
					{
						xnp_window_monitor_optimize_event_renamed (self, i);
						break;
					}
					default:
					{
						XnpWindowMonitorFileEvent* _tmp5_;
						gint _tmp5__length1;
						XnpWindowMonitorFileEvent _tmp6_;
						XnpWindowMonitorFileEvent _tmp7_;
						XnpWindowMonitorFileEvent _tmp8_ = {0};
						_tmp5_ = self->priv->events;
						_tmp5__length1 = self->priv->events_length1;
						_tmp6_ = self->priv->dummy;
						_tmp7_ = _tmp6_;
						xnp_window_monitor_file_event_copy (&_tmp7_, &_tmp8_);
						xnp_window_monitor_file_event_destroy (&_tmp5_[i]);
						_tmp5_[i] = _tmp8_;
						break;
					}
				}
			}
		}
	}
	_tmp9_ = g_new0 (XnpWindowMonitorFileEvent, 0);
	new_events = _tmp9_;
	new_events_length1 = 0;
	_new_events_size_ = new_events_length1;
	_tmp10_ = self->priv->events;
	_tmp10__length1 = self->priv->events_length1;
	{
		XnpWindowMonitorFileEvent* ev_collection = NULL;
		gint ev_collection_length1 = 0;
		gint _ev_collection_size_ = 0;
		gint ev_it = 0;
		ev_collection = _tmp10_;
		ev_collection_length1 = _tmp10__length1;
		for (ev_it = 0; ev_it < ev_collection_length1; ev_it = ev_it + 1) {
			XnpWindowMonitorFileEvent _tmp11_;
			XnpWindowMonitorFileEvent _tmp12_ = {0};
			XnpWindowMonitorFileEvent ev = {0};
			_tmp11_ = ev_collection[ev_it];
			xnp_window_monitor_file_event_copy (&_tmp11_, &_tmp12_);
			ev = _tmp12_;
			{
				XnpWindowMonitorFileEvent _tmp13_;
				XnpWindowMonitorFileEvent _tmp14_;
				_tmp13_ = ev;
				_tmp14_ = self->priv->dummy;
				if (_xnp_window_monitor_file_event_equal (&_tmp13_, &_tmp14_) != TRUE) {
					XnpWindowMonitorFileEvent _tmp15_;
					XnpWindowMonitorFileEvent _tmp16_;
					XnpWindowMonitorFileEvent _tmp17_ = {0};
					_tmp15_ = ev;
					_tmp16_ = _tmp15_;
					xnp_window_monitor_file_event_copy (&_tmp16_, &_tmp17_);
					_vala_array_add2 (&new_events, &new_events_length1, &_new_events_size_, &_tmp17_);
				}
				xnp_window_monitor_file_event_destroy (&ev);
			}
		}
	}
	_tmp18_ = new_events;
	_tmp18__length1 = new_events_length1;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup1 (_tmp18_, _tmp18__length1) : _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	self->priv->events = (_vala_XnpWindowMonitorFileEvent_array_free (self->priv->events, self->priv->events_length1), NULL);
	self->priv->events = _tmp19_;
	self->priv->events_length1 = _tmp19__length1;
	self->priv->_events_size_ = self->priv->events_length1;
	new_events = (_vala_XnpWindowMonitorFileEvent_array_free (new_events, new_events_length1), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
xnp_window_monitor_optimize_event_created (XnpWindowMonitor* self,
                                           gint n)
{
	GFile* file = NULL;
	XnpWindowMonitorFileEvent* _tmp0_;
	gint _tmp0__length1;
	XnpWindowMonitorFileEvent _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFileMonitorEvent _tmp4_ = 0;
	GFile* _tmp5_;
	gboolean _tmp6_ = FALSE;
	XnpWindowMonitorFileEvent* _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->events;
	_tmp0__length1 = self->priv->events_length1;
	_tmp1_ = _tmp0_[n];
	_tmp2_ = _tmp1_.file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	file = _tmp3_;
	_tmp5_ = file;
	g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp5_, &_tmp6_);
	if (_tmp6_) {
		_tmp4_ = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
	} else {
		_tmp4_ = XNP_WINDOW_MONITOR_CREATED;
	}
	_tmp7_ = self->priv->events;
	_tmp7__length1 = self->priv->events_length1;
	_tmp7_[n].event = _tmp4_;
	{
		gint i = 0;
		i = n + 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				XnpWindowMonitorFileEvent* _tmp10_;
				gint _tmp10__length1;
				GFile* _tmp11_;
				XnpWindowMonitorFileEvent* _tmp12_;
				gint _tmp12__length1;
				XnpWindowMonitorFileEvent _tmp13_;
				GFile* _tmp14_;
				XnpWindowMonitorFileEvent* _tmp15_;
				gint _tmp15__length1;
				XnpWindowMonitorFileEvent _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = self->priv->events;
				_tmp10__length1 = self->priv->events_length1;
				if (!(i < _tmp10__length1)) {
					break;
				}
				_tmp11_ = file;
				_tmp12_ = self->priv->events;
				_tmp12__length1 = self->priv->events_length1;
				_tmp13_ = _tmp12_[i];
				_tmp14_ = _tmp13_.file;
				if (!g_file_equal (_tmp11_, _tmp14_)) {
					continue;
				}
				_tmp15_ = self->priv->events;
				_tmp15__length1 = self->priv->events_length1;
				_tmp16_ = _tmp15_[i];
				switch (_tmp16_.event) {
					case G_FILE_MONITOR_EVENT_DELETED:
					case G_FILE_MONITOR_EVENT_MOVED_OUT:
					{
						XnpWindowMonitorFileEvent* _tmp17_;
						gint _tmp17__length1;
						XnpWindowMonitorFileEvent _tmp18_;
						XnpWindowMonitorFileEvent* _tmp23_;
						gint _tmp23__length1;
						XnpWindowMonitorFileEvent _tmp24_;
						XnpWindowMonitorFileEvent _tmp25_;
						XnpWindowMonitorFileEvent _tmp26_ = {0};
						_tmp17_ = self->priv->events;
						_tmp17__length1 = self->priv->events_length1;
						_tmp18_ = _tmp17_[n];
						if (_tmp18_.event == XNP_WINDOW_MONITOR_CREATED) {
							XnpWindowMonitorFileEvent* _tmp19_;
							gint _tmp19__length1;
							XnpWindowMonitorFileEvent _tmp20_;
							XnpWindowMonitorFileEvent _tmp21_;
							XnpWindowMonitorFileEvent _tmp22_ = {0};
							_tmp19_ = self->priv->events;
							_tmp19__length1 = self->priv->events_length1;
							_tmp20_ = self->priv->dummy;
							_tmp21_ = _tmp20_;
							xnp_window_monitor_file_event_copy (&_tmp21_, &_tmp22_);
							xnp_window_monitor_file_event_destroy (&_tmp19_[i]);
							_tmp19_[i] = _tmp22_;
						}
						_tmp23_ = self->priv->events;
						_tmp23__length1 = self->priv->events_length1;
						_tmp24_ = self->priv->dummy;
						_tmp25_ = _tmp24_;
						xnp_window_monitor_file_event_copy (&_tmp25_, &_tmp26_);
						xnp_window_monitor_file_event_destroy (&_tmp23_[n]);
						_tmp23_[n] = _tmp26_;
						_g_object_unref0 (file);
						return;
					}
					case XNP_WINDOW_MONITOR_CHANGES_DONE_HINT:
					{
						XnpWindowMonitorFileEvent* _tmp27_;
						gint _tmp27__length1;
						XnpWindowMonitorFileEvent* _tmp28_;
						gint _tmp28__length1;
						XnpWindowMonitorFileEvent _tmp29_;
						XnpWindowMonitorFileEvent _tmp30_;
						XnpWindowMonitorFileEvent _tmp31_ = {0};
						XnpWindowMonitorFileEvent* _tmp32_;
						gint _tmp32__length1;
						XnpWindowMonitorFileEvent _tmp33_;
						XnpWindowMonitorFileEvent _tmp34_;
						XnpWindowMonitorFileEvent _tmp35_ = {0};
						_tmp27_ = self->priv->events;
						_tmp27__length1 = self->priv->events_length1;
						_tmp28_ = self->priv->events;
						_tmp28__length1 = self->priv->events_length1;
						_tmp29_ = _tmp28_[n];
						_tmp30_ = _tmp29_;
						xnp_window_monitor_file_event_copy (&_tmp30_, &_tmp31_);
						xnp_window_monitor_file_event_destroy (&_tmp27_[i]);
						_tmp27_[i] = _tmp31_;
						_tmp32_ = self->priv->events;
						_tmp32__length1 = self->priv->events_length1;
						_tmp33_ = self->priv->dummy;
						_tmp34_ = _tmp33_;
						xnp_window_monitor_file_event_copy (&_tmp34_, &_tmp35_);
						xnp_window_monitor_file_event_destroy (&_tmp32_[n]);
						_tmp32_[n] = _tmp35_;
						n = i;
						break;
					}
					case G_FILE_MONITOR_EVENT_RENAMED:
					{
						GFile* other_file = NULL;
						XnpWindowMonitorFileEvent* _tmp36_;
						gint _tmp36__length1;
						XnpWindowMonitorFileEvent _tmp37_;
						GFile* _tmp38_;
						GFile* _tmp39_;
						XnpWindowMonitorFileEvent* _tmp40_;
						gint _tmp40__length1;
						XnpWindowMonitorFileEvent _tmp41_;
						XnpWindowMonitorFileEvent* _tmp56_;
						gint _tmp56__length1;
						GFile* _tmp57_;
						GFile* _tmp58_;
						XnpWindowMonitorFileEvent* _tmp59_;
						gint _tmp59__length1;
						_tmp36_ = self->priv->events;
						_tmp36__length1 = self->priv->events_length1;
						_tmp37_ = _tmp36_[i];
						_tmp38_ = _tmp37_.other_file;
						_tmp39_ = _g_object_ref0 (_tmp38_);
						other_file = _tmp39_;
						_tmp40_ = self->priv->events;
						_tmp40__length1 = self->priv->events_length1;
						_tmp41_ = _tmp40_[n];
						if (_tmp41_.event == XNP_WINDOW_MONITOR_CREATED) {
							XnpWindowMonitorFileEvent* _tmp42_;
							gint _tmp42__length1;
							XnpWindowMonitorFileEvent _tmp43_;
							XnpWindowMonitorFileEvent _tmp44_;
							XnpWindowMonitorFileEvent _tmp45_ = {0};
							GFileMonitorEvent _tmp46_ = 0;
							GFile* _tmp47_;
							gboolean _tmp48_ = FALSE;
							XnpWindowMonitorFileEvent* _tmp49_;
							gint _tmp49__length1;
							_tmp42_ = self->priv->events;
							_tmp42__length1 = self->priv->events_length1;
							_tmp43_ = self->priv->dummy;
							_tmp44_ = _tmp43_;
							xnp_window_monitor_file_event_copy (&_tmp44_, &_tmp45_);
							xnp_window_monitor_file_event_destroy (&_tmp42_[n]);
							_tmp42_[n] = _tmp45_;
							_tmp47_ = other_file;
							g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp47_, &_tmp48_);
							if (_tmp48_) {
								_tmp46_ = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
							} else {
								_tmp46_ = XNP_WINDOW_MONITOR_CREATED;
							}
							_tmp49_ = self->priv->events;
							_tmp49__length1 = self->priv->events_length1;
							_tmp49_[i].event = _tmp46_;
						} else {
							XnpWindowMonitorFileEvent* _tmp50_;
							gint _tmp50__length1;
							XnpWindowMonitorFileEvent* _tmp51_;
							gint _tmp51__length1;
							XnpWindowMonitorFileEvent _tmp52_;
							XnpWindowMonitorFileEvent _tmp53_;
							XnpWindowMonitorFileEvent _tmp54_ = {0};
							XnpWindowMonitorFileEvent* _tmp55_;
							gint _tmp55__length1;
							_tmp50_ = self->priv->events;
							_tmp50__length1 = self->priv->events_length1;
							_tmp51_ = self->priv->events;
							_tmp51__length1 = self->priv->events_length1;
							_tmp52_ = _tmp51_[i];
							_tmp53_ = _tmp52_;
							xnp_window_monitor_file_event_copy (&_tmp53_, &_tmp54_);
							xnp_window_monitor_file_event_destroy (&_tmp50_[n]);
							_tmp50_[n] = _tmp54_;
							_tmp55_ = self->priv->events;
							_tmp55__length1 = self->priv->events_length1;
							_tmp55_[i].event = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
						}
						_tmp56_ = self->priv->events;
						_tmp56__length1 = self->priv->events_length1;
						_tmp57_ = other_file;
						_tmp58_ = _g_object_ref0 (_tmp57_);
						_g_object_unref0 (_tmp56_[i].file);
						_tmp56_[i].file = _tmp58_;
						_tmp59_ = self->priv->events;
						_tmp59__length1 = self->priv->events_length1;
						_g_object_unref0 (_tmp59_[i].other_file);
						_tmp59_[i].other_file = NULL;
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					default:
					{
						break;
					}
				}
			}
		}
	}
	_g_object_unref0 (file);
}

static void
xnp_window_monitor_optimize_event_deleted (XnpWindowMonitor* self,
                                           gint n)
{
	GFile* file = NULL;
	XnpWindowMonitorFileEvent* _tmp0_;
	gint _tmp0__length1;
	XnpWindowMonitorFileEvent _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->events;
	_tmp0__length1 = self->priv->events_length1;
	_tmp1_ = _tmp0_[n];
	_tmp2_ = _tmp1_.file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp4_, &_tmp5_);
	if (!_tmp5_) {
		_g_object_unref0 (file);
		return;
	}
	{
		gint i = 0;
		i = n + 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				XnpWindowMonitorFileEvent* _tmp8_;
				gint _tmp8__length1;
				gboolean file_equal = FALSE;
				GFile* _tmp9_;
				XnpWindowMonitorFileEvent* _tmp10_;
				gint _tmp10__length1;
				XnpWindowMonitorFileEvent _tmp11_;
				GFile* _tmp12_;
				GFile* other_file = NULL;
				XnpWindowMonitorFileEvent* _tmp13_;
				gint _tmp13__length1;
				XnpWindowMonitorFileEvent _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				gboolean _tmp17_ = FALSE;
				GFile* _tmp18_;
				gboolean other_file_equal = FALSE;
				gboolean _tmp21_ = FALSE;
				XnpWindowMonitorFileEvent* _tmp22_;
				gint _tmp22__length1;
				XnpWindowMonitorFileEvent _tmp23_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->events;
				_tmp8__length1 = self->priv->events_length1;
				if (!(i < _tmp8__length1)) {
					break;
				}
				_tmp9_ = file;
				_tmp10_ = self->priv->events;
				_tmp10__length1 = self->priv->events_length1;
				_tmp11_ = _tmp10_[i];
				_tmp12_ = _tmp11_.file;
				file_equal = g_file_equal (_tmp9_, _tmp12_);
				_tmp13_ = self->priv->events;
				_tmp13__length1 = self->priv->events_length1;
				_tmp14_ = _tmp13_[i];
				_tmp15_ = _tmp14_.other_file;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				other_file = _tmp16_;
				_tmp18_ = other_file;
				if (_tmp18_ != NULL) {
					GFile* _tmp19_;
					GFile* _tmp20_;
					_tmp19_ = file;
					_tmp20_ = other_file;
					_tmp17_ = g_file_equal (_tmp19_, _tmp20_);
				} else {
					_tmp17_ = FALSE;
				}
				other_file_equal = _tmp17_;
				if (!file_equal) {
					_tmp21_ = !other_file_equal;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					_g_object_unref0 (other_file);
					continue;
				}
				_tmp22_ = self->priv->events;
				_tmp22__length1 = self->priv->events_length1;
				_tmp23_ = _tmp22_[i];
				switch (_tmp23_.event) {
					case XNP_WINDOW_MONITOR_CREATED:
					case G_FILE_MONITOR_EVENT_MOVED_IN:
					{
						XnpWindowMonitorFileEvent* _tmp24_;
						gint _tmp24__length1;
						XnpWindowMonitorFileEvent _tmp25_;
						XnpWindowMonitorFileEvent _tmp26_;
						XnpWindowMonitorFileEvent _tmp27_ = {0};
						XnpWindowMonitorFileEvent* _tmp28_;
						gint _tmp28__length1;
						_tmp24_ = self->priv->events;
						_tmp24__length1 = self->priv->events_length1;
						_tmp25_ = self->priv->dummy;
						_tmp26_ = _tmp25_;
						xnp_window_monitor_file_event_copy (&_tmp26_, &_tmp27_);
						xnp_window_monitor_file_event_destroy (&_tmp24_[n]);
						_tmp24_[n] = _tmp27_;
						_tmp28_ = self->priv->events;
						_tmp28__length1 = self->priv->events_length1;
						_tmp28_[i].event = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					case G_FILE_MONITOR_EVENT_RENAMED:
					{
						XnpWindowMonitorFileEvent* _tmp29_;
						gint _tmp29__length1;
						XnpWindowMonitorFileEvent _tmp30_;
						XnpWindowMonitorFileEvent _tmp31_;
						XnpWindowMonitorFileEvent _tmp32_ = {0};
						XnpWindowMonitorFileEvent* _tmp33_;
						gint _tmp33__length1;
						XnpWindowMonitorFileEvent* _tmp34_;
						gint _tmp34__length1;
						GFile* _tmp35_;
						GFile* _tmp36_;
						XnpWindowMonitorFileEvent* _tmp37_;
						gint _tmp37__length1;
						_tmp29_ = self->priv->events;
						_tmp29__length1 = self->priv->events_length1;
						_tmp30_ = self->priv->dummy;
						_tmp31_ = _tmp30_;
						xnp_window_monitor_file_event_copy (&_tmp31_, &_tmp32_);
						xnp_window_monitor_file_event_destroy (&_tmp29_[n]);
						_tmp29_[n] = _tmp32_;
						_tmp33_ = self->priv->events;
						_tmp33__length1 = self->priv->events_length1;
						_tmp33_[i].event = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
						_tmp34_ = self->priv->events;
						_tmp34__length1 = self->priv->events_length1;
						_tmp35_ = file;
						_tmp36_ = _g_object_ref0 (_tmp35_);
						_g_object_unref0 (_tmp34_[i].file);
						_tmp34_[i].file = _tmp36_;
						_tmp37_ = self->priv->events;
						_tmp37__length1 = self->priv->events_length1;
						_g_object_unref0 (_tmp37_[i].other_file);
						_tmp37_[i].other_file = NULL;
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					default:
					{
						break;
					}
				}
				_g_object_unref0 (other_file);
			}
		}
	}
	_g_object_unref0 (file);
}

static void
_vala_array_add3 (XnpWindowMonitorFileEvent* * array,
                  gint* length,
                  gint* size,
                  const XnpWindowMonitorFileEvent* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XnpWindowMonitorFileEvent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
xnp_window_monitor_optimize_event_renamed (XnpWindowMonitor* self,
                                           gint n)
{
	GFile* file = NULL;
	XnpWindowMonitorFileEvent* _tmp0_;
	gint _tmp0__length1;
	XnpWindowMonitorFileEvent _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* other_file = NULL;
	XnpWindowMonitorFileEvent* _tmp4_;
	gint _tmp4__length1;
	XnpWindowMonitorFileEvent _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->events;
	_tmp0__length1 = self->priv->events_length1;
	_tmp1_ = _tmp0_[n];
	_tmp2_ = _tmp1_.file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	file = _tmp3_;
	_tmp4_ = self->priv->events;
	_tmp4__length1 = self->priv->events_length1;
	_tmp5_ = _tmp4_[n];
	_tmp6_ = _tmp5_.other_file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	other_file = _tmp7_;
	_tmp8_ = other_file;
	g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp8_, &_tmp9_);
	if (_tmp9_) {
		GFile* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = file;
		g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp10_, &_tmp11_);
		if (_tmp11_) {
			XnpWindowMonitorFileEvent* _tmp12_;
			gint _tmp12__length1;
			GFile* _tmp13_;
			XnpWindowMonitorFileEvent _tmp14_ = {0};
			_tmp12_ = self->priv->events;
			_tmp12__length1 = self->priv->events_length1;
			_tmp12_[n].event = G_FILE_MONITOR_EVENT_DELETED;
			_tmp13_ = other_file;
			xnp_window_monitor_file_event_init (&_tmp14_, _tmp13_, NULL, XNP_WINDOW_MONITOR_CHANGES_DONE_HINT);
			_vala_array_add3 (&self->priv->events, &self->priv->events_length1, &self->priv->_events_size_, &_tmp14_);
			xnp_window_monitor_optimize_event_deleted (self, n);
		} else {
			XnpWindowMonitorFileEvent* _tmp15_;
			gint _tmp15__length1;
			XnpWindowMonitorFileEvent* _tmp16_;
			gint _tmp16__length1;
			GFile* _tmp17_;
			GFile* _tmp18_;
			_tmp15_ = self->priv->events;
			_tmp15__length1 = self->priv->events_length1;
			_tmp15_[n].event = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
			_tmp16_ = self->priv->events;
			_tmp16__length1 = self->priv->events_length1;
			_tmp17_ = other_file;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (_tmp16_[n].file);
			_tmp16_[n].file = _tmp18_;
			xnp_window_monitor_optimize_event_created (self, n);
		}
		_g_object_unref0 (other_file);
		_g_object_unref0 (file);
		return;
	}
	{
		gint i = 0;
		i = n + 1;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				XnpWindowMonitorFileEvent* _tmp21_;
				gint _tmp21__length1;
				gboolean _tmp22_ = FALSE;
				GFile* _tmp23_;
				XnpWindowMonitorFileEvent* _tmp24_;
				gint _tmp24__length1;
				XnpWindowMonitorFileEvent _tmp25_;
				GFile* _tmp26_;
				XnpWindowMonitorFileEvent* _tmp31_;
				gint _tmp31__length1;
				XnpWindowMonitorFileEvent _tmp32_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = self->priv->events;
				_tmp21__length1 = self->priv->events_length1;
				if (!(i < _tmp21__length1)) {
					break;
				}
				_tmp23_ = file;
				_tmp24_ = self->priv->events;
				_tmp24__length1 = self->priv->events_length1;
				_tmp25_ = _tmp24_[i];
				_tmp26_ = _tmp25_.file;
				if (!g_file_equal (_tmp23_, _tmp26_)) {
					GFile* _tmp27_;
					XnpWindowMonitorFileEvent* _tmp28_;
					gint _tmp28__length1;
					XnpWindowMonitorFileEvent _tmp29_;
					GFile* _tmp30_;
					_tmp27_ = other_file;
					_tmp28_ = self->priv->events;
					_tmp28__length1 = self->priv->events_length1;
					_tmp29_ = _tmp28_[i];
					_tmp30_ = _tmp29_.file;
					_tmp22_ = !g_file_equal (_tmp27_, _tmp30_);
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					continue;
				}
				_tmp31_ = self->priv->events;
				_tmp31__length1 = self->priv->events_length1;
				_tmp32_ = _tmp31_[i];
				switch (_tmp32_.event) {
					case XNP_WINDOW_MONITOR_CREATED:
					case G_FILE_MONITOR_EVENT_MOVED_IN:
					{
						XnpWindowMonitorFileEvent* _tmp33_;
						gint _tmp33__length1;
						XnpWindowMonitorFileEvent* _tmp34_;
						gint _tmp34__length1;
						GFile* _tmp35_;
						GFile* _tmp36_;
						XnpWindowMonitorFileEvent* _tmp37_;
						gint _tmp37__length1;
						XnpWindowMonitorFileEvent* _tmp38_;
						gint _tmp38__length1;
						_tmp33_ = self->priv->events;
						_tmp33__length1 = self->priv->events_length1;
						_tmp33_[n].event = XNP_WINDOW_MONITOR_CREATED;
						_tmp34_ = self->priv->events;
						_tmp34__length1 = self->priv->events_length1;
						_tmp35_ = other_file;
						_tmp36_ = _g_object_ref0 (_tmp35_);
						_g_object_unref0 (_tmp34_[n].file);
						_tmp34_[n].file = _tmp36_;
						_tmp37_ = self->priv->events;
						_tmp37__length1 = self->priv->events_length1;
						_g_object_unref0 (_tmp37_[n].other_file);
						_tmp37_[n].other_file = NULL;
						_tmp38_ = self->priv->events;
						_tmp38__length1 = self->priv->events_length1;
						_tmp38_[i].event = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
						xnp_window_monitor_optimize_event_created (self, n);
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					case G_FILE_MONITOR_EVENT_DELETED:
					case G_FILE_MONITOR_EVENT_MOVED_OUT:
					{
						XnpWindowMonitorFileEvent* _tmp39_;
						gint _tmp39__length1;
						XnpWindowMonitorFileEvent* _tmp40_;
						gint _tmp40__length1;
						XnpWindowMonitorFileEvent* _tmp41_;
						gint _tmp41__length1;
						XnpWindowMonitorFileEvent* _tmp42_;
						gint _tmp42__length1;
						XnpWindowMonitorFileEvent _tmp43_;
						XnpWindowMonitorFileEvent _tmp44_;
						XnpWindowMonitorFileEvent _tmp45_ = {0};
						XnpWindowMonitorFileEvent* _tmp46_;
						gint _tmp46__length1;
						XnpWindowMonitorFileEvent _tmp47_;
						XnpWindowMonitorFileEvent _tmp48_;
						XnpWindowMonitorFileEvent _tmp49_ = {0};
						_tmp39_ = self->priv->events;
						_tmp39__length1 = self->priv->events_length1;
						_tmp39_[n].event = G_FILE_MONITOR_EVENT_DELETED;
						_tmp40_ = self->priv->events;
						_tmp40__length1 = self->priv->events_length1;
						_g_object_unref0 (_tmp40_[n].other_file);
						_tmp40_[n].other_file = NULL;
						_tmp41_ = self->priv->events;
						_tmp41__length1 = self->priv->events_length1;
						_tmp42_ = self->priv->events;
						_tmp42__length1 = self->priv->events_length1;
						_tmp43_ = _tmp42_[n];
						_tmp44_ = _tmp43_;
						xnp_window_monitor_file_event_copy (&_tmp44_, &_tmp45_);
						xnp_window_monitor_file_event_destroy (&_tmp41_[i]);
						_tmp41_[i] = _tmp45_;
						_tmp46_ = self->priv->events;
						_tmp46__length1 = self->priv->events_length1;
						_tmp47_ = self->priv->dummy;
						_tmp48_ = _tmp47_;
						xnp_window_monitor_file_event_copy (&_tmp48_, &_tmp49_);
						xnp_window_monitor_file_event_destroy (&_tmp46_[n]);
						_tmp46_[n] = _tmp49_;
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					case XNP_WINDOW_MONITOR_CHANGES_DONE_HINT:
					{
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					case G_FILE_MONITOR_EVENT_RENAMED:
					{
						XnpWindowMonitorFileEvent* _tmp50_;
						gint _tmp50__length1;
						XnpWindowMonitorFileEvent _tmp51_;
						GFile* _tmp52_;
						gboolean _tmp53_ = FALSE;
						_tmp50_ = self->priv->events;
						_tmp50__length1 = self->priv->events_length1;
						_tmp51_ = _tmp50_[i];
						_tmp52_ = _tmp51_.other_file;
						g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp52_, &_tmp53_);
						if (_tmp53_) {
							GFile* _tmp54_;
							gboolean _tmp55_ = FALSE;
							_tmp54_ = file;
							g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL], 0, _tmp54_, &_tmp55_);
							if (_tmp55_) {
								XnpWindowMonitorFileEvent* _tmp56_;
								gint _tmp56__length1;
								XnpWindowMonitorFileEvent _tmp57_;
								XnpWindowMonitorFileEvent _tmp58_;
								XnpWindowMonitorFileEvent _tmp59_ = {0};
								XnpWindowMonitorFileEvent* _tmp60_;
								gint _tmp60__length1;
								GFile* _tmp61_;
								GFile* _tmp62_;
								_tmp56_ = self->priv->events;
								_tmp56__length1 = self->priv->events_length1;
								_tmp57_ = self->priv->dummy;
								_tmp58_ = _tmp57_;
								xnp_window_monitor_file_event_copy (&_tmp58_, &_tmp59_);
								xnp_window_monitor_file_event_destroy (&_tmp56_[n]);
								_tmp56_[n] = _tmp59_;
								_tmp60_ = self->priv->events;
								_tmp60__length1 = self->priv->events_length1;
								_tmp61_ = file;
								_tmp62_ = _g_object_ref0 (_tmp61_);
								_g_object_unref0 (_tmp60_[i].file);
								_tmp60_[i].file = _tmp62_;
							} else {
								XnpWindowMonitorFileEvent* _tmp63_;
								gint _tmp63__length1;
								XnpWindowMonitorFileEvent _tmp64_;
								XnpWindowMonitorFileEvent _tmp65_;
								XnpWindowMonitorFileEvent _tmp66_ = {0};
								XnpWindowMonitorFileEvent* _tmp67_;
								gint _tmp67__length1;
								XnpWindowMonitorFileEvent* _tmp68_;
								gint _tmp68__length1;
								XnpWindowMonitorFileEvent* _tmp69_;
								gint _tmp69__length1;
								XnpWindowMonitorFileEvent _tmp70_;
								GFile* _tmp71_;
								GFile* _tmp72_;
								XnpWindowMonitorFileEvent* _tmp73_;
								gint _tmp73__length1;
								_tmp63_ = self->priv->events;
								_tmp63__length1 = self->priv->events_length1;
								_tmp64_ = self->priv->dummy;
								_tmp65_ = _tmp64_;
								xnp_window_monitor_file_event_copy (&_tmp65_, &_tmp66_);
								xnp_window_monitor_file_event_destroy (&_tmp63_[n]);
								_tmp63_[n] = _tmp66_;
								_tmp67_ = self->priv->events;
								_tmp67__length1 = self->priv->events_length1;
								_tmp67_[i].event = XNP_WINDOW_MONITOR_CHANGES_DONE_HINT;
								_tmp68_ = self->priv->events;
								_tmp68__length1 = self->priv->events_length1;
								_tmp69_ = self->priv->events;
								_tmp69__length1 = self->priv->events_length1;
								_tmp70_ = _tmp69_[i];
								_tmp71_ = _tmp70_.other_file;
								_tmp72_ = _g_object_ref0 (_tmp71_);
								_g_object_unref0 (_tmp68_[i].file);
								_tmp68_[i].file = _tmp72_;
								_tmp73_ = self->priv->events;
								_tmp73__length1 = self->priv->events_length1;
								_g_object_unref0 (_tmp73_[i].other_file);
								_tmp73_[i].other_file = NULL;
							}
						} else {
							XnpWindowMonitorFileEvent* _tmp74_;
							gint _tmp74__length1;
							XnpWindowMonitorFileEvent* _tmp75_;
							gint _tmp75__length1;
							XnpWindowMonitorFileEvent _tmp76_;
							GFile* _tmp77_;
							GFile* _tmp78_;
							XnpWindowMonitorFileEvent* _tmp79_;
							gint _tmp79__length1;
							XnpWindowMonitorFileEvent* _tmp80_;
							gint _tmp80__length1;
							XnpWindowMonitorFileEvent _tmp81_;
							XnpWindowMonitorFileEvent _tmp82_;
							XnpWindowMonitorFileEvent _tmp83_ = {0};
							XnpWindowMonitorFileEvent* _tmp84_;
							gint _tmp84__length1;
							XnpWindowMonitorFileEvent _tmp85_;
							XnpWindowMonitorFileEvent _tmp86_;
							XnpWindowMonitorFileEvent _tmp87_ = {0};
							_tmp74_ = self->priv->events;
							_tmp74__length1 = self->priv->events_length1;
							_tmp75_ = self->priv->events;
							_tmp75__length1 = self->priv->events_length1;
							_tmp76_ = _tmp75_[i];
							_tmp77_ = _tmp76_.other_file;
							_tmp78_ = _g_object_ref0 (_tmp77_);
							_g_object_unref0 (_tmp74_[n].other_file);
							_tmp74_[n].other_file = _tmp78_;
							_tmp79_ = self->priv->events;
							_tmp79__length1 = self->priv->events_length1;
							_tmp80_ = self->priv->events;
							_tmp80__length1 = self->priv->events_length1;
							_tmp81_ = _tmp80_[n];
							_tmp82_ = _tmp81_;
							xnp_window_monitor_file_event_copy (&_tmp82_, &_tmp83_);
							xnp_window_monitor_file_event_destroy (&_tmp79_[i]);
							_tmp79_[i] = _tmp83_;
							_tmp84_ = self->priv->events;
							_tmp84__length1 = self->priv->events_length1;
							_tmp85_ = self->priv->dummy;
							_tmp86_ = _tmp85_;
							xnp_window_monitor_file_event_copy (&_tmp86_, &_tmp87_);
							xnp_window_monitor_file_event_destroy (&_tmp84_[n]);
							_tmp84_[n] = _tmp87_;
						}
						_g_object_unref0 (other_file);
						_g_object_unref0 (file);
						return;
					}
					default:
					{
						break;
					}
				}
			}
		}
	}
	_g_object_unref0 (other_file);
	_g_object_unref0 (file);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
xnp_window_monitor_file_event_init (XnpWindowMonitorFileEvent *self,
                                    GFile* file,
                                    GFile* other_file,
                                    GFileMonitorEvent event)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	memset (self, 0, sizeof (XnpWindowMonitorFileEvent));
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 ((*self).file);
	(*self).file = _tmp0_;
	_tmp1_ = _g_object_ref0 (other_file);
	_g_object_unref0 ((*self).other_file);
	(*self).other_file = _tmp1_;
	(*self).event = event;
}

static void
xnp_window_monitor_file_event_copy (const XnpWindowMonitorFileEvent* self,
                                    XnpWindowMonitorFileEvent* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	_tmp0_ = (*self).file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).file);
	(*dest).file = _tmp1_;
	_tmp2_ = (*self).other_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).other_file);
	(*dest).other_file = _tmp3_;
	(*dest).event = (*self).event;
}

static void
xnp_window_monitor_file_event_destroy (XnpWindowMonitorFileEvent* self)
{
	_g_object_unref0 ((*self).file);
	_g_object_unref0 ((*self).other_file);
}

static XnpWindowMonitorFileEvent*
xnp_window_monitor_file_event_dup (const XnpWindowMonitorFileEvent* self)
{
	XnpWindowMonitorFileEvent* dup;
	dup = g_new0 (XnpWindowMonitorFileEvent, 1);
	xnp_window_monitor_file_event_copy (self, dup);
	return dup;
}

static void
xnp_window_monitor_file_event_free (XnpWindowMonitorFileEvent* self)
{
	xnp_window_monitor_file_event_destroy (self);
	g_free (self);
}

static GType
xnp_window_monitor_file_event_get_type_once (void)
{
	GType xnp_window_monitor_file_event_type_id;
	xnp_window_monitor_file_event_type_id = g_boxed_type_register_static ("XnpWindowMonitorFileEvent", (GBoxedCopyFunc) xnp_window_monitor_file_event_dup, (GBoxedFreeFunc) xnp_window_monitor_file_event_free);
	return xnp_window_monitor_file_event_type_id;
}

static GType
xnp_window_monitor_file_event_get_type (void)
{
	static volatile gsize xnp_window_monitor_file_event_type_id__once = 0;
	if (g_once_init_enter (&xnp_window_monitor_file_event_type_id__once)) {
		GType xnp_window_monitor_file_event_type_id;
		xnp_window_monitor_file_event_type_id = xnp_window_monitor_file_event_get_type_once ();
		g_once_init_leave (&xnp_window_monitor_file_event_type_id__once, xnp_window_monitor_file_event_type_id);
	}
	return xnp_window_monitor_file_event_type_id__once;
}

static void
xnp_window_monitor_class_init (XnpWindowMonitorClass * klass,
                               gpointer klass_data)
{
	xnp_window_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpWindowMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = xnp_window_monitor_finalize;
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_UPDATED_SIGNAL] = g_signal_new ("note-updated", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_DELETED_SIGNAL] = g_signal_new ("note-deleted", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_CREATED_SIGNAL] = g_signal_new ("note-created", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_RENAMED_SIGNAL] = g_signal_new ("note-renamed", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_EXISTS_SIGNAL] = g_signal_new ("note-exists", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, g_file_get_type ());
}

static void
xnp_window_monitor_instance_init (XnpWindowMonitor * self,
                                  gpointer klass)
{
	XnpWindowMonitorFileEvent* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	self->priv = xnp_window_monitor_get_instance_private (self);
	self->priv->src_external = (guint) 0;
	self->priv->src_internal = (guint) 0;
	self->priv->skip = FALSE;
	_tmp0_ = g_new0 (XnpWindowMonitorFileEvent, 0);
	self->priv->events = _tmp0_;
	self->priv->events_length1 = 0;
	self->priv->_events_size_ = self->priv->events_length1;
	_tmp1_ = g_file_new_for_path ("");
	_tmp2_ = _tmp1_;
	xnp_window_monitor_file_event_init (&self->priv->dummy, _tmp2_, NULL, -1);
	_g_object_unref0 (_tmp2_);
}

static void
xnp_window_monitor_finalize (GObject * obj)
{
	XnpWindowMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitor);
	if (self->priv->src_external != ((guint) 0)) {
		g_source_remove (self->priv->src_external);
	}
	if (self->priv->src_internal != ((guint) 0)) {
		g_source_remove (self->priv->src_internal);
	}
	_g_object_unref0 (self->priv->monitor);
	self->priv->events = (_vala_XnpWindowMonitorFileEvent_array_free (self->priv->events, self->priv->events_length1), NULL);
	xnp_window_monitor_file_event_destroy (&self->priv->dummy);
	G_OBJECT_CLASS (xnp_window_monitor_parent_class)->finalize (obj);
}

static GType
xnp_window_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpWindowMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindowMonitor), 0, (GInstanceInitFunc) xnp_window_monitor_instance_init, NULL };
	GType xnp_window_monitor_type_id;
	xnp_window_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpWindowMonitor", &g_define_type_info, 0);
	XnpWindowMonitor_private_offset = g_type_add_instance_private (xnp_window_monitor_type_id, sizeof (XnpWindowMonitorPrivate));
	return xnp_window_monitor_type_id;
}

GType
xnp_window_monitor_get_type (void)
{
	static volatile gsize xnp_window_monitor_type_id__once = 0;
	if (g_once_init_enter (&xnp_window_monitor_type_id__once)) {
		GType xnp_window_monitor_type_id;
		xnp_window_monitor_type_id = xnp_window_monitor_get_type_once ();
		g_once_init_leave (&xnp_window_monitor_type_id__once, xnp_window_monitor_type_id);
	}
	return xnp_window_monitor_type_id__once;
}

