# $Header: /home/yav/catty/xmagv/RCS/Makefile.x,v 1.2 1995/11/17 17:29:06 yav Exp $
# xmagv - X Window System MAG Viewer  Makefile
#  for No xmkmf users
# written by yav (UHD98984@pcvan.or.jp)
#

##########################
# FreeBSD/Linux XFree86 3.1.1
CC	      = gcc
CCINC 	      = -I/usr/X11R6/include
CCMAGFNC      = 
LINKER	      = $(CC)
LDLIBS	      = -lX11
LDFLAGS	      = -L/usr/X11R6/lib
LIBS	      =
##########################
# SONY NEWS-OS R4.1C X11R4
#CC	      = gcc
#CCINC 	      = 
#CCMAGFNC     = 
#LINKER	      = $(CC)
#LDLIBS	      = -lX11
#LDFLAGS      = -L/usr/X11R6/lib
#LIBS	      =
#PRINT	      = pr
##########################
# Hitachi 3050 (HI-UX/WE)
#LDLIBS	      =  -lXm -lXt -lX11 -lbsd -lPW -lm
##########################
# SunOs
#CCSYSTEM     = -DSYSV
# SunOS OpenWindows
#CCINC 	      = -I/usr/openwin/include
#LDLIBS	      = -L/usr/openwin/lib -lX11 -lxview -lolgx -lmle
##########################
# private
DEST	      = $(HOME)/bin
JMANPATH      = /usr/local/man/ja_JP.SJIS
AMANPATH      = /usr/local/man
##########################

CFLAGS	      = -O2 $(CCINC) $(CCSYSTEM) $(CCMAGFNC)

HDRS	      =
MAKEFILE      = Makefile
PROGRAM	      = xmagv
OBJS	      = xmagv.o fblib.o error.o
SRCS	      = xmagv.c fblib.c error.c

HEADERS = config.h headers.h fb.h error.h
ICON_BITMAP = icon.xbm
HDRS = $(HEADERS) $(ICON_BITMAP)

all:		$(PROGRAM)

$(PROGRAM):     $(OBJS) $(LIBS)
		@echo -n "Loading $(PROGRAM) ... "
		@$(LINKER) $(LDFLAGS) $(OBJS) $(LIBS) -o $(PROGRAM) $(LDLIBS)
		@echo "done"

clean:;		@rm -f $(OBJS)

depend:;	@mkmf -f $(MAKEFILE) PROGRAM=$(PROGRAM) DEST=$(DEST)

index:;		@ctags -wx $(HDRS) $(SRCS)

install:	$(PROGRAM)
		@echo Installing $(PROGRAM) in $(DEST)
		@install -s $(PROGRAM) $(DEST)

print:;		@$(PRINT) $(HDRS) $(SRCS)

program:        $(PROGRAM)

tags:           $(HDRS) $(SRCS); @ctags $(HDRS) $(SRCS)

update:		$(DEST)/$(PROGRAM)

$(DEST)/$(PROGRAM): $(SRCS) $(LIBS) $(HDRS)
		@make -f $(MAKEFILE) DEST=$(DEST) install

jman : $(JMANPATH)/man1/$(PROGRAM).1

$(JMANPATH)/man1/$(PROGRAM).1 : $(PROGRAM).j
	cp $^ $@

man : $(AMANPATH)/man1/$(PROGRAM).1

$(AMANPATH)/man1/$(PROGRAM).1 : $(PROGRAM).man
	cp $^ $@

#
$(OBJS) : $(HEADERS)
xmagv.o : $(ICON_BITMAP)

config.h: config.h.in
	/bin/sh ./configure

### End of file ###
