/* $Header: /home/yav/catty/xmagv/RCS/fb.h,v 1.8 1995/11/17 17:29:36 yav Exp $
 *
 * Environment:
 *  OS
 *   __MSDOS__  for NEC PC-9801 MS-DOS
 *   __X68K__   for SHARP X68000 Human68k
 *   __UNIX__   for unix
 *  Frame buffer
 *   __MSDOS__  for NEC PC-9801 Shazo/HyperFrame/SuperFrame
 *   __X68K__   for SHARP X68000 Graphic Video RAM
 *   __X11__    for X Window System, Version 11
 *  C-compiler
 *   OLDSTYLE   for non-ANSI CC
 *
 * $Log: fb.h,v $
 * Revision 1.8  1995/11/17  17:29:36  yav
 * *** empty log message ***
 *
 * Revision 1.7  1995/11/15  23:30:20  yav
 * *** empty log message ***
 *
 * Revision 1.6  1995/11/14  22:54:55  yav
 * *** empty log message ***
 *
 * Revision 1.5  1995/11/14  08:07:29  yav
 * *** empty log message ***
 *
 * Revision 1.5  92/12/01  05:00:23  yav
 * FB_getmousecursor prototype bug.
 * 
 * Revision 1.4  92/11/30  21:35:32  yav
 * mimic X header file.
 * 
 * Revision 1.3  92/11/12  18:41:43  yav
 * event hook.
 * 
 * Revision 1.2  92/11/07  08:11:26  yav
 * for X Window System.
 * 
 * Revision 1.1  92/06/18  01:20:26  yav
 * Initial revision
 * 
 */

#ifndef __X11__
#ifndef __MSDOS__
#ifndef __X68K__
#define   __X11__ 1
#endif
#endif
#endif

#ifndef __UNIX__
#ifndef __MSDOS__
#ifndef __X68K__
#define   __UNIX__ 1
#endif
#endif
#endif

#ifndef OLDSTYLE
#ifndef __STDC__
#ifndef __GNUC__
#ifndef __MSDOS__
#define OLDSTYLE 1
#endif
#endif
#endif
#endif

#ifdef __X11__
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#endif
#ifdef __MSDOS__
#include <fb/szio.h>
#endif

#ifndef TRUE
#define TRUE (1==1)
#endif
#ifndef FALSE
#define FALSE (!TRUE)
#endif
#ifndef Yes
#define Yes TRUE
#endif
#ifndef No
#define No FALSE
#endif

#ifndef _WORD_T
typedef unsigned short word;
#define _WORD_T word
#endif

#ifndef _PIXEL
typedef struct pixel {
	unsigned char r;
	unsigned char g;
	unsigned char b;
} PIXEL;
#define _PIXEL PIXEL
#define _PIXEL_T PIXEL
#endif

/* Frame buffer id code */
#define FBID_default    0
#define FBID_X68k       1  /* SHARP X68000 graphic video RAM */
#define FBID_SZslow     2  /* CAST Shazo (PORT $(SHAZO)) */
#define FBID_SZ         3  /* CAST Shazo (PORT 00dx fix) */
#define FBID_HF         4  /* Digital Arts HyPER-FRAME */
#define FBID_HFp        5  /* Digital Arts HyPER-FRAME+ */
#define FBID_SF         6  /* SAPIENCE SuperFrame2 */
#define FBID_X11        7  /* X Window System, Version 11 */
#define FBID_PC98       8  /* NEC PC-9801 graphic video RAM */
#define FBID_MAX        9

/* Frame buffer size */
#ifndef FB_XSIZEMAX
#define FB_XSIZEMAX     4096
#ifdef __MSDOS__
#undef    FB_XSIZEMAX
#define   FB_XSIZEMAX    640
#endif

#ifdef __X68K__
#undef    FB_XSIZEMAX
#define   FB_XSIZEMAX    640
#endif
#endif /* FB_XSIZEMAX */

#ifndef FB_YSIZEMAX
#define FB_YSIZEMAX     4096
#ifdef __MSDOS__
#undef    FB_YSIZEMAX
#define   FB_YSIZEMAX    512
#endif
#ifdef __X68K__
#undef    FB_YSIZEMAX
#define   FB_YSIZEMAX    512
#endif
#endif /* FB_YSIZEMAX */

/* typedef color map interface */
#ifndef XPIX
#ifndef _XPIX_T
#ifdef __X11__
typedef unsigned long XPIX;
typedef unsigned short XRGB;
typedef unsigned long FBPIX;
#else
typedef unsigned short XPIX;
typedef unsigned char XRGB;
typedef unsigned short FBPIX;
#endif
#define _XPIX_T XPIX
#define _XRGB_T XRGB
#endif
#endif

#ifndef __X11__
#include <fb/mimixeve.h>
#include <fb/mimixpix.h>
#include <fb/mimixcur.h>
#include <fb/mimixkey.h>
#endif

#define FBMC_OFF (-1)

/* NEC PC-9801 port map */
#ifdef __MSDOS__

#define	SZ_REGX	SZ_XPOS
#define	SZ_REGY	SZ_YPOS
#define	SZ_REGR	SZ_DATA
#define	SZ_REGG	SZ_DATA
#define	SZ_REGB	SZ_DATA

#define	HF_REGX	0xd4
#define	HF_REGY	0xd6
#define	HF_REGR	0xd8
#define	HF_REGG	0xda
#define	HF_REGB	0xdc

#define	SF_REGX	0xd4
#define	SF_REGY	0xd6
#define	SF_REGR	0xd8
#define	SF_REGG	0xda
#define	SF_REGB	0xdc

#define	FB_REGX	HF_REGX
#define	FB_REGY	HF_REGY
#define	FB_REGR	HF_REGR
#define	FB_REGG	HF_REGG
#define	FB_REGB	HF_REGB

#endif /* __MSDOS__ */


/* NEC PC-9801 SZ/HF/SF libs */
#ifdef __MSDOS__
/*---------------------------------------------------------------------------*/
/* for HF */
void HFOn(void);        /* HyperFrame ON */
void HFSoRe(int);       /* 1:use as fb */
void HFBnIo(int);       /* 1:need I/O access */
void HFDisp(int);       /* PCdisp ctrl? 1:HyperFrame only 2:Super impose */
void HFRgIni(void);     /* HyperFrame register initialize */
void HFRgSw(int);       /* 1:enable to use */
void HFAnDg(int);       /* 0:fb no disp?? 1:force super impose */
void HFScroll(int x, int y);
void HFZoom(int zx, int zy);
void HFPget(int xx, int yy, int *rr, int *gg, int *bb); /* get pix data */
void HFPset(int xx, int yy, int rr, int gg, int bb);    /* set pix data */
void FB_getline(int x, int y, int xs, PIXEL *p);
void FB_putline(int x, int y, int xs, PIXEL *p);
void HFClr(void);
/*---------------------------------------------------------------------------*/
/* for SF */
void SF_init(void);
void SF_pcdisp(int mode);
void SF_fbdisp(int mode);
void SF_clear(void);
/*---------------------------------------------------------------------------*/
#endif /* __MSDOS__ */


/*---------------------------------------------------------------------------*/
/* global work */
extern char *fbsym[];
extern int fb_id;
extern int fb_xsize;
extern int fb_ysize;
extern long fb_eventmask;
extern unsigned wxs, wys;
extern char fblibRCSrevision[];
extern char fblib_id[];
extern char *fblibproginfo[];
extern char *str_display;
extern char *str_geometry;
extern int fb_realtime;
extern char *fb_title;
extern char *fb_font;
#ifdef __MSDOS__
extern unsigned p_posx;
extern unsigned p_posy;
extern unsigned p_datr;
extern unsigned p_datg;
extern unsigned p_datb;
#endif /* __MSDOS__ */
#ifdef __X11__
extern Display *dsp;
extern int scr;
extern Colormap cmap;
extern Window win;
extern GC gc;
extern unsigned long bgpix, fgpix;
extern XImage *img;
extern unsigned int fb_icon_w, fb_icon_h;
extern char *fb_icon_d;
#endif /* __X11__ */

extern FBPIX fb_xcoln;
extern XColor *fb_xcoltbl;
extern char *fb_xcolf;

/*---------------------------------------------------------------------------*/
/* prototype declarations */
#ifdef OLDSTYLE

int  FB_libinit();	/* fblib initialize */
void FB_libend();	/* fblib end */
void FB_disp();		/* pc/fb display control */
void FB_clear();	/* clear fb */
int  FB_open();
int  FB_close();
int  FB_alloccol();
void FB_freecol();
void FB_event();
void FB_putline3();
void FB_setmousecursor();
int  FB_getmousecursor();
void FB_putline2();
int  FB_redrawimage();
void FB_setevent();
void FB_setkeyevent();
void FB_setmouseevent();
void FB_setredrawevent();
void FB_setredraw2event();
void FB_scroll();	/* pan x,y */
void FB_vsync();	/* Vsync wait */
void FB_getpixel();	/* get pixel data */
void FB_setpixel();	/* set pixel data */
#ifdef __X11__
void FB_setresizeevent();
#else /* __X11__ */
int  FB_namecode();	/* get fbid */
char *FB_codename();	/* get name */
#define FB_libmode()	FB_codename(0)
void FB_init();		/* initialize fb hardware */
void FB_zoom();		/* zoom */
void FB_getline();
void FB_putline();
void FB_getlinev();
void FB_putlinev();
#endif /* __X11__ */

#else /* OLDSTYLE */

int  FB_libinit(char *);	/* fblib initialize */
void FB_libend(void);		/* fblib end */
void FB_disp(int);		/* pc/fb display control */
void FB_clear(void);		/* clear fb */
int  FB_open(int, char **, char *);
int  FB_close(void);
int  FB_alloccol(FBPIX *, PIXEL *);
void FB_freecol(FBPIX);
void FB_event(void);
void FB_putline3(int, int, int, FBPIX *);
void FB_setmousecursor(int);
int  FB_getmousecursor(void);
void FB_putline2(int, int, int, unsigned long *);
int  FB_redrawimage(int, int, int, int);
void FB_setevent(int (*func)(int));
void FB_setkeyevent(int (*)(char *, KeySym*));
void FB_setmouseevent(int (*)(int, int, int));
void FB_setredrawevent(int (*)(int, int, int, int));
void FB_setredraw2event(int (*)(int, int, int, int));
void FB_scroll(int, int);	/* pan x,y */
void FB_vsync(int);	/* Vsync wait */
void FB_getpixel(int, int, PIXEL *);	/* get pixel x y pixel */
void FB_setpixel(int, int, PIXEL *);	/* set pixel x y pixel */
#ifdef __X11__
void FB_setresizeevent(int (*)(int, int, int, int));	/* resize x y w h */
#else /* __X11__ */
int  FB_namecode(char *);	/* get id-code from name */
char *FB_codename(int);	/* get name from id-code*/
#define FB_libmode()	FB_codename(0)
void FB_init(void);	/* initialize fb hardware */
void FB_zoom(int n);	/* zoom */
void FB_getline(int, int, int, PIXEL *);	/* get x y xs pixels */
void FB_putline(int, int, int, PIXEL *);	/* put x y xs pixels */
void FB_getlinev(int, int, int, PIXEL *);	/* getv x y ys pixels */
void FB_putlinev(int, int, int, PIXEL *);	/* putv x y ys pixels */
#endif /* __X11__ */

#endif /* OLDSTYLE */

/* End of file */
