/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.stress.StressAction;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.MultiResultLogger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class StressServer {
    private static final Options availableOptions = new Options();
    private static final AtomicInteger threadCounter;

    public static void main(String[] args) throws Exception {
        ServerSocket serverSocket = null;
        PosixParser parser = new PosixParser();
        InetAddress address = InetAddress.getByName("127.0.0.1");
        try {
            CommandLine cmd = parser.parse(availableOptions, args);
            if (cmd.hasOption("h")) {
                address = InetAddress.getByName(cmd.getOptionValue("h"));
            }
        }
        catch (ParseException e) {
            System.err.printf("Usage: ./bin/stressd start|stop|status [-h <host>]", new Object[0]);
            System.exit(1);
        }
        try {
            serverSocket = new ServerSocket(2159, 0, address);
        }
        catch (IOException e) {
            System.err.printf("Could not listen on port: %s:2159.%n", address.getHostAddress());
            System.exit(1);
        }
        while (true) {
            new StressThread(serverSocket.accept()).start();
        }
    }

    static {
        availableOptions.addOption("h", "host", true, "Host to listen for connections.");
        threadCounter = new AtomicInteger(1);
    }

    public static class StressThread
    extends Thread {
        private final Socket socket;

        public StressThread(Socket client) {
            this.socket = client;
        }

        @Override
        public void run() {
            try {
                ObjectInputStream in = new ObjectInputStream(this.socket.getInputStream());
                PrintStream out = new PrintStream(this.socket.getOutputStream());
                MultiResultLogger log = new MultiResultLogger(out);
                StressAction action = new StressAction((StressSettings)in.readObject(), log);
                Thread actionThread = NamedThreadFactory.createThread((Runnable)action, (String)("stress-" + threadCounter.incrementAndGet()));
                actionThread.start();
                while (actionThread.isAlive()) {
                    try {
                        if (in.readInt() != 1) continue;
                        actionThread.interrupt();
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

