/*
 * Decompiled with CFR 0.152.
 */
package vcf;

public final class VcfMetaInfo {
    public static final String PREFIX = "##";
    public static final char DELIMITER = '=';
    private final String line;
    private final String key;
    private final String value;

    public VcfMetaInfo(String string) {
        string = string.trim();
        if (!string.startsWith(PREFIX)) {
            String string2 = "VCF meta-information line: missing starting \"##\": " + string;
            throw new IllegalArgumentException(string2);
        }
        int n = string.indexOf(61);
        if (n <= 0 || n == string.length() - 1) {
            String string3 = "VCF meta-information line: missing \"=\"";
            throw new IllegalArgumentException(string3);
        }
        this.line = string;
        this.key = string.substring(2, n);
        this.value = string.substring(n + 1);
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.line;
    }
}

