# Test gdb threading support
# Similar to pr47430.py, but sets breakpoints, and looks for SIGSEGV
# rather than SIGTRAP.

from bracket import make_sh_test_op
import anita

def op():
    return make_sh_test_op('gdb_threads_2',
'''
set -x

# Make sure PaX won't interfere
sysctl -w security.pax.mprotect.enabled=0 || true
sysctl -w security.pax.mprotect.ptrace=0 || true

# Dig at an unused IP address so that dig fails the
# same way on machines with Internet connectivity
# as on those without.

cat <<EOF >test.gdb
b main
run +time=1 +tries=1 @127.0.0.177
b write
cont
cont
cont
cont
cont
EOF
gdb --batch -x test.gdb dig >gdb.out
cat gdb.out
! grep SIGSEGV gdb.out
''')
