/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.marbl.mhap.math.BasicMath;
import edu.umd.marbl.mhap.sketch.SketchRuntimeException;
import edu.umd.marbl.mhap.utils.MersenneTwisterFast;
import edu.umd.marbl.mhap.utils.Utils;
import java.nio.ByteBuffer;

public class HashUtils {
    public static long[] computeHashes(String item, int numWords, int seed) {
        long[] hashes = new long[numWords];
        for (int word = 0; word < numWords; word += 2) {
            HashFunction hashFunc = Hashing.murmur3_128(seed + word);
            Hasher hasher = hashFunc.newHasher();
            hasher.putUnencodedChars(item);
            HashCode hc = hasher.hash();
            ByteBuffer bb = ByteBuffer.wrap(hc.asBytes());
            hashes[word] = bb.getLong(0);
            if (word + 1 >= numWords) continue;
            hashes[word + 1] = bb.getLong(8);
        }
        return hashes;
    }

    public static final int[] computeHashesInt(Object obj, int numWords, int seed) {
        if (obj instanceof Integer) {
            return HashUtils.computeHashesIntInt((Integer)obj, numWords, seed);
        }
        if (obj instanceof Long) {
            return HashUtils.computeHashesIntLong((Long)obj, numWords, seed);
        }
        if (obj instanceof Double) {
            return HashUtils.computeHashesIntDouble((Double)obj, numWords, seed);
        }
        if (obj instanceof Float) {
            return HashUtils.computeHashesIntFloat(((Float)obj).floatValue(), numWords, seed);
        }
        if (obj instanceof String) {
            return HashUtils.computeHashesIntString((String)obj, numWords, seed);
        }
        throw new SketchRuntimeException("Cannot hash class type " + obj.getClass().getCanonicalName());
    }

    public static final int[] computeHashesIntDouble(double obj, int numWords, int seed) {
        int[] hashes = new int[numWords];
        HashFunction hf = Hashing.murmur3_32(seed);
        for (int iter = 0; iter < numWords; ++iter) {
            HashCode hc = hf.newHasher().putDouble(obj).putInt(iter).hash();
            hashes[iter] = hc.asInt();
        }
        return hashes;
    }

    public static final int[] computeHashesIntFloat(float obj, int numWords, int seed) {
        int[] hashes = new int[numWords];
        HashFunction hf = Hashing.murmur3_32(seed);
        for (int iter = 0; iter < numWords; ++iter) {
            HashCode hc = hf.newHasher().putFloat(obj).putInt(iter).hash();
            hashes[iter] = hc.asInt();
        }
        return hashes;
    }

    public static final int[] computeHashesIntInt(int obj, int numWords, int seed) {
        int[] hashes = new int[numWords];
        HashFunction hf = Hashing.murmur3_32(seed);
        for (int iter = 0; iter < numWords; ++iter) {
            HashCode hc = hf.newHasher().putInt(obj).putInt(iter).hash();
            hashes[iter] = hc.asInt();
        }
        return hashes;
    }

    public static final int[] computeHashesIntLong(long obj, int numWords, int seed) {
        int[] hashes = new int[numWords];
        HashFunction hf = Hashing.murmur3_32(seed);
        for (int iter = 0; iter < numWords; ++iter) {
            HashCode hc = hf.newHasher().putLong(obj).putInt(iter).hash();
            hashes[iter] = hc.asInt();
        }
        return hashes;
    }

    public static final int[] computeHashesIntString(String obj, int numWords, int seed) {
        int[] hashes = new int[numWords];
        HashFunction hf = Hashing.murmur3_32(seed);
        for (int iter = 0; iter < numWords; ++iter) {
            HashCode hc = hf.newHasher().putUnencodedChars(obj).putInt(iter).hash();
            hashes[iter] = hc.asInt();
        }
        return hashes;
    }

    public static final long[][] computeNGramHashes(String seq, int nGramSize, int numWords, int seed, boolean doReverseCompliment) {
        int numberNGrams = seq.length() - nGramSize + 1;
        if (numberNGrams < 1) {
            throw new SketchRuntimeException("N-gram size bigger than string length.");
        }
        long[] rabinHashes = HashUtils.computeSequenceHashesLong(seq, nGramSize, seed, doReverseCompliment);
        long[][] hashes = new long[rabinHashes.length][numWords];
        for (int iter = 0; iter < rabinHashes.length; ++iter) {
            long x = rabinHashes[iter];
            for (int word = 0; word < numWords; ++word) {
                x ^= x << 21;
                x ^= x >>> 35;
                x ^= x << 4;
                hashes[iter][word] = x;
            }
        }
        return hashes;
    }

    public static final long[][] computeNGramHashesExact(String seq, int nGramSize, int numWords, int seed) {
        HashFunction hf = Hashing.murmur3_128(seed);
        long[][] hashes = new long[seq.length() - nGramSize + 1][numWords];
        for (int iter = 0; iter < hashes.length; ++iter) {
            String subStr = seq.substring(iter, iter + nGramSize);
            for (int word = 0; word < numWords; ++word) {
                HashCode hc = hf.newHasher().putUnencodedChars(subStr).putInt(word).hash();
                hashes[iter][word] = hc.asLong();
            }
        }
        return hashes;
    }

    public static final int[] computeSequenceHashes(String seq, int nGramSize, boolean doReverseCompliment) {
        HashFunction hf = Hashing.murmur3_32(0);
        int[] hashes = new int[seq.length() - nGramSize + 1];
        for (int iter = 0; iter < hashes.length; ++iter) {
            String str = seq.substring(iter, iter + nGramSize);
            String strReverse = null;
            if (doReverseCompliment && (strReverse = Utils.rc(str)).compareTo(str) < 0) {
                str = strReverse;
            }
            HashCode hc = hf.newHasher().putUnencodedChars(str).hash();
            hashes[iter] = hc.asInt();
        }
        return hashes;
    }

    public static final long[] computeSequenceHashesLong(String seq, int nGramSize, int seed, boolean doReverseCompliment) {
        HashFunction hf = Hashing.murmur3_128(seed);
        long[] hashes = new long[seq.length() - nGramSize + 1];
        for (int iter = 0; iter < hashes.length; ++iter) {
            String str = seq.substring(iter, iter + nGramSize);
            String strReverse = null;
            if (doReverseCompliment && (strReverse = Utils.rc(str)).compareTo(str) < 0) {
                str = strReverse;
            }
            HashCode hc = hf.newHasher().putUnencodedChars(str).hash();
            hashes[iter] = hc.asLong();
        }
        return hashes;
    }

    public static double[] randomGuassianVector(int n, int seed) {
        MersenneTwisterFast rand = new MersenneTwisterFast(seed);
        double[] vec = new double[n];
        for (int iter = 0; iter < n; ++iter) {
            vec[iter] = rand.nextGaussian();
        }
        double norm = BasicMath.norm(vec);
        if (norm < 1.0E-10) {
            return vec;
        }
        return BasicMath.mult(vec, 1.0 / norm);
    }

    public static double[] randomStringGuassianVector(String str, int n, int seed) {
        int[] seeds = new int[4];
        for (int iter = 0; iter < 4; ++iter) {
            HashFunction hf = Hashing.murmur3_32(seed * 4 + iter);
            HashCode hc = hf.newHasher().putUnencodedChars(str).hash();
            seeds[iter] = hc.asInt();
        }
        MersenneTwisterFast rand = new MersenneTwisterFast(seeds);
        double[] vec = new double[n];
        for (int iter = 0; iter < n; ++iter) {
            vec[iter] = rand.nextGaussian();
        }
        double norm = BasicMath.norm(vec);
        if (norm < 1.0E-10) {
            return vec;
        }
        return BasicMath.mult(vec, 1.0 / norm);
    }

    private HashUtils() {
    }
}

