/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.MaybeCompressedFileResource;
import org.gradle.api.internal.file.UnknownBackingFileReadableResource;
import org.gradle.api.internal.file.archive.TarFileTree;
import org.gradle.api.internal.file.archive.ZipFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.FileCopier;
import org.gradle.api.internal.file.delete.DefaultDeleteSpec;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.internal.LocalResourceAdapter;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.LocalFileStandInExternalResource;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GFileUtils;

public class DefaultFileOperations
implements FileOperations {
    private final FileResolver fileResolver;
    private final TemporaryFileProvider temporaryFileProvider;
    private final Instantiator instantiator;
    private final Deleter deleter;
    private final ResourceHandler resourceHandler;
    private final StreamHasher streamHasher;
    private final FileHasher fileHasher;
    private final Factory<PatternSet> patternSetFactory;
    private final FileCopier fileCopier;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProviderFactory providers;

    public DefaultFileOperations(FileResolver fileResolver, TemporaryFileProvider temporaryFileProvider, Instantiator instantiator, DirectoryFileTreeFactory directoryFileTreeFactory, StreamHasher streamHasher, FileHasher fileHasher, DefaultResourceHandler.Factory resourceHandlerFactory, FileCollectionFactory fileCollectionFactory, FileSystem fileSystem, Factory<PatternSet> patternSetFactory, Deleter deleter, DocumentationRegistry documentationRegistry, ProviderFactory providers) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileResolver = fileResolver;
        this.temporaryFileProvider = temporaryFileProvider;
        this.instantiator = instantiator;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.resourceHandler = resourceHandlerFactory.create(this);
        this.streamHasher = streamHasher;
        this.fileHasher = fileHasher;
        this.patternSetFactory = patternSetFactory;
        this.providers = providers;
        this.fileCopier = new FileCopier(deleter, directoryFileTreeFactory, fileCollectionFactory, fileResolver, patternSetFactory, fileSystem, instantiator, documentationRegistry);
        this.fileSystem = fileSystem;
        this.deleter = deleter;
    }

    @Override
    public File file(Object path) {
        return this.fileResolver.resolve(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileResolver.resolve(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileResolver.resolveUri(path);
    }

    @Override
    public ConfigurableFileCollection configurableFiles(Object ... paths) {
        return this.fileCollectionFactory.configurableFiles().from(paths);
    }

    @Override
    public FileCollection immutableFiles(Object ... paths) {
        return this.fileCollectionFactory.resolving(paths);
    }

    @Override
    public PatternSet patternSet() {
        return this.patternSetFactory.create();
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        ConfigurableFileTree fileTree = this.fileCollectionFactory.fileTree();
        fileTree.from(baseDir);
        return fileTree;
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        ConfigurableFileTree fileTree = this.fileCollectionFactory.fileTree();
        ConfigureUtil.configureByMap(args, fileTree);
        return fileTree;
    }

    @Override
    public FileTreeInternal zipTree(Object zipPath) {
        Provider<File> fileProvider = this.asFileProvider(zipPath);
        return new FileTreeAdapter(new ZipFileTree(fileProvider, this.getExpandDir(), this.fileSystem, this.directoryFileTreeFactory, this.fileHasher), this.patternSetFactory);
    }

    @Override
    public FileTreeInternal tarTree(Object tarPath) {
        Provider<File> fileProvider = this.asFileProvider(tarPath);
        Provider<ReadableResourceInternal> resource = this.providers.provider(() -> {
            if (tarPath instanceof ReadableResourceInternal) {
                return (ReadableResourceInternal)tarPath;
            }
            if (tarPath instanceof ReadableResource) {
                return new UnknownBackingFileReadableResource((ReadableResource)tarPath);
            }
            File tarFile = this.file(tarPath);
            return new LocalResourceAdapter(new LocalFileStandInExternalResource(tarFile, this.fileSystem));
        });
        TarFileTree tarTree = new TarFileTree(fileProvider, resource.map(MaybeCompressedFileResource::new), this.getExpandDir(), this.fileSystem, this.directoryFileTreeFactory, this.streamHasher, this.fileHasher);
        return new FileTreeAdapter(tarTree, this.patternSetFactory);
    }

    private Provider<File> asFileProvider(Object path) {
        if (path instanceof ReadableResource) {
            return this.providers.provider(() -> null);
        }
        if (path instanceof Provider) {
            ProviderInternal provider = (ProviderInternal)path;
            Class type = provider.getType();
            if (type != null) {
                if (File.class.isAssignableFrom(type)) {
                    return (Provider)Cast.uncheckedCast(path);
                }
                if (RegularFile.class.isAssignableFrom(type)) {
                    Provider regularFileProvider = (Provider)Cast.uncheckedCast(provider);
                    return regularFileProvider.map(RegularFile::getAsFile);
                }
            }
            return provider.map(this::file);
        }
        return this.providers.provider(() -> this.file(path));
    }

    private File getExpandDir() {
        return this.temporaryFileProvider.newTemporaryFile("expandedArchives");
    }

    @Override
    public String relativePath(Object path) {
        return this.fileResolver.resolveAsRelativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        File dir = this.fileResolver.resolve(path);
        if (dir.isFile()) {
            throw new InvalidUserDataException(String.format("Can't create directory. The path=%s points to an existing file.", path));
        }
        GFileUtils.mkdirs(dir);
        return dir;
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.delete((? super DeleteSpec deleteSpec) -> deleteSpec.delete(paths).setFollowSymlinks(false)).getDidWork();
    }

    @Override
    public WorkResult delete(Action<? super DeleteSpec> action) {
        DefaultDeleteSpec deleteSpec = new DefaultDeleteSpec();
        action.execute(deleteSpec);
        FileCollectionInternal roots = this.fileCollectionFactory.resolving(deleteSpec.getPaths());
        boolean didWork = false;
        for (File root : roots) {
            try {
                didWork |= this.deleter.deleteRecursively(root, deleteSpec.isFollowSymlinks());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return WorkResults.didWork(didWork);
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileCopier.copy(action);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileCopier.sync(action);
    }

    public CopySpec copySpec(Action<? super CopySpec> action) {
        CopySpec copySpec = this.copySpec();
        action.execute(copySpec);
        return copySpec;
    }

    @Override
    public CopySpec copySpec() {
        return this.instantiator.newInstance(DefaultCopySpec.class, this.fileCollectionFactory, this.instantiator, this.patternSetFactory);
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public ResourceHandler getResources() {
        return this.resourceHandler;
    }

    public static DefaultFileOperations createSimple(FileResolver fileResolver, FileCollectionFactory fileTreeFactory, ServiceRegistry services) {
        Instantiator instantiator = services.get(Instantiator.class);
        FileSystem fileSystem = services.get(FileSystem.class);
        DirectoryFileTreeFactory directoryFileTreeFactory = services.get(DirectoryFileTreeFactory.class);
        StreamHasher streamHasher = services.get(StreamHasher.class);
        FileHasher fileHasher = services.get(FileHasher.class);
        ApiTextResourceAdapter.Factory textResourceAdapterFactory = services.get(ApiTextResourceAdapter.Factory.class);
        Factory<PatternSet> patternSetFactory = services.getFactory(PatternSet.class);
        Deleter deleter = services.get(Deleter.class);
        DocumentationRegistry documentationRegistry = services.get(DocumentationRegistry.class);
        ProviderFactory providers = services.get(ProviderFactory.class);
        DefaultResourceHandler.Factory resourceHandlerFactory = DefaultResourceHandler.Factory.from(fileResolver, fileSystem, null, textResourceAdapterFactory);
        return new DefaultFileOperations(fileResolver, null, instantiator, directoryFileTreeFactory, streamHasher, fileHasher, resourceHandlerFactory, fileTreeFactory, fileSystem, patternSetFactory, deleter, documentationRegistry, providers);
    }
}

