/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import groovy.lang.Closure;
import org.gradle.api.specs.CompositeSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.internal.ClosureSpec;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ObjectArrays;

public class AndSpec<T>
extends CompositeSpec<T> {
    public static final AndSpec<?> EMPTY = new AndSpec();

    public AndSpec() {
    }

    @SafeVarargs
    public AndSpec(Spec<? super T> ... specs) {
        super(specs);
    }

    public AndSpec(Iterable<? extends Spec<? super T>> specs) {
        super(specs);
    }

    @Override
    public boolean isSatisfiedBy(T object) {
        Spec<T>[] specs;
        for (Spec<T> spec : specs = this.getSpecsArray()) {
            if (spec.isSatisfiedBy(object)) continue;
            return false;
        }
        return true;
    }

    public AndSpec<T> and(Spec<? super T> ... specs) {
        if (specs.length == 0) {
            return this;
        }
        Spec<T>[] thisSpecs = this.getSpecsArray();
        int thisLength = thisSpecs.length;
        if (thisLength == 0) {
            return new AndSpec<T>(specs);
        }
        Spec[] combinedSpecs = (Spec[])AndSpec.uncheckedCast(ObjectArrays.newArray(Spec.class, (int)(thisLength + specs.length)));
        System.arraycopy(thisSpecs, 0, combinedSpecs, 0, thisLength);
        System.arraycopy(specs, 0, combinedSpecs, thisLength, specs.length);
        return new AndSpec<T>(combinedSpecs);
    }

    public AndSpec<T> and(Spec<? super T> spec) {
        return this.and((Spec[])Cast.uncheckedNonnullCast(new Spec[]{spec}));
    }

    public AndSpec<T> and(Closure spec) {
        return this.and((Spec<? super T>)new ClosureSpec(spec));
    }

    public static <T> AndSpec<T> empty() {
        return (AndSpec)AndSpec.uncheckedCast(EMPTY);
    }
}

