/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeActionExecutor;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.buildtree.BuildTreeLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;

class DefaultBuildTreeContext
implements BuildTreeContext {
    private final ServiceRegistry services;
    private boolean completed;

    public DefaultBuildTreeContext(ServiceRegistry services) {
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result execute(BuildAction action) {
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for a build tree.");
        }
        try {
            BuildTreeLifecycleListener broadcaster = this.services.get(ListenerManager.class).getBroadcaster(BuildTreeLifecycleListener.class);
            broadcaster.afterStart();
            try {
                BuildActionRunner.Result result = this.services.get(BuildTreeActionExecutor.class).execute(action, this);
                broadcaster.beforeStop();
                return result;
            }
            catch (Throwable throwable) {
                broadcaster.beforeStop();
                throw throwable;
            }
        }
        finally {
            this.completed = true;
        }
    }
}

