/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Collection;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class NoMatchingCapabilitiesException
extends RuntimeException {
    public NoMatchingCapabilitiesException(ComponentResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, ImmutableList<? extends ConfigurationMetadata> candidates) {
        super(NoMatchingCapabilitiesException.buildMessage(targetComponent, requestedCapabilities, candidates));
    }

    private static String buildMessage(ComponentResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, ImmutableList<? extends ConfigurationMetadata> candidates) {
        StringBuilder sb = new StringBuilder("Unable to find a variant of ");
        sb.append(targetComponent.getId()).append(" providing the requested ");
        sb.append(CapabilitiesSupport.prettifyCapabilities(targetComponent, requestedCapabilities));
        sb.append(":\n");
        for (ConfigurationMetadata candidate : candidates) {
            sb.append("   - Variant ").append(candidate.getName()).append(" provides ");
            sb.append(CapabilitiesSupport.sortedCapabilityList(targetComponent, candidate.getCapabilities().getCapabilities())).append("\n");
        }
        return sb.toString();
    }
}

