/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Map;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;

public class DefaultCurrentFileCollectionFingerprint
implements CurrentFileCollectionFingerprint {
    private final Map<String, FileSystemLocationFingerprint> fingerprints;
    private final FingerprintHashingStrategy hashingStrategy;
    private final String identifier;
    private final FileSystemSnapshot roots;
    private final ImmutableMultimap<String, HashCode> rootHashes;
    private HashCode hash;

    public static CurrentFileCollectionFingerprint from(FileSystemSnapshot roots, FingerprintingStrategy strategy) {
        if (roots == FileSystemSnapshot.EMPTY) {
            return strategy.getEmptyFingerprint();
        }
        Map<String, FileSystemLocationFingerprint> fingerprints = strategy.collectFingerprints(roots);
        if (fingerprints.isEmpty()) {
            return strategy.getEmptyFingerprint();
        }
        return new DefaultCurrentFileCollectionFingerprint(fingerprints, strategy.getHashingStrategy(), strategy.getIdentifier(), roots);
    }

    private DefaultCurrentFileCollectionFingerprint(Map<String, FileSystemLocationFingerprint> fingerprints, FingerprintHashingStrategy hashingStrategy, String identifier, FileSystemSnapshot roots) {
        this.fingerprints = fingerprints;
        this.hashingStrategy = hashingStrategy;
        this.identifier = identifier;
        this.roots = roots;
        this.rootHashes = SnapshotUtil.getRootHashes(roots);
    }

    @Override
    public HashCode getHash() {
        if (this.hash == null) {
            Hasher hasher = Hashing.newHasher();
            this.hashingStrategy.appendToHasher(hasher, this.fingerprints.values());
            this.hash = hasher.hash();
        }
        return this.hash;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> getFingerprints() {
        return this.fingerprints;
    }

    @Override
    public ImmutableMultimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    @Override
    public String getStrategyIdentifier() {
        return this.identifier;
    }

    @Override
    public FileSystemSnapshot getSnapshot() {
        return this.roots;
    }

    public String toString() {
        return this.identifier + this.fingerprints;
    }
}

