/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.doctest;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeSerialization;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestTestFramework;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCIntType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDoctestTestUtil {
    private static final Pattern _DOCTEST_ANON_VAR_ = Pattern.compile("_DOCTEST_ANON_VAR_\\d+");
    private static final Pattern _DOCTEST_ANON_SUITE_ = Pattern.compile("_DOCTEST_ANON_SUITE_\\d+");
    private static final Pattern _DOCTEST_ANON_TMP_ITERATOR = Pattern.compile("(?:(?:_DOCTEST_ANON_TMP_\\d+)|(?:\\w+))ITERATOR<.*");
    @NonNls
    static final String regTest = "::doctest::detail::regTest";
    @NonNls
    static final String setTestSuite = "::doctest::detail::setTestSuite";
    @NonNls
    static final String doctest_detail_test_suite = "doctest_detail_test_suite_ns";

    @NotNull
    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        if (file == null) {
            CidrDoctestTestUtil.$$$reportNull$$$0(0);
        }
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final Project project = file.getProject();
        final CidrDoctestTestFramework testFramework = CidrDoctestTestFramework.getInstance();
        final VirtualFile virtualFile = file.getVirtualFile();
        final boolean isRoot = testFramework.isPotentialTestHolderRoot(file.getProject()).value((Object)virtualFile);
        Processor<OCSymbol> processor = new Processor<OCSymbol>(){
            final Stack<OCNamespaceSymbol> namespaces = new Stack();
            final Stack<String> suites = new Stack();

            public boolean process(final @NotNull OCSymbol symbol) {
                OCExpression _initializer;
                OCDeclarator declarator;
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!isRoot && !virtualFile.equals(symbol.getContainingFile())) {
                    return true;
                }
                PsiFile psiFile = symbol.getContainingPsiFile(project);
                if (psiFile == null || testFramework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    return true;
                }
                final OCResolveContext context = OCResolveContext.forPsi((PsiElement)psiFile);
                if (symbol instanceof OCNamespaceSymbol && symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    OCIfStatement ifStm;
                    OCFunctionDefinition getCurrentTestSuite;
                    Object doctest_detail_test_suite_ns;
                    OCCppNamespace sameNameNS;
                    if (_DOCTEST_ANON_SUITE_.matcher(symbol.getName()).matches() && (sameNameNS = (OCCppNamespace)symbol.locateDefinition(project)) != null && (doctest_detail_test_suite_ns = (OCCppNamespace)PsiTreeUtil.findChildOfType((PsiElement)sameNameNS, OCCppNamespace.class)) != null && CidrDoctestTestUtil.doctest_detail_test_suite.equals(doctest_detail_test_suite_ns.getName()) && (getCurrentTestSuite = (OCFunctionDefinition)PsiTreeUtil.findChildOfType((PsiElement)doctest_detail_test_suite_ns, OCFunctionDefinition.class)) != null && getCurrentTestSuite.getBody() != null && (ifStm = (OCIfStatement)PsiTreeUtil.findChildOfType((PsiElement)getCurrentTestSuite.getBody(), OCIfStatement.class)) != null && ifStm.getThenBranch() != null) {
                        CidrDoctestTestUtil.checkMul(false, false, links, symbol, testFramework, context, PsiTreeUtil.findChildOfType((PsiElement)ifStm.getThenBranch(), OCExpressionStatement.class));
                    }
                    this.namespaces.push((OCNamespaceSymbol)symbol);
                    List membersList = ((OCNamespaceSymbol)symbol).getMembersList();
                    if (membersList != null) {
                        for (OCSymbol nsSymbol : membersList) {
                            this.process(nsSymbol);
                        }
                    }
                    String endNamespace = this.namespaces.pop().getName();
                    if (this.suites.size() > 0 && this.suites.peek().equals(endNamespace)) {
                        this.suites.pop();
                    }
                    return true;
                }
                if (symbol.getKind() == OCSymbolKind.STRUCT && _DOCTEST_ANON_TMP_ITERATOR.matcher(symbol.getType().getName()).matches()) {
                    OCStruct struct = (OCStruct)symbol.locateDefinition(project);
                    if (struct != null) {
                        struct.getParent().getParent().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                            public void visitElement(@NotNull PsiElement maybeTestCase) {
                                if (maybeTestCase == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (maybeTestCase instanceof OCCallExpression && CidrDoctestTestUtil.regTest.equals(CidrDoctestTestUtil.getFunctionName(((OCCallExpression)maybeTestCase).getFunctionReferenceExpression()))) {
                                    this.stopWalking();
                                    CidrDoctestTestUtil.checkMul(true, true, links, symbol, testFramework, context, maybeTestCase);
                                } else {
                                    super.visitElement(maybeTestCase);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maybeTestCase", "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestUtil$1$1", "visitElement"));
                            }
                        });
                    }
                } else if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE && _DOCTEST_ANON_VAR_.matcher(symbol.getName()).matches() && symbol.getType() instanceof OCIntType && (declarator = (OCDeclarator)symbol.locateDefinition(project)) != null && (_initializer = declarator.getInitializer()) instanceof OCCallExpression) {
                    String funcName = CidrDoctestTestUtil.getFunctionName(((OCCallExpression)_initializer).getFunctionReferenceExpression());
                    if (CidrDoctestTestUtil.setTestSuite.equals(funcName)) {
                        CidrDoctestTestUtil.checkMul(false, false, links, symbol, testFramework, context, (PsiElement)_initializer);
                    } else if (CidrDoctestTestUtil.regTest.equals(funcName)) {
                        CidrDoctestTestUtil.checkMul(true, false, links, symbol, testFramework, context, (PsiElement)_initializer);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestUtil$1", "process"));
            }
        };
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, (Processor)processor);
        HashMap<String, CidrTestScopeElement> hashMap = links;
        if (hashMap == null) {
            CidrDoctestTestUtil.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static boolean checkMul(boolean isTest, boolean isTemplate, @NotNull Map<String, CidrTestScopeElement> links, @NotNull OCSymbol symbol, @NotNull CidrDoctestTestFramework testFramework, @NotNull OCResolveContext context, @Nullable PsiElement multiBinary) {
        if (links == null) {
            CidrDoctestTestUtil.$$$reportNull$$$0(2);
        }
        if (symbol == null) {
            CidrDoctestTestUtil.$$$reportNull$$$0(3);
        }
        if (testFramework == null) {
            CidrDoctestTestUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CidrDoctestTestUtil.$$$reportNull$$$0(5);
        }
        if (multiBinary != null) {
            Collection literals = PsiTreeUtil.findChildrenOfAnyType((PsiElement)multiBinary, (Class[])new Class[]{OCLiteralExpression.class});
            for (OCLiteralExpression literal : literals) {
                if (!literal.isStringLiteral() || !(literal.getParent() instanceof OCBinaryExpression)) continue;
                String name = literal.getUnescapedLiteralText();
                String testQNameDecl = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)((OCSymbolWithQualifiedName)symbol), (OCResolveContext)context);
                long offsetAsNaturalOrder = symbol.getComplexOffset();
                if (testQNameDecl != null && !name.isEmpty()) {
                    links.put(testQNameDecl, CidrTestScopeSerialization.createTestScopeElementForCaching((String)(isTest ? name + (isTemplate ? "<*" : "") : null), (String)(isTest ? null : name), (long)offsetAsNaturalOrder, (String)testQNameDecl, (PsiFile)context.getFile(), (OCSymbolKind)symbol.getKind(), testFramework.getGenerator()));
                }
                return true;
            }
        }
        return false;
    }

    @Contract(value="null -> null")
    private static String getFunctionName(@Nullable OCExpression expression) {
        OCResolveContext context;
        OCSymbol symbol;
        if (expression instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)expression).resolveToSymbol(context = OCResolveContext.forPsi((PsiElement)expression))) instanceof OCSymbolWithQualifiedName && (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION || symbol.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION || symbol.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION)) {
            return CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)((OCSymbolWithQualifiedName)symbol), (OCResolveContext)context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestLinks";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkMul";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

