/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.diff.DiffUmlProvider;
import com.intellij.uml.diff.ShowDiffOnUmlAction;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShowChangesAction
extends ShowDiffOnUmlAction {
    @Nullable
    private String selectedListID;

    ShowChangesAction() {
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowChangesAction.$$$reportNull$$$0(0);
        }
        this.selectedListID = null;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        ChangeList[] contextChangeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        List allChangeLists = ChangeListManager.getInstance((Project)project).getChangeLists();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("diagram.show.diff");
        if (contextChangeLists != null && contextChangeLists.length == 1 && contextChangeLists[0] instanceof LocalChangeList) {
            this.doActionPerformed(project, (LocalChangeList)contextChangeLists[0], point);
        } else if (allChangeLists.size() == 1) {
            this.doActionPerformed(project, (LocalChangeList)allChangeLists.get(0), point);
        } else {
            JBPopupFactory.getInstance().createPopupChooserBuilder(allChangeLists).setItemChosenCallback(selectedValue -> this.doActionPerformed(project, (LocalChangeList)selectedValue, point)).setTitle(DiagramBundle.message("popup.title.select.change.list", new Object[0])).createPopup().showInBestPositionFor(e.getDataContext());
        }
    }

    private void doActionPerformed(@NotNull Project project, @NotNull LocalChangeList changeList, @NotNull RelativePoint point) {
        if (project == null) {
            ShowChangesAction.$$$reportNull$$$0(1);
        }
        if (changeList == null) {
            ShowChangesAction.$$$reportNull$$$0(2);
        }
        if (point == null) {
            ShowChangesAction.$$$reportNull$$$0(3);
        }
        this.selectedListID = changeList.getId();
        if (changeList.getChanges().size() <= 50) {
            this.showUnderProgress(project, DiffUmlProvider.INSTANCE, null, Collections.emptyList(), point);
        } else {
            DiagramAction.showNotification(DiagramBundle.message("change.list.contains.too.many.files", this.selectedListID, 50), point);
        }
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Project project, @Nullable Object element, @NotNull DiagramProvider<Object> provider, @NotNull DiagramState presentation, @NotNull Collection<Object> additionalElements) {
        LocalChangeList list;
        if (project == null) {
            ShowChangesAction.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            ShowChangesAction.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            ShowChangesAction.$$$reportNull$$$0(6);
        }
        if (additionalElements == null) {
            ShowChangesAction.$$$reportNull$$$0(7);
        }
        String string = (list = this.getChangeList(project)) == null ? DiagramBundle.message("uml.change.list.name", new Object[0]) : DiagramBundle.message("uml.file.name.for.changes", list.getName());
        if (string == null) {
            ShowChangesAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        boolean isFileContextMenu;
        Project project;
        boolean enabled;
        if (e == null) {
            ShowChangesAction.$$$reportNull$$$0(9);
        }
        boolean visible = enabled = (project = e.getProject()) != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        boolean bl = isFileContextMenu = ActionPlaces.isPopupPlace((String)e.getPlace()) && !"ChangesViewPopup".equals(e.getPlace());
        if (visible && isFileContextMenu) {
            Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            visible = files != null && ContainerUtil.exists((Object[])files, file -> {
                FileStatus status = ChangeListManager.getInstance((Project)project).getStatus(file);
                return status == FileStatus.ADDED || status == FileStatus.MODIFIED;
            });
        }
        e.getPresentation().setEnabled(enabled && !DumbService.isDumb((Project)project));
        e.getPresentation().setVisible(visible);
    }

    @Nullable
    private LocalChangeList getChangeList(@NotNull Project project) {
        if (project == null) {
            ShowChangesAction.$$$reportNull$$$0(10);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 0 && this.selectedListID != null) {
            return ChangeListManager.getInstance((Project)project).getChangeList(this.selectedListID);
        }
        return null;
    }

    @Override
    @Nullable
    protected UmlVirtualFileSystem.UmlVirtualFile initializeDiagramVirtualFile(@NotNull Project project, @NotNull DiagramProvider<Object> provider, @Nullable Object element, @NotNull Collection<Object> additionalElements) {
        if (project == null) {
            ShowChangesAction.$$$reportNull$$$0(11);
        }
        if (provider == null) {
            ShowChangesAction.$$$reportNull$$$0(12);
        }
        if (additionalElements == null) {
            ShowChangesAction.$$$reportNull$$$0(13);
        }
        String url = "uml://" + provider.getID() + "/$SHOW_CHANGES$";
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        LocalChangeList list = this.getChangeList(project);
        if (list != null && virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
            String text = DiagramBundle.message("uml.file.name.for.changes", list.getName());
            file.setPresentableName(text);
            file.putUserData(DiffUmlProvider.CHANGE_LIST, list);
            UmlVirtualFileSystem.setInitialized(file);
            return file;
        }
        return super.initializeDiagramVirtualFile(project, provider, element, additionalElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/diff/ShowChangesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/diff/ShowChangesAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doActionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initializeDiagramVirtualFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

