/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePathToMainFile, @Nullable String relativePathToAdditionalBinaries) {
        if (relativePathToMainFile == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(0);
        }
        return CidrDebuggerPathManager.getBinFile("lldb/" + CidrPathManager.getPlatformRelativePath((String)relativePathToMainFile), relativePathToAdditionalBinaries == null ? null : "lldb/" + CidrPathManager.getPlatformRelativePath((String)relativePathToAdditionalBinaries));
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        return CidrDebuggerPathManager.getBinFile("lldb/renderers");
    }

    @NotNull
    public static File getBundledGDBBinary() {
        String platformBin = "gdb/" + CidrPathManager.getPlatformRelativePath((String)"bin");
        return CidrDebuggerPathManager.getBinFile(platformBin + "/" + (SystemInfo.isWindows ? "gdb.exe" : "gdb"), platformBin);
    }

    @NotNull
    public static File getWinbreakFile(@NotNull String name) {
        if (name == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(1);
        }
        return CidrDebuggerPathManager.getBinFile("gdb/" + name);
    }

    @NotNull
    public static File getBundledGDBSTLPrettyPrinters() {
        return CidrDebuggerPathManager.getBinFile("gdb/renderers");
    }

    @Nullable
    public static File getOSXSystemPythonBinDir() {
        File pythonBinDir = new File("/System/Library/Frameworks/Python.framework/Versions/Current/bin");
        if (pythonBinDir.exists() && pythonBinDir.isDirectory()) {
            return pythonBinDir;
        }
        return null;
    }

    @NotNull
    private static File getBinFile(String relativePath) {
        return CidrDebuggerPathManager.getBinFile(relativePath, null);
    }

    @NotNull
    private static File getBinFile(String relativePath, @Nullable String relativePathToAdditionalBinaries) {
        File file = CidrPathManager.getBinPath(CidrDebuggerPathManager.class, (String)"cidr-debugger/bin", (String)relativePath, (String)relativePathToAdditionalBinaries).toFile();
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(2);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToMainFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getWinbreakFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

