/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrOSProcessUtil;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.CidrAttachedDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import org.jetbrains.annotations.NotNull;

public class CidrLocalAttachedDebugProcess
extends CidrAttachedDebugProcess {
    private final int myPid;

    public CidrLocalAttachedDebugProcess(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info, @NotNull XDebugSession session, @NotNull TextConsoleBuilder builder) throws ExecutionException {
        if (driverConfiguration == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(0);
        }
        if (info == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(3);
        }
        this(driverConfiguration, info, session, builder, it -> Filter.EMPTY_ARRAY);
    }

    public CidrLocalAttachedDebugProcess(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info, @NotNull XDebugSession session, @NotNull TextConsoleBuilder builder, @NotNull ConsoleFilterProvider backendFilterProvider) throws ExecutionException {
        if (driverConfiguration == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(4);
        }
        if (info == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(5);
        }
        if (session == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(7);
        }
        if (backendFilterProvider == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(8);
        }
        super(CidrLocalAttachedDebugProcess.createRunParameters(driverConfiguration, info), session, builder, backendFilterProvider);
        this.myPid = info.getPid();
    }

    @NotNull
    private static RunParameters createRunParameters(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info) {
        if (driverConfiguration == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(9);
        }
        if (info == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(10);
        }
        int pid = info.getPid();
        ArchitectureType architectureType = SystemInfoRt.isWindows ? CidrOSProcessUtil.getProcessArchitectureType(pid) : ArchitectureType.UNKNOWN;
        return new TrivialRunParameters(driverConfiguration, new GeneralCommandLine(), architectureType);
    }

    @Override
    protected int getPidToAttachTo() throws ExecutionException {
        return this.myPid;
    }

    @Override
    public boolean isDetachDefault() {
        return true;
    }

    @Override
    @NlsContexts.LinkLabel
    @NotNull
    protected String getRestartDebuggerMessage() {
        String string = XDebuggerBundle.message((String)"xdebugger.attach.reattach", (Object[])new Object[]{this.myPid});
        if (string == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverConfiguration";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendFilterProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrLocalAttachedDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrLocalAttachedDebugProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartDebuggerMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRunParameters";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

