/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    private static final Pattern SWIFT_DESCRIPTION_PATTERN = Pattern.compile("( *((\u25bf .*)|(- .*? : .*?))(\n|$))*");
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final CachedDebuggerResult<Pair<String, XFullValueEvaluator>> myValueCache;
    @NotNull
    private final CachedDebuggerResult<Boolean> myMayHaveChildrenCache;
    @NotNull
    private final CachedDebuggerResult<Integer> myChildrenCountCache;

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(0);
        }
        this.myValueCache = new CachedDebuggerResult();
        this.myMayHaveChildrenCache = new CachedDebuggerResult();
        this.myChildrenCountCache = new CachedDebuggerResult();
        this.myValue = value;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        CidrPhysicalValue cidrPhysicalValue = this.myValue;
        if (cidrPhysicalValue == null) {
            ValueRenderer.$$$reportNull$$$0(1);
        }
        return cidrPhysicalValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        LLValue childVar;
        Long address;
        if (child == null) {
            ValueRenderer.$$$reportNull$$$0(2);
        }
        LLValueData varData = this.myValue.getPreparedVarData();
        boolean isSynthetic = varData.isSynthetic();
        if (lvalue && isSynthetic && (address = (childVar = child.getVar()).getAddress()) != null && ValueRenderer.isValueOfPrimitiveType(childVar)) {
            String string = "(*(" + childVar.getType() + "*)(0x" + Long.toHexString(address) + "))";
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        boolean isPointer = varData.isPointer();
        boolean isSwift = this.myValue.isSwiftContext();
        if (child.getName().matches("\\[\\w+\\]")) {
            String string = this.getChildEvaluationExpression(child, "", this.myValue);
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (!isSwift && isPointer) {
            String string = this.getChildEvaluationExpression(child, "->", this.myValue);
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (!isSwift && this.myValue instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)this.myValue;
            if (value.getIndex() == 0) {
                String string = this.getChildEvaluationExpression(child, "->", value.getContainer());
                if (string == null) {
                    ValueRenderer.$$$reportNull$$$0(6);
                }
                return string;
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                String string = parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
                if (string == null) {
                    ValueRenderer.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String string = this.getChildEvaluationExpression(child, ".", this.myValue);
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValueData messageSendToSelfData(String selectorAndArgs, String returnType, EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return context2.getData(this.messageSendToSelf(selectorAndArgs, returnType, context2));
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return context2.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context2) throws ExecutionException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(9);
        }
        StringBuilder builder = new StringBuilder();
        try {
            boolean hasChildren;
            String value = (String)this.computeValueAndEvaluator((EvaluationContext)context2).first;
            builder.append("(").append(this.myValue.getType()).append((") " + value).trim());
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeMayHaveChildren(context2))) {
                builder.append("\n");
                this.printChildrenConsoleDescription(context2, builder);
            }
        }
        catch (DebuggerCommandException e) {
            ValueRenderer.appendConsoleError(builder, this.toString());
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            ValueRenderer.$$$reportNull$$$0(10);
        }
        return stringBuilder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    private void printChildrenConsoleDescription(EvaluationContext context2, StringBuilder builder) throws ExecutionException, DebuggerCommandException {
        builder.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder, context2);
        try {
            this.computeChildren(context2, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder, @NotNull String errorMessage) {
        if (errorMessage == null) {
            ValueRenderer.$$$reportNull$$$0(11);
        }
        builder.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        return ValueRenderer.getShortenedType(this.myValue.getVar().getType());
    }

    @NotNull
    public static String getShortenedType(@NotNull String type) {
        if (type == null) {
            ValueRenderer.$$$reportNull$$$0(12);
        }
        int TEMPLATE_TYPE_REDUCE_LEVEL = 1;
        StringBuilder result2 = new StringBuilder();
        int count = 0;
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '<') {
                ++count;
            }
            if (count <= TEMPLATE_TYPE_REDUCE_LEVEL) {
                int length = result2.length();
                if (c == '>' && length > 2 && result2.charAt(length - 1) == ' ' && result2.charAt(length - 2) != '>') {
                    result2.setLength(length - 1);
                }
                result2.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        String string = count == 0 ? result2.toString() : type;
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String separator, CidrPhysicalValue parent) {
        String childVarName;
        boolean cast;
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, separator, parent);
        }
        Object parentRefExpression = parent.getEvaluationExpression();
        boolean bl = cast = parent.getVar().getTypeClass() == LLValue.TypeClass.OBJC_POINTER;
        if (cast) {
            parentRefExpression = "((" + parent.getType() + ")(" + (String)parentRefExpression + "))";
        }
        return (childVarName = child.getVar().getName()).isBlank() ? parentRefExpression : (String)parentRefExpression + separator + childVarName;
    }

    @NotNull
    public Pair<String, XFullValueEvaluator> computeValueAndEvaluator(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(14);
        }
        Pair<String, XFullValueEvaluator> pair = this.myValueCache.getResult(new CachedDebuggerResult.NotNullCalculator<Pair<String, XFullValueEvaluator>>(){

            @Override
            @NotNull
            public Pair<String, XFullValueEvaluator> calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context2);
                if (data.isNullPointer()) {
                    LLValue var = ValueRenderer.this.getValue().getVar();
                    boolean objc = var.getTypeClass() == LLValue.TypeClass.OBJC_POINTER || "id".equals(var.getType()) && ValueRenderer.this.getValue().isObjectiveCContext();
                    Pair pair = Pair.create((Object)(objc ? "nil" : "NULL"), null);
                    if (pair == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return pair;
                }
                if (ValueRenderer.this.myValue.isSwiftVoid()) {
                    Pair pair = Pair.create((Object)"", null);
                    if (pair == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return pair;
                }
                Pair result2 = ValueRenderer.this.doComputeValueAndEvaluator(context2);
                Pair pair = ((String)result2.first).equals("{...}") ? Pair.create((Object)"", null) : result2;
                if (pair == null) {
                    1.$$$reportNull$$$0(2);
                }
                return pair;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$1", "calculate"));
            }
        });
        if (pair == null) {
            ValueRenderer.$$$reportNull$$$0(15);
        }
        return pair;
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(16);
        }
        Pair<String, XFullValueEvaluator> pair = this.doComputeValueAndEvaluator(context2, this.myValue.getPresentationVar(), this.myValue.getPresentationVarData(context2));
        if (pair == null) {
            ValueRenderer.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context2, LLValue var, LLValueData data) throws ExecutionException, DebuggerCommandException {
        XFullValueEvaluator evaluator;
        String description;
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(18);
        }
        boolean isRawStringViewEnabled = Registry.is((String)"cidr.debugger.value.stringEvaluator", (boolean)false);
        Pair result2 = null;
        String descriptionOrig = data.getDescription();
        if (descriptionOrig != null) {
            description = descriptionOrig;
            if (this.myValue.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT) {
                description = StringUtil.unescapeStringCharacters((String)description);
            }
            if (!this.ignoreDescription(description = description.trim())) {
                evaluator = null;
                boolean hasLongerDescription = data.hasLongerDescription();
                if (isRawStringViewEnabled && ValueRendererUtils.isBeginQuotedString(description)) {
                    String linkText = CidrDebuggerBundle.message("debugger.variables.showRawStringValue.link", new Object[0]);
                    evaluator = this.createFullDescriptionEvaluator(var, linkText, ValueRendererUtils::getRawString);
                } else if (hasLongerDescription) {
                    String linkText = XDebuggerBundle.message((String)"node.test.show.full.value", (Object[])new Object[0]);
                    evaluator = this.createFullDescriptionEvaluator(var, linkText, null);
                }
                result2 = Pair.create((Object)StringUtil.first((String)description, (int)1000, (boolean)false), (Object)evaluator);
            }
        }
        if (result2 == null) {
            description = this.doComputeFallbackValue(context2, var, data);
            evaluator = null;
            if (isRawStringViewEnabled && ValueRendererUtils.isQuotedString(description)) {
                String linkText = CidrDebuggerBundle.message("debugger.variables.showRawStringValue.link", new Object[0]);
                evaluator = this.createImmediateDescriptionEvaluator(description, linkText, ValueRendererUtils::getRawString);
            } else if (description.length() > 1000) {
                String linkText = XDebuggerBundle.message((String)"node.test.show.full.value", (Object[])new Object[0]);
                evaluator = this.createImmediateDescriptionEvaluator(description, linkText, null);
            }
            result2 = Pair.create((Object)StringUtil.first((String)description, (int)1000, (boolean)false), evaluator);
        }
        Pair pair = result2;
        if (pair == null) {
            ValueRenderer.$$$reportNull$$$0(19);
        }
        return pair;
    }

    protected boolean ignoreDescription(@NotNull String description) {
        DebuggerDriver.DebuggerLanguage language;
        if (description == null) {
            ValueRenderer.$$$reportNull$$$0(20);
        }
        return (language = this.myValue.getLanguage()) == DebuggerDriver.StandardDebuggerLanguage.OBJC && StringUtil.containsLineBreak((CharSequence)description) || language == DebuggerDriver.StandardDebuggerLanguage.SWIFT && SWIFT_DESCRIPTION_PATTERN.matcher(description).matches();
    }

    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context2, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(21);
        }
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(22);
        }
        if (data == null) {
            ValueRenderer.$$$reportNull$$$0(23);
        }
        String string = data.getValue();
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(24);
        }
        return string;
    }

    private XFullValueEvaluator createImmediateDescriptionEvaluator(@NotNull String description, @NotNull @Nls String linkText, @Nullable Function<String, String> descriptionProc) {
        if (description == null) {
            ValueRenderer.$$$reportNull$$$0(25);
        }
        if (linkText == null) {
            ValueRenderer.$$$reportNull$$$0(26);
        }
        if (this.myValue.getProcess().getUserData(CidrValue.THREAT_VALUE_AS_RICH_TEXT) == Boolean.TRUE) {
            description = ValueRendererUtils.extractString(description);
        }
        if (descriptionProc != null) {
            description = descriptionProc.apply(description);
        }
        return new ImmediateFullValueEvaluator(linkText, description);
    }

    @NotNull
    private XFullValueEvaluator createFullDescriptionEvaluator(final @NotNull LLValue value, @NotNull @Nls String linkText, final @Nullable Function<String, String> descriptionProc) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(27);
        }
        if (linkText == null) {
            ValueRenderer.$$$reportNull$$$0(28);
        }
        return new XFullValueEvaluator(linkText){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    2.$$$reportNull$$$0(0);
                }
                ValueRenderer.this.getValue().getProcess().postCommand(driver -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    try {
                        int _10mb = 0xA00000;
                        String description = driver.getDescription(value, _10mb);
                        description = StringUtil.notNullize((String)description);
                        if (ValueRenderer.this.myValue.getProcess().getUserData(CidrValue.THREAT_VALUE_AS_RICH_TEXT) == Boolean.TRUE) {
                            description = ValueRendererUtils.extractString(description);
                        }
                        if (descriptionProc != null) {
                            description = (String)descriptionProc.apply(description);
                        }
                        callback.evaluated(description);
                    }
                    catch (DebuggerCommandException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$2", "startEvaluation"));
            }
        };
    }

    public boolean computeMayHaveChildren(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        Integer result2;
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(29);
        }
        if (this.mayHaveChildrenViaChildrenCount() && (result2 = this.computeChildrenCount(context2)) != null) {
            return result2 > 0;
        }
        return this.myMayHaveChildrenCache.getResult(new CachedDebuggerResult.NotNullCalculator<Boolean>(){

            @Override
            @NotNull
            public Boolean calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context2);
                Boolean bl = data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? false : data.mayHaveChildren();
                if (bl == null) {
                    3.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$3", "calculate"));
            }
        });
    }

    protected boolean mayHaveChildrenViaChildrenCount() {
        return false;
    }

    @Nullable
    protected Integer computeChildrenCount(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(30);
        }
        return this.myChildrenCountCache.getResult(new CachedDebuggerResult.Calculator<Integer>(){

            @Override
            @Nullable
            public Integer calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context2);
                return data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? new Integer(0) : ValueRenderer.this.doComputeChildrenCount(context2);
            }
        });
    }

    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(31);
        }
        return context2.getChildrenCount(this.myValue.getPresentationVar());
    }

    public final void computeChildren(@NotNull EvaluationContext context2, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(32);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(33);
        }
        if (!this.computeMayHaveChildren(context2)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context2, container, 0, null);
    }

    protected int getBatchSize() {
        return ValueRenderer.getPositiveNumberFromRegistry("cidr.debugger.value.maxChildren", 50);
    }

    private static int getPositiveNumberFromRegistry(@NotNull String key, int defaultValue) {
        int value;
        if (key == null) {
            ValueRenderer.$$$reportNull$$$0(34);
        }
        if ((value = Registry.intValue((String)key, (int)defaultValue)) <= 0) {
            CidrDebuggerLog.LOG.warn(key + " must be a positive number, falling back to default value: " + defaultValue);
            value = defaultValue;
        }
        return value;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context2, @NotNull XCompositeNode container, int fromIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(35);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(36);
        }
        LLValue var = this.myValue.getPresentationVar();
        DebuggerDriver.ResultList<LLValue> result2 = context2.getVariableChildren(var, fromIndex, this.getBatchSize());
        this.addChildrenTo(result2.list, context2, container, fromIndex, this.areChildrenModifiable(var, this.myValue.getPresentationVarData(context2)));
        if (result2.hasMore && !result2.list.isEmpty()) {
            int nextIndex = fromIndex + result2.list.size();
            this.tooManyChildren(context2, container, nextIndex, totalCount);
        }
    }

    protected void tooManyChildren(@NotNull EvaluationContext context2, @NotNull XCompositeNode container, int nextIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(37);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(38);
        }
        if (totalCount == null && (totalCount = this.computeChildrenCount(context2)) == null) {
            totalCount = -1;
        }
        Integer finalTotalCount = totalCount;
        container.tooManyChildren(totalCount == -1 ? -1 : totalCount - nextIndex, () -> this.getValue().getProcess().postCommand(driver -> CidrPhysicalValue.invokeRenderChildren(container, () -> this.doComputeChildren(context2, container, nextIndex, finalTotalCount))));
    }

    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context2, @NotNull XCompositeNode container, int startIndex, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        if (children == null) {
            ValueRenderer.$$$reportNull$$$0(39);
        }
        if (context2 == null) {
            ValueRenderer.$$$reportNull$$$0(40);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(41);
        }
        SmartList values = new SmartList();
        for (LLValue each : children) {
            if (container.isObsolete()) {
                return;
            }
            boolean isChildModifiable = modifiable || this.isChildModifiable(each);
            values.add(new CidrMemberValue(each, this.myValue, isChildModifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, container);
    }

    protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(42);
        }
        if (data == null) {
            ValueRenderer.$$$reportNull$$$0(43);
        }
        return !data.isSynthetic();
    }

    protected boolean isChildModifiable(@NotNull LLValue var) {
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(44);
        }
        return var.getAddress() != null && ValueRenderer.isValueOfPrimitiveType(var);
    }

    private static boolean isValueOfPrimitiveType(@NotNull LLValue var) {
        LLValue.TypeClass typeClass;
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(45);
        }
        return (typeClass = var.getTypeClass()) == LLValue.TypeClass.BUILTIN || typeClass == LLValue.TypeClass.POINTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 22: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 23: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 33: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEvaluationExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortenedType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeValueAndEvaluator";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeFallbackValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildEvaluationExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDescription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendConsoleError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShortenedType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeValueAndEvaluator";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDescription";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doComputeFallbackValue";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createImmediateDescriptionEvaluator";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFullDescriptionEvaluator";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeMayHaveChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeChildrenCount";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildrenCount";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPositiveNumberFromRegistry";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "tooManyChildren";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenModifiable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isChildModifiable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValueOfPrimitiveType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context2) {
            this.myBuilder = builder;
            this.myContext = context2;
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            if (children == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(0);
            }
            for (int i = 0; i < children.size(); ++i) {
                String name = children.getName(i);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children.getValue(i)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DebuggerCommandException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(1);
            }
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(2);
            }
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(4);
            }
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setErrorMessage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

