/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsStringUtil {
    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StatisticsStringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        if (StatisticsStringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@Nullable String s1, @Nullable String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        return s1.equals(s2);
    }

    @NotNull
    public static List<String> split(@NotNull String text, char separator) {
        if (text == null) {
            StatisticsStringUtil.$$$reportNull$$$0(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int index = text.indexOf(separator, pos);
        while (index >= 0) {
            int nextPos = index + 1;
            String token = text.substring(pos, index);
            if (token.length() != 0) {
                result.add(token);
            }
            pos = nextPos;
            index = text.indexOf(separator, pos);
        }
        if (pos < text.length()) {
            result.add(text.substring(pos));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            StatisticsStringUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/StatisticsStringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/StatisticsStringUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

