/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

final class ShTerminalRunner
implements ShRunner {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);

    ShTerminalRunner() {
    }

    @Override
    public void run(@NotNull Project project, @NotNull String command, @NotNull String workingDirectory, @NotNull @NlsContexts.TabTitle String title, boolean activateToolWindow) {
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ShTerminalRunner.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            ShTerminalRunner.$$$reportNull$$$0(2);
        }
        if (title == null) {
            ShTerminalRunner.$$$reportNull$$$0(3);
        }
        TerminalView terminalView = TerminalView.getInstance((Project)project);
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        if (window == null) {
            return;
        }
        ContentManager contentManager = window.getContentManager();
        Pair<Content, ShellTerminalWidget> pair = ShTerminalRunner.getSuitableProcess(contentManager, workingDirectory);
        try {
            if (pair == null) {
                terminalView.createLocalShellWidget(workingDirectory, title, activateToolWindow, activateToolWindow).executeCommand(command);
                return;
            }
            if (activateToolWindow) {
                window.activate(null);
            }
            ((Content)pair.first).setDisplayName(title);
            contentManager.setSelectedContent((Content)pair.first);
            ((ShellTerminalWidget)pair.second).executeCommand(command);
        }
        catch (IOException e) {
            LOG.warn("Cannot run command:" + command, (Throwable)e);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        ToolWindow window;
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(4);
        }
        return (window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal")) != null && window.isAvailable();
    }

    @Nullable
    private static Pair<Content, ShellTerminalWidget> getSuitableProcess(@NotNull ContentManager contentManager, @NotNull String workingDirectory) {
        Pair<Content, ShellTerminalWidget> pair;
        Content selectedContent;
        if (contentManager == null) {
            ShTerminalRunner.$$$reportNull$$$0(5);
        }
        if (workingDirectory == null) {
            ShTerminalRunner.$$$reportNull$$$0(6);
        }
        if ((selectedContent = contentManager.getSelectedContent()) != null && (pair = ShTerminalRunner.getSuitableProcess(selectedContent, workingDirectory)) != null) {
            return pair;
        }
        return Arrays.stream(contentManager.getContents()).map(content -> ShTerminalRunner.getSuitableProcess(content, workingDirectory)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static Pair<Content, ShellTerminalWidget> getSuitableProcess(@NotNull Content content, @NotNull String workingDirectory) {
        JBTerminalWidget widget;
        if (content == null) {
            ShTerminalRunner.$$$reportNull$$$0(7);
        }
        if (workingDirectory == null) {
            ShTerminalRunner.$$$reportNull$$$0(8);
        }
        if (!((widget = TerminalView.getWidgetByContent((Content)content)) instanceof ShellTerminalWidget)) {
            return null;
        }
        ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)widget;
        if (!shellTerminalWidget.getTypedShellCommand().isEmpty() || shellTerminalWidget.hasRunningCommands()) {
            return null;
        }
        String currentWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory((JBTerminalWidget)shellTerminalWidget, null);
        if (currentWorkingDirectory == null || !currentWorkingDirectory.equals(workingDirectory)) {
            return null;
        }
        return new Pair((Object)content, (Object)shellTerminalWidget);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/run/terminal/ShTerminalRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

