/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JumpsAndSwitches
implements CoverageData {
    private List<JumpData> myJumps;
    private JumpData[] myJumpsArray;
    private List<SwitchData> mySwitches;
    private SwitchData[] mySwitchesArray;

    public JumpData[] getJumps() {
        return this.myJumpsArray;
    }

    public SwitchData[] getSwitches() {
        return this.mySwitchesArray;
    }

    public JumpData addJump(int jump) {
        if (this.myJumps == null) {
            this.myJumps = new ArrayList<JumpData>();
        }
        if (this.myJumps.size() <= jump) {
            for (int i = this.myJumps.size(); i <= jump; ++i) {
                this.myJumps.add(new JumpData());
            }
        }
        return this.myJumps.get(jump);
    }

    public JumpData getJumpData(int jump) {
        return this.myJumpsArray == null ? null : this.myJumpsArray[jump];
    }

    public SwitchData addSwitch(int switchNumber, int[] keys) {
        if (this.mySwitches == null) {
            this.mySwitches = new ArrayList<SwitchData>();
        }
        SwitchData switchData = new SwitchData(keys);
        if (this.mySwitches.size() <= switchNumber) {
            for (int i = this.mySwitches.size(); i < switchNumber; ++i) {
                this.mySwitches.add(new SwitchData(new int[0]));
            }
            if (this.mySwitches.size() == switchNumber) {
                this.mySwitches.add(switchData);
            }
        }
        return this.mySwitches.get(switchNumber);
    }

    public void removeSwitch(int switchNumber) {
        if (0 <= switchNumber && switchNumber < this.mySwitches.size()) {
            this.mySwitches.remove(switchNumber);
        } else {
            ErrorReporter.reportError("Remove switch", new ArrayIndexOutOfBoundsException(switchNumber));
        }
    }

    public SwitchData getSwitchData(int switchNumber) {
        return this.mySwitchesArray == null ? null : this.mySwitchesArray[switchNumber];
    }

    public void save(DataOutputStream os) throws IOException {
        CoverageIOUtil.writeINT(os, this.myJumpsArray != null ? this.myJumpsArray.length : 0);
        if (this.myJumpsArray != null) {
            for (JumpData jumpData : this.myJumpsArray) {
                jumpData.save(os);
            }
        }
        CoverageIOUtil.writeINT(os, this.mySwitchesArray != null ? this.mySwitchesArray.length : 0);
        if (this.mySwitchesArray != null) {
            for (CoverageData coverageData : this.mySwitchesArray) {
                ((SwitchData)coverageData).save(os);
            }
        }
    }

    public void removeJump(int jump) {
        if (0 <= jump && jump < this.myJumps.size()) {
            this.myJumps.remove(jump);
        } else {
            ErrorReporter.reportError("Remove jump", new ArrayIndexOutOfBoundsException(jump));
        }
    }

    public void fillArrays() {
        int i;
        if (this.myJumps != null) {
            this.myJumpsArray = new JumpData[this.myJumps.size()];
            for (i = 0; i < this.myJumps.size(); ++i) {
                this.myJumpsArray[i] = this.myJumps.get(i);
            }
            this.myJumps = null;
        }
        if (this.mySwitches != null) {
            this.mySwitchesArray = new SwitchData[this.mySwitches.size()];
            for (i = 0; i < this.mySwitches.size(); ++i) {
                this.mySwitchesArray[i] = this.mySwitches.get(i);
            }
            this.mySwitches = null;
        }
    }

    public void merge(CoverageData data) {
        CoverageData[] extJumpsArray;
        JumpsAndSwitches jumpsData = (JumpsAndSwitches)data;
        if (jumpsData.myJumpsArray != null) {
            if (this.myJumpsArray == null) {
                this.myJumpsArray = new JumpData[jumpsData.myJumpsArray.length];
            } else if (this.myJumpsArray.length < jumpsData.myJumpsArray.length) {
                extJumpsArray = new JumpData[jumpsData.myJumpsArray.length];
                System.arraycopy(this.myJumpsArray, 0, extJumpsArray, 0, this.myJumpsArray.length);
                this.myJumpsArray = extJumpsArray;
            }
            JumpsAndSwitches.mergeJumps(this.myJumpsArray, jumpsData.myJumpsArray);
        }
        if (jumpsData.mySwitchesArray != null) {
            if (this.mySwitchesArray == null) {
                this.mySwitchesArray = new SwitchData[jumpsData.mySwitchesArray.length];
            } else if (this.mySwitchesArray.length < jumpsData.mySwitchesArray.length) {
                extJumpsArray = new SwitchData[jumpsData.mySwitchesArray.length];
                System.arraycopy(this.mySwitchesArray, 0, extJumpsArray, 0, this.mySwitchesArray.length);
                this.mySwitchesArray = extJumpsArray;
            }
            JumpsAndSwitches.mergeSwitches(this.mySwitchesArray, jumpsData.mySwitchesArray);
        }
    }

    private static void mergeSwitches(SwitchData[] myArray, SwitchData[] array) {
        for (int i = 0; i < array.length; ++i) {
            SwitchData switchData = myArray[i];
            if (switchData == null) {
                if (array[i] == null) continue;
                myArray[i] = switchData = new SwitchData(array[i].getKeys());
            }
            switchData.merge(array[i]);
        }
    }

    private static void mergeJumps(JumpData[] myArray, JumpData[] array) {
        for (int i = 0; i < array.length; ++i) {
            JumpData switchData = myArray[i];
            if (switchData == null) {
                if (array[i] == null) continue;
                myArray[i] = switchData = new JumpData();
            }
            switchData.merge(array[i]);
        }
    }

    public int jumpsCount() {
        if (this.myJumps != null) {
            return this.myJumps.size();
        }
        if (this.myJumpsArray != null) {
            return this.myJumpsArray.length;
        }
        return 0;
    }

    public int switchesCount() {
        if (this.mySwitches != null) {
            return this.mySwitches.size();
        }
        if (this.mySwitchesArray != null) {
            return this.mySwitchesArray.length;
        }
        return 0;
    }
}

