/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.util.ConcurrentModificationException;
import org.jetbrains.coverage.gnu.trove.TIterator;
import org.jetbrains.coverage.gnu.trove.TObjectDoubleHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectDoubleIterator<K>
extends TIterator {
    private final TObjectDoubleHashMap<K> _map;

    public TObjectDoubleIterator(TObjectDoubleHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public double value() {
        return this._map._values[this._index];
    }

    public double setValue(double val) {
        double old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

