/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.InfoItemImpl;
import com.jetbrains.cidr.doxygen.psi.impl.DxPsiImplUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DoxygenCommentGroupImpl
implements DoxygenCommentGroup {
    @NotNull
    private final String options;
    @NotNull
    private final List<InfoItem> items;
    private final boolean empty;

    private DoxygenCommentGroupImpl(@NotNull String options, @NotNull List<InfoItem> items, boolean empty) {
        if (options == null) {
            DoxygenCommentGroupImpl.$$$reportNull$$$0(0);
        }
        if (items == null) {
            DoxygenCommentGroupImpl.$$$reportNull$$$0(1);
        }
        this.options = options;
        this.items = items;
        this.empty = empty;
    }

    @Override
    @NotNull
    public String getOptions() {
        String string = this.options;
        if (string == null) {
            DoxygenCommentGroupImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public List<InfoItem> getContent() {
        List<InfoItem> list = this.items;
        if (list == null) {
            DoxygenCommentGroupImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoxygenCommentGroupImpl commentGroup = (DoxygenCommentGroupImpl)o;
        if (!this.options.equals(commentGroup.options)) {
            return false;
        }
        int size = this.items.size();
        if (size != commentGroup.items.size()) {
            return false;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.items.get(i2).equals(commentGroup.items.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.options.hashCode();
        result = 31 * result + this.items.hashCode();
        return result;
    }

    public String getDescription() {
        return StringUtil.join(this.items, InfoItem::getDescription, (String)" ").trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentGroupImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentGroupImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Builder
    implements ComplexItemBuilder {
        private final List<InfoItem> tags = new ArrayList<InfoItem>();
        private String options = "";
        private boolean empty = true;

        Builder() {
        }

        public void addOptions(@NotNull ASTNode node) {
            if (node == null) {
                Builder.$$$reportNull$$$0(0);
            }
            assert (this.options.isEmpty());
            List<String> optionList = DxPsiImplUtil.extractOptions(node);
            this.options = "[" + StringUtil.join(optionList, (String)", ") + "]";
        }

        @Override
        public void addTag(@NotNull TagItem tag) {
            if (tag == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.empty = false;
            this.tags.add(tag);
        }

        @Override
        public void addText(@NotNull String text) {
            if (text == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.empty = false;
            if (text.isEmpty()) {
                return;
            }
            this.tags.add(new InfoItemImpl(text));
        }

        public DoxygenCommentGroupImpl build() {
            return new DoxygenCommentGroupImpl(this.options, this.tags, this.empty);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentGroupImpl$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

