/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportSuperHierarchyTreeStructure
extends HierarchyTreeStructure {
    private static final HierarchyNodeDescriptor[] EMPTY_DESCRIPTORS = new HierarchyNodeDescriptor[0];
    private static final boolean DISPLAY_LOCATION = !ApplicationManager.getApplication().isUnitTestMode();

    public OCImportSuperHierarchyTreeStructure(@NotNull Project project, @NotNull OCFile file) {
        if (project == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        super(project, OCImportSuperHierarchyTreeStructure.createDescriptor(project, null, file, true, DISPLAY_LOCATION));
    }

    protected Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor nodeDescriptor) {
        if (nodeDescriptor == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        OCClassHierarchyNodeDescriptor descriptor = (OCClassHierarchyNodeDescriptor)nodeDescriptor;
        OCFile file = (OCFile)descriptor.getType();
        FileSymbolTablesCache.getInstance(this.myProject).ensurePendingFilesProcessed();
        if (file == null) {
            if (EMPTY_DESCRIPTORS == null) {
                OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(3);
            }
            return EMPTY_DESCRIPTORS;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            if (EMPTY_DESCRIPTORS == null) {
                OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(4);
            }
            return EMPTY_DESCRIPTORS;
        }
        OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
        Collection<VirtualFile> includingFiles = importGraph.findImmediateIncludingFiles(vFile, false);
        List answer = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), includingFiles);
        return OCImportSuperHierarchyTreeStructure.convertToDescriptors(this.myProject, descriptor, answer, DISPLAY_LOCATION);
    }

    public static HierarchyNodeDescriptor @NotNull [] convertToDescriptors(@NotNull Project project, @Nullable OCClassHierarchyNodeDescriptor<OCFile> parent, @NotNull Collection<PsiFile> files, boolean displayLocation) {
        if (project == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(5);
        }
        if (files == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        HierarchyNodeDescriptor[] descriptors = new HierarchyNodeDescriptor[files.size()];
        int i2 = 0;
        for (PsiFile superFile : files) {
            OCFile ocFile = OCLanguageUtils.asOCFile(superFile);
            OCLog.LOG.assertTrue(ocFile != null, (Object)superFile);
            descriptors[i2] = OCImportSuperHierarchyTreeStructure.createDescriptor(project, parent, ocFile, false, displayLocation);
            ++i2;
        }
        if (descriptors == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(7);
        }
        return descriptors;
    }

    @NotNull
    public static HierarchyNodeDescriptor createDescriptor(@NotNull Project project, @Nullable OCClassHierarchyNodeDescriptor<OCFile> parent, @NotNull OCFile superFile, boolean isBase, boolean displayLocation) {
        if (project == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(8);
        }
        if (superFile == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(9);
        }
        return new OCClassHierarchyNodeDescriptor<OCFile>(project, parent, superFile, isBase, displayLocation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/include/OCImportSuperHierarchyTreeStructure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/include/OCImportSuperHierarchyTreeStructure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

