/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSinkWrapper;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclareSpecificMethodInPrivateCategoryAction;
import com.jetbrains.cidr.lang.legacy.daemon.OCAssignmentChecker;
import com.jetbrains.cidr.lang.legacy.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.legacy.daemon.OCFunctionGroupHelperKt;
import com.jetbrains.cidr.lang.legacy.quickfixes.OCCreateMissingSwitchCasesFix;
import com.jetbrains.cidr.lang.legacy.symbols.OCVisibility;
import com.jetbrains.cidr.lang.legacy.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeFunctionConstAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeFunctionVolatileAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodStaticnessIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCDeclareMethodInTargetInterfaceAction;
import com.jetbrains.cidr.lang.quickfixes.OCDeclarePropertyInPrivateCategoryAction;
import com.jetbrains.cidr.lang.quickfixes.OCExtractAssignmentIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCValueCategoryHolder;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOperatorsChecker
extends OCAnnotatorSinkWrapper {
    @NotNull
    private final OCCppChecker myCppChecker;

    public OCOperatorsChecker(@NotNull OCAnnotatorSink impl, @NotNull OCCppChecker checker) {
        if (impl == null) {
            OCOperatorsChecker.$$$reportNull$$$0(0);
        }
        if (checker == null) {
            OCOperatorsChecker.$$$reportNull$$$0(1);
        }
        super(impl);
        this.myCppChecker = checker;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkBinaryOperatorApplicable(OCExpression lOperand, OCExpression rOperand, OCElementType operator, OCExpression element) {
        boolean intAndPtr;
        OCType rType;
        if (lOperand == null || rOperand == null || operator == null || element == null) {
            return;
        }
        if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains((IElementType)operator) && !this.checkAssignable(lOperand)) {
            return;
        }
        OCType lType = lOperand.getResolvedType().getGuessedType();
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType(element);
        }
        if ((rType = rOperand.getResolvedType().getGuessedType()) instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType(element);
        }
        OCResolveContext context = OCResolveContext.forPsi(element);
        if (OCTypeUtils.isUnresolvedLambdaAutoType(rType)) {
            rType = OCTypeUtils.resolveLambdaAutoType(lType, rType, context);
        }
        OCFile containingFile = element.getContainingOCFile();
        if (lType.isUnknown() || rType.isUnknown() || lType.isSubclassOfMagic(context) || rType.isSubclassOfMagic(context)) {
            return;
        }
        if (operator == OCTokenTypes.EQ) {
            OCSymbol symbol2;
            PsiElement parent = element.getParent();
            if (OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(element, context), context) && !(parent instanceof OCParenthesizedExpression) && !(parent instanceof OCAssignmentExpression) && !(parent instanceof OCDeclarator)) {
                void var10_13;
                Class<OCInspections.EqualityInConditionalOperator> clazz = OCInspections.EqualityInConditionalOperator.class;
                Object message = "Using '=' in conditional expression";
                if ("self".equals(lOperand.getText())) {
                    Class<OCInspections.EqualityInConditionalOperatorWithSelf> clazz2 = OCInspections.EqualityInConditionalOperatorWithSelf.class;
                    message = (String)message + " with \"self\"";
                }
                Annotation annotation = this.addWarningAnnotation(element, (Class<? extends OCInspection>)var10_13, "warn_condition_is_assignment", (String)message);
                String text = element.getTextWithMacros();
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(containingFile, element.getTextOffset(), text.length(), "(" + text + ")", OCInspectionsBundle.message("quick.fix.place.parentheses.around", new Object[0])));
                this.registerQuickFix(annotation, new OCExtractAssignmentIntentionAction(element, lOperand));
            }
            if (lOperand instanceof OCReferenceExpression && ((OCReferenceExpression)lOperand).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                OCMethod oCMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)element, OCMethod.class);
                OCResolveContext resolveContext = OCResolveContext.forPsi(lOperand);
                if (oCMethod != null && OCElementUtil.startsWithWord(oCMethod.getSelector(), "init") && rType.isCompatible(lType, resolveContext)) {
                    return;
                }
            }
            OCGetSymbolVisitor oCGetSymbolVisitor = new OCGetSymbolVisitor(context);
            lOperand.accept(oCGetSymbolVisitor);
            OCType symbolRequiredType = OCPointerType.to(rType.transformType(OCArrayToPointerChanger.INSTANCE), oCGetSymbolVisitor.getNumOfDereferences());
            OCTypeCompatibilityVisitor.checkConvertible(lType, rType, rOperand, element, true, true, context).setDestSymbol(oCGetSymbolVisitor.getSymbol()).setSymbolRequiredType(symbolRequiredType).annotate(this.myCppChecker);
            if (lType instanceof OCStructType && rType instanceof OCStructType && lType.isVolatile() && !rType.isVolatile()) {
                this.addErrorAnnotation(element, "err_ovl_no_viable_oper", OCBundle.message("inspections.typeChecks.volatileConflict", new Object[0]));
                return;
            }
            if (!(lOperand instanceof OCReferenceExpression) || !(rOperand instanceof OCReferenceExpression)) return;
            OCReferenceElement refElement1 = ((OCReferenceExpression)lOperand).getReferenceElement();
            OCReferenceElement refElement2 = ((OCReferenceExpression)rOperand).getReferenceElement();
            OCSymbol symbol1 = refElement1 != null ? refElement1.resolveToSymbol() : null;
            OCSymbol oCSymbol = symbol2 = refElement2 != null ? refElement2.resolveToSymbol() : null;
            if (symbol1 == null || symbol2 == null || !symbol1.equals(symbol2)) return;
            String message = symbol1.getNameWithKindUppercase(OCCompilationContext.create(element)) + " is assigned to itself";
            boolean isBuiltin = symbol1.getType() instanceof OCNumericType;
            this.addWarningAnnotation(element, OCInspections.UnusedValue.class, OCClangMessageFinder.getInstance().getSelfAssignment(isBuiltin), message, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            return;
        }
        boolean lIntegerCompatible = lType.isIntegerCompatible(context);
        boolean bl = rType.isIntegerCompatible(context);
        boolean lPointerCompatible = lType.isPointerCompatible(context) || OCExpressionEvaluator.getPointerType(lOperand, context) != null;
        boolean rPointerCompatible = rType.isPointerCompatible(context) || OCExpressionEvaluator.getPointerType(rOperand, context) != null;
        boolean lEnumInEnum = OCOperatorsChecker.isEnumeratorInsideOwnEnumClass(lOperand, lType);
        boolean rEnumInEnum = OCOperatorsChecker.isEnumeratorInsideOwnEnumClass(rOperand, rType);
        if ((OCTokenTypes.ARITHMETIC_OPERATIONS.contains((IElementType)operator) || OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator)) && !OCTokenTypes.ONLY_INTEGER_ARITHMETIC_OPERATIONS.contains((IElementType)operator) && (lType.isNumberCompatible(context) || lEnumInEnum) && (rType.isNumberCompatible(context) || rEnumInEnum)) {
            return;
        }
        if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator) && lType.isScalarOrConvertibleToScalar(context) && rType.isScalarOrConvertibleToScalar(context)) {
            return;
        }
        if ((OCTokenTypes.BITLOGIC_OPERATIONS.contains((IElementType)operator) || OCTokenTypes.ONLY_INTEGER_ARITHMETIC_OPERATIONS.contains((IElementType)operator)) && (lIntegerCompatible || lEnumInEnum) && (bl || rEnumInEnum)) {
            return;
        }
        if (OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator) && lType instanceof OCStructType && ((OCStructType)lType).isEnumClass() && rType.equals(lType, false, context)) {
            return;
        }
        Object message = null;
        if (OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator) && lPointerCompatible && rPointerCompatible) {
            if (lIntegerCompatible || bl) {
                message = "Comparison between pointer and integer";
            } else {
                if (!(lType instanceof OCPointerType) || !(rType instanceof OCPointerType)) return;
                message = "Comparison between distinct pointer types";
            }
        } else if (operator == OCTokenTypes.EQEQ || operator == OCTokenTypes.EXCLEQ) {
            if (lType instanceof OCStructType && !lType.isScalarOrConvertibleToScalar(context) || rType instanceof OCStructType && !rType.isScalarOrConvertibleToScalar(context)) {
                this.addErrorAnnotation(element, "err_typecheck_invalid_operands", "Can't compare structures");
                return;
            }
            message = "Types '" + lType.getName(context) + "' and '" + rType.getName(context) + "' are not compatible";
        }
        if (message != null) {
            this.checkTypesEquivalence(lType, rType, lOperand, rOperand, element, (String)message, context);
            return;
        }
        boolean ptrAndInt = lPointerCompatible && bl;
        boolean bl2 = intAndPtr = lIntegerCompatible && rPointerCompatible;
        if (operator == OCTokenTypes.PLUS && (ptrAndInt || intAndPtr) || operator == OCTokenTypes.MINUS && lType instanceof OCPointerType && rType instanceof OCPointerType && new OCTypeEqualityAfterResolvingVisitor(((OCPointerType)rType).getRefType(), false, false, true, true, context).equal(((OCPointerType)lType).getRefType()) || (operator == OCTokenTypes.MINUS || operator == OCTokenTypes.PLUSEQ || operator == OCTokenTypes.MINUSEQ) && ptrAndInt) {
            if (!OCCompilerFeaturesHelper.isArcEnabled(containingFile) || !lType.isPointerToObjectCompatible() && !rType.isPointerToObjectCompatible()) return;
            this.addErrorAnnotation(element, OCInspections.ARCIssues.class, "err_arithmetic_nonfragile_interface", "Object pointer arithmetic is forbidden in ARC");
            return;
        }
        if (operator == OCTokenTypes.DOT_MUL && lType instanceof OCStructType || operator == OCTokenTypes.DEREF_MUL && lType instanceof OCPointerType && rType.isPointer() && (((OCPointerType)lType).getRefType() instanceof OCStructType || ((OCPointerType)lType).getRefType() instanceof OCMagicType)) {
            return;
        }
        this.addErrorAnnotation(element, "err_typecheck_invalid_operands", "Binary operator '" + operator.getName() + "' can't be applied to the expressions of type '" + lType.getName(context) + "' and '" + rType.getName(context) + "'");
    }

    private static boolean isEnumeratorInsideOwnEnumClass(@NotNull OCExpression element, @NotNull OCType typeOfElement) {
        OCEnum enumDecl;
        if (element == null) {
            OCOperatorsChecker.$$$reportNull$$$0(2);
        }
        if (typeOfElement == null) {
            OCOperatorsChecker.$$$reportNull$$$0(3);
        }
        return typeOfElement instanceof OCStructType && ((OCStructType)typeOfElement).isEnum() && (enumDecl = (OCEnum)PsiTreeUtil.getParentOfType((PsiElement)element, OCEnum.class)) != null && ((OCStructType)typeOfElement).getSymbol() == enumDecl.getSymbol();
    }

    protected void checkTypesEquivalence(OCType lType, OCType rType, OCExpression lOperand, OCExpression rOperand, OCExpression element, String message, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCOperatorsChecker.$$$reportNull$$$0(4);
        }
        if (lType instanceof OCArrayType) {
            lType = OCPointerType.to(((OCArrayType)lType).getRefType(), ((OCArrayType)lType).getARCAttribute());
        }
        if (rType instanceof OCArrayType) {
            rType = OCPointerType.to(((OCArrayType)rType).getRefType(), ((OCArrayType)rType).getARCAttribute());
        }
        if (rType.checkCompatible(lType, lOperand, element, true, resolveContext).getState() != OCTypeCheckState.OK) {
            OCTypeCompatibilityVisitor.checkConvertible(lType, rType, rOperand, element, true, true, resolveContext).setForcedMessage(message).annotate(this.myCppChecker);
        }
    }

    public void checkUnaryOperatorApplicable(OCExpression operand, OCElementType operator, PsiElement element) {
        if (operand == null || operator == null || element == null || operator == OCTokenTypes.UDL_SUFFIX) {
            return;
        }
        OCFile containingFile = operand.getContainingOCFile();
        OCType type = operand.getResolvedType();
        OCResolveContext context = OCResolveContext.forPsi(operand);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (operator == OCTokenTypes.MUL) {
            if (type.isSubclassOfMagic(context)) {
                return;
            }
            if (type instanceof OCPointerType) {
                OCType refType = ((OCPointerType)type).getRefType();
                if (refType.isUnknown() && !(refType instanceof OCMagicType) && !(refType instanceof OCAutoType)) {
                    this.addErrorAnnotation(operand, OCInspections.CannotResolve.class, "err_incomplete_type", "Dereferencing pointer to unknown type");
                } else if (refType instanceof OCVoidType) {
                    this.addErrorAnnotation(element, "CIDR", "Dereferencing 'void *' pointer");
                }
            } else if (!type.isUnknown()) {
                this.addErrorAnnotation(element, OCInspections.PointerTypeRequired.class, "err_typecheck_indirection_requires_pointer", "Pointer type is required");
            }
            return;
        }
        if (type.isUnknown()) {
            return;
        }
        if (operator == OCTokenTypes.PLUSPLUS || operator == OCTokenTypes.MINUSMINUS) {
            if (!this.checkAssignable(operand)) {
                return;
            }
            if (OCCompilerFeaturesHelper.isArcEnabled(containingFile) && type.isPointerToObjectCompatible()) {
                this.addErrorAnnotation(operand, OCInspections.ARCIssues.class, "err_arithmetic_nonfragile_interface", "Object pointer arithmetic is forbidden in ARC");
            } else if (!type.isNumberCompatible(context) && !(type instanceof OCPointerType)) {
                this.addErrorAnnotation(operand, OCInspections.IntegerTypeRequired.class, "err_typecheck_illegal_increment_decrement", OCBundle.message("inspections.typeChecks.neitherNumericNorPointer", type.getName(operand)));
            }
            return;
        }
        if (operator == OCTokenTypes.PLUS || operator == OCTokenTypes.MINUS) {
            if (!type.isNumberCompatible(context)) {
                if (operand.getContainingOCFile().isCpp()) {
                    if (operator != OCTokenTypes.PLUS || !(type instanceof OCPointerType)) {
                        this.addErrorAnnotation(operand, OCInspections.IntegerTypeRequired.class, "err_typecheck_unary_expr", OCBundle.message("inspections.typeChecks.neitherNumericNorPointer", type.getName(operand)));
                    }
                } else {
                    this.addErrorAnnotation(operand, OCInspections.IntegerTypeRequired.class, "err_typecheck_unary_expr", OCBundle.message("inspections.typeChecks.notNumeric", type.getName(operand)));
                }
            }
            return;
        }
        if (operator == OCTokenTypes.AND) {
            if (!OCExprValueCategory.classify(operand).isLValue()) {
                this.addErrorAnnotation(operand, OCInspections.NotAssignable.class, "err_typecheck_invalid_lvalue_addrof", "Address expression must be lvalue");
            }
            return;
        }
        if (operator == OCTokenTypes.EXCL && type.isScalarOrConvertibleToScalar(context)) {
            return;
        }
        if (operator == OCTokenTypes.TILDE && type.isIntegerCompatible(context)) {
            return;
        }
        if ((operator == OCTokenTypes.__IMAG__KEYWORD || operator == OCTokenTypes.__REAL__KEYWORD) && type instanceof OCRealType) {
            return;
        }
        String message = "Unary operator '" + operator.getName() + "' can't be applied to the expression of type '" + type.getName(operand) + "'";
        this.addErrorAnnotation(element, "err_typecheck_unary_expr", message);
    }

    public void checkCastExperssion(OCCastExpression expression) {
        OCType lType = expression.getCastType().resolve(expression);
        OCExpression operand = expression.getOperand();
        if (operand == null) {
            OCArgumentList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            if (argumentList.getArguments().size() == 1) {
                operand = argumentList.getArguments().get(0);
            } else {
                this.myCppChecker.checkTypeInitialization(expression, expression.getTypeElement(), OCArgumentsList.getArgumentList(argumentList.getArguments()), null, lType, true, expression);
                return;
            }
        }
        OCResolveContext context = OCResolveContext.forPsi(operand);
        OCType rType = operand.getResolvedType().getGuessedType();
        if (operand instanceof OCCompoundInitializer) {
            OCTypeCompatibilityVisitor.checkConvertible(lType, rType, operand, expression, true, true, context).annotate(this.myCppChecker);
            return;
        }
        PsiElement bridgeCastModifier = expression.getBridgeCastModifier();
        if (bridgeCastModifier != null) {
            boolean rIsCFPtr;
            OCElementType bridgeType = (OCElementType)OCElementUtil.getElementType(bridgeCastModifier);
            String bridgeTypeName = bridgeType.getName();
            String rTypeName = rType.getName(context);
            boolean lIsObjectPtr = lType.isPointerToObjectCompatible();
            boolean lIsCFPtr = !lIsObjectPtr && lType instanceof OCPointerType;
            boolean rIsObjectPtr = rType.isPointerToObjectCompatible();
            boolean bl = rIsCFPtr = !rIsObjectPtr && rType instanceof OCPointerType;
            if (bridgeType == OCTokenTypes.BRIDGE_RETAINED_KEYWORD) {
                if (!lIsCFPtr) {
                    this.addErrorAnnotation(expression.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires CF pointer type");
                }
                if (!rIsObjectPtr) {
                    this.addErrorAnnotation(expression.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object pointer type instead of '" + rTypeName + "'");
                }
            } else if (bridgeType == OCTokenTypes.BRIDGE_TRANSFER_KEYWORD) {
                if (!lIsObjectPtr) {
                    this.addErrorAnnotation(expression.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object pointer type");
                }
                if (!rIsCFPtr) {
                    this.addErrorAnnotation(expression.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires CF pointer type instead of '" + rTypeName + "'");
                }
            } else if (bridgeType == OCTokenTypes.BRIDGE_KEYWORD) {
                if (!lIsObjectPtr && !lIsCFPtr) {
                    this.addErrorAnnotation(expression.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object or CF pointer type");
                }
                if (!(lIsCFPtr && rIsObjectPtr || lIsObjectPtr && rIsCFPtr)) {
                    String message = bridgeTypeName + " requires " + (lIsObjectPtr ? "CF" : "object") + " pointer type instead of '" + rTypeName + "'";
                    this.addErrorAnnotation(expression.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", message);
                }
            }
            return;
        }
        this.myCppChecker.checkTypeCast(lType, rType, expression.getTypeElement(), operand, expression, OCResolveContext.forPsi(expression));
    }

    private boolean checkAssignable(@Nullable OCExpression expression) {
        OCType operandType;
        if (expression == null) {
            return true;
        }
        OCResolveContext context = OCResolveContext.forPsi(expression);
        OCType resolvedType = expression.getResolvedType();
        if ((expression = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression)) == null) {
            return true;
        }
        if (resolvedType instanceof OCMagicType) {
            return false;
        }
        if (expression instanceof OCConditionalExpression && expression.getContainingOCFile().isCpp()) {
            if (!this.checkAssignable(((OCConditionalExpression)expression).getPositiveExpression(true)) || !this.checkAssignable(((OCConditionalExpression)expression).getNegativeExpression())) {
                return false;
            }
            if (!OCExprValueCategory.classify(expression).isLValue()) {
                this.addErrorAnnotation(expression, OCInspections.NotAssignable.class, "CIDR", "Expression is not assignable");
                return false;
            }
            return true;
        }
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(context);
        expression.accept(visitor);
        OCSymbol symbol = visitor.getSymbol();
        if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.STRUCT_FIELD && expression instanceof OCQualifiedExpression && !((OCDeclaratorSymbol)symbol).isMutable()) {
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)expression;
            OCExpression qualifier = qualifiedExpression.getQualifier();
            if (qualifiedExpression.getQualifyingTokenKind() == OCTokenTypes.DOT) {
                if (!this.checkAssignable(qualifier)) {
                    return false;
                }
            } else {
                OCType qualifierType = qualifier.getResolvedType();
                if (qualifierType instanceof OCPointerType && ((OCPointerType)qualifierType).isPointerToConst() && (!(qualifier instanceof OCReferenceExpression) || !((OCReferenceExpression)qualifier).isCppThis())) {
                    this.addErrorAnnotation(qualifier, OCInspections.NotAssignable.class, "CIDR", "Expression is not assignable");
                    return false;
                }
            }
        }
        boolean isAssignable = false;
        List<Object> quickfixes = null;
        Object message = "Expression is not assignable";
        Project project = expression.getProject();
        if (visitor.getNumOfDereferences() > 0) {
            isAssignable = true;
        } else if (symbol instanceof OCPropertySymbol) {
            OCClassSymbol classSymbol;
            OCPropertySymbol propertySymbol = (OCPropertySymbol)symbol;
            isAssignable = !propertySymbol.isReadonly();
            quickfixes = new ArrayList<Object>(2);
            quickfixes.add(new OCChangePropertyAttributeIntentionAction(propertySymbol, OCPropertySymbol.PropertyAttribute.READONLY, null, null, project));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && propertySymbol.getParent().equals(classSymbol.getInterface(project))) {
                quickfixes.add(new OCDeclarePropertyInPrivateCategoryAction(propertySymbol));
            }
        } else if (symbol instanceof OCMethodSymbol) {
            isAssignable = OCNameSuggester.isObjCSetter(symbol.getName());
            if (!this.checkReadonlyAccess(Collections.singletonList(expression), (OCMethodSymbol)symbol, "Calling", project)) {
                return false;
            }
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            isAssignable = true;
        } else if (symbol instanceof OCFunctionSymbol) {
            isAssignable = false;
        } else if (symbol instanceof OCDeclaratorSymbol) {
            OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
            Ref functionSymbol = new Ref();
            isAssignable = true;
            if (resolvedType instanceof OCArrayType && ((OCArrayType)resolvedType).hasLength()) {
                isAssignable = false;
                message = "Array is not assignable";
            }
            if (isAssignable) {
                if (declaratorSymbol.getKind() == OCSymbolKind.TYPEDEF) {
                    isAssignable = false;
                } else if (resolvedType.isConst() || declaratorSymbol.isConstexpr() || declaratorSymbol.getKind() == OCSymbolKind.ENUM_CONST) {
                    isAssignable = false;
                    message = "Variable is declared constant and is not assignable";
                    OCElementType keyword = declaratorSymbol.isConstexpr() ? OCTokenTypes.CONSTEXPR_CPP_KEYWORD : OCTokenTypes.CONST_KEYWORD;
                    quickfixes = Collections.singletonList(new OCRemoveTypeModifierIntentionAction(declaratorSymbol, keyword, project));
                } else if (resolvedType instanceof OCCppReferenceType && ((OCCppReferenceType)resolvedType).isReferenceToConst()) {
                    isAssignable = false;
                    message = "'" + resolvedType.getName(context) + "' is read-only reference";
                    OCCppReferenceType type = OCCppReferenceType.to(((OCCppReferenceType)resolvedType).getRefType().cloneWithoutConstModifier(project));
                    quickfixes = Collections.singletonList(new OCChangeTypeIntentionAction(symbol, type, context));
                } else if (OCOperatorsChecker.isOutsideBlock(expression, declaratorSymbol)) {
                    isAssignable = false;
                    message = "Variable is declared outside the block and is not assignable";
                    quickfixes = Collections.singletonList(new OCAddTypeModifierIntentionAction(declaratorSymbol, OCTokenTypes.BLOCK_KEYWORD, context.getProject()));
                } else if (OCOperatorsChecker.isInConstMemberFunction(expression, declaratorSymbol, (Ref<OCFunctionSymbol>)functionSymbol)) {
                    isAssignable = false;
                    message = declaratorSymbol.getNameWithKindUppercase(context) + " is assigned inside a const function";
                    quickfixes = Collections.singletonList(new OCChangeFunctionConstAction((OCFunctionSymbol)functionSymbol.get(), false, (OCCompilationContext)context));
                } else if (!OCExprValueCategory.classify(expression).isLValue()) {
                    isAssignable = false;
                }
            }
        } else {
            isAssignable = resolvedType instanceof OCStructType ? !resolvedType.isConst() && OCOperatorReference.resolveOperator("=", OCOperatorReference.OperatorPlacement.INFIX, expression, (OCStructType)resolvedType) != null : (visitor.wasUnresolvedSymbol() ? true : (expression instanceof OCLiteralExpression && ((OCLiteralExpression)expression).isStringLiteral() ? false : OCExprValueCategory.classify(expression).isLValue()));
        }
        OCExpression operand = null;
        if (expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).getOperationSign() == OCTokenTypes.MUL) {
            operand = ((OCUnaryExpression)expression).getOperand();
        } else if (expression instanceof OCArraySelectionExpression) {
            operand = ((OCArraySelectionExpression)expression).getArrayExpression();
        }
        if (operand != null && (operandType = operand.getResolvedType()) instanceof OCPointerType && ((OCPointerType)operandType).isPointerToConst()) {
            isAssignable = false;
            message = "'" + operandType.getName(expression) + "' is read-only pointer";
            if (symbol != null && !(operandType instanceof OCArrayType)) {
                boolean isConst = operandType.isConst();
                OCType oCType = OCPointerType.to(((OCPointerType)operandType).getRefType().cloneWithoutConstModifier(project), visitor.getNumOfDereferences() - 1);
                OCPointerType newType = OCPointerType.to(oCType.cloneWithoutConstModifier(project), null, null, isConst, oCType.isVolatile());
                quickfixes = Collections.singletonList(new OCChangeTypeIntentionAction(symbol, newType, context));
            }
        }
        if (!isAssignable) {
            Annotation annotation = this.addErrorAnnotation(expression, OCInspections.NotAssignable.class, "CIDR", (String)message);
            if (quickfixes != null) {
                for (IntentionAction intentionAction : quickfixes) {
                    this.registerQuickFix(annotation, intentionAction);
                }
            }
        }
        return isAssignable;
    }

    private static boolean isOutsideBlock(@NotNull OCExpression expression, @NotNull OCDeclaratorSymbol declaratorSymbol) {
        ComplexTextRange scope;
        if (expression == null) {
            OCOperatorsChecker.$$$reportNull$$$0(5);
        }
        if (declaratorSymbol == null) {
            OCOperatorsChecker.$$$reportNull$$$0(6);
        }
        if (!declaratorSymbol.getKind().isLocal() || declaratorSymbol.isBlockModifiable() || declaratorSymbol.isFriendOrStatic()) {
            return false;
        }
        OCBlockExpression block = (OCBlockExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCBlockExpression.class});
        return block != null && ((scope = declaratorSymbol.getScope()) == null || !OCSymbolOffsetUtil.getComplexRange(block).contains(scope));
    }

    private static boolean isInConstMemberFunction(@Nullable OCExpression expression, @NotNull OCDeclaratorSymbol declaratorSymbol, @NotNull Ref<OCFunctionSymbol> functionSymbol) {
        CVQualifiers cvQualifiers;
        if (declaratorSymbol == null) {
            OCOperatorsChecker.$$$reportNull$$$0(7);
        }
        if (functionSymbol == null) {
            OCOperatorsChecker.$$$reportNull$$$0(8);
        }
        return (cvQualifiers = OCCodeInsightUtil.getOuterFunctionCVQualifiers(declaratorSymbol, expression, functionSymbol)) != null && cvQualifiers.isConst();
    }

    public boolean checkReadonlyAccess(List<? extends PsiElement> elements, OCMethodSymbol symbol, String accessKind, @NotNull Project project) {
        String getter;
        OCClassSymbol parent;
        if (project == null) {
            OCOperatorsChecker.$$$reportNull$$$0(9);
        }
        if ((parent = symbol.getParent().getInterfaceOrProtocol(project)) == null) {
            return true;
        }
        CommonProcessors.FindFirstProcessor propFinder = new CommonProcessors.FindFirstProcessor();
        if (symbol.isSetter(OCResolveContext.forSymbol(symbol, project)) && (getter = OCNameSuggester.getObjCGetterFromSetter(symbol.getName())) != null) {
            parent.processMembers(getter, OCPropertySymbol.class, propFinder);
        }
        if (propFinder.isFound() && ((OCPropertySymbol)propFinder.getFoundValue()).isReadonly()) {
            OCClassSymbol classSymbol;
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)elements.get(0), (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && parent.equals(classSymbol.getInterface(project))) {
                return true;
            }
            String message = accessKind + " the setter method for readonly " + ((OCPropertySymbol)propFinder.getFoundValue()).getNameWithKindLowercase(OCCompilationContext.create(parent, project));
            List<Annotation> annotations = this.addWarningAnnotations(elements, OCInspections.SetterForReadonlyProperty.class, "CIDR", message);
            this.registerQuickFixes(annotations, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)propFinder.getFoundValue(), OCPropertySymbol.PropertyAttribute.READONLY, null, null, project));
            return false;
        }
        return true;
    }

    public void checkCallExpression(OCCallExpression expr) {
        OCExpression function = OCParenthesesUtils.diveIntoParentheses(expr.getFunctionReferenceExpression());
        if (function == null) {
            return;
        }
        OCResolveContext context = OCResolveContext.forPsi(expr);
        OCType funcType = expr.getCalleeType(context);
        OCSymbol functionSymbol = null;
        if (funcType instanceof OCCppReferenceType) {
            funcType = ((OCCppReferenceType)funcType).getRefType();
        }
        if (expr.getContainingOCFile().isCpp()) {
            if (function instanceof OCReferenceExpression) {
                OCSymbol symbol = ((OCReferenceExpression)function).resolveToSymbol();
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() || symbol instanceof OCStructSymbol) {
                    this.myCppChecker.checkConstructorCall(expr, expr.getArguments(), symbol, null);
                    return;
                }
                if (symbol != null && symbol.getKind().isType()) {
                    OCType type = symbol.getType().resolve(expr);
                    this.myCppChecker.checkTypeInitialization(expr, function, OCArgumentsList.getArgumentList(expr.getArguments()), symbol, type, true, expr);
                    return;
                }
            }
            if (expr.getReference() instanceof OCOperatorReference) {
                for (OCSymbol symbol : ((OCOperatorReference)expr.getReference()).resolveToSymbols()) {
                    if (!(symbol instanceof OCFunctionSymbol)) continue;
                    OCVisibility.checkFieldVisibility(symbol, expr, null, this);
                    functionSymbol = symbol;
                    funcType = symbol.getResolvedType(context);
                    break;
                }
                if (funcType != null && funcType.isSubclassOfMagic(context)) {
                    return;
                }
            }
            if (function instanceof OCQualifiedExpression && ((OCQualifiedExpression)function).getName().startsWith("~") && expr.getArguments().isEmpty()) {
                return;
            }
        }
        if (funcType instanceof OCPointerType) {
            funcType = ((OCPointerType)funcType).getRefType();
        }
        if (funcType == null || funcType.isUnknown()) {
            return;
        }
        if (!(funcType instanceof OCFunctionType)) {
            this.addErrorAnnotation(function, "err_typecheck_call_not_function", "Called object is not a function");
            return;
        }
        if (functionSymbol == null) {
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(context);
            function.accept(visitor);
            functionSymbol = visitor.getSymbol();
        }
        boolean isRecoveringFromOverloadFailure = false;
        if (functionSymbol instanceof OCFunctionGroupSymbol) {
            OCFunctionGroupSymbol group = (OCFunctionGroupSymbol)functionSymbol;
            if (group.getOverloads().size() == 1) {
                functionSymbol = group.getOverloads().get(0);
                isRecoveringFromOverloadFailure = true;
            } else {
                OCFunctionGroupHelperKt.annotateAmbig(this, function, group, "No matching function");
                OCFunctionSymbol sameArgsCountSymbol = null;
                int argsCount = expr.getArguments().size();
                for (OCFunctionSymbol symbol : group.getOverloads()) {
                    if (!(symbol instanceof OCFunctionSymbol) || symbol.getParameterSymbols().size() != argsCount) continue;
                    if (sameArgsCountSymbol != null) {
                        return;
                    }
                    sameArgsCountSymbol = symbol;
                }
                if (sameArgsCountSymbol == null) {
                    return;
                }
                functionSymbol = sameArgsCountSymbol;
            }
            funcType = functionSymbol.getResolvedType(context);
        }
        this.myCppChecker.annotateFunctionArguments(expr, (OCFunctionType)funcType, expr.getArguments(), functionSymbol, isRecoveringFromOverloadFailure);
        if (expr.getContainingOCFile().isCpp() && functionSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)functionSymbol).getResolvedOwner(context) instanceof OCStructSymbol && !((OCFunctionSymbol)functionSymbol).isCppNonMemberOperator(context)) {
            this.checkConstFunction(function, (OCFunctionSymbol)functionSymbol);
        }
    }

    protected void checkConstFunction(OCExpression function, OCFunctionSymbol symbol) {
        CVQualifiers cvQualifiers = null;
        OCQuickFix extraConstFix = null;
        OCQuickFix extraVolatileFix = null;
        if (function instanceof OCQualifiedExpression) {
            OCSymbol qualifierSymbol;
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)function;
            OCExpression qualifier = qualifiedExpression.getQualifier();
            OCPunctuatorElementType qualifyingTokenKind = qualifiedExpression.getQualifyingTokenKind();
            cvQualifiers = qualifiedExpression.getCVQualifiers();
            if (cvQualifiers.isConst() && qualifyingTokenKind == OCTokenTypes.DOT && (qualifierSymbol = OCGetSymbolVisitor.getSymbol(qualifier)) instanceof OCSymbolWithQualifiedName) {
                Project project = function.getProject();
                extraConstFix = new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)qualifierSymbol, OCTokenTypes.CONST_KEYWORD, project);
                extraVolatileFix = new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)qualifierSymbol, OCTokenTypes.VOLATILE_KEYWORD, project);
            }
        } else if (function instanceof OCReferenceExpression) {
            OCFunctionSymbol containingFunSymbol;
            OCFunctionDefinition containingFunction = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)function, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol oCFunctionSymbol = containingFunSymbol = containingFunction != null ? containingFunction.getSymbol() : null;
            if (containingFunSymbol != null) {
                cvQualifiers = containingFunSymbol.getType().getCVQualifiers();
                OCCompilationContext context = OCCompilationContext.create(containingFunction);
                extraConstFix = new OCChangeFunctionConstAction(containingFunSymbol, false, context);
                extraVolatileFix = new OCChangeFunctionVolatileAction(containingFunSymbol, false, context);
            }
        }
        if (!symbol.isCppConstructor() && !symbol.resolveIsFriendOrStatic(OCResolveContext.forPsi(function))) {
            this.checkCVMismatch(function, symbol, cvQualifiers, true, "const", extraConstFix);
            this.checkCVMismatch(function, symbol, cvQualifiers, false, "volatile", extraVolatileFix);
        }
    }

    private void checkCVMismatch(OCExpression function, OCFunctionSymbol symbol, CVQualifiers cvQualifiers, boolean isConstModifier, String modifierName, IntentionAction extraFix) {
        if (cvQualifiers != null && (isConstModifier && cvQualifiers.isConst() && !symbol.isConst() || !isConstModifier && cvQualifiers.isVolatile() && !symbol.getType().isVolatile())) {
            OCResolveContext context = OCResolveContext.forPsi(function);
            String message = "Non-" + modifierName + " " + symbol.getNameWithKindLowercase(context) + " is called " + (function instanceof OCReferenceExpression ? "from the " + modifierName + " function" : "on the " + modifierName + " object");
            Annotation annotation = this.addErrorAnnotation(function, OCInspections.ConstExpressionRequired.class, "err_member_function_call_bad_cvr", message);
            OCFunctionSymbol declarationInParent = symbol.getDeclarationInParent(context);
            if (declarationInParent != null) {
                this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(declarationInParent, OCTokenTypes.STATIC_KEYWORD, context.getProject(), false));
            }
            if (isConstModifier) {
                this.registerQuickFix(annotation, new OCChangeFunctionConstAction(symbol, true, (OCCompilationContext)context));
            } else {
                this.registerQuickFix(annotation, new OCChangeFunctionVolatileAction(symbol, true, (OCCompilationContext)context));
            }
            if (extraFix != null) {
                this.registerQuickFix(annotation, extraFix);
            }
        }
    }

    public void checkMacroCall(OCMacroCall macroCall) {
        int expectedCount;
        if (macroCall.getTextLength() == 0) {
            return;
        }
        OCMacroSymbol symbol = macroCall.resolveToSymbol();
        if (symbol == null || !symbol.hasParameterList()) {
            return;
        }
        OCMacroCall.ParameterCheckResult result = macroCall.checkParameters(symbol);
        int actualCount = result.getActualCount();
        if (actualCount < (expectedCount = result.getAllowedCount())) {
            this.addErrorAnnotation(macroCall, OCInspections.FunctionParameterCountMismatch.class, "err_too_few_args_in_macro_invoc", "Too few arguments for a macro call, expected " + (symbol.isVararg() ? "at least " : "") + expectedCount);
        } else if (actualCount > expectedCount) {
            this.addErrorAnnotation(macroCall, OCInspections.FunctionParameterCountMismatch.class, "err_too_many_args_in_macro_invoc", "Too many arguments for a macro call, expected " + expectedCount);
        }
    }

    public void checkSendMessageExpression(@NotNull OCSendMessageExpression expr) {
        if (expr == null) {
            OCOperatorsChecker.$$$reportNull$$$0(10);
        }
        OCSendMessageExpression.ProbableResponders responders = expr.getProbableResponders();
        OCExpression receiver = expr.getReceiverExpression();
        if (expr.getArguments().size() == 0) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_message_selector_missing", "Message selector expected");
            return;
        }
        if (responders.isStaticnessMismatch()) {
            String message = responders.isStaticContext() ? "Instance method is called from the class context" : "Class method is called from the instance context";
            Annotation annotation = this.addErrorAnnotation(expr, OCInspections.StaticnessMismatch.class, "CIDR", message);
            if (responders.getAllResponders().size() == 1) {
                OCMethodSymbol methodSymbol;
                OCMethodSymbol responder = responders.getAllResponders().get(0);
                this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(responder, responders.isStaticContext(), expr.getProject()));
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (receiver instanceof OCReferenceExpression && containingMethod != null && ((OCReferenceExpression)receiver).getSelfSuperToken() != null && (methodSymbol = (OCMethodSymbol)containingMethod.getSymbol()) != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(methodSymbol, !responders.isStaticContext(), expr.getProject()));
                }
            }
            return;
        }
        OCMethodSymbol knownResponder = responders.getKnownResponder();
        if (knownResponder != null && expr.isVarargCall() && !knownResponder.isVararg()) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_not_vararg_method", knownResponder.getNameWithKindUppercase(OCCompilationContext.create(knownResponder, expr.getProject())) + " is not a vararg method");
            return;
        }
        String messageSelector = expr.getMessageSelector();
        OCMethodSymbol target = OCOperatorsChecker.findTargetMethod(expr, responders.getFilteredByStaticnessResponders());
        if (responders.getKnownResponder() == null) {
            for (OCMethodSymbol responder : responders.getAllResponders()) {
                OCFileSymbols.markSymbolAsUsed(expr.getContainingOCFile(), responder, expr);
            }
        }
        if (target == null) {
            return;
        }
        this.checkResponderIsKnown(expr, responders, target);
        this.checkSendMessageArguments(expr, target);
        Project project = expr.getProject();
        if (!OCCompilerFeaturesHelper.isArcEnabled(expr.getContainingFile())) {
            if (messageSelector.equals("dealloc")) {
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (containingMethod != null && containingMethod.getSelector().equals("dealloc") && receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER) {
                    return;
                }
                Annotation annotation = this.addWarningAnnotation(expr, OCInspections.CallDealloc.class, "CIDR", "Sending 'dealloc' directly");
                int selectorOffset = expr.getArgumentSelectors().get(0).getTextOffset();
                String message = OCInspectionsBundle.message("quick.fix.send.release.message.instead.dealloc", new Object[0]);
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(expr.getContainingFile(), selectorOffset, "dealloc".length(), "release", message));
            } else if (OCElementUtil.isReleaseSelector(messageSelector)) {
                OCSymbol receiverSymbol = null;
                if (receiver instanceof OCReferenceExpression) {
                    receiverSymbol = ((OCReferenceExpression)receiver).resolveToSymbol();
                } else if (receiver instanceof OCQualifiedExpression) {
                    receiverSymbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
                }
                if (receiverSymbol instanceof OCInstanceVariableSymbol) {
                    receiverSymbol = ((OCInstanceVariableSymbol)receiverSymbol).getAssociatedProperty(project);
                }
                if (receiverSymbol instanceof OCPropertySymbol && !((OCPropertySymbol)receiverSymbol).isReadonly() && ((OCPropertySymbol)receiverSymbol).getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, receiverSymbol.getResolvedType(OCResolveContext.forPsi(expr)), expr) == OCPropertySymbol.PropertyAttribute.ASSIGN) {
                    Annotation annotation = this.addWarningAnnotation(expr, OCInspections.ReleasingOfAssignProperties.class, "CIDR", "Releasing of the property with 'assign' attribute");
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.RETAIN, null, project));
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.COPY, null, project));
                }
            }
        }
        this.checkReadonlyAccess(expr.getArgumentSelectors(), target, "Calling", project);
    }

    private void checkSendMessageArguments(OCSendMessageExpression expr, OCMethodSymbol target) {
        List<OCMessageArgument> arguments = expr.getArguments();
        boolean requiresNil = OCType.isFunctionRequiringNil(target);
        int argPos = 0;
        OCResolveContext context = OCResolveContext.forPsi(expr);
        for (OCMessageArgument arg : arguments) {
            OCExpression argument = arg.getArgumentExpression();
            if (argument == null) continue;
            OCType argumentType = argument.getResolvedType().getGuessedType();
            if (target.isVararg() && argPos >= target.getSelectors().size()) {
                if (argumentType.isVoid()) {
                    this.addErrorAnnotation(argument, "CIDR", "Invalid use of void expression");
                    continue;
                }
                if (!requiresNil || !expr.getMessageSelector().contains("Objects") || argumentType.isPointerToObjectCompatible()) continue;
                OCAssignmentChecker.checkAssignment(argument, OCIdType.pointerToID(), argumentType, null, argumentType, true, "Parameter type mismatch: ", OCResolveContext.forPsi(argument)).setOnlyWarnings(true).annotate(this.myCppChecker);
                continue;
            }
            OCDeclaratorSymbol parameter = target.getSelectors().get(argPos++).getParameter();
            if (parameter == null) continue;
            OCType declType = parameter.getType().resolve(context);
            OCAssignmentChecker.checkAssignment(argument, declType, argumentType, parameter, argumentType, true, "Parameter type mismatch: ", context).annotate(this.myCppChecker);
        }
        if (requiresNil && arguments.size() > 0) {
            String text;
            OCMessageArgument lastArgument = arguments.get(arguments.size() - 1);
            OCExpression expression = lastArgument.getArgumentExpression();
            String string = text = expression != null ? expression.getTextWithMacros() : null;
            if (!OCCodeInsightUtil.isLikeNull(text)) {
                Annotation annotation = this.addWarningAnnotation(lastArgument, OCInspections.LastArgumentMustBeNull.class, "CIDR", "Last argument must be \"nil\"");
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(lastArgument.getContainingOCFile(), lastArgument.getTextRange().getEndOffset(), 0, ", nil", OCInspectionsBundle.message("quick.fix.append.nil.argument", new Object[0])));
            }
        }
    }

    private void checkResponderIsKnown(OCSendMessageExpression expr, OCSendMessageExpression.ProbableResponders responders, OCMethodSymbol target) {
        OCInterfaceSymbol receiverClass;
        OCFile file = expr.getContainingOCFile();
        OCExpression receiver = expr.getReceiverExpression();
        OCFileSymbols.markSymbolAsUsed(file, target, expr);
        OCObjectType receiverType = responders.getReceiverType();
        OCType receiverOriginalType = responders.getReceiverOriginalType();
        OCInterfaceSymbol oCInterfaceSymbol = receiverClass = receiverType != null ? receiverType.getInterface() : null;
        if (receiverClass != null && !receiverClass.isPredeclaration()) {
            OCFileSymbols.markImportNeeded(file, receiverClass);
        }
        if (responders.getKnownResponder() != null) {
            return;
        }
        OCCompilationContext context = OCCompilationContext.create(expr);
        Project project = expr.getProject();
        if (receiverClass != null && receiverClass.isPredeclaration()) {
            String message = receiverClass.getNameWithKindUppercase(context) + " definition is not visible";
            Annotation annotation = this.addErrorAnnotation(receiver, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", message);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, receiverClass.getDefinitionSymbol(project)));
        } else if (receiverType instanceof OCIdType || receiverOriginalType != null && receiverOriginalType.isClassType()) {
            if (!OCFileSymbols.isSymbolImported(file, target.getParent())) {
                Annotation annotation = this.addErrorAnnotation(expr, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", target.getNameWithKindUppercase(context) + " is not visible");
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, target.getParent()));
            }
        } else {
            OCClassSymbol containingClassSymbol;
            boolean isSameClassName = receiverClass != null && receiverClass.getName().equals(target.getParent().getName());
            String message = receiverClass != null && !isSameClassName && target.getParent().isSubclass(receiverClass, project) ? target.getNameWithKindUppercase(context) + " is defined in subclass '" + target.getParent().getPresentableName() + "'" : target.getNameWithKindUppercase(context) + " is defined in class '" + target.getParent().getPresentableName() + "' and is not visible";
            Annotation annotation = OCCompilerFeaturesHelper.isArcEnabled(file) ? this.addErrorAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message) : this.addWarningAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, target.getParent()));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            OCClassSymbol oCClassSymbol = containingClassSymbol = containingClass != null ? containingClass.getSymbol() : null;
            if (receiverClass != null) {
                this.registerQuickFix(annotation, new OCDeclareMethodInTargetInterfaceAction(receiverClass, target, project));
                if (receiver != null && !isSameClassName) {
                    OCPointerType targetType = OCPointerType.to(target.getParent().getType().resolve(expr));
                    this.registerQuickFix(annotation, new OCInsertCastIntentionAction(receiver, targetType));
                    OCChangeTypeIntentionAction.registerChangeTypeFix(receiver, targetType, annotation, this);
                    this.registerQuickFix(annotation, new OCConvertTypeIntentionAction(receiver, targetType));
                    OCExpression inner = OCParenthesesUtils.diveIntoParentheses(receiver);
                    if (inner != null) {
                        this.registerQuickFix(annotation, new OCConvertLiteralIntentionAction(inner, targetType, receiverType));
                    }
                }
            }
            if (receiverClass != null && containingClassSymbol != null && receiverClass.getImplementation(project) == containingClassSymbol) {
                this.registerQuickFix(annotation, new OCDeclareSpecificMethodInPrivateCategoryAction(receiverClass, target));
            }
        }
    }

    public void checkForeach(OCForeachStatement statement) {
        OCElement varExprElement = statement.getVariableExpression();
        OCExpression varExpr = varExprElement instanceof OCExpressionStatement ? ((OCExpressionStatement)varExprElement).getExpression() : (OCExpression)varExprElement;
        OCExpression collExpr = statement.getCollectionExpression();
        OCElement varDeclElement = statement.getVariableDeclaration();
        OCDeclaration varDecl = varDeclElement instanceof OCDeclarationStatement ? ((OCDeclarationStatement)varDeclElement).getDeclaration() : (OCDeclaration)varDeclElement;
        OCType lType = null;
        OCElement varElement = null;
        OCSymbol varSymbol = null;
        if (varExpr != null) {
            if (!this.checkAssignable(varExpr)) {
                return;
            }
            lType = varExpr.getResolvedType();
            varElement = varExprElement;
            varSymbol = OCGetSymbolVisitor.getSymbol(varExpr);
            if (!(statement.isCpp11Foreach() || lType.isUnknown() || lType.isPointerToObjectCompatible())) {
                this.addErrorAnnotation(varExpr, "CIDR", "Expression has non-object type '" + lType.getName(varExpr) + "'");
            }
        } else if (varDecl != null) {
            varElement = varDecl;
            if (varDecl instanceof OCStructuredBindingDeclaration) {
                OCElement initializer = ((OCStructuredBindingDeclaration)varDecl).getInitializer();
                if (initializer != null) {
                    this.addErrorAnnotation(initializer, OCInspections.InitializerIssues.class, "CIDR", "Initializer is not allowed here");
                }
            } else {
                if (varDecl.getDeclarators().size() != 1) {
                    Annotation annotation = this.addErrorAnnotation(varDecl, "err_toomany_element_decls", "Only one variable declarator is allowed");
                    for (int i2 = varDecl.getDeclarators().size() - 1; i2 >= 1; --i2) {
                        this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)varDecl.getDeclarators().get(i2), OCInspectionsBundle.message("quick.fix.remove.extra.declarators", new Object[0])));
                    }
                    return;
                }
                OCDeclarator declarator = varDecl.getDeclarators().get(0);
                varSymbol = declarator.getSymbol();
                lType = declarator.getResolvedType();
                if (declarator.getInitializer() != null) {
                    this.addErrorAnnotation(declarator.getInitializer(), OCInspections.InitializerIssues.class, "CIDR", "Initializer is not allowed here");
                } else if (!(statement.isCpp11Foreach() || lType.isUnknown() || lType.isPointerToObjectCompatible())) {
                    this.addErrorAnnotation(declarator, "err_selector_element_type", "Variable has non-object type '" + lType.getName(varDecl) + "'");
                }
            }
        } else {
            return;
        }
        if (collExpr == null) {
            return;
        }
        OCResolveContext context = OCResolveContext.forPsi(collExpr);
        OCType rType = collExpr.getResolvedType(context).getGuessedType();
        if (rType.isUnknown()) {
            return;
        }
        if (statement.isCpp11Foreach()) {
            OCType elementType = OCCodeInsightUtil.getCollectionElementType(collExpr, rType);
            if (elementType != null) {
                if (lType != null) {
                    OCTypeCompatibilityVisitor.checkConvertible(lType, elementType, null, varElement, true, true, context).setDestSymbol(varSymbol).setSymbolRequiredType(elementType).annotate(this.myCppChecker);
                }
            } else {
                this.addErrorAnnotation(collExpr, OCInspections.ArrayIssues.class, "err_for_range_invalid", "'" + rType.getBestNameInContext(context) + "' is not a valid range type");
            }
        } else if (rType.isPointerToObjectCompatible()) {
            OCType refType = ((OCPointerType)rType).getRefType();
            if (!(refType instanceof OCObjectType)) {
                return;
            }
            OCObjectType objectType = (OCObjectType)refType;
            OCType itemType = OCTypeUtils.getCollectionItemType(objectType, context);
            if (itemType != null && lType != null) {
                OCTypeCompatibilityVisitor.checkConvertible(lType, itemType, null, varElement, true, true, context).setDestSymbol(varSymbol).setSymbolRequiredType(itemType).annotate(this.myCppChecker);
            }
            String enumFunction = "countByEnumeratingWithState:objects:count:";
            if (!(objectType instanceof OCIdType && objectType.getAllProtocols().isEmpty() || objectType.findMember("countByEnumeratingWithState:objects:count:", OCMethodSymbol.class) != null)) {
                String message = "Collection expression of type '" + rType.getName(context) + "' doesn't respond to 'countByEnumeratingWithState:objects:count:'";
                Annotation annotation = this.addWarningAnnotation(collExpr, OCInspections.UnresolvedCollectionMessage.class, "warn_collection_expr_type", message);
                if (objectType.getInterface() != null) {
                    this.registerQuickFix(annotation, new OCAddSuperProtocolIntentionAction(objectType.getInterface(), "NSFastEnumeration", false, context.getProject()));
                }
            }
        } else {
            this.addErrorAnnotation(collExpr, "CIDR", "Expression has non-object type '" + rType.getName(context) + "'");
        }
    }

    @Nullable
    public static OCMethodSymbol findTargetMethod(OCSendMessageExpression expr, List<OCMethodSymbol> targets) {
        List<OCMessageArgument> arguments = expr.getArguments();
        OCMethodSymbol best = null;
        int minValue = 0;
        OCResolveContext context = OCResolveContext.forPsi(expr);
        block0: for (OCMethodSymbol target : targets) {
            int argPos = 0;
            int value = 0;
            for (OCMessageArgument arg : arguments) {
                OCDeclaratorSymbol parameter;
                OCExpression argument = arg.getArgumentExpression();
                if (argument == null) continue;
                OCType argumentType = argument.getResolvedType().getGuessedType();
                List<OCMethodSymbol.SelectorPartSymbol> parameters = target.getSelectors();
                if (target.isVararg()) {
                    if (argPos >= parameters.size()) {
                        continue;
                    }
                } else if (parameters.size() != arguments.size()) continue block0;
                if ((parameter = parameters.get(argPos).getParameter()) == null) continue;
                OCType declType = parameter.getType().resolve(context);
                OCTypeCheckState state = declType.checkCompatible(argumentType, argument, argument, context).getState();
                if (state.isError(expr)) {
                    value += 2000;
                } else if (state != OCTypeCheckState.OK) {
                    ++value;
                }
                ++argPos;
            }
            if (!OCFileSymbols.isSymbolImported(expr.getContainingOCFile(), target.getParent())) {
                value += 1000;
            }
            if (best != null && (value == -1 || value >= minValue)) continue;
            minValue = value;
            best = target;
        }
        return best;
    }

    public void checkQualifiedExpression(OCQualifiedExpression expression) {
        OCType type = expression.getQualifier().getResolvedType();
        if (type.isUnknown()) {
            return;
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCFile file = expression.getContainingOCFile();
        OCResolveContext context = OCResolveContext.forPsi(expression);
        if (expression.getQualifyingTokenKind() == OCTokenTypes.DEREF) {
            Ref isSynthetic = new Ref((Object)false);
            OCType derefType = expression.getQualifierContainerType((Ref<Boolean>)isSynthetic);
            if (derefType == OCUnknownType.INSTANCE && ((Boolean)isSynthetic.get()).booleanValue()) {
                String message = "Applying '->' operator to '" + type.getName(expression) + "' instead of a pointer";
                Annotation annotation = this.addErrorAnnotation(expression.getQualifier(), OCInspections.PointerTypeRequired.class, "err_typecheck_member_reference_arrow", message);
                if (type instanceof OCStructType || type instanceof OCObjectType) {
                    OCChangeTypeIntentionAction.registerChangeTypeFix(expression.getQualifier(), OCPointerType.to(type), annotation, this);
                }
                return;
            }
            Ref qualifierType = new Ref();
            expression.processTargets(expression.getSymbolName(), (Processor<OCSymbol>)new CommonProcessors.CollectProcessor(), true, null, false, false, (Ref<OCType>)qualifierType, context);
            OCType oCType = type = qualifierType.isNull() ? derefType : (OCType)qualifierType.get();
        }
        if (!(type.isUnknown() || type instanceof OCStructType || type.isClassType() || type instanceof OCObjectType || expression.getQualifyingTokenKind() == OCTokenTypes.DOT && type.isPointerToObject())) {
            this.addErrorAnnotation(expression.getQualifier(), "err_typecheck_member_reference_struct_union", "Structure type required instead of '" + type.getName(expression) + "'");
            return;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        expression.processTargets(expression.getSymbolName(), (Processor<OCSymbol>)finder, false, null, true, false, null, context);
        OCSymbol symbol = (OCSymbol)finder.getFoundValue();
        if (symbol == null) {
            expression.processTargets(expression.getSymbolName(), (Processor<OCSymbol>)finder, true, null, true, false, null, context);
            symbol = (OCSymbol)finder.getFoundValue();
            if (symbol != null) {
                OCMethodSymbol methodSymbol;
                OCFileSymbols.markSymbolAsUsed(file, symbol, expression);
                boolean isStatic = symbol instanceof OCMemberSymbol && ((OCMemberSymbol)symbol).isStatic();
                String message = isStatic ? "Class " + symbol.getNameWithKindLowercase(context) + " is accessed from the instance context" : "Instance " + symbol.getNameWithKindLowercase(context) + " is accessed from the class context";
                Annotation annotation = this.addErrorAnnotation(expression, OCInspections.StaticnessMismatch.class, "CIDR", message);
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCMethod.class});
                OCExpression qualifier = expression.getQualifier();
                if (symbol instanceof OCMethodSymbol) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)symbol, !isStatic, context.getProject()));
                }
                if (containingMethod != null && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() != null && (methodSymbol = (OCMethodSymbol)containingMethod.getSymbol()) != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(methodSymbol, isStatic, context.getProject()));
                }
            }
        } else {
            OCFileSymbols.markSymbolAsUsed(file, symbol, expression);
            OCVisibility.checkFieldVisibility(symbol, expression, type, this);
        }
    }

    public void checkReturnStatement(OCReturnStatement stmt) {
        OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCCallable.class});
        OCExpression expr = stmt.getExpression();
        String callableKind = "function/method/block";
        if (callable == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "CIDRillegal_return", "Return statement is outside of a " + callableKind + " declaration");
            return;
        }
        OCSymbol symbol = callable.getSymbol();
        OCType unresolvedReturnType = callable.getReturnType();
        OCType returnType = unresolvedReturnType.resolve(stmt);
        OCResolveContext context = OCResolveContext.forPsi(stmt);
        if (symbol != null) {
            callableKind = symbol.getKindLowercase(context);
            if (symbol.getKind().isConstructorOrDestructor()) {
                returnType = OCVoidType.instance();
            }
        }
        if (expr == null) {
            if (!(returnType instanceof OCVoidType)) {
                String message = "Returning 'void' from a " + callableKind + " returning '" + returnType.getName(stmt) + "'";
                Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "ext_return_missing_expr", message);
                if (symbol != null) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, (OCType)OCVoidType.instance(), true, (OCCompilationContext)context));
                }
            }
            return;
        }
        OCType rType = expr.getResolvedType().getGuessedType();
        if (returnType instanceof OCUnknownType || returnType instanceof OCAutoType) {
            if (unresolvedReturnType instanceof OCAutoType) {
                symbol = ((OCAutoType)unresolvedReturnType).getExpressionSymbol();
            }
            if (symbol instanceof OCLambdaExpressionSymbol) {
                OCType firstReturnType;
                OCExpressionSymbol returnExpr = (OCExpressionSymbol)ContainerUtil.getFirstItem(((OCLambdaExpressionSymbol)symbol).getReturnExpressions());
                OCType oCType = firstReturnType = returnExpr != null ? returnExpr.getResolvedType(context) : null;
                if (firstReturnType != null && !firstReturnType.isMagicInside(context) && !new OCTypeEqualityVisitor(rType, true, false, context).equal(firstReturnType)) {
                    this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "err_auto_fn_different_deductions", "'auto' return type was previously deduced as '" + firstReturnType.getName(context) + "' but here as '" + rType.getName(context) + "'");
                }
                return;
            }
        }
        String message = "Returning '" + rType.getName(context) + "' from a " + callableKind + " returning '" + returnType.getName(context) + "'";
        if (returnType instanceof OCVoidType && !(rType instanceof OCVoidType) && !(rType instanceof OCMagicType)) {
            Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "ext_return_has_expr", message);
            if (symbol != null) {
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, rType, true, (OCCompilationContext)context));
            }
        } else {
            OCTypeCheckResult prValueResult;
            OCTypeCheckResult result = null;
            if (OCExprValueCategory.classify(expr).isLValue() && returnType.isCppStructType(context) && returnType.equals(rType, false, context) && !(prValueResult = OCTypeCompatibilityVisitor.checkConvertible(returnType, rType, new OCValueCategoryHolder(rType, OCExprValueCategory.PRValue), stmt, true, true, context).setDestSymbol(symbol).setSymbolRequiredType(rType)).getState().isError(stmt)) {
                result = prValueResult;
            }
            if (result == null) {
                result = OCTypeCompatibilityVisitor.checkConvertible(returnType, rType, expr, stmt, true, true, context).setDestSymbol(symbol).setSymbolRequiredType(rType);
            }
            if (result.getMessagePrefix().isEmpty()) {
                result.setMessagePrefix(message + ": ");
            }
            result.annotate(this.myCppChecker);
        }
    }

    public void checkSwitchStatement(OCSwitchStatement stmt) {
        List<Object> missingCases;
        boolean isEnumClass;
        OCCondition expr = stmt.getExpression();
        OCStatement body = stmt.getBody();
        ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
        boolean wasDefaultOrUnresolved = true;
        Ref wasField = Ref.create((Object)false);
        OCType type = expr != null ? OCTypeUtils.doSwitchImplicitConversion(stmt, expr.getResolvedType()) : null;
        boolean bl = isEnumClass = type instanceof OCStructType && ((OCStructType)type).isEnumClass();
        if (body != null) {
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            wasDefaultOrUnresolved = OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body, ranges, caseStmts);
            missingCases = OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)wasField);
            final Ref wasDefault = Ref.create((Object)false);
            body.accept(new OCRecursiveVisitor(){

                @Override
                public void visitCaseStatement(OCCaseStatement stmt) {
                    Annotation annotation;
                    super.visitCaseStatement(stmt);
                    OCStatement statement = stmt.getStatement();
                    if (statement == null) {
                        OCOperatorsChecker.this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Statement is expected");
                    } else if (statement instanceof OCDeclarationStatement && OCCodeInsightUtil.isInPlainOldC(stmt)) {
                        annotation = OCOperatorsChecker.this.addErrorAnnotation(statement, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Declaration is not allowed here");
                        OCOperatorsChecker.this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)statement, OCInspectionsBundle.message("quick.fix.remove.statement", new Object[0])));
                    }
                    if (stmt.isDefault()) {
                        if (((Boolean)wasDefault.get()).booleanValue()) {
                            OCOperatorsChecker.this.addErrorAnnotation(stmt, OCInspections.DuplicateSwitchCase.class, "err_multiple_default_labels_defined", "Duplicate default label");
                        } else {
                            if (missingCases.isEmpty() && isEnumClass) {
                                annotation = OCOperatorsChecker.this.addWarningAnnotation(stmt, OCInspections.DuplicateSwitchCase.class, "CIDR", "Default case is useless: all cases are covered");
                                OCOperatorsChecker.this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)stmt, OCInspectionsBundle.message("intention.family.name.remove.statement", new Object[0])));
                            }
                            wasDefault.set((Object)true);
                        }
                    }
                }

                @Override
                public void visitSwitchStatement(OCSwitchStatement stmt) {
                }
            });
            block0: for (int i2 = 0; i2 < ranges.size(); ++i2) {
                Pair range = (Pair)ranges.get(i2);
                OCCaseStatement caseStatement = (OCCaseStatement)caseStmts.get(i2);
                for (Pair pair : ranges) {
                    if (range == pair || Math.max((Integer)range.getFirst(), (Integer)pair.getFirst()) > Math.min((Integer)range.getSecond(), (Integer)pair.getSecond())) continue;
                    String message = ((Integer)range.getFirst()).equals(range.getSecond()) ? "Duplicate case value" : "Overlapping case range";
                    this.addErrorAnnotation(caseStatement, OCInspections.DuplicateSwitchCase.class, "err_duplicate_case", message);
                    continue block0;
                }
            }
        } else {
            missingCases = Collections.emptyList();
        }
        if (expr != null) {
            OCResolveContext context = OCResolveContext.forPsi(expr);
            if (!(type.isUnknown() || OCTypeUtils.isIntegralType(type) || OCTypeUtils.isEnumType(type))) {
                String message = "Integer expression is required in switch instead of '" + type.getName(context) + "'";
                Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IntegerTypeRequired.class, "err_typecheck_statement_requires_integer", message);
                OCExpression expression = expr.getExpression();
                if (expression != null) {
                    OCChangeTypeIntentionAction.registerChangeTypeFix(expression, OCIntType.CHAR, annotation, this);
                }
            }
            if (!wasDefaultOrUnresolved) {
                Annotation annotation;
                if (!(type.getTerminalType() instanceof OCStructType || ((Boolean)wasField.get()).booleanValue() || type.isUnknown())) {
                    annotation = this.addWarningAnnotation(stmt.getSwitchToken(), OCInspections.MissingSwitchCase.class, "CIDRmissing_default_case", "Default case is not handled");
                    this.registerQuickFix(annotation, new OCCreateMissingSwitchCasesFix(stmt, true));
                }
                if (!missingCases.isEmpty()) {
                    annotation = this.addWarningAnnotation(stmt.getSwitchToken(), OCInspections.MissingSwitchCase.class, OCClangMessageFinder.getInstance().getMissingCase(), "Not all switch cases were handled");
                    this.registerQuickFix(annotation, new OCCreateMissingSwitchCasesFix(stmt, false));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaratorSymbol";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSymbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/legacy/daemon/OCOperatorsChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnumeratorInsideOwnEnumClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypesEquivalence";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isOutsideBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInConstMemberFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReadonlyAccess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSendMessageExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

